/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic.extractor;

import com.uqm.crashsight.symtabtool.generic.ArgsParser;
import com.uqm.crashsight.symtabtool.generic.SymtabToolClient;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class SymtabExtractorJs {
    public static String extract(ArgsParser argsParser) {
        if (null == argsParser) {
            return null;
        }
        String string = argsParser.getFileName();
        return SymtabExtractorJs.extractByJsFileName(string);
    }

    public static String extractByJsFileName(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        final ArrayList<File> arrayList = new ArrayList<File>();
        String string2 = "";
        if (file.isDirectory()) {
            try {
                string2 = file.getCanonicalPath();
                Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
                        if (path.toFile().getName().endsWith(".map") || path.toFile().getName().endsWith(".js") || path.toFile().getName().endsWith(".unityweb")) {
                            arrayList.add(path.toFile());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (Exception exception) {
                SymtabToolClient.getErrorInfo().addErrorMsg(exception.getMessage());
                exception.printStackTrace();
            }
        } else {
            try {
                string2 = file.getParentFile().getCanonicalPath();
                if (!(string.endsWith(".map") || string.endsWith(".js") || string.endsWith(".unityweb"))) {
                    SymtabToolClient.getErrorInfo().addErrorMsg("not map file found");
                    return null;
                }
                arrayList.add(file);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        try {
            File file2 = SymtabExtractorJs.zipFiles(arrayList, string2, "jsFile");
            return file2.getCanonicalPath().toString();
        }
        catch (Exception exception) {
            SymtabToolClient.getErrorInfo().addErrorMsg(exception.getMessage());
            return null;
        }
    }

    public static File zipFiles(List<File> list, String string, String string2) throws IOException {
        File file = File.createTempFile("crashsightSymbol", string2 + ".zip");
        byte[] byArray = new byte[2048];
        ZipOutputStream zipOutputStream = null;
        zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(zipOutputStream, 2048);
        HashSet hashSet = new HashSet();
        for (File file2 : list) {
            String string3 = new File(string).toURI().relativize(file2.toURI()).getPath();
            FileInputStream fileInputStream = new FileInputStream(file2);
            ZipEntry zipEntry = new ZipEntry(string3);
            zipEntry.setTime(0L);
            zipOutputStream.putNextEntry(zipEntry);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            int n = 0;
            while ((n = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedOutputStream.flush();
            ((InputStream)fileInputStream).close();
        }
        zipOutputStream.close();
        return file;
    }
}

