/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.uqm.crashsight.symtabtool.common.DsymRebuilder;
import com.uqm.crashsight.symtabtool.common.upload.HttpClientHelper;
import com.uqm.crashsight.symtabtool.common.upload.SymtabFileUploader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.common.utils.SymtabToolLogPrinter;
import com.uqm.crashsight.symtabtool.elf.ElfParser;
import com.uqm.crashsight.symtabtool.generic.ArgsParser;
import com.uqm.crashsight.symtabtool.generic.extractor.SymtabExtractorAndroid;
import com.uqm.crashsight.symtabtool.generic.extractor.SymtabExtractorIos;
import com.uqm.crashsight.symtabtool.generic.extractor.SymtabExtractorJs;
import com.uqm.crashsight.symtabtool.generic.extractor.SymtabExtractorLinux;
import com.uqm.crashsight.symtabtool.generic.extractor.SymtabExtractorNss;
import com.uqm.crashsight.symtabtool.generic.extractor.SymtabExtractorPs;
import com.uqm.crashsight.symtabtool.generic.extractor.SymtabExtractorWin;
import com.uqm.crashsight.symtabtool.generic.util.Common;
import com.uqm.crashsight.symtabtool.generic.util.CosUploader;
import com.uqm.crashsight.symtabtool.generic.util.ErrorInfo;
import com.uqm.crashsight.symtabtool.mach.MachFatHeaderParser;
import com.uqm.crashsight.symtabtool.mach.MachParser;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;

public class SymtabToolClient {
    public static final String SYMTAB_TOOL_VERSION = "3.2.1120";
    private static final int EXIT_VALUE_SUCCESS = 0;
    private static final int EXIT_VALUE_ARGS_ERROR = -1;
    private static final int EXIT_VALUE_SYMTAB_ERROR = -2;
    private static final int EXIT_VALUE_UPLOAD_ERROR = -3;
    private static final int EXIT_VALUE_DUMP_UUID_ERROR = -4;
    public static boolean isDebug = false;
    public static boolean extracted = false;
    public static boolean uploaded = false;
    private static ErrorInfo errorInfo = new ErrorInfo();
    private static JsonArray jsonArray = new JsonArray();

    public static ErrorInfo getErrorInfo() {
        return errorInfo;
    }

    public static JsonArray getJsonArray() {
        return jsonArray;
    }

    private static void setLogPrinter() {
        Log.setPrinter(new SymtabToolLogPrinter());
    }

    private static String[] getTestArgs() {
        String string = "0ac88aa5a3";
        String string2 = "8fb5d416-7cc7-46c7-a7ee-fd953ad3f9a3";
        String string3 = "com.uqm.crashsight.demo";
        String string4 = "5.0";
        String string5 = "./test/";
        return new String[]{"-d", "-u", "-symbol", "-package", string3, "-version", string4, "-id", string, "-key", string2, "-i", string5, "-url", "https://test-crashsight.wetest.qq.com/openapi/file/upload/symbol"};
    }

    /*
     * WARNING - void declaration
     */
    private static boolean dumpUuid(ArgsParser argsParser) {
        Vector<File> vector = argsParser.getSoFiles();
        if (argsParser.getSymbolPlatform().equals("aos")) {
            if (vector.isEmpty()) {
                Log.error("Please specify SO files to dump UUID.", new Object[0]);
                ArgsParser.printHelp();
                return false;
            }
            Log.setEnable(false);
            for (File file : vector) {
                void string3;
                String string;
                String string2 = file.getAbsolutePath();
                String object = ElfParser.getArch(string2);
                if (object == null) {
                    Log.warn("Failed to get architecture of file: " + string2, new Object[0]);
                    String string4 = "unknown";
                }
                if ((string = ElfParser.getUuid(string2, false)) == null) {
                    Log.warn("Failed to get UUID of file: " + string2, new Object[0]);
                    string = "unknown";
                }
                System.out.printf("%s [%s] %s\n", string2, string3, string);
            }
            System.out.println();
            Log.setEnable(true);
            return true;
        }
        if (argsParser.getSymbolPlatform().equals("ios")) {
            Vector<File> vector2 = argsParser.getdSymFiles();
            if (vector2.isEmpty()) {
                Log.error("Please specify SO files to dump UUID.", new Object[0]);
                ArgsParser.printHelp();
                return false;
            }
            Vector<String> vector3 = new Vector<String>();
            for (File file : vector2) {
                String string = file.getAbsolutePath();
                MachFatHeaderParser machFatHeaderParser = new MachFatHeaderParser(string);
                Vector<Long> vector4 = machFatHeaderParser.getOffsetTable();
                machFatHeaderParser.close();
                if (null == vector4) {
                    Log.error("Failed to parse header of file: " + string, new Object[0]);
                    continue;
                }
                for (Long l : vector4) {
                    String string5;
                    String string6 = MachParser.getArch(string, l);
                    if (string6 == null) {
                        Log.warn("Failed to get architecture of file: " + string, new Object[0]);
                        string6 = "unknown";
                    }
                    if ((string5 = MachParser.getUuid(string, l)) == null) {
                        Log.warn("Failed to get UUID of file: " + string, new Object[0]);
                        string5 = "unknown";
                    }
                    vector3.add(Log.format("%s [%s] %s", string, string6, string5));
                }
            }
            Log.setEnable(false);
            for (String string : vector3) {
                System.out.println(string);
            }
            System.out.println();
            Log.setEnable(true);
        }
        return false;
    }

    private static boolean uploadSymtabFile(final List<String> list, final ArgsParser argsParser, final List<String> list2) {
        int n = argsParser.getNetworkTimeout();
        if (n > 0) {
            HttpClientHelper.setNetworkTimeout(n * 1000);
        }
        int n2 = Runtime.getRuntime().availableProcessors();
        n2 = Math.max(n2, list.size());
        ExecutorService executorService = Executors.newFixedThreadPool(n2);
        ArrayList<Future<JsonObject>> arrayList = new ArrayList<Future<JsonObject>>();
        for (int i = 0; i < list.size(); ++i) {
            if (StringUtils.isEmpty(list.get(i))) continue;
            final int n3 = i;
            Future<JsonObject> future = executorService.submit(new Callable<JsonObject>(){

                @Override
                public JsonObject call() throws Exception {
                    File file;
                    SymtabFileUploader.UploadInfo uploadInfo = new SymtabFileUploader.UploadInfo();
                    uploadInfo.appId = argsParser.getAppId();
                    uploadInfo.appKey = argsParser.getAppKey();
                    uploadInfo.appVersion = argsParser.getAppVersion();
                    uploadInfo.appPackage = argsParser.getAppPackage();
                    uploadInfo.crashSightVersion = argsParser.getCrashSightVersion();
                    uploadInfo.uploadUrl = argsParser.getUploadUrl();
                    uploadInfo.symbolType = (String)list2.get(n3);
                    uploadInfo.file = file = new File((String)list.get(n3));
                    uploadInfo.fileName = file.getName();
                    uploadInfo.appChannel = argsParser.getAppChannel();
                    JsonObject jsonObject = new JsonObject();
                    if (!uploadInfo.fileName.equals("")) {
                        long l = System.currentTimeMillis();
                        JsonObject jsonObject2 = SymtabFileUploader.uploadSymtabFile(uploadInfo);
                        boolean bl = jsonObject2 != null && jsonObject2.get("result").getAsBoolean();
                        long l2 = System.currentTimeMillis();
                        jsonObject.addProperty("time", l2 - l);
                        jsonObject.addProperty("result", bl);
                        jsonObject.addProperty("name", uploadInfo.fileName);
                        if (!bl && jsonObject2 != null) {
                            jsonObject.addProperty("message", jsonObject2.get("message").getAsString());
                        }
                    }
                    return jsonObject;
                }
            });
            arrayList.add(future);
        }
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        int n4 = 0;
        boolean bl = true;
        int n5 = 0;
        for (Future future : arrayList) {
            try {
                JsonObject jsonObject2 = (JsonObject)future.get();
                ++n5;
                if (jsonObject2.get("result").getAsBoolean()) {
                    jsonArray.add(jsonObject2);
                    ++n4;
                    continue;
                }
                JsonElement jsonElement = jsonObject2.get("message");
                if (jsonElement != null) {
                    SymtabToolClient.getErrorInfo().addErrorMsg(jsonElement.getAsString());
                }
                bl = false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        executorService.shutdown();
        jsonObject.addProperty("all", n5);
        jsonObject.addProperty("success", n4);
        jsonObject.addProperty("info", jsonArray.toString());
        ErrorInfo errorInfo = new ErrorInfo();
        errorInfo.setAppKey(argsParser.getAppKey());
        errorInfo.setAppId(argsParser.getAppId());
        errorInfo.setType("jar-statistics");
        errorInfo.setUploadResult(jsonObject.toString());
        SymtabToolClient.reportError(argsParser.getUploadUrl(), errorInfo);
        return bl;
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        ArgsParser argsParser;
        SymtabToolClient.setLogPrinter();
        Log.setEnable(true);
        if (isDebug) {
            stringArray = SymtabToolClient.getTestArgs();
        }
        if (null == (argsParser = ArgsParser.create(stringArray))) {
            Log.error("Please input right args.", new Object[0]);
            System.exit(-1);
        }
        Log.setDebugMode(argsParser.isDebug());
        SymtabToolClient.getErrorInfo().setAppId(argsParser.getAppId());
        SymtabToolClient.getErrorInfo().setAppKey(argsParser.getAppKey());
        System.out.println("CrashSight Symtab Tool for 3.2.1120");
        if (argsParser.dumpUuid()) {
            if (!SymtabToolClient.dumpUuid(argsParser)) {
                System.exit(-4);
            } else {
                System.exit(0);
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (argsParser.getSymbolPlatform().equals("aos") || argsParser.getSymbolPlatform().equals("hm")) {
            Object object4;
            if (argsParser.getSymbolPlatform().equals("aos")) {
                Log.info("Processing Android symbols.", new Object[0]);
            } else if (argsParser.getSymbolPlatform().equals("hm")) {
                Log.info("Processing HarMoney symbols.", new Object[0]);
            }
            arrayList2.add("3");
            arrayList2.add("3");
            object3 = SymtabExtractorAndroid.extract(argsParser);
            if (object3 != null) {
                arrayList.addAll(Arrays.asList(object3));
            }
            if (argsParser.getMappingFileName() != null) {
                object4 = new File(argsParser.getMappingFileName());
                if (((File)object4).exists() && ((File)object4).getName().endsWith(".txt")) {
                    object2 = new ArrayList<Object>();
                    object2.add(object4);
                    object = null;
                    try {
                        object = Common.zipFile((List<File>)object2, "mappingFile");
                        arrayList.add(((File)object).getAbsolutePath());
                        arrayList2.add("1");
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else {
                    SymtabToolClient.getErrorInfo().addErrorMsg("apping file to upload is not valid:" + ((File)object4).getAbsolutePath());
                    Log.error("Mapping file to upload is not valid: %s", ((File)object4).getAbsolutePath());
                }
            }
            if (argsParser.getJsFileName() != null) {
                object4 = SymtabExtractorJs.extractByJsFileName(argsParser.getJsFileName());
                arrayList.add((String)object4);
                arrayList2.add("30");
            }
            boolean bl = extracted = object3 != null;
            if (!extracted) {
                SymtabToolClient.reportError(argsParser.getUploadUrl(), SymtabToolClient.getErrorInfo());
                System.exit(-2);
            }
        } else if (argsParser.getSymbolPlatform().equals("ios")) {
            Log.info("Processing iOS symbols.", new Object[0]);
            if (argsParser.getOnlyRebuildDsym()) {
                Log.info("Start only rebuild dsym.", new Object[0]);
                object3 = argsParser.getdSymFiles();
                if (((Vector)object3).isEmpty()) {
                    Log.error("dSymFiles is empty!", new Object[0]);
                    System.exit(-2);
                } else if (((Vector)object3).size() == 1) {
                    Log.info("Extracting symtab file: %s", ((File)((Vector)object3).get(0)).getName());
                } else if (((Vector)object3).size() > 1) {
                    Log.info("Extracting symtab files of directory: %s", argsParser.getPathName());
                }
                Iterator iterator2 = ((Vector)object3).iterator();
                while (iterator2.hasNext()) {
                    object2 = (File)iterator2.next();
                    object = null;
                    try {
                        object = ((File)object2).getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        Log.error(iOException);
                        continue;
                    }
                    DsymRebuilder dsymRebuilder = new DsymRebuilder((String)object);
                    dsymRebuilder.parseSectionInfo();
                    dsymRebuilder.rebuildDebugSection();
                }
                System.exit(0);
            }
            arrayList2.add("2");
            object3 = SymtabExtractorIos.extract(argsParser);
            boolean bl = extracted = object3 != null;
            if (!extracted) {
                SymtabToolClient.reportError(argsParser.getUploadUrl(), SymtabToolClient.getErrorInfo());
                System.exit(-2);
            }
            arrayList.add((String)object3);
        } else if (argsParser.getSymbolPlatform().equals("win")) {
            Log.info("Processing Windows symbols.", new Object[0]);
            if (argsParser.getParseMode().equals("") || argsParser.getParseMode().equals("ori")) {
                arrayList2.add("10");
            } else {
                arrayList2.add("11");
                arrayList2.add("12");
            }
            object3 = SymtabExtractorWin.getInstance().extract(argsParser);
            boolean bl = extracted = object3 != null;
            if (!extracted) {
                SymtabToolClient.reportError(argsParser.getUploadUrl(), SymtabToolClient.getErrorInfo());
                System.exit(-2);
            }
            arrayList.addAll(Arrays.asList(object3));
        } else if (argsParser.getSymbolPlatform().equals("linux")) {
            Log.info("Processing Linux symbols.", new Object[0]);
            object3 = SymtabExtractorLinux.extract(argsParser);
            arrayList2.add("20");
            arrayList2.add("21");
            boolean bl = extracted = object3 != null;
            if (!extracted) {
                SymtabToolClient.reportError(argsParser.getUploadUrl(), SymtabToolClient.getErrorInfo());
                System.exit(-2);
            }
            arrayList.addAll(Arrays.asList(object3));
        } else if (argsParser.getSymbolPlatform().equals("js")) {
            object3 = SymtabExtractorJs.extract(argsParser);
            arrayList2.add("30");
            boolean bl = extracted = object3 != null;
            if (!extracted) {
                SymtabToolClient.reportError(argsParser.getUploadUrl(), SymtabToolClient.getErrorInfo());
                System.exit(-2);
            }
            arrayList.add((String)object3);
        } else if (argsParser.getSymbolPlatform().equals("ps5")) {
            object3 = SymtabExtractorPs.extract(argsParser);
            arrayList2.add("14");
            boolean bl = extracted = object3 != null;
            if (!extracted) {
                SymtabToolClient.reportError(argsParser.getUploadUrl(), SymtabToolClient.getErrorInfo());
                System.exit(-2);
            }
            arrayList.add((String)object3);
        } else if (argsParser.getSymbolPlatform().equals("switch")) {
            object3 = SymtabExtractorNss.extract(argsParser);
            boolean bl = extracted = object3 != null;
            if (!extracted) {
                SymtabToolClient.reportError(argsParser.getUploadUrl(), SymtabToolClient.getErrorInfo());
                System.exit(-2);
            }
            arrayList.add((String)object3);
            arrayList2.add("13");
        } else if (argsParser.getSymbolPlatform().equals("xbox")) {
            argsParser.setParseMode("win");
            object3 = SymtabExtractorWin.getInstance().extract(argsParser);
            boolean bl = extracted = object3 != null;
            if (!extracted) {
                SymtabToolClient.reportError(argsParser.getUploadUrl(), SymtabToolClient.getErrorInfo());
                System.exit(-2);
            }
            for (int i = 0; i < ((Object)object3).length; ++i) {
                arrayList.add((String)object3[i]);
                arrayList2.add("15");
            }
        } else {
            Log.error("Unsupport platform %s", argsParser.getSymbolPlatform());
        }
        if (!SymtabToolClient.getJsonArray().isEmpty()) {
            object3 = new ErrorInfo();
            ((ErrorInfo)object3).setAppKey(argsParser.getAppKey());
            ((ErrorInfo)object3).setAppId(argsParser.getAppId());
            ((ErrorInfo)object3).setType("make-statistics");
            ((ErrorInfo)object3).setUploadResult(SymtabToolClient.getJsonArray().toString());
            SymtabToolClient.reportError(argsParser.getUploadUrl(), (ErrorInfo)object3);
        }
        if (argsParser.shouldUpload()) {
            if (argsParser.getUploadCos()) {
                try {
                    object3 = new URL(argsParser.getUploadUrl());
                    String string = ((URL)object3).getHost();
                    object2 = new CosUploader(argsParser.getAppId(), argsParser.getAppKey(), string, argsParser.getAppPackage(), argsParser.getAppVersion(), argsParser.getSymbolPlatform());
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        if (StringUtils.isEmpty((CharSequence)arrayList.get(i)) || !Files.exists(Paths.get((String)arrayList.get(i), new String[0]), new LinkOption[0])) continue;
                        uploaded = ((String)arrayList2.get(i)).equals("30") ? ((CosUploader)object2).uploadFile(new File((String)arrayList.get(i)), (String)arrayList2.get(i)) : ((CosUploader)object2).uploadFile(new File(Common.splitZipFiles((String)arrayList.get(i), (String)arrayList2.get(i))), (String)arrayList2.get(i));
                    }
                }
                catch (Exception exception) {
                    Log.error(exception);
                    uploaded = false;
                }
            }
            if (!uploaded) {
                uploaded = SymtabToolClient.uploadSymtabFile(arrayList, argsParser, arrayList2);
            }
        }
        if (argsParser.shouldUpload() && !uploaded) {
            SymtabToolClient.reportError(argsParser.getUploadUrl(), SymtabToolClient.getErrorInfo());
            System.exit(-3);
        }
    }

    private static void reportError(String string, ErrorInfo errorInfo) {
        try {
            URL uRL = new URL(string);
            CosUploader cosUploader = new CosUploader(uRL.getHost());
            cosUploader.reportError(errorInfo);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }
}

