/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.elf;

import com.uqm.crashsight.symtabtool.common.Subroutine;
import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.elf.ElfStringParser;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class ElfSymtabParser {
    private static final long SYMTAB_FUNC_TYPE = 2L;
    private static final long SYMTAB_FILE_TYPE = 4L;
    private String fileName = null;
    private long fileFormat = 0L;
    private long endian = 0L;
    private BinaryFileReader binaryFileReader = null;

    public ElfSymtabParser(String string, long l, long l2) {
        this.setFileName(string);
        this.setFileFormat(l);
        this.setEndian(l2);
    }

    private static void sortSubroutineTable(Vector<Subroutine> vector) {
        Collections.sort(vector, new Comparator<Subroutine>(){

            @Override
            public int compare(Subroutine subroutine, Subroutine subroutine2) {
                if (subroutine.getLowPc() == subroutine2.getLowPc()) {
                    return (int)(subroutine.getHighPc() - subroutine2.getHighPc());
                }
                return (int)(subroutine.getLowPc() - subroutine2.getLowPc());
            }
        });
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFileFormat(long l) {
        this.fileFormat = l;
    }

    public void setEndian(long l) {
        this.endian = l;
    }

    private void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName, this.endian);
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
        return true;
    }

    private long parseSymbolType(long l) {
        return l & 0xFL;
    }

    private ElfSymtabEntry parseElfSymtabEntry() {
        try {
            ElfSymtabEntry elfSymtabEntry = new ElfSymtabEntry();
            elfSymtabEntry.setName(this.binaryFileReader.readUInt());
            if (32L == this.fileFormat) {
                elfSymtabEntry.setValue(this.binaryFileReader.readUInt());
                elfSymtabEntry.setSize(this.binaryFileReader.readUInt());
                elfSymtabEntry.setInfo(this.binaryFileReader.readUByte());
                elfSymtabEntry.setOther(this.binaryFileReader.readUByte());
                elfSymtabEntry.setSectionIndex(this.binaryFileReader.readUShort());
            } else if (64L == this.fileFormat) {
                elfSymtabEntry.setInfo(this.binaryFileReader.readUByte());
                elfSymtabEntry.setOther(this.binaryFileReader.readUByte());
                elfSymtabEntry.setSectionIndex(this.binaryFileReader.readUShort());
                elfSymtabEntry.setValue(this.binaryFileReader.readULong());
                elfSymtabEntry.setSize(this.binaryFileReader.readULong());
            } else {
                Log.error("File format error", new Object[0]);
            }
            return elfSymtabEntry;
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
    }

    private Vector<Subroutine> parseSubroutineTable(long l, ElfStringParser elfStringParser, Vector<String> vector) {
        Vector<ElfSymtabEntry> vector2 = new Vector<ElfSymtabEntry>();
        int n = 0;
        while ((long)n < l) {
            vector2.add(this.parseElfSymtabEntry());
            ++n;
        }
        Vector<Subroutine> vector3 = new Vector<Subroutine>();
        String string = null;
        for (int i = 0; i < vector2.size(); ++i) {
            boolean bl;
            ElfSymtabEntry elfSymtabEntry = (ElfSymtabEntry)vector2.get(i);
            int n2 = (int)elfSymtabEntry.getSectionIndex();
            String string2 = "";
            if (n2 < vector.size()) {
                string2 = vector.get((int)elfSymtabEntry.getSectionIndex());
            }
            boolean bl2 = bl = 4L == this.parseSymbolType(elfSymtabEntry.getInfo());
            if (bl) {
                string = elfStringParser.getString(elfSymtabEntry.getName());
                continue;
            }
            boolean bl3 = 2L == this.parseSymbolType(elfSymtabEntry.getInfo());
            boolean bl4 = StringUtils.equalsIgnoreCase(string2, ".text");
            if (!bl3 && !bl4 || elfSymtabEntry.getValue() == 0L) continue;
            Subroutine subroutine = new Subroutine();
            subroutine.setName(elfStringParser.getString(elfSymtabEntry.getName()));
            subroutine.setLowPc(elfSymtabEntry.getValue());
            long l2 = subroutine.getLowPc() + elfSymtabEntry.getSize();
            subroutine.setHighPc(l2);
            subroutine.setFilePathFromSymtab(string);
            if (subroutine.getName().matches("\\$.+\\.\\d+")) continue;
            vector3.add(subroutine);
        }
        return vector3;
    }

    public Vector<Subroutine> getSubroutineTable(long l, long l2, ElfStringParser elfStringParser, Vector<String> vector) {
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(l)) {
            this.close();
            return null;
        }
        Vector<Subroutine> vector2 = this.parseSubroutineTable(l2, elfStringParser, vector);
        this.close();
        ElfSymtabParser.sortSubroutineTable(vector2);
        for (int i = 0; i < vector2.size(); ++i) {
            Subroutine subroutine = vector2.elementAt(i);
            if (subroutine.getHighPc() != subroutine.getLowPc() || i + 1 >= vector2.size()) continue;
            subroutine.setHighPc(vector2.elementAt(i + 1).getLowPc());
        }
        if (vector2.isEmpty()) {
            return vector2;
        }
        Vector<Subroutine> vector3 = new Vector<Subroutine>();
        vector3.add(vector2.get(0));
        for (int i = 1; i < vector2.size(); ++i) {
            Subroutine subroutine = vector2.elementAt(i - 1);
            Subroutine subroutine2 = vector2.elementAt(i);
            if (subroutine2.equal(subroutine)) continue;
            vector3.add(subroutine2);
        }
        return vector3;
    }

    public static class ElfSymtabEntry {
        private long name = 0L;
        private long info = 0L;
        private long other = 0L;
        private long sectionIndex = 0L;
        private long value = 0L;
        private long size = 0L;

        public long getName() {
            return this.name;
        }

        public void setName(long l) {
            this.name = l;
        }

        public long getInfo() {
            return this.info;
        }

        public void setInfo(long l) {
            this.info = l;
        }

        public long getOther() {
            return this.other;
        }

        public void setOther(long l) {
            this.other = l;
        }

        public long getSectionIndex() {
            return this.sectionIndex;
        }

        public void setSectionIndex(long l) {
            this.sectionIndex = l;
        }

        public long getValue() {
            return this.value;
        }

        public void setValue(long l) {
            this.value = l;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long l) {
            this.size = l;
        }
    }
}

