/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.elf;

import com.uqm.crashsight.symtabtool.common.ProgramHeader;
import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.IOException;
import java.util.Vector;

public class ElfProgramHeaderParser {
    private String fileName = null;
    private long fileFormat = 0L;
    private long endian = 0L;
    private BinaryFileReader binaryFileReader = null;

    public ElfProgramHeaderParser(String string, long l, long l2) {
        this.setFileName(string);
        this.setFileFormat(l);
        this.setEndian(l2);
    }

    private void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName, this.endian);
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
        return true;
    }

    private ProgramHeader parsePhdrInfo() {
        ProgramHeader programHeader = new ProgramHeader();
        try {
            if (32L == this.fileFormat) {
                programHeader.setP_type(this.binaryFileReader.readUInt());
                programHeader.setP_offset(this.binaryFileReader.readUInt());
                programHeader.setP_vaddr(this.binaryFileReader.readUInt());
                programHeader.setP_paddr(this.binaryFileReader.readUInt());
                programHeader.setP_filesz(this.binaryFileReader.readUInt());
                programHeader.setP_memsz(this.binaryFileReader.readUInt());
                programHeader.setP_flags(this.binaryFileReader.readUInt());
                programHeader.setP_align(this.binaryFileReader.readUInt());
            } else {
                programHeader.setP_type(this.binaryFileReader.readUInt());
                programHeader.setP_flags(this.binaryFileReader.readUInt());
                programHeader.setP_offset(this.binaryFileReader.readULong());
                programHeader.setP_vaddr(this.binaryFileReader.readULong());
                programHeader.setP_paddr(this.binaryFileReader.readULong());
                programHeader.setP_filesz(this.binaryFileReader.readULong());
                programHeader.setP_memsz(this.binaryFileReader.readULong());
                programHeader.setP_align(this.binaryFileReader.readULong());
            }
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
        Log.info("current flag is : %d; it's vaddr is %d", programHeader.getP_flags(), programHeader.getP_vaddr());
        return programHeader;
    }

    private Vector<ProgramHeader> getProgramHeaderInfoTable(long l) {
        Vector<ProgramHeader> vector = new Vector<ProgramHeader>();
        int n = 0;
        while ((long)n < l) {
            vector.add(this.parsePhdrInfo());
            ++n;
        }
        return vector;
    }

    public Vector<ProgramHeader> getProgramHeaderInfoTable(long l, long l2) {
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(l)) {
            this.close();
            return null;
        }
        Vector<ProgramHeader> vector = this.getProgramHeaderInfoTable(l2);
        this.close();
        return vector;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public long getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(long l) {
        this.fileFormat = l;
    }

    public long getEndian() {
        return this.endian;
    }

    public void setEndian(long l) {
        this.endian = l;
    }

    public BinaryFileReader getBinaryFileReader() {
        return this.binaryFileReader;
    }

    public void setBinaryFileReader(BinaryFileReader binaryFileReader) {
        this.binaryFileReader = binaryFileReader;
    }
}

