/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.elf;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public class ElfHeaderParser {
    private String fileName = null;
    private BinaryFileReader binaryFileReader = null;
    private long fileFormat = 0L;
    private long endian = 0L;
    private byte[] elfIdentification = new byte[16];
    private long fileType = 0L;
    private long arch = 0L;
    private String archName = null;
    private long version = 0L;
    private long entryAddress = 0L;
    private long programHeaderTableOffset = 0L;
    private long sectionHeaderTableOffset = 0L;
    private long processorSpecificFlags = 0L;
    private long headerSize = 0L;
    private long programHeaderTableEntrySize = 0L;
    private long programNumber = 0L;
    private long sectionHeaderTableEntrySize = 0L;
    private long sectionNumber = 0L;
    private long stringTableHeaderIndex = 0L;
    private static final HashMap<Long, String> archTable = new HashMap();
    public static final String ARCH_ARM = "armeabi";
    public static final String ARCH_MIPS = "mips";
    public static final String ARCH_MIPS_64 = "mips64";

    private static String getArchName(long l, long l2) {
        String string = archTable.get(l);
        if (64L == l2 && string.equals(ARCH_MIPS)) {
            string = ARCH_MIPS_64;
        }
        return string;
    }

    private void setFileName(String string) {
        this.fileName = string;
    }

    private ElfHeaderParser(String string) {
        this.setFileName(string);
    }

    private void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName);
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
        return true;
    }

    private static boolean checkMagic(byte[] byArray) {
        if (byArray.length < 3) {
            return false;
        }
        if (127 != byArray[0]) {
            return false;
        }
        if (69 != byArray[1]) {
            return false;
        }
        if (76 != byArray[2]) {
            return false;
        }
        return 70 == byArray[3];
    }

    private long parseFileFormat(byte by) {
        if (1 == by) {
            return 32L;
        }
        if (2 == by) {
            return 64L;
        }
        return 0L;
    }

    private long parseEndian(byte by) {
        if (1 == by) {
            return BinaryFileReader.LITTLE_ENDIAN;
        }
        if (2 == by) {
            return BinaryFileReader.BIG_ENDIAN;
        }
        return BinaryFileReader.INVALID_ENDIAN;
    }

    private boolean parseHeaderIndent() {
        if (!this.binaryFileReader.readByteArray(this.elfIdentification)) {
            Log.error("Failed to parse elf indentification", new Object[0]);
            return false;
        }
        if (!ElfHeaderParser.checkMagic(this.elfIdentification)) {
            Log.error("Not a elf file: %s", this.fileName);
            return false;
        }
        this.fileFormat = this.parseFileFormat(this.elfIdentification[4]);
        if (0L == this.fileFormat) {
            Log.error("File format error: 0x%x", this.elfIdentification[4]);
            return false;
        }
        this.endian = this.parseEndian(this.elfIdentification[5]);
        if (BinaryFileReader.INVALID_ENDIAN == this.endian) {
            Log.error("Endian error: 0x%x", this.elfIdentification[5]);
            return false;
        }
        this.binaryFileReader.setEndian(this.endian);
        return true;
    }

    private boolean parseHeader() {
        if (!this.parseHeaderIndent()) {
            Log.error("Failed to parse header indent of elf", new Object[0]);
            return false;
        }
        try {
            this.fileType = this.binaryFileReader.readUShort();
            this.arch = this.binaryFileReader.readUShort();
            this.archName = ElfHeaderParser.getArchName(this.arch, this.fileFormat);
            this.version = this.binaryFileReader.readUInt();
            if (32L == this.fileFormat) {
                this.entryAddress = this.version = this.binaryFileReader.readUInt();
                this.programHeaderTableOffset = this.binaryFileReader.readUInt();
                this.sectionHeaderTableOffset = this.binaryFileReader.readUInt();
            } else if (64L == this.fileFormat) {
                this.entryAddress = this.version = this.binaryFileReader.readULong();
                this.programHeaderTableOffset = this.binaryFileReader.readULong();
                this.sectionHeaderTableOffset = this.binaryFileReader.readULong();
            } else {
                Log.error("File format error", new Object[0]);
                return false;
            }
            this.processorSpecificFlags = this.binaryFileReader.readUInt();
            this.headerSize = this.binaryFileReader.readUShort();
            this.programHeaderTableEntrySize = this.binaryFileReader.readUShort();
            this.programNumber = this.binaryFileReader.readUShort();
            this.sectionHeaderTableEntrySize = this.binaryFileReader.readUShort();
            this.sectionNumber = this.binaryFileReader.readUShort();
            this.stringTableHeaderIndex = this.binaryFileReader.readUShort();
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return false;
        }
        return true;
    }

    private boolean parse() {
        if (!this.openFile()) {
            return false;
        }
        if (!this.parseHeader()) {
            this.close();
            return false;
        }
        this.close();
        return true;
    }

    public static ElfHeaderParser create(String string) {
        ElfHeaderParser elfHeaderParser = new ElfHeaderParser(string);
        if (!elfHeaderParser.parse()) {
            return null;
        }
        return elfHeaderParser;
    }

    public static boolean isElf(String string) {
        try {
            BinaryFileReader binaryFileReader = new BinaryFileReader(string);
            byte[] byArray = new byte[4];
            if (!binaryFileReader.readByteArray(byArray)) {
                return false;
            }
            return ElfHeaderParser.checkMagic(byArray);
        }
        catch (Exception exception) {
            Log.error(exception.getMessage(), new Object[0]);
            return false;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public BinaryFileReader getBinaryFileReader() {
        return this.binaryFileReader;
    }

    public long getFileFormat() {
        return this.fileFormat;
    }

    public long getEndian() {
        return this.endian;
    }

    public byte[] getElfIdentification() {
        return this.elfIdentification;
    }

    public long getFileType() {
        return this.fileType;
    }

    public long getArch() {
        return this.arch;
    }

    public String getArchName() {
        return this.archName;
    }

    public long getVersion() {
        return this.version;
    }

    public long getEntryAddress() {
        return this.entryAddress;
    }

    public long getProgramHeaderTableOffset() {
        return this.programHeaderTableOffset;
    }

    public long getSectionHeaderTableOffset() {
        return this.sectionHeaderTableOffset;
    }

    public long getProcessorSpecificFlags() {
        return this.processorSpecificFlags;
    }

    public long getHeaderSize() {
        return this.headerSize;
    }

    public long getProgramHeaderTableEntrySize() {
        return this.programHeaderTableEntrySize;
    }

    public long getProgramNumber() {
        return this.programNumber;
    }

    public long getSectionHeaderTableEntrySize() {
        return this.sectionHeaderTableEntrySize;
    }

    public long getSectionNumber() {
        return this.sectionNumber;
    }

    public long getStringTableHeaderIndex() {
        return this.stringTableHeaderIndex;
    }

    public void setBinaryFileReader(BinaryFileReader binaryFileReader) {
        this.binaryFileReader = binaryFileReader;
    }

    public void setFileFormat(long l) {
        this.fileFormat = l;
    }

    public void setEndian(long l) {
        this.endian = l;
    }

    public void setElfIdentification(byte[] byArray) {
        this.elfIdentification = byArray;
    }

    public void setFileType(long l) {
        this.fileType = l;
    }

    public void setArch(long l) {
        this.arch = l;
    }

    public void setArchName(String string) {
        this.archName = string;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public void setEntryAddress(long l) {
        this.entryAddress = l;
    }

    public void setProgramHeaderTableOffset(long l) {
        this.programHeaderTableOffset = l;
    }

    public void setSectionHeaderTableOffset(long l) {
        this.sectionHeaderTableOffset = l;
    }

    public void setProcessorSpecificFlags(long l) {
        this.processorSpecificFlags = l;
    }

    public void setHeaderSize(long l) {
        this.headerSize = l;
    }

    public void setProgramHeaderTableEntrySize(long l) {
        this.programHeaderTableEntrySize = l;
    }

    public void setProgramNumber(long l) {
        this.programNumber = l;
    }

    public void setSectionHeaderTableEntrySize(long l) {
        this.sectionHeaderTableEntrySize = l;
    }

    public void setSectionNumber(long l) {
        this.sectionNumber = l;
    }

    public void setStringTableHeaderIndex(long l) {
        this.stringTableHeaderIndex = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ElfHeaderParser)) {
            return false;
        }
        ElfHeaderParser elfHeaderParser = (ElfHeaderParser)object;
        if (!elfHeaderParser.canEqual(this)) {
            return false;
        }
        if (this.getFileFormat() != elfHeaderParser.getFileFormat()) {
            return false;
        }
        if (this.getEndian() != elfHeaderParser.getEndian()) {
            return false;
        }
        if (this.getFileType() != elfHeaderParser.getFileType()) {
            return false;
        }
        if (this.getArch() != elfHeaderParser.getArch()) {
            return false;
        }
        if (this.getVersion() != elfHeaderParser.getVersion()) {
            return false;
        }
        if (this.getEntryAddress() != elfHeaderParser.getEntryAddress()) {
            return false;
        }
        if (this.getProgramHeaderTableOffset() != elfHeaderParser.getProgramHeaderTableOffset()) {
            return false;
        }
        if (this.getSectionHeaderTableOffset() != elfHeaderParser.getSectionHeaderTableOffset()) {
            return false;
        }
        if (this.getProcessorSpecificFlags() != elfHeaderParser.getProcessorSpecificFlags()) {
            return false;
        }
        if (this.getHeaderSize() != elfHeaderParser.getHeaderSize()) {
            return false;
        }
        if (this.getProgramHeaderTableEntrySize() != elfHeaderParser.getProgramHeaderTableEntrySize()) {
            return false;
        }
        if (this.getProgramNumber() != elfHeaderParser.getProgramNumber()) {
            return false;
        }
        if (this.getSectionHeaderTableEntrySize() != elfHeaderParser.getSectionHeaderTableEntrySize()) {
            return false;
        }
        if (this.getSectionNumber() != elfHeaderParser.getSectionNumber()) {
            return false;
        }
        if (this.getStringTableHeaderIndex() != elfHeaderParser.getStringTableHeaderIndex()) {
            return false;
        }
        String string = this.getFileName();
        String string2 = elfHeaderParser.getFileName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        BinaryFileReader binaryFileReader = this.getBinaryFileReader();
        BinaryFileReader binaryFileReader2 = elfHeaderParser.getBinaryFileReader();
        if (binaryFileReader == null ? binaryFileReader2 != null : !binaryFileReader.equals(binaryFileReader2)) {
            return false;
        }
        if (!Arrays.equals(this.getElfIdentification(), elfHeaderParser.getElfIdentification())) {
            return false;
        }
        String string3 = this.getArchName();
        String string4 = elfHeaderParser.getArchName();
        return !(string3 == null ? string4 != null : !string3.equals(string4));
    }

    protected boolean canEqual(Object object) {
        return object instanceof ElfHeaderParser;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getFileFormat();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getEndian();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getFileType();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        long l4 = this.getArch();
        n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
        long l5 = this.getVersion();
        n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
        long l6 = this.getEntryAddress();
        n2 = n2 * 59 + (int)(l6 >>> 32 ^ l6);
        long l7 = this.getProgramHeaderTableOffset();
        n2 = n2 * 59 + (int)(l7 >>> 32 ^ l7);
        long l8 = this.getSectionHeaderTableOffset();
        n2 = n2 * 59 + (int)(l8 >>> 32 ^ l8);
        long l9 = this.getProcessorSpecificFlags();
        n2 = n2 * 59 + (int)(l9 >>> 32 ^ l9);
        long l10 = this.getHeaderSize();
        n2 = n2 * 59 + (int)(l10 >>> 32 ^ l10);
        long l11 = this.getProgramHeaderTableEntrySize();
        n2 = n2 * 59 + (int)(l11 >>> 32 ^ l11);
        long l12 = this.getProgramNumber();
        n2 = n2 * 59 + (int)(l12 >>> 32 ^ l12);
        long l13 = this.getSectionHeaderTableEntrySize();
        n2 = n2 * 59 + (int)(l13 >>> 32 ^ l13);
        long l14 = this.getSectionNumber();
        n2 = n2 * 59 + (int)(l14 >>> 32 ^ l14);
        long l15 = this.getStringTableHeaderIndex();
        n2 = n2 * 59 + (int)(l15 >>> 32 ^ l15);
        String string = this.getFileName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        BinaryFileReader binaryFileReader = this.getBinaryFileReader();
        n2 = n2 * 59 + (binaryFileReader == null ? 43 : binaryFileReader.hashCode());
        n2 = n2 * 59 + Arrays.hashCode(this.getElfIdentification());
        String string2 = this.getArchName();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        return n2;
    }

    public String toString() {
        return "ElfHeaderParser(fileName=" + this.getFileName() + ", binaryFileReader=" + this.getBinaryFileReader() + ", fileFormat=" + this.getFileFormat() + ", endian=" + this.getEndian() + ", elfIdentification=" + Arrays.toString(this.getElfIdentification()) + ", fileType=" + this.getFileType() + ", arch=" + this.getArch() + ", archName=" + this.getArchName() + ", version=" + this.getVersion() + ", entryAddress=" + this.getEntryAddress() + ", programHeaderTableOffset=" + this.getProgramHeaderTableOffset() + ", sectionHeaderTableOffset=" + this.getSectionHeaderTableOffset() + ", processorSpecificFlags=" + this.getProcessorSpecificFlags() + ", headerSize=" + this.getHeaderSize() + ", programHeaderTableEntrySize=" + this.getProgramHeaderTableEntrySize() + ", programNumber=" + this.getProgramNumber() + ", sectionHeaderTableEntrySize=" + this.getSectionHeaderTableEntrySize() + ", sectionNumber=" + this.getSectionNumber() + ", stringTableHeaderIndex=" + this.getStringTableHeaderIndex() + ")";
    }

    static {
        archTable.put(new Long(3L), "x86");
        archTable.put(new Long(7L), "x86");
        archTable.put(new Long(8L), ARCH_MIPS);
        archTable.put(new Long(10L), ARCH_MIPS);
        archTable.put(new Long(40L), ARCH_ARM);
        archTable.put(new Long(62L), "x86_64");
        archTable.put(new Long(183L), "arm64-v8a");
    }
}

