/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.BaseAddresses;
import com.uqm.crashsight.symtabtool.dwarf.CallFrameInstruction;
import com.uqm.crashsight.symtabtool.dwarf.CallFrameInstructionIter;
import com.uqm.crashsight.symtabtool.dwarf.CfaRule;
import com.uqm.crashsight.symtabtool.dwarf.CommonInformationEntry;
import com.uqm.crashsight.symtabtool.dwarf.FrameDescriptionEntry;
import com.uqm.crashsight.symtabtool.dwarf.RegisterAndOffset;
import com.uqm.crashsight.symtabtool.dwarf.RegisterRule;
import com.uqm.crashsight.symtabtool.dwarf.UninitializedUnwindContext;
import com.uqm.crashsight.symtabtool.dwarf.UnwindContext;
import com.uqm.crashsight.symtabtool.dwarf.UnwindSection;
import com.uqm.crashsight.symtabtool.dwarf.UnwindTableRow;

class UnwindTable {
    long codeAlignmentFactor;
    long dataAlignmentFactor;
    long nextStartAddress;
    long lastEndAddress;
    boolean returnedLastRow;
    CallFrameInstructionIter instructions;
    UnwindContext ctx;

    public UnwindTable(long l, long l2, long l3, long l4, boolean bl, CallFrameInstructionIter callFrameInstructionIter, UnwindContext unwindContext) {
        this.codeAlignmentFactor = l;
        this.dataAlignmentFactor = l2;
        this.nextStartAddress = l3;
        this.lastEndAddress = l4;
        this.returnedLastRow = bl;
        this.instructions = callFrameInstructionIter;
        this.ctx = unwindContext;
    }

    public static UnwindTable _new(UnwindSection unwindSection, BaseAddresses baseAddresses, UninitializedUnwindContext uninitializedUnwindContext, FrameDescriptionEntry frameDescriptionEntry) {
        UnwindContext unwindContext = uninitializedUnwindContext.initialize(unwindSection, baseAddresses, frameDescriptionEntry.cie);
        return UnwindTable.newForFde(unwindSection, baseAddresses, unwindContext, frameDescriptionEntry);
    }

    public static UnwindTable newForCie(UnwindSection unwindSection, BaseAddresses baseAddresses, UnwindContext unwindContext, CommonInformationEntry commonInformationEntry) {
        assert (unwindContext.stack().length >= 1);
        return new UnwindTable(commonInformationEntry.codeAlignmentFactor, commonInformationEntry.dataAlignmentFactor, 0L, 0L, false, commonInformationEntry.instructions(unwindSection, baseAddresses), unwindContext);
    }

    public static UnwindTable newForFde(UnwindSection unwindSection, BaseAddresses baseAddresses, UnwindContext unwindContext, FrameDescriptionEntry frameDescriptionEntry) {
        assert (unwindContext.stack().length >= 1);
        return new UnwindTable(frameDescriptionEntry.cie.codeAlignmentFactor, frameDescriptionEntry.cie.dataAlignmentFactor, frameDescriptionEntry.initialAddress, frameDescriptionEntry.initialAddress + frameDescriptionEntry.len(), false, frameDescriptionEntry.instructions(unwindSection, baseAddresses), unwindContext);
    }

    public UnwindTableRow nextRow() {
        UnwindTableRow[] unwindTableRowArray = this.ctx.stack();
        int n = unwindTableRowArray.length;
        if (n < 1) {
            return null;
        }
        this.ctx.setStartAddress(this.nextStartAddress);
        try {
            CallFrameInstruction callFrameInstruction;
            do {
                if ((callFrameInstruction = this.instructions.next()) != null) continue;
                if (this.returnedLastRow) {
                    return null;
                }
                UnwindTableRow unwindTableRow = this.ctx.row();
                unwindTableRow.endAddress = this.lastEndAddress;
                this.returnedLastRow = true;
                return unwindTableRow;
            } while (!this.evaluate(callFrameInstruction));
            return this.ctx.row();
        }
        catch (RuntimeException runtimeException) {
            Log.error(runtimeException);
            throw runtimeException;
        }
    }

    public boolean evaluate(CallFrameInstruction callFrameInstruction) {
        Object object;
        if (callFrameInstruction.setLoc != null) {
            if (callFrameInstruction.setLoc.address < this.ctx.startAddress()) {
                throw new RuntimeException("InvalidAddressRange");
            }
            this.ctx.row().endAddress = this.nextStartAddress = callFrameInstruction.setLoc.address;
            return true;
        }
        if (callFrameInstruction.advanceLoc != null) {
            long l = callFrameInstruction.advanceLoc.delta * this.codeAlignmentFactor;
            this.ctx.row().endAddress = this.nextStartAddress = this.ctx.startAddress() + l;
            return true;
        }
        if (callFrameInstruction.defCfa != null) {
            object = new CfaRule();
            ((CfaRule)object).registerAndOffset = new RegisterAndOffset(callFrameInstruction.defCfa.register, callFrameInstruction.defCfa.offset);
            this.ctx.setCfa((CfaRule)object);
        }
        if (callFrameInstruction.defCfaSf != null) {
            object = new CfaRule();
            ((CfaRule)object).registerAndOffset = new RegisterAndOffset(callFrameInstruction.defCfaSf.register, callFrameInstruction.defCfaSf.factoredOffset * this.dataAlignmentFactor);
            this.ctx.setCfa((CfaRule)object);
        }
        if (callFrameInstruction.defCfaRegister != null) {
            object = this.ctx.cfa().registerAndOffset;
            if (object != null) {
                ((RegisterAndOffset)object).register = callFrameInstruction.defCfaRegister.register;
            } else {
                throw new RuntimeException("CfiInstructionInInvalidContext");
            }
        }
        if (callFrameInstruction.defCfaOffset != null) {
            object = this.ctx.cfa().registerAndOffset;
            if (object != null) {
                ((RegisterAndOffset)object).offset = callFrameInstruction.defCfaOffset.offset;
            } else {
                throw new RuntimeException("CfiInstructionInInvalidContext");
            }
        }
        if (callFrameInstruction.defCfaOffsetSf != null) {
            object = this.ctx.cfa().registerAndOffset;
            if (object != null) {
                ((RegisterAndOffset)object).offset = callFrameInstruction.defCfaOffsetSf.factoredOffset * this.dataAlignmentFactor;
            } else {
                throw new RuntimeException("CfiInstructionInInvalidContext");
            }
        }
        if (callFrameInstruction.defCfaExpression != null) {
            object = new CfaRule();
            ((CfaRule)object).expression = callFrameInstruction.defCfaExpression.expression;
            this.ctx.setCfa((CfaRule)object);
        }
        if (callFrameInstruction.undefined != null) {
            this.ctx.setRegisterRule(callFrameInstruction.undefined.register, RegisterRule.undefined());
        }
        if (callFrameInstruction.sameValue != null) {
            this.ctx.setRegisterRule(callFrameInstruction.sameValue.register, RegisterRule.sameValue());
        }
        if (callFrameInstruction.offset != null) {
            this.ctx.setRegisterRule(callFrameInstruction.offset.register, RegisterRule.offset(callFrameInstruction.offset.factoredOffset * this.dataAlignmentFactor));
        }
        if (callFrameInstruction.offsetExtendedSf != null) {
            this.ctx.setRegisterRule(callFrameInstruction.offsetExtendedSf.register, RegisterRule.offset(callFrameInstruction.offsetExtendedSf.factoredOffset * this.dataAlignmentFactor));
        }
        if (callFrameInstruction.valueOffset != null) {
            this.ctx.setRegisterRule(callFrameInstruction.valueOffset.register, RegisterRule.valueOffset(callFrameInstruction.valueOffset.factoredOffset * this.dataAlignmentFactor));
        }
        if (callFrameInstruction.valueOffsetSf != null) {
            this.ctx.setRegisterRule(callFrameInstruction.valueOffsetSf.register, RegisterRule.valueOffset(callFrameInstruction.valueOffsetSf.factoredOffset * this.dataAlignmentFactor));
        }
        if (callFrameInstruction.cfaRegister != null) {
            this.ctx.setRegisterRule(callFrameInstruction.cfaRegister.destRegister, RegisterRule.register(callFrameInstruction.cfaRegister.srcRegister));
        }
        if (callFrameInstruction.expression != null) {
            this.ctx.setRegisterRule(callFrameInstruction.expression.register, RegisterRule.expression(callFrameInstruction.expression.expression));
        }
        if (callFrameInstruction.valExpression != null) {
            this.ctx.setRegisterRule(callFrameInstruction.valExpression.register, RegisterRule.valExpression(callFrameInstruction.valExpression.expression));
        }
        if (callFrameInstruction.restore != null) {
            object = this.ctx.getInitialRule(callFrameInstruction.restore.register);
            this.ctx.setRegisterRule(callFrameInstruction.restore.register, (RegisterRule)object);
        }
        if (callFrameInstruction.rememberState != null) {
            this.ctx.pushRow();
        }
        if (callFrameInstruction.restoreState != null) {
            assert (this.ctx.stack().length > 0);
            if (this.ctx.stack().length == 1) {
                throw new RuntimeException("PopWithEmptyStack");
            }
            long l = this.ctx.startAddress();
            this.ctx.popRow();
            this.ctx.setStartAddress(l);
        }
        if (callFrameInstruction.argsSize != null) {
            this.ctx.row().savedArgsSize = callFrameInstruction.argsSize.size;
        }
        if (callFrameInstruction.nop != null) {
            Log.debug("nop", new Object[0]);
        }
        return false;
    }
}

