/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class SectionParseBuffer {
    private static final long FIX_LEB128 = 127L;
    private ByteBuffer buffer;
    private final ByteBuffer tmpBuffer = ByteBuffer.allocate(8);
    private final byte[] tmpBytes = new byte[8];
    private long initialSize = 0L;

    public SectionParseBuffer(String string, long l, int n, ByteOrder byteOrder) throws IOException {
        ByteBuffer byteBuffer = FileHelper.readFileToByteBuffer(string, l, n);
        byteBuffer.order(byteOrder);
        this.initialSize = n;
        this.buffer = byteBuffer;
    }

    public long pos() {
        return this.buffer.position();
    }

    public void pos(long l) {
        this.buffer.position((int)l);
    }

    public void skip(long l) {
        int n = (int)((long)this.buffer.position() + l);
        this.buffer.position(Math.min(n, this.buffer.limit()));
    }

    public long len() {
        return this.buffer.remaining();
    }

    public boolean isEmpty() {
        return this.len() == 0L;
    }

    public void align(long l) {
        long l2 = this.pos() % l;
        if (l2 > 0L) {
            if (this.len() < l - l2) {
                Log.error("UnexpectedEof", new Object[0]);
            }
            this.pos(this.pos() + (l - l2));
        }
    }

    public byte readI8() {
        return this.buffer.get();
    }

    public short readI16() {
        return this.buffer.getShort();
    }

    public int readI32() {
        return this.buffer.getInt();
    }

    public long readI64() {
        return this.buffer.getLong();
    }

    public short readU8() {
        byte by = this.buffer.get();
        this.tmpBuffer.clear();
        this.tmpBuffer.put((byte)0);
        this.tmpBuffer.put(by);
        this.tmpBuffer.flip();
        return this.tmpBuffer.getShort();
    }

    public byte readByte() {
        return this.buffer.get();
    }

    public int readU16() {
        this.buffer.get(this.tmpBytes, 0, 2);
        this.tmpBuffer.clear();
        this.tmpBuffer.putShort((short)0);
        for (int i = 1; i >= 0; --i) {
            this.tmpBuffer.put(this.tmpBytes[i]);
        }
        this.tmpBuffer.flip();
        return this.tmpBuffer.getInt();
    }

    public long readU32() {
        this.buffer.get(this.tmpBytes, 0, 4);
        this.tmpBuffer.clear();
        this.tmpBuffer.putInt(0);
        for (int i = 3; i >= 0; --i) {
            this.tmpBuffer.put(this.tmpBytes[i]);
        }
        this.tmpBuffer.flip();
        return this.tmpBuffer.getLong();
    }

    public long parseULeb128() {
        byte by;
        long l = 0L;
        long l2 = 0L;
        do {
            by = this.buffer.get();
            l |= ((long)by & 0x7FL) << (int)l2;
            l2 += 7L;
        } while ((by & 0x80) != 0);
        return l;
    }

    public long parseSLeb128() {
        byte by;
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        do {
            by = this.buffer.get();
            l |= ((long)by & 0x7FL) << (int)l2;
            l2 += 7L;
            boolean bl2 = bl = (by & 0x40) != 0;
        } while ((by & 0x80) != 0);
        if (bl) {
            l |= -(1L << (int)l2);
        }
        return l;
    }

    public int find(byte by) {
        int n = 0;
        while ((long)n < this.initialSize && this.buffer.get() != by) {
            ++n;
        }
        return (long)n == this.initialSize ? -1 : n;
    }

    public String parseAddress(long l) {
        long l2 = 0L;
        if (32L == l) {
            l2 = this.readU32();
        } else if (64L == l) {
            l2 = this.readI64();
        }
        return Long.toHexString(l2);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public ByteBuffer getTmpBuffer() {
        return this.tmpBuffer;
    }

    public byte[] getTmpBytes() {
        return this.tmpBytes;
    }

    public long getInitialSize() {
        return this.initialSize;
    }

    public void setBuffer(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    public void setInitialSize(long l) {
        this.initialSize = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SectionParseBuffer)) {
            return false;
        }
        SectionParseBuffer sectionParseBuffer = (SectionParseBuffer)object;
        if (!sectionParseBuffer.canEqual(this)) {
            return false;
        }
        if (this.getInitialSize() != sectionParseBuffer.getInitialSize()) {
            return false;
        }
        ByteBuffer byteBuffer = this.getBuffer();
        ByteBuffer byteBuffer2 = sectionParseBuffer.getBuffer();
        if (byteBuffer == null ? byteBuffer2 != null : !((Object)byteBuffer).equals(byteBuffer2)) {
            return false;
        }
        ByteBuffer byteBuffer3 = this.getTmpBuffer();
        ByteBuffer byteBuffer4 = sectionParseBuffer.getTmpBuffer();
        if (byteBuffer3 == null ? byteBuffer4 != null : !((Object)byteBuffer3).equals(byteBuffer4)) {
            return false;
        }
        return Arrays.equals(this.getTmpBytes(), sectionParseBuffer.getTmpBytes());
    }

    protected boolean canEqual(Object object) {
        return object instanceof SectionParseBuffer;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getInitialSize();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        ByteBuffer byteBuffer = this.getBuffer();
        n2 = n2 * 59 + (byteBuffer == null ? 43 : ((Object)byteBuffer).hashCode());
        ByteBuffer byteBuffer2 = this.getTmpBuffer();
        n2 = n2 * 59 + (byteBuffer2 == null ? 43 : ((Object)byteBuffer2).hashCode());
        n2 = n2 * 59 + Arrays.hashCode(this.getTmpBytes());
        return n2;
    }

    public String toString() {
        return "SectionParseBuffer(buffer=" + this.getBuffer() + ", tmpBuffer=" + this.getTmpBuffer() + ", tmpBytes=" + Arrays.toString(this.getTmpBytes()) + ", initialSize=" + this.getInitialSize() + ")";
    }
}

