/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Leb128Parser {
    private static final long FIX_LEB128 = 127L;

    public static long parseULeb128(BinaryFileReader binaryFileReader) throws IOException {
        byte by;
        long l = 0L;
        long l2 = 0L;
        do {
            by = binaryFileReader.readByte();
            l |= ((long)by & 0x7FL) << (int)l2;
            l2 += 7L;
        } while ((by & 0x80) != 0);
        return l;
    }

    public static long parseSLeb128(BinaryFileReader binaryFileReader) throws IOException {
        byte by;
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        do {
            by = binaryFileReader.readByte();
            l |= ((long)by & 0x7FL) << (int)l2;
            l2 += 7L;
            boolean bl2 = bl = (by & 0x40) != 0;
        } while ((by & 0x80) != 0);
        if (bl) {
            l |= (long)(-(1 << (int)l2));
        }
        return l;
    }

    public static int writeUnsignedLeb128(ByteBuffer byteBuffer, long l) {
        int n = 0;
        for (long i = l >>> 7; i != 0L; i >>>= 7) {
            byteBuffer.put((byte)(l & 0x7FL | 0x80L));
            ++n;
            l = i;
        }
        byteBuffer.put((byte)(l & 0x7FL));
        return ++n;
    }

    public static void writeSignedLeb128(ByteBuffer byteBuffer, int n) {
        int n2;
        int n3 = n >> 7;
        boolean bl = true;
        int n4 = n2 = (n & Integer.MIN_VALUE) == 0 ? 0 : -1;
        while (bl) {
            bl = n3 != n2 || (n3 & 1) != (n >> 6 & 1);
            byteBuffer.put((byte)(n & 0x7F | (bl ? 128 : 0)));
            n = n3;
            n3 >>= 7;
        }
    }
}

