/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.Subroutine;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.symtab.Symbol;
import com.uqm.crashsight.symtabtool.symtab.SymbolTable;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class IntervalDifference {
    private static Vector<Symbol> mergeIntervals(SymbolTable symbolTable) {
        Symbol symbol = symbolTable.lastNext();
        if (symbol == null) {
            return new Vector<Symbol>();
        }
        Vector<Symbol> vector = new Vector<Symbol>();
        vector.add(symbol);
        symbol = symbolTable.lastNext();
        while (symbol != null) {
            Symbol symbol2 = vector.get(vector.size() - 1);
            if (symbol.getAddress() <= symbol2.getEndAddress()) {
                symbol2.setEndAddress(Math.max(symbol2.getEndAddress(), symbol.getEndAddress()));
            } else {
                vector.add(symbol);
            }
            symbol = symbolTable.lastNext();
        }
        return vector;
    }

    private static Vector<Subroutine> mergeIntervals(Vector<Subroutine> vector) {
        if (vector == null || vector.isEmpty()) {
            return new Vector<Subroutine>();
        }
        Vector<Subroutine> vector2 = new Vector<Subroutine>();
        vector2.add(vector.get(0));
        for (int i = 1; i < vector.size(); ++i) {
            Subroutine subroutine = vector.get(i);
            Subroutine subroutine2 = vector2.get(vector2.size() - 1);
            if (subroutine.getLowPc() <= subroutine2.getHighPc() && StringUtils.equalsIgnoreCase(subroutine.getName(), subroutine2.getName())) {
                subroutine2.setHighPc(Math.max(subroutine2.getHighPc(), subroutine.getHighPc()));
                continue;
            }
            vector2.add(subroutine);
        }
        return vector2;
    }

    public static Vector<Symbol> getDifference(SymbolTable symbolTable, Vector<Subroutine> vector) {
        Vector<Symbol> vector2 = IntervalDifference.mergeIntervals(symbolTable);
        Vector<Subroutine> vector3 = IntervalDifference.mergeIntervals(vector);
        Log.warn("mergedA size: " + vector2.size(), new Object[0]);
        Log.warn("mergedB size: " + vector3.size(), new Object[0]);
        Vector<Symbol> vector4 = new Vector<Symbol>();
        for (Subroutine subroutine : vector3) {
            long l = subroutine.getHighPc();
            long l2 = subroutine.getLowPc();
            for (Symbol symbol : vector2) {
                long l3 = symbol.getAddress();
                long l4 = symbol.getEndAddress();
                if (l4 <= l2) continue;
                if (l3 >= l) break;
                if (l2 < l3) {
                    Symbol symbol2 = new Symbol();
                    symbol2.setAddress(l2);
                    symbol2.setEndAddress(l3);
                    symbol2.setFunction(subroutine.getName());
                    symbol2.setSourceFile(subroutine.getFilePathFromSymtab());
                    vector4.add(symbol2);
                }
                l2 = l4;
            }
            if (l2 >= l) continue;
            Symbol symbol = new Symbol();
            symbol.setAddress(l2);
            symbol.setEndAddress(l);
            symbol.setFunction(subroutine.getName());
            symbol.setSourceFile(subroutine.getFilePathFromSymtab());
            vector4.add(symbol);
        }
        return vector4;
    }

    public static boolean isInter(SymbolTable symbolTable) {
        symbolTable.rewind();
        Symbol symbol = symbolTable.lastNext();
        while (symbol != null && symbol.getEntries().size() > 1) {
            symbol = symbolTable.lastNext();
        }
        if (symbol == null) {
            return false;
        }
        Symbol symbol2 = symbolTable.lastNext();
        while (symbol2 != null) {
            if (symbol2.getEntries().size() > 1) {
                symbol2 = symbolTable.lastNext();
                continue;
            }
            if (symbol.inter(symbol2)) {
                Log.error("cross symbol %s", symbol2.toString());
                Log.error("cross last %s", symbol.toString());
            }
            symbol = symbol2;
            symbol2 = symbolTable.lastNext();
        }
        return true;
    }

    public static Symbol make(long l, long l2, String string) {
        Symbol symbol = new Symbol();
        symbol.setAddress(l);
        symbol.setEndAddress(l2);
        symbol.setFunction(string);
        return symbol;
    }

    public static Subroutine make2(long l, long l2, String string) {
        Subroutine subroutine = new Subroutine();
        subroutine.setLowPc(l);
        subroutine.setHighPc(l2);
        subroutine.setName(string);
        return subroutine;
    }

    public static void main(String[] stringArray) {
        SymbolTable symbolTable = new SymbolTable();
        symbolTable.add(IntervalDifference.make(12L, 15L, "A1"));
        symbolTable.add(IntervalDifference.make(18L, 25L, "A2"));
        Vector<Subroutine> vector = new Vector<Subroutine>();
        vector.add(IntervalDifference.make2(10L, 20L, "B1"));
        System.out.println("Test1: " + IntervalDifference.formatResult(IntervalDifference.getDifference(symbolTable, vector)));
        symbolTable = new SymbolTable();
        symbolTable.add(IntervalDifference.make(5L, 30L, "A1"));
        vector.clear();
        vector.add(IntervalDifference.make2(10L, 20L, "B1"));
        System.out.println("Test2: " + IntervalDifference.formatResult(IntervalDifference.getDifference(symbolTable, vector)));
        symbolTable = new SymbolTable();
        symbolTable.add(IntervalDifference.make(1L, 2L, "A1"));
        vector.clear();
        vector.add(IntervalDifference.make2(3L, 4L, "B1"));
        vector.add(IntervalDifference.make2(5L, 6L, "B2"));
        System.out.println("Test3: " + IntervalDifference.formatResult(IntervalDifference.getDifference(symbolTable, vector)));
    }

    private static String formatResult(Vector<Symbol> vector) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Symbol symbol : vector) {
            stringBuilder.append(symbol.getAddress()).append(",").append(symbol.getEndAddress()).append(",").append(symbol.getFunction());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

