/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.Pair;
import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.Arch;
import com.uqm.crashsight.symtabtool.dwarf.BaseAddresses;
import com.uqm.crashsight.symtabtool.dwarf.CfaRule;
import com.uqm.crashsight.symtabtool.dwarf.CfiEntriesIter;
import com.uqm.crashsight.symtabtool.dwarf.CieOffsetEncoding;
import com.uqm.crashsight.symtabtool.dwarf.CieOrFde;
import com.uqm.crashsight.symtabtool.dwarf.CommonInformationEntry;
import com.uqm.crashsight.symtabtool.dwarf.DebugFrame;
import com.uqm.crashsight.symtabtool.dwarf.DwarfSection;
import com.uqm.crashsight.symtabtool.dwarf.EhFrame;
import com.uqm.crashsight.symtabtool.dwarf.ElfObject;
import com.uqm.crashsight.symtabtool.dwarf.Format;
import com.uqm.crashsight.symtabtool.dwarf.FrameDescriptionEntry;
import com.uqm.crashsight.symtabtool.dwarf.Leb128Parser;
import com.uqm.crashsight.symtabtool.dwarf.PartialFrameDescriptionEntry;
import com.uqm.crashsight.symtabtool.dwarf.Reader;
import com.uqm.crashsight.symtabtool.dwarf.Register;
import com.uqm.crashsight.symtabtool.dwarf.RegisterRule;
import com.uqm.crashsight.symtabtool.dwarf.RegisterRulePair;
import com.uqm.crashsight.symtabtool.dwarf.RunTimeEndian;
import com.uqm.crashsight.symtabtool.dwarf.UninitializedUnwindContext;
import com.uqm.crashsight.symtabtool.dwarf.UnwindInfo;
import com.uqm.crashsight.symtabtool.dwarf.UnwindSection;
import com.uqm.crashsight.symtabtool.dwarf.UnwindTable;
import com.uqm.crashsight.symtabtool.dwarf.UnwindTableRow;
import com.uqm.crashsight.symtabtool.elf.ElfHeaderParser;
import com.uqm.crashsight.symtabtool.elf.ElfParser;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFile;
import java.io.BufferedWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class EhFrameParser {
    ElfObject elfObject = null;
    String archName = null;
    public static Map<Long, CommonInformationEntry> cieMap = new HashMap<Long, CommonInformationEntry>();
    private BufferedWriter writer = null;
    private FileChannel fileChannel = null;
    private ByteBuffer buffer = null;
    public static final int DW_EH_PE_format_omit = 255;
    public static final int DW_EH_PE_uleb128 = 1;
    public static final int DW_EH_PE_udata2 = 2;
    public static final int DW_EH_PE_udata4 = 3;
    public static final int DW_EH_PE_udata8 = 4;
    public static final int DW_EH_PE_sleb128 = 9;
    public static final int DW_EH_PE_sdata2 = 10;
    public static final int DW_EH_PE_sdata4 = 11;
    public static final int DW_EH_PE_sdata8 = 12;
    public static final int DW_EH_PE_absptr = 0;
    public static final int DW_EH_PE_pcrel = 16;
    public static final int DW_EH_PE_datarel = 48;
    public static final int DW_EH_PE_application_omit = 255;
    private String fileName = null;
    private long sectionOffset = 0L;
    private long sectionSize = 0L;
    private BinaryFileReader binaryFileReader = null;

    public ElfObject elfObject(ElfHeaderParser elfHeaderParser, ElfParser elfParser) {
        return new ElfObject(elfHeaderParser, elfParser);
    }

    public static CieOrFde parseCfiEntry(BaseAddresses baseAddresses, UnwindSection unwindSection, Reader reader) {
        long l;
        Serializable serializable;
        Reader reader2;
        Long l2 = null;
        Long l3 = null;
        Format format = Format.Dwarf32;
        do {
            reader2 = unwindSection.section();
            l2 = reader.offsetFrom(reader2);
            serializable = reader.readInitialLength();
            assert (serializable != null);
            l3 = ((Pair)serializable).getKey();
            format = ((Pair)serializable).getValue();
            if (!unwindSection.lengthValueIsEndOfEntries(l3)) continue;
            return null;
        } while (l3 == 0L && format == Format.Dwarf32);
        reader2 = reader.split(l3);
        serializable = reader2.offsetFrom(unwindSection.section());
        CieOffsetEncoding cieOffsetEncoding = unwindSection.cieOffsetEncoding(format);
        long l4 = l = cieOffsetEncoding == CieOffsetEncoding.U32 ? reader2.readU32() : reader2.readU64();
        if (unwindSection.isCie(format, l)) {
            CommonInformationEntry commonInformationEntry = CommonInformationEntry.parseRest(l2, l3, format, baseAddresses, unwindSection, reader2);
            cieMap.put(commonInformationEntry.offset, commonInformationEntry);
            return new CieOrFde(commonInformationEntry, null);
        }
        Long l5 = l;
        l5 = unwindSection.resolveCieOffset((Long)serializable, l5);
        if (l5 == null) {
            throw new RuntimeException("OffsetOutOfBounds");
        }
        PartialFrameDescriptionEntry partialFrameDescriptionEntry = new PartialFrameDescriptionEntry(l2, l3, format, l5, reader2, unwindSection, baseAddresses);
        return new CieOrFde(null, partialFrameDescriptionEntry);
    }

    public void parseDwarf(ElfHeaderParser elfHeaderParser, ElfParser elfParser, FileChannel fileChannel, ByteBuffer byteBuffer) {
        this.fileChannel = fileChannel;
        this.buffer = byteBuffer;
        this.elfObject = this.elfObject(elfHeaderParser, elfParser);
        this.archName = this.elfObject.arch()._name();
        RunTimeEndian runTimeEndian = this.elfObject.endianity();
        DwarfSection dwarfSection = this.elfObject.section(".debug_frame");
        if (dwarfSection != null) {
            dwarfSection = this.elfObject.section(".debug_frame");
            DebugFrame<RunTimeEndian> debugFrame = DebugFrame._new(dwarfSection.data, runTimeEndian);
            UnwindInfo<DebugFrame<RunTimeEndian>> unwindInfo = UnwindInfo._new(this.elfObject, dwarfSection.address, debugFrame);
            this.readCfi(unwindInfo);
        } else {
            dwarfSection = this.elfObject.section(".eh_frame");
            EhFrame<RunTimeEndian> ehFrame = EhFrame._new(dwarfSection.data, runTimeEndian);
            UnwindInfo<EhFrame<RunTimeEndian>> unwindInfo = UnwindInfo._new(this.elfObject, dwarfSection.address, ehFrame);
            this.readCfi(unwindInfo);
        }
    }

    public <U extends UnwindSection> void readCfi(UnwindInfo<U> unwindInfo) {
        CieOrFde cieOrFde;
        UninitializedUnwindContext uninitializedUnwindContext = new UninitializedUnwindContext();
        CfiEntriesIter cfiEntriesIter = ((UnwindSection)unwindInfo.section).entries(unwindInfo.bases);
        while ((cieOrFde = cfiEntriesIter.next()) != null) {
            PartialFrameDescriptionEntry partialFrameDescriptionEntry;
            FrameDescriptionEntry frameDescriptionEntry;
            if (cieOrFde.fde == null || (frameDescriptionEntry = (partialFrameDescriptionEntry = cieOrFde.fde).parse(cieMap)) == null) continue;
            this.processFde(unwindInfo, uninitializedUnwindContext, frameDescriptionEntry);
        }
    }

    public <U extends UnwindSection> void processFde(UnwindInfo<U> unwindInfo, UninitializedUnwindContext uninitializedUnwindContext, FrameDescriptionEntry frameDescriptionEntry) {
        UnwindTableRow unwindTableRow;
        Register register = frameDescriptionEntry.cie.returnAddressRegister;
        UnwindTable unwindTable = frameDescriptionEntry.rows((UnwindSection)unwindInfo.section, unwindInfo.bases, uninitializedUnwindContext);
        ArrayList<UnwindTableRow> arrayList = new ArrayList<UnwindTableRow>();
        while ((unwindTableRow = unwindTable.nextRow()) != null) {
            UnwindTableRow unwindTableRow2 = unwindTableRow._clone();
            arrayList.add(unwindTableRow2);
        }
        unwindTableRow = (UnwindTableRow)arrayList.get(0);
        long l = unwindTableRow.startAddress;
        long l2 = ((UnwindTableRow)arrayList.get((int)(arrayList.size() - 1))).endAddress - l;
        if (l < unwindInfo.loadAddress) {
            return;
        }
        HashMap<Long, RegisterRule> hashMap = new HashMap<Long, RegisterRule>();
        CfaRule cfaRule = null;
        for (UnwindTableRow unwindTableRow3 : arrayList) {
            long l3;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            if (unwindTableRow3.startAddress == l) {
                l3 = l - unwindInfo.loadAddress;
                stringBuilder.append(String.format(Locale.ROOT, "STACK CFI INIT %x %x", l3, l2));
            } else {
                l3 = unwindTableRow3.startAddress - unwindInfo.loadAddress;
                stringBuilder.append(String.format(Locale.ROOT, "STACK CFI %x", l3));
            }
            if (cfaRule == null || !cfaRule.equals(unwindTableRow3.cfa)) {
                cfaRule = unwindTableRow3.cfa;
                bl = EhFrameParser.writeCfaRule(stringBuilder, unwindInfo.arch, unwindTableRow3.cfa);
            }
            for (RegisterRulePair registerRulePair : unwindTableRow3.registers.rules()) {
                long l4 = registerRulePair.register.val;
                RegisterRule registerRule = (RegisterRule)hashMap.get(l4);
                if (registerRule != null && registerRule.equals(registerRulePair.registerRule)) continue;
                hashMap.put(l4, registerRulePair.registerRule);
                bl = EhFrameParser.writeRegisterRule(stringBuilder, unwindInfo.arch, registerRulePair.register, registerRulePair.registerRule, register);
            }
            if (!bl) continue;
            SymtabFile.writeStrToBuffer(this.fileChannel, this.buffer, stringBuilder + "\n");
        }
    }

    public static boolean writeCfaRule(StringBuilder stringBuilder, Arch arch, CfaRule cfaRule) {
        String string = "";
        if (cfaRule.registerAndOffset != null) {
            String string2 = arch.cpuFamily().cfiRegisterName(cfaRule.registerAndOffset.register.val);
            if (string2 != null) {
                string = String.format(Locale.ROOT, "%s %d +", string2, cfaRule.registerAndOffset.offset);
            } else {
                return false;
            }
        }
        if (cfaRule.expression != null) {
            return false;
        }
        stringBuilder.append(String.format(Locale.ROOT, " .cfa: %s", string));
        return true;
    }

    public static boolean writeRegisterRule(StringBuilder stringBuilder, Arch arch, Register register, RegisterRule registerRule, Register register2) {
        String string;
        String string2 = "";
        if (registerRule.undefined != null) {
            return false;
        }
        if (registerRule.sameValue != null) {
            string = arch.cpuFamily().cfiRegisterName(register.val);
            if (string != null) {
                string2 = string;
            } else {
                return false;
            }
        }
        if (registerRule.offset != null) {
            string2 = String.format(Locale.ROOT, ".cfa %d + ^", registerRule.offset);
        }
        if (registerRule.valueOffset != null) {
            string2 = String.format(Locale.ROOT, ".cfa %d + ^", registerRule.valueOffset);
        }
        if (registerRule.register != null) {
            string = arch.cpuFamily().cfiRegisterName(registerRule.register.val);
            if (string != null) {
                string2 = string;
            } else {
                return false;
            }
        }
        if (registerRule.expression != null) {
            return false;
        }
        if (registerRule.valExpression != null) {
            return false;
        }
        if (registerRule.architectural != null) {
            return false;
        }
        if (register.val == register2.val) {
            string = ".ra";
        } else {
            String string3 = arch.cpuFamily().cfiRegisterName(register.val);
            if (string3 != null) {
                string = string3;
            } else {
                return false;
            }
        }
        stringBuilder.append(String.format(Locale.ROOT, " %s: %s", string, string2));
        return true;
    }

    private boolean checkInit() {
        return this.sectionOffset >= 0L && this.sectionSize > 0L;
    }

    private boolean openFile() {
        if (!this.checkInit()) {
            return false;
        }
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName);
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
        return this.binaryFileReader.skip(this.sectionOffset);
    }

    private void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            Log.error("Failed to open file\uff1a%s", this.fileName);
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean parse(BufferedWriter bufferedWriter) {
        try {
            Log.info("Contents of the .eh_frame section:\n\n", new Object[0]);
            if (!this.openFile()) {
                this.close();
                return false;
            }
            long l = 0L;
            int n = 255;
            int n2 = 255;
            boolean bl = false;
            long l2 = 0L;
            long l3 = 64L;
            long l4 = 0L;
            while (this.binaryFileReader.getOffset() - this.sectionOffset < this.sectionSize) {
                long l5;
                long l6 = this.binaryFileReader.getOffset() - this.sectionOffset;
                long l7 = this.binaryFileReader.readUInt();
                if (l7 == 0L) {
                    Log.error("CIE process end", new Object[0]);
                    break;
                }
                long l8 = Long.compare(l7, -1L) == 0 ? 64L : 32L;
                long l9 = 0L;
                if (l8 == 64L) {
                    l9 = this.binaryFileReader.readULong();
                }
                if ((l5 = this.binaryFileReader.readUInt()) != 0L) continue;
                n = 255;
                n2 = 255;
                bl = false;
                l = l6;
                byte by = this.binaryFileReader.readByte();
                StringBuilder stringBuilder = new StringBuilder();
                char c = '\u0000';
                while ((c = (char)(this.binaryFileReader.readByte() & 0xFF)) != '\u0000') {
                    stringBuilder.append(c);
                }
                String string = stringBuilder.toString();
                long l10 = 0L;
                if (string.contains("eh")) {
                    l10 = l8 == 32L ? this.binaryFileReader.readUInt() : this.binaryFileReader.readULong();
                }
                long l11 = Leb128Parser.parseULeb128(this.binaryFileReader);
                long l12 = Leb128Parser.parseSLeb128(this.binaryFileReader);
                short s2 = this.binaryFileReader.readByte();
                byte[] byArray = null;
                long l13 = 0L;
                if (string.charAt(0) != 'z') continue;
                bl = true;
                l13 = Leb128Parser.parseULeb128(this.binaryFileReader);
                byArray = new byte[(int)l13];
                this.binaryFileReader.readByteArray(byArray);
                block8: for (int i = 1; i < string.length(); ++i) {
                    char c2 = string.charAt(i);
                    switch (c2) {
                        case 'L': {
                            n = this.binaryFileReader.readByte();
                            continue block8;
                        }
                        case 'P': {
                            short s3 = this.binaryFileReader.readByte();
                        }
                    }
                }
            }
            return true;
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
    }

    public ElfObject getElfObject() {
        return this.elfObject;
    }

    public String getArchName() {
        return this.archName;
    }

    public BufferedWriter getWriter() {
        return this.writer;
    }

    public FileChannel getFileChannel() {
        return this.fileChannel;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSectionOffset() {
        return this.sectionOffset;
    }

    public long getSectionSize() {
        return this.sectionSize;
    }

    public BinaryFileReader getBinaryFileReader() {
        return this.binaryFileReader;
    }

    public void setElfObject(ElfObject elfObject) {
        this.elfObject = elfObject;
    }

    public void setArchName(String string) {
        this.archName = string;
    }

    public void setWriter(BufferedWriter bufferedWriter) {
        this.writer = bufferedWriter;
    }

    public void setFileChannel(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    public void setBuffer(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setSectionOffset(long l) {
        this.sectionOffset = l;
    }

    public void setSectionSize(long l) {
        this.sectionSize = l;
    }

    public void setBinaryFileReader(BinaryFileReader binaryFileReader) {
        this.binaryFileReader = binaryFileReader;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EhFrameParser)) {
            return false;
        }
        EhFrameParser ehFrameParser = (EhFrameParser)object;
        if (!ehFrameParser.canEqual(this)) {
            return false;
        }
        if (this.getSectionOffset() != ehFrameParser.getSectionOffset()) {
            return false;
        }
        if (this.getSectionSize() != ehFrameParser.getSectionSize()) {
            return false;
        }
        ElfObject elfObject = this.getElfObject();
        ElfObject elfObject2 = ehFrameParser.getElfObject();
        if (elfObject == null ? elfObject2 != null : !elfObject.equals(elfObject2)) {
            return false;
        }
        String string = this.getArchName();
        String string2 = ehFrameParser.getArchName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        BufferedWriter bufferedWriter = this.getWriter();
        BufferedWriter bufferedWriter2 = ehFrameParser.getWriter();
        if (bufferedWriter == null ? bufferedWriter2 != null : !bufferedWriter.equals(bufferedWriter2)) {
            return false;
        }
        FileChannel fileChannel = this.getFileChannel();
        FileChannel fileChannel2 = ehFrameParser.getFileChannel();
        if (fileChannel == null ? fileChannel2 != null : !fileChannel.equals(fileChannel2)) {
            return false;
        }
        ByteBuffer byteBuffer = this.getBuffer();
        ByteBuffer byteBuffer2 = ehFrameParser.getBuffer();
        if (byteBuffer == null ? byteBuffer2 != null : !((Object)byteBuffer).equals(byteBuffer2)) {
            return false;
        }
        String string3 = this.getFileName();
        String string4 = ehFrameParser.getFileName();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        BinaryFileReader binaryFileReader = this.getBinaryFileReader();
        BinaryFileReader binaryFileReader2 = ehFrameParser.getBinaryFileReader();
        return !(binaryFileReader == null ? binaryFileReader2 != null : !binaryFileReader.equals(binaryFileReader2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof EhFrameParser;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getSectionOffset();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getSectionSize();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        ElfObject elfObject = this.getElfObject();
        n2 = n2 * 59 + (elfObject == null ? 43 : elfObject.hashCode());
        String string = this.getArchName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        BufferedWriter bufferedWriter = this.getWriter();
        n2 = n2 * 59 + (bufferedWriter == null ? 43 : bufferedWriter.hashCode());
        FileChannel fileChannel = this.getFileChannel();
        n2 = n2 * 59 + (fileChannel == null ? 43 : fileChannel.hashCode());
        ByteBuffer byteBuffer = this.getBuffer();
        n2 = n2 * 59 + (byteBuffer == null ? 43 : ((Object)byteBuffer).hashCode());
        String string2 = this.getFileName();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        BinaryFileReader binaryFileReader = this.getBinaryFileReader();
        n2 = n2 * 59 + (binaryFileReader == null ? 43 : binaryFileReader.hashCode());
        return n2;
    }

    public String toString() {
        return "EhFrameParser(elfObject=" + this.getElfObject() + ", archName=" + this.getArchName() + ", writer=" + this.getWriter() + ", fileChannel=" + this.getFileChannel() + ", buffer=" + this.getBuffer() + ", fileName=" + this.getFileName() + ", sectionOffset=" + this.getSectionOffset() + ", sectionSize=" + this.getSectionSize() + ", binaryFileReader=" + this.getBinaryFileReader() + ")";
    }
}

