/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.file.SectionReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.common.utils.StrUtils;
import com.uqm.crashsight.symtabtool.common.utils.Utils;
import com.uqm.crashsight.symtabtool.dwarf.DebugLineStrParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugStrParser;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Base64;
import java.util.Vector;

public class DebugLineParser {
    private static final byte SPECIAL_OPCODE = 0;
    private static final byte STANDARD_OPCODE = 1;
    private static final byte EXTENDED_OPCODE = 2;
    private static final byte DW_LNS_copy = 1;
    private static final byte DW_LNS_advance_pc = 2;
    private static final byte DW_LNS_advance_line = 3;
    private static final byte DW_LNS_set_file = 4;
    private static final byte DW_LNS_set_column = 5;
    private static final byte DW_LNS_negate_stmt = 6;
    private static final byte DW_LNS_set_basic_block = 7;
    private static final byte DW_LNS_const_add_pc = 8;
    private static final byte DW_LNS_fixed_advance_pc = 9;
    private static final byte DW_LNS_set_prologue_end = 10;
    private static final byte DW_LNS_set_epilogue_begin = 11;
    private static final byte DW_LNS_set_isa = 12;
    private static final byte DW_LNE_end_sequence = 1;
    private static final byte DW_LNE_set_address = 2;
    private static final byte DW_LNE_define_file = 3;
    private static final byte DW_LNE_set_discriminator = 4;
    private static final byte DW_LNE_lo_user = -128;
    private static final byte DW_LNE_hi_user = -1;
    private long registerAddress = 0L;
    private long registerFileIndex = 1L;
    private long registerLine = 1L;
    private long registerColumn = 0L;
    private long registerOpIndex = 0L;
    private boolean registerIsStmt = false;
    private boolean registerBasicBlock = false;
    private boolean registerEndEquence = false;
    private boolean registerPrologueEnd = false;
    private boolean registerEpilogueBegin = false;
    private long registerIsa = 0L;
    private long registerDiscriminator = 0L;
    private String fileName = null;
    private long sectionOffset = 0L;
    private long sectionSize = 0L;
    private long addrBits = 0L;
    private SectionReader binaryFileReader = null;
    boolean isLittleEndian;
    private LineNumberProgramHeader header = null;
    private Vector<DebugLineEntry> lineInfoTable = null;

    public DebugLineParser(String string, long l, long l2, boolean bl) {
        this.fileName = string;
        this.sectionOffset = l;
        this.sectionSize = l2;
        this.isLittleEndian = bl;
    }

    private void initRegisters() {
        this.registerAddress = 0L;
        this.registerFileIndex = 1L;
        this.registerLine = 1L;
        this.registerColumn = 0L;
        this.registerOpIndex = 0L;
        this.registerIsStmt = false;
        this.registerBasicBlock = false;
        this.registerEndEquence = false;
        this.registerPrologueEnd = false;
        this.registerEpilogueBegin = false;
        this.registerIsa = 0L;
        this.registerDiscriminator = 0L;
    }

    public String getSourceFile(int n) {
        if (this.header == null) {
            return null;
        }
        return this.header.getPathName(n);
    }

    public void setAddrBits(long l) {
        switch ((int)l) {
            case 4: 
            case 32: {
                this.addrBits = 32L;
                break;
            }
            case 8: 
            case 64: {
                this.addrBits = 64L;
                break;
            }
            default: {
                this.addrBits = 32L;
                Log.warn("Address bits error, default to 32", new Object[0]);
            }
        }
    }

    private void clearEnv() {
        this.header = null;
        this.lineInfoTable = null;
        this.binaryFileReader.resetReadBytes();
        this.initRegisters();
    }

    private boolean checkInit() {
        return this.sectionOffset >= 0L && this.sectionSize > 0L;
    }

    public void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (this.binaryFileReader.isUseParseBuffer()) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (this.binaryFileReader != null && this.binaryFileReader.isUseParseBuffer()) {
            this.binaryFileReader.resetParseBuffer();
            return true;
        }
        if (!this.checkInit()) {
            return false;
        }
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new SectionReader(this.fileName, this.sectionOffset, this.sectionSize, this.isLittleEndian);
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
        return true;
    }

    private boolean checkAddrBits() {
        return 0L != this.addrBits;
    }

    public Vector<DebugLineEntry> getLineInfoTable(long l, DebugStrParser debugStrParser, DebugLineStrParser debugLineStrParser) {
        if (!this.checkAddrBits()) {
            return null;
        }
        if (l < 0L || l >= this.sectionSize) {
            return null;
        }
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(l)) {
            this.close();
            return null;
        }
        if (l == 61272325L) {
            boolean bl = true;
        }
        return this.next(debugStrParser, debugLineStrParser);
    }

    public Vector<DebugLineEntry> next(DebugStrParser debugStrParser, DebugLineStrParser debugLineStrParser) {
        if (null == this.binaryFileReader && !this.openFile()) {
            return null;
        }
        if (this.getSectionRestLength() <= 0L) {
            return null;
        }
        this.clearEnv();
        this.lineInfoTable = new Vector();
        this.header = new LineNumberProgramHeader(this.binaryFileReader, debugStrParser, debugLineStrParser);
        if (!this.header.parse()) {
            return null;
        }
        if (!this.parseOpcode()) {
            return null;
        }
        return this.lineInfoTable;
    }

    public long getSectionRestLength() {
        long l = this.binaryFileReader.getOffset() - this.sectionOffset;
        return this.sectionSize - l;
    }

    private long getUnitRestLength() {
        return this.header.getUnitLength() - this.binaryFileReader.getReadBytesNum();
    }

    private boolean parseOpcode() {
        boolean bl = false;
        while (this.getUnitRestLength() > 0L) {
            byte by = 0;
            try {
                by = this.binaryFileReader.readByte();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            byte by2 = this.getOpcodeType(by);
            switch (by2) {
                case 0: {
                    bl = this.parseSpecialOpcode(by);
                    break;
                }
                case 1: {
                    bl = this.parseStandardOpcode(by);
                    break;
                }
                case 2: {
                    bl = this.parseExtendedOpcode();
                    break;
                }
            }
            if (bl) continue;
            Log.error("Faile to parse opcode of debug line", new Object[0]);
            return false;
        }
        return true;
    }

    private byte getOpcodeType(byte by) {
        if (0 == by) {
            return 2;
        }
        if (by > 0 && (long)by < this.header.getOpcodeBase()) {
            return 1;
        }
        return 0;
    }

    private boolean parseSpecialOpcode(byte by) {
        long l = Utils.unsignedToLong(by);
        if (l < this.header.getOpcodeBase()) {
            Log.error("Faile to special opcode of debug line", new Object[0]);
            return false;
        }
        long l2 = l - this.header.getOpcodeBase();
        long l3 = (long)this.header.getLineBase() + l2 % this.header.getLineRange();
        long l4 = l2 / this.header.getLineRange() * this.header.getMinInstructionLength();
        this.registerLine += l3;
        this.registerAddress += l4;
        this.registerBasicBlock = false;
        this.addToLineInfoTable();
        return true;
    }

    private boolean parseStandardOpcode(byte by) {
        long l = Utils.unsignedToLong(by);
        if (l >= this.header.getOpcodeBase()) {
            Log.error("Faile to standard opcode of debug line", new Object[0]);
            return false;
        }
        long l2 = 0L;
        long l3 = 0L;
        try {
            switch (by) {
                case 1: {
                    this.addToLineInfoTable();
                    this.registerBasicBlock = false;
                    break;
                }
                case 2: {
                    l2 = this.binaryFileReader.parseULeb128() * this.header.getMinInstructionLength();
                    this.registerAddress += l2;
                    break;
                }
                case 3: {
                    l3 = this.binaryFileReader.parseSLeb128();
                    this.registerLine += l3;
                    break;
                }
                case 4: {
                    this.registerFileIndex = this.binaryFileReader.parseULeb128();
                    break;
                }
                case 5: {
                    this.registerColumn = this.binaryFileReader.parseULeb128();
                    break;
                }
                case 6: {
                    this.registerIsStmt = !this.registerIsStmt;
                    break;
                }
                case 7: {
                    this.registerBasicBlock = true;
                    break;
                }
                case 8: {
                    long l4 = 255L - this.header.getOpcodeBase();
                    l2 = l4 / this.header.getLineRange() * this.header.getMinInstructionLength();
                    this.registerAddress += l2;
                    break;
                }
                case 9: {
                    this.registerAddress += this.binaryFileReader.readUShort();
                    break;
                }
                case 10: {
                    this.registerPrologueEnd = true;
                    break;
                }
                case 11: {
                    this.registerEpilogueBegin = true;
                    break;
                }
                case 12: {
                    this.registerIsa = this.binaryFileReader.parseULeb128();
                    break;
                }
                default: {
                    Log.error("Faile to standard opcode of debug line for code: %x", by);
                    return false;
                }
            }
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return false;
        }
        return true;
    }

    private boolean parseExtendedOpcode() {
        try {
            this.binaryFileReader.parseULeb128();
            long l = this.binaryFileReader.readUByte();
            switch ((int)l) {
                case 1: {
                    if (this.registerAddress == 28365628L) {
                        boolean bl = true;
                    }
                    this.fixLastEndAddress();
                    this.initRegisters();
                    break;
                }
                case 2: {
                    if (32L == this.addrBits) {
                        this.registerAddress = this.binaryFileReader.readUInt();
                        break;
                    }
                    if (64L == this.addrBits) {
                        this.registerAddress = this.binaryFileReader.readULong();
                        break;
                    }
                    Log.warn("Address bits error", new Object[0]);
                    return false;
                }
                case 3: {
                    FileNameEntry fileNameEntry = new FileNameEntry(this.binaryFileReader);
                    this.header.getFileNameTable().add(fileNameEntry);
                    break;
                }
                case 4: {
                    this.registerDiscriminator = this.binaryFileReader.parseULeb128();
                    break;
                }
                default: {
                    Log.error("Fail to extended opcode of debug line for code: %x", l);
                    return false;
                }
            }
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return false;
        }
        return true;
    }

    private void addToLineInfoTable() {
        if (this.registerAddress == 56L) {
            boolean bl = true;
        }
        DebugLineEntry debugLineEntry = new DebugLineEntry();
        String string = this.header.getPathName(this.registerFileIndex);
        if (!this.lineInfoTable.isEmpty()) {
            DebugLineEntry debugLineEntry2 = this.lineInfoTable.lastElement();
            if (debugLineEntry2.getPathName().equals(string)) {
                if (debugLineEntry2.getAddress() == this.registerAddress) {
                    if (debugLineEntry2.getLineNumber() != this.registerLine) {
                        if (0L == debugLineEntry2.getLineNumber()) {
                            debugLineEntry2.setLineNumber(this.registerLine);
                        } else {
                            debugLineEntry2.setEndLineNumber(this.registerLine);
                        }
                    }
                    return;
                }
                debugLineEntry2.setEndAddress(this.registerAddress);
            } else {
                if (debugLineEntry2.getAddress() == this.registerAddress) {
                    debugLineEntry2.setAddress(this.registerAddress);
                    debugLineEntry2.setLineNumber(this.registerLine);
                    debugLineEntry2.setColumnNumber(this.registerColumn);
                    debugLineEntry2.setPathName(string);
                    return;
                }
                debugLineEntry2.setEndAddress(this.registerAddress);
            }
        }
        debugLineEntry.setAddress(this.registerAddress);
        debugLineEntry.setLineNumber(this.registerLine);
        debugLineEntry.setColumnNumber(this.registerColumn);
        debugLineEntry.setPathName(string);
        this.lineInfoTable.add(debugLineEntry);
    }

    private void fixLastEndAddress() {
        if (!this.lineInfoTable.isEmpty()) {
            DebugLineEntry debugLineEntry = this.lineInfoTable.lastElement();
            debugLineEntry.setEndAddress(this.registerAddress);
        }
    }

    public long getRegisterAddress() {
        return this.registerAddress;
    }

    public long getRegisterFileIndex() {
        return this.registerFileIndex;
    }

    public long getRegisterLine() {
        return this.registerLine;
    }

    public long getRegisterColumn() {
        return this.registerColumn;
    }

    public long getRegisterOpIndex() {
        return this.registerOpIndex;
    }

    public boolean isRegisterIsStmt() {
        return this.registerIsStmt;
    }

    public boolean isRegisterBasicBlock() {
        return this.registerBasicBlock;
    }

    public boolean isRegisterEndEquence() {
        return this.registerEndEquence;
    }

    public boolean isRegisterPrologueEnd() {
        return this.registerPrologueEnd;
    }

    public boolean isRegisterEpilogueBegin() {
        return this.registerEpilogueBegin;
    }

    public long getRegisterIsa() {
        return this.registerIsa;
    }

    public long getRegisterDiscriminator() {
        return this.registerDiscriminator;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSectionOffset() {
        return this.sectionOffset;
    }

    public long getSectionSize() {
        return this.sectionSize;
    }

    public long getAddrBits() {
        return this.addrBits;
    }

    public SectionReader getBinaryFileReader() {
        return this.binaryFileReader;
    }

    public boolean isLittleEndian() {
        return this.isLittleEndian;
    }

    public LineNumberProgramHeader getHeader() {
        return this.header;
    }

    public Vector<DebugLineEntry> getLineInfoTable() {
        return this.lineInfoTable;
    }

    public void setRegisterAddress(long l) {
        this.registerAddress = l;
    }

    public void setRegisterFileIndex(long l) {
        this.registerFileIndex = l;
    }

    public void setRegisterLine(long l) {
        this.registerLine = l;
    }

    public void setRegisterColumn(long l) {
        this.registerColumn = l;
    }

    public void setRegisterOpIndex(long l) {
        this.registerOpIndex = l;
    }

    public void setRegisterIsStmt(boolean bl) {
        this.registerIsStmt = bl;
    }

    public void setRegisterBasicBlock(boolean bl) {
        this.registerBasicBlock = bl;
    }

    public void setRegisterEndEquence(boolean bl) {
        this.registerEndEquence = bl;
    }

    public void setRegisterPrologueEnd(boolean bl) {
        this.registerPrologueEnd = bl;
    }

    public void setRegisterEpilogueBegin(boolean bl) {
        this.registerEpilogueBegin = bl;
    }

    public void setRegisterIsa(long l) {
        this.registerIsa = l;
    }

    public void setRegisterDiscriminator(long l) {
        this.registerDiscriminator = l;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setSectionOffset(long l) {
        this.sectionOffset = l;
    }

    public void setSectionSize(long l) {
        this.sectionSize = l;
    }

    public void setBinaryFileReader(SectionReader sectionReader) {
        this.binaryFileReader = sectionReader;
    }

    public void setLittleEndian(boolean bl) {
        this.isLittleEndian = bl;
    }

    public void setHeader(LineNumberProgramHeader lineNumberProgramHeader) {
        this.header = lineNumberProgramHeader;
    }

    public void setLineInfoTable(Vector<DebugLineEntry> vector) {
        this.lineInfoTable = vector;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DebugLineParser)) {
            return false;
        }
        DebugLineParser debugLineParser = (DebugLineParser)object;
        if (!debugLineParser.canEqual(this)) {
            return false;
        }
        if (this.getRegisterAddress() != debugLineParser.getRegisterAddress()) {
            return false;
        }
        if (this.getRegisterFileIndex() != debugLineParser.getRegisterFileIndex()) {
            return false;
        }
        if (this.getRegisterLine() != debugLineParser.getRegisterLine()) {
            return false;
        }
        if (this.getRegisterColumn() != debugLineParser.getRegisterColumn()) {
            return false;
        }
        if (this.getRegisterOpIndex() != debugLineParser.getRegisterOpIndex()) {
            return false;
        }
        if (this.isRegisterIsStmt() != debugLineParser.isRegisterIsStmt()) {
            return false;
        }
        if (this.isRegisterBasicBlock() != debugLineParser.isRegisterBasicBlock()) {
            return false;
        }
        if (this.isRegisterEndEquence() != debugLineParser.isRegisterEndEquence()) {
            return false;
        }
        if (this.isRegisterPrologueEnd() != debugLineParser.isRegisterPrologueEnd()) {
            return false;
        }
        if (this.isRegisterEpilogueBegin() != debugLineParser.isRegisterEpilogueBegin()) {
            return false;
        }
        if (this.getRegisterIsa() != debugLineParser.getRegisterIsa()) {
            return false;
        }
        if (this.getRegisterDiscriminator() != debugLineParser.getRegisterDiscriminator()) {
            return false;
        }
        if (this.getSectionOffset() != debugLineParser.getSectionOffset()) {
            return false;
        }
        if (this.getSectionSize() != debugLineParser.getSectionSize()) {
            return false;
        }
        if (this.getAddrBits() != debugLineParser.getAddrBits()) {
            return false;
        }
        if (this.isLittleEndian() != debugLineParser.isLittleEndian()) {
            return false;
        }
        String string = this.getFileName();
        String string2 = debugLineParser.getFileName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        SectionReader sectionReader = this.getBinaryFileReader();
        SectionReader sectionReader2 = debugLineParser.getBinaryFileReader();
        if (sectionReader == null ? sectionReader2 != null : !((Object)sectionReader).equals(sectionReader2)) {
            return false;
        }
        LineNumberProgramHeader lineNumberProgramHeader = this.getHeader();
        LineNumberProgramHeader lineNumberProgramHeader2 = debugLineParser.getHeader();
        if (lineNumberProgramHeader == null ? lineNumberProgramHeader2 != null : !((Object)lineNumberProgramHeader).equals(lineNumberProgramHeader2)) {
            return false;
        }
        Vector<DebugLineEntry> vector = this.getLineInfoTable();
        Vector<DebugLineEntry> vector2 = debugLineParser.getLineInfoTable();
        return !(vector == null ? vector2 != null : !((Object)vector).equals(vector2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof DebugLineParser;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getRegisterAddress();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getRegisterFileIndex();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getRegisterLine();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        long l4 = this.getRegisterColumn();
        n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
        long l5 = this.getRegisterOpIndex();
        n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
        n2 = n2 * 59 + (this.isRegisterIsStmt() ? 79 : 97);
        n2 = n2 * 59 + (this.isRegisterBasicBlock() ? 79 : 97);
        n2 = n2 * 59 + (this.isRegisterEndEquence() ? 79 : 97);
        n2 = n2 * 59 + (this.isRegisterPrologueEnd() ? 79 : 97);
        n2 = n2 * 59 + (this.isRegisterEpilogueBegin() ? 79 : 97);
        long l6 = this.getRegisterIsa();
        n2 = n2 * 59 + (int)(l6 >>> 32 ^ l6);
        long l7 = this.getRegisterDiscriminator();
        n2 = n2 * 59 + (int)(l7 >>> 32 ^ l7);
        long l8 = this.getSectionOffset();
        n2 = n2 * 59 + (int)(l8 >>> 32 ^ l8);
        long l9 = this.getSectionSize();
        n2 = n2 * 59 + (int)(l9 >>> 32 ^ l9);
        long l10 = this.getAddrBits();
        n2 = n2 * 59 + (int)(l10 >>> 32 ^ l10);
        n2 = n2 * 59 + (this.isLittleEndian() ? 79 : 97);
        String string = this.getFileName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        SectionReader sectionReader = this.getBinaryFileReader();
        n2 = n2 * 59 + (sectionReader == null ? 43 : ((Object)sectionReader).hashCode());
        LineNumberProgramHeader lineNumberProgramHeader = this.getHeader();
        n2 = n2 * 59 + (lineNumberProgramHeader == null ? 43 : ((Object)lineNumberProgramHeader).hashCode());
        Vector<DebugLineEntry> vector = this.getLineInfoTable();
        n2 = n2 * 59 + (vector == null ? 43 : ((Object)vector).hashCode());
        return n2;
    }

    public String toString() {
        return "DebugLineParser(registerAddress=" + this.getRegisterAddress() + ", registerFileIndex=" + this.getRegisterFileIndex() + ", registerLine=" + this.getRegisterLine() + ", registerColumn=" + this.getRegisterColumn() + ", registerOpIndex=" + this.getRegisterOpIndex() + ", registerIsStmt=" + this.isRegisterIsStmt() + ", registerBasicBlock=" + this.isRegisterBasicBlock() + ", registerEndEquence=" + this.isRegisterEndEquence() + ", registerPrologueEnd=" + this.isRegisterPrologueEnd() + ", registerEpilogueBegin=" + this.isRegisterEpilogueBegin() + ", registerIsa=" + this.getRegisterIsa() + ", registerDiscriminator=" + this.getRegisterDiscriminator() + ", fileName=" + this.getFileName() + ", sectionOffset=" + this.getSectionOffset() + ", sectionSize=" + this.getSectionSize() + ", addrBits=" + this.getAddrBits() + ", binaryFileReader=" + this.getBinaryFileReader() + ", isLittleEndian=" + this.isLittleEndian() + ", header=" + this.getHeader() + ", lineInfoTable=" + this.getLineInfoTable() + ")";
    }

    private static class FileNameEntry {
        private StringBuffer fileName = new StringBuffer();
        private long indexOfDirTable = 0L;
        private long lastModTime = 0L;
        private long fileLength = 0L;
        private String md5;

        public FileNameEntry(StringBuffer stringBuffer) {
            this.fileName = stringBuffer;
        }

        public FileNameEntry(SectionReader sectionReader) {
            this.parse(sectionReader);
        }

        private boolean parse(SectionReader sectionReader) {
            boolean bl = false;
            try {
                char c = '\u0000';
                while ('\u0000' != (c = (char)sectionReader.readByte())) {
                    this.fileName.append(c);
                }
                this.indexOfDirTable = sectionReader.parseULeb128();
                this.lastModTime = sectionReader.parseULeb128();
                this.fileLength = sectionReader.parseULeb128();
                bl = true;
            }
            catch (Exception exception) {
                Log.error(exception);
            }
            return bl;
        }

        public String getFileName() {
            return this.fileName.toString();
        }

        public long getIndexOfDirTable() {
            return this.indexOfDirTable;
        }

        public long getLastModTime() {
            return this.lastModTime;
        }

        public long getFileLength() {
            return this.fileLength;
        }

        public String getMd5() {
            return this.md5;
        }

        public void setFileName(StringBuffer stringBuffer) {
            this.fileName = stringBuffer;
        }

        public void setIndexOfDirTable(long l) {
            this.indexOfDirTable = l;
        }

        public void setLastModTime(long l) {
            this.lastModTime = l;
        }

        public void setFileLength(long l) {
            this.fileLength = l;
        }

        public void setMd5(String string) {
            this.md5 = string;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof FileNameEntry)) {
                return false;
            }
            FileNameEntry fileNameEntry = (FileNameEntry)object;
            if (!fileNameEntry.canEqual(this)) {
                return false;
            }
            if (this.getIndexOfDirTable() != fileNameEntry.getIndexOfDirTable()) {
                return false;
            }
            if (this.getLastModTime() != fileNameEntry.getLastModTime()) {
                return false;
            }
            if (this.getFileLength() != fileNameEntry.getFileLength()) {
                return false;
            }
            String string = this.getFileName();
            String string2 = fileNameEntry.getFileName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            String string3 = this.getMd5();
            String string4 = fileNameEntry.getMd5();
            return !(string3 == null ? string4 != null : !string3.equals(string4));
        }

        protected boolean canEqual(Object object) {
            return object instanceof FileNameEntry;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            long l = this.getIndexOfDirTable();
            n2 = n2 * 59 + (int)(l >>> 32 ^ l);
            long l2 = this.getLastModTime();
            n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
            long l3 = this.getFileLength();
            n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
            String string = this.getFileName();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            String string2 = this.getMd5();
            n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
            return n2;
        }

        public String toString() {
            return "DebugLineParser.FileNameEntry(fileName=" + this.getFileName() + ", indexOfDirTable=" + this.getIndexOfDirTable() + ", lastModTime=" + this.getLastModTime() + ", fileLength=" + this.getFileLength() + ", md5=" + this.getMd5() + ")";
        }
    }

    public static class LineNumberProgramHeader {
        private static final byte DW_FORM_STRING = 8;
        private static final byte DW_FORM_line_strp = 31;
        private static final byte DW_FORM_strp = 14;
        private static final byte DW_FORM_strp_sup = 29;
        private static final byte DW_FORM_data1 = 11;
        private static final byte DW_FORM_data2 = 5;
        private static final byte DW_FORM_data4 = 6;
        private static final byte DW_FORM_data8 = 7;
        private static final byte DW_FORM_data16 = 30;
        private static final byte DW_FORM_udata = 15;
        private static final byte DW_FORM_block = 9;
        private static final String PATH_SEPARATOR = "/";
        private static final int IDENTIFICATION_OF_64BIT = -1;
        private SectionReader binaryFileReader = null;
        DebugStrParser debugStrParser;
        DebugLineStrParser debugLineStrParser;
        private long dwarfFormat = 0L;
        private long unitLength = 0L;
        private long version = 2L;
        private long addressSize;
        private long segmentSelectorSize;
        private long headerLength = 0L;
        private long minInstructionLength = 0L;
        private long maxInstructionLength = 0L;
        private long defaultIsStmt = 0L;
        private byte lineBase = 0;
        private long lineRange = 0L;
        private long opcodeBase = 0L;
        private byte[] standardOpcodeLengths = null;
        public static final byte DW_LNCT_path = 1;
        public static final byte DW_LNCT_directory_index = 2;
        public static final byte DW_LNCT_timestamp = 3;
        public static final byte DW_LNCT_size = 4;
        public static final byte DW_LNCT_MD5 = 5;
        public static final int DW_LNS_lo_user = 8192;
        public static final int DW_LNS_hi_user = 16383;
        private long dwarf5DirectoryEntryFormatCount = 0L;
        private Dwarf5DirectoryEntryFormat[] dwarf5DirectoryEntryFormats = null;
        private long dwarf5DirectoriesCount;
        private Dwarf5Directory[] dwarf5Directories = null;
        private long dwarf5FileNameEntryFormatCount = 0L;
        private Dwarf5FileNameEntryFormat[] dwarf5FileNameEntryFormats = null;
        private long dwarf5FilesCount = 0L;
        private Dwarf5File[] dwarf5Files = null;
        private final Vector<StringBuffer> dirTable = new Vector();
        private final Vector<FileNameEntry> fileNameTable = new Vector();

        public LineNumberProgramHeader(SectionReader sectionReader, DebugStrParser debugStrParser, DebugLineStrParser debugLineStrParser) {
            this.binaryFileReader = sectionReader;
            this.debugStrParser = debugStrParser;
            this.debugLineStrParser = debugLineStrParser;
        }

        private boolean parseUnitLength() {
            try {
                this.unitLength = this.binaryFileReader.readUInt();
                if (-1L == this.unitLength) {
                    this.dwarfFormat = 64L;
                    this.unitLength = this.binaryFileReader.readULong();
                }
                this.dwarfFormat = 32L;
                this.binaryFileReader.resetReadBytes();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseVersion() {
            try {
                this.version = this.binaryFileReader.readUShort();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseAddressSize() {
            try {
                this.addressSize = this.binaryFileReader.readUByte();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseSegmentSelectorSize() {
            try {
                this.segmentSelectorSize = this.binaryFileReader.readUByte();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseHeaderLength() {
            try {
                if (32L == this.dwarfFormat) {
                    this.headerLength = this.binaryFileReader.readUInt();
                } else if (64L == this.dwarfFormat) {
                    this.headerLength = this.binaryFileReader.readULong();
                }
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseMinInstructionLength() {
            try {
                this.minInstructionLength = this.binaryFileReader.readUByte();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseMaxInstructionLength() {
            try {
                this.maxInstructionLength = this.binaryFileReader.readUByte();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseDefaultIsStmt() {
            try {
                this.defaultIsStmt = this.binaryFileReader.readUByte();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseLineBase() {
            try {
                this.lineBase = this.binaryFileReader.readByte();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseLineRange() {
            try {
                this.lineRange = this.binaryFileReader.readUByte();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseOpcodeBase() {
            try {
                this.opcodeBase = this.binaryFileReader.readUByte();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            if (this.opcodeBase <= 0L) {
                Log.error("Failed to parse opcode base: opcodeBase is less than 1", new Object[0]);
                return false;
            }
            return true;
        }

        private boolean parseStandardOpcodeLengths() {
            this.standardOpcodeLengths = new byte[(int)(this.opcodeBase - 1L)];
            return this.binaryFileReader.readByteArray(this.standardOpcodeLengths);
        }

        private boolean parseDirectoryEntryFormatCount() {
            try {
                this.dwarf5DirectoryEntryFormatCount = this.binaryFileReader.readUByte();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseDirectoryEntryFormat() {
            try {
                this.dwarf5DirectoryEntryFormats = new Dwarf5DirectoryEntryFormat[(int)this.dwarf5DirectoryEntryFormatCount];
                int n = 0;
                while ((long)n < this.dwarf5DirectoryEntryFormatCount) {
                    Dwarf5DirectoryEntryFormat dwarf5DirectoryEntryFormat = new Dwarf5DirectoryEntryFormat();
                    dwarf5DirectoryEntryFormat.typeCode = this.binaryFileReader.parseULeb128();
                    dwarf5DirectoryEntryFormat.formCode = this.binaryFileReader.parseULeb128();
                    this.dwarf5DirectoryEntryFormats[n] = dwarf5DirectoryEntryFormat;
                    ++n;
                }
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseDirectoriesCount() {
            try {
                this.dwarf5DirectoriesCount = this.binaryFileReader.parseULeb128();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseDirectories() {
            try {
                this.dwarf5Directories = new Dwarf5Directory[(int)this.dwarf5DirectoriesCount];
                int n = 0;
                while ((long)n < this.dwarf5DirectoriesCount) {
                    int n2 = 0;
                    while ((long)n2 < this.dwarf5DirectoryEntryFormatCount) {
                        Dwarf5DirectoryEntryFormat dwarf5DirectoryEntryFormat = this.dwarf5DirectoryEntryFormats[n2];
                        if (dwarf5DirectoryEntryFormat.typeCode == 1L) {
                            String string = this.parseDwarf5LNCT((int)dwarf5DirectoryEntryFormat.formCode);
                            Dwarf5Directory dwarf5Directory = new Dwarf5Directory();
                            dwarf5Directory.directoryName = string;
                            this.dwarf5Directories[n] = dwarf5Directory;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                Log.error(exception);
                return false;
            }
            return true;
        }

        private boolean parseFileNameEntryFormatCount() {
            try {
                this.dwarf5FileNameEntryFormatCount = this.binaryFileReader.parseULeb128();
            }
            catch (Exception exception) {
                Log.error(exception);
                return false;
            }
            return true;
        }

        private boolean parseFileNameEntryFormat() {
            try {
                this.dwarf5FileNameEntryFormats = new Dwarf5FileNameEntryFormat[(int)this.dwarf5FileNameEntryFormatCount];
                int n = 0;
                while ((long)n < this.dwarf5FileNameEntryFormatCount) {
                    Dwarf5FileNameEntryFormat dwarf5FileNameEntryFormat = new Dwarf5FileNameEntryFormat();
                    dwarf5FileNameEntryFormat.typeCode = this.binaryFileReader.parseULeb128();
                    dwarf5FileNameEntryFormat.formCode = this.binaryFileReader.parseULeb128();
                    this.dwarf5FileNameEntryFormats[n] = dwarf5FileNameEntryFormat;
                    ++n;
                }
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseFileNamesCount() {
            try {
                this.dwarf5FilesCount = this.binaryFileReader.parseULeb128();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseFileNames() {
            try {
                this.dwarf5Files = new Dwarf5File[(int)this.dwarf5FilesCount];
                int n = 0;
                while ((long)n < this.dwarf5FilesCount) {
                    Dwarf5File dwarf5File = new Dwarf5File();
                    int n2 = 0;
                    while ((long)n2 < this.dwarf5FileNameEntryFormatCount) {
                        Dwarf5FileNameEntryFormat dwarf5FileNameEntryFormat = this.dwarf5FileNameEntryFormats[n2];
                        String string = this.parseDwarf5LNCT((int)dwarf5FileNameEntryFormat.formCode);
                        switch ((int)dwarf5FileNameEntryFormat.typeCode) {
                            case 1: {
                                dwarf5File.name = string;
                                break;
                            }
                            case 2: {
                                dwarf5File.directoryIndex = Integer.parseInt(string, 16);
                                break;
                            }
                            case 3: {
                                dwarf5File.timestamp = Long.parseLong(string, 16);
                                break;
                            }
                            case 4: {
                                dwarf5File.size = Long.parseLong(string, 16);
                                break;
                            }
                            case 5: {
                                dwarf5File.md5 = string;
                            }
                        }
                        ++n2;
                    }
                    this.dwarf5Files[n] = dwarf5File;
                    ++n;
                }
            }
            catch (Exception exception) {
                Log.error(exception);
                return false;
            }
            return true;
        }

        private boolean fillDirTable() {
            this.dirTable.add(new StringBuffer("."));
            char c = '\u0000';
            try {
                while ('\u0000' != (c = (char)this.binaryFileReader.readByte())) {
                    StringBuffer stringBuffer = new StringBuffer();
                    while ('\u0000' != c) {
                        stringBuffer.append(c);
                        c = (char)this.binaryFileReader.readByte();
                    }
                    this.dirTable.add(stringBuffer);
                }
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean fillFileNameTable() {
            this.fileNameTable.add(new FileNameEntry(new StringBuffer(".")));
            char c = '\u0000';
            try {
                while ('\u0000' != (c = (char)this.binaryFileReader.readByte())) {
                    FileNameEntry fileNameEntry = new FileNameEntry(this.binaryFileReader);
                    fileNameEntry.fileName.insert(0, c);
                    this.fileNameTable.add(fileNameEntry);
                }
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        public boolean parse() {
            if (null == this.binaryFileReader) {
                return false;
            }
            if (!this.parseUnitLength()) {
                return false;
            }
            if (!this.parseVersion()) {
                return false;
            }
            if (5L == this.version) {
                if (!this.parseAddressSize()) {
                    return false;
                }
                if (!this.parseSegmentSelectorSize()) {
                    return false;
                }
            }
            if (!this.parseHeaderLength()) {
                return false;
            }
            if (!this.parseMinInstructionLength()) {
                return false;
            }
            if (!(4L != this.version && 5L != this.version || this.parseMaxInstructionLength())) {
                return false;
            }
            if (!this.parseDefaultIsStmt()) {
                return false;
            }
            if (!this.parseLineBase()) {
                return false;
            }
            if (!this.parseLineRange()) {
                return false;
            }
            if (!this.parseOpcodeBase()) {
                return false;
            }
            if (!this.parseStandardOpcodeLengths()) {
                return false;
            }
            if (5L == this.version) {
                Object object;
                if (!this.parseDirectoryEntryFormatCount()) {
                    return false;
                }
                if (!this.parseDirectoryEntryFormat()) {
                    return false;
                }
                if (!this.parseDirectoriesCount()) {
                    return false;
                }
                if (!this.parseDirectories()) {
                    return false;
                }
                if (!this.parseFileNameEntryFormatCount()) {
                    return false;
                }
                if (!this.parseFileNameEntryFormat()) {
                    return false;
                }
                if (!this.parseFileNamesCount()) {
                    return false;
                }
                if (!this.parseFileNames()) {
                    return false;
                }
                for (Dwarf5Directory object2 : this.dwarf5Directories) {
                    object = object2.directoryName;
                    this.dirTable.add(new StringBuffer((String)object));
                }
                for (Dwarf5File dwarf5File : this.dwarf5Files) {
                    object = new FileNameEntry(new StringBuffer(dwarf5File.name));
                    ((FileNameEntry)object).lastModTime = dwarf5File.timestamp;
                    ((FileNameEntry)object).fileLength = dwarf5File.size;
                    ((FileNameEntry)object).md5 = dwarf5File.md5;
                    this.fileNameTable.add((FileNameEntry)object);
                }
            } else {
                if (!this.fillDirTable()) {
                    return false;
                }
                if (!this.fillFileNameTable()) {
                    return false;
                }
            }
            return true;
        }

        private String getDirName(long l) {
            return this.dirTable.get((int)l).toString();
        }

        public String getFileName(long l) {
            FileNameEntry fileNameEntry = this.fileNameTable.get((int)l);
            return fileNameEntry.getFileName();
        }

        public String getPathName(long l) {
            if ((long)this.fileNameTable.size() <= l) {
                Log.error("debugline index " + l + "is missing!", new Object[0]);
                return "";
            }
            FileNameEntry fileNameEntry = this.fileNameTable.get((int)l);
            String string = fileNameEntry.getFileName();
            String string2 = this.getDirName(fileNameEntry.getIndexOfDirTable());
            if (2L == this.version && Paths.get(string, new String[0]).isAbsolute()) {
                return string;
            }
            return string2 + PATH_SEPARATOR + string;
        }

        private String parseDwarf5LNCT(int n) {
            String string = "";
            String string2 = "";
            switch (n) {
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 15: 
                case 30: {
                    return this.parseConstant(n);
                }
                case 8: {
                    return this.parseString();
                }
                case 14: {
                    string2 = this.parseStringPointer();
                    return this.debugStrParser.getString(Long.parseLong(string2, 16));
                }
                case 31: {
                    string2 = this.parseStringPointer();
                    return this.debugLineStrParser.getString(Long.parseLong(string2, 16));
                }
                case 29: {
                    string2 = this.parseStringPointer();
                    return "";
                }
                case 9: {
                    return this.parseBlock(n);
                }
            }
            return string;
        }

        private String parseString() {
            StringBuilder stringBuilder = new StringBuilder();
            byte by = 0;
            try {
                while (0 != (by = this.binaryFileReader.readByte())) {
                    stringBuilder.append((char)by);
                }
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return null;
            }
            return stringBuilder.toString();
        }

        private String parseStringPointer() {
            long l = 0L;
            try {
                if (32L == this.dwarfFormat) {
                    l = this.binaryFileReader.readUInt();
                } else if (64L == this.dwarfFormat) {
                    l = this.binaryFileReader.readULong();
                }
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return null;
            }
            return Long.toHexString(l);
        }

        private String parseConstant(long l) {
            long l2 = 0L;
            try {
                switch ((int)l) {
                    case 11: {
                        l2 = this.binaryFileReader.readUByte();
                        break;
                    }
                    case 5: {
                        l2 = this.binaryFileReader.readUShort();
                        break;
                    }
                    case 6: {
                        l2 = this.binaryFileReader.readUInt();
                        break;
                    }
                    case 7: {
                        l2 = this.binaryFileReader.readULong();
                        break;
                    }
                    case 30: {
                        byte[] byArray = new byte[16];
                        this.binaryFileReader.readByteArray(byArray);
                        return StrUtils.bytesToHex(byArray);
                    }
                    case 15: {
                        l2 = this.binaryFileReader.parseULeb128();
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return null;
            }
            return Long.toHexString(l2);
        }

        private String parseBlock(long l) {
            long l2 = 0L;
            try {
                switch ((int)l) {
                    case 9: {
                        l2 = this.binaryFileReader.parseULeb128();
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return null;
            }
            byte[] byArray = new byte[(int)l2];
            if (!this.binaryFileReader.readByteArray(byArray)) {
                return null;
            }
            return Base64.getEncoder().encodeToString(byArray);
        }

        public SectionReader getBinaryFileReader() {
            return this.binaryFileReader;
        }

        public DebugStrParser getDebugStrParser() {
            return this.debugStrParser;
        }

        public DebugLineStrParser getDebugLineStrParser() {
            return this.debugLineStrParser;
        }

        public long getDwarfFormat() {
            return this.dwarfFormat;
        }

        public long getUnitLength() {
            return this.unitLength;
        }

        public long getVersion() {
            return this.version;
        }

        public long getAddressSize() {
            return this.addressSize;
        }

        public long getSegmentSelectorSize() {
            return this.segmentSelectorSize;
        }

        public long getHeaderLength() {
            return this.headerLength;
        }

        public long getMinInstructionLength() {
            return this.minInstructionLength;
        }

        public long getMaxInstructionLength() {
            return this.maxInstructionLength;
        }

        public long getDefaultIsStmt() {
            return this.defaultIsStmt;
        }

        public byte getLineBase() {
            return this.lineBase;
        }

        public long getLineRange() {
            return this.lineRange;
        }

        public long getOpcodeBase() {
            return this.opcodeBase;
        }

        public byte[] getStandardOpcodeLengths() {
            return this.standardOpcodeLengths;
        }

        public long getDwarf5DirectoryEntryFormatCount() {
            return this.dwarf5DirectoryEntryFormatCount;
        }

        public Dwarf5DirectoryEntryFormat[] getDwarf5DirectoryEntryFormats() {
            return this.dwarf5DirectoryEntryFormats;
        }

        public long getDwarf5DirectoriesCount() {
            return this.dwarf5DirectoriesCount;
        }

        public Dwarf5Directory[] getDwarf5Directories() {
            return this.dwarf5Directories;
        }

        public long getDwarf5FileNameEntryFormatCount() {
            return this.dwarf5FileNameEntryFormatCount;
        }

        public Dwarf5FileNameEntryFormat[] getDwarf5FileNameEntryFormats() {
            return this.dwarf5FileNameEntryFormats;
        }

        public long getDwarf5FilesCount() {
            return this.dwarf5FilesCount;
        }

        public Dwarf5File[] getDwarf5Files() {
            return this.dwarf5Files;
        }

        public Vector<StringBuffer> getDirTable() {
            return this.dirTable;
        }

        public Vector<FileNameEntry> getFileNameTable() {
            return this.fileNameTable;
        }

        public void setBinaryFileReader(SectionReader sectionReader) {
            this.binaryFileReader = sectionReader;
        }

        public void setDebugStrParser(DebugStrParser debugStrParser) {
            this.debugStrParser = debugStrParser;
        }

        public void setDebugLineStrParser(DebugLineStrParser debugLineStrParser) {
            this.debugLineStrParser = debugLineStrParser;
        }

        public void setDwarfFormat(long l) {
            this.dwarfFormat = l;
        }

        public void setUnitLength(long l) {
            this.unitLength = l;
        }

        public void setVersion(long l) {
            this.version = l;
        }

        public void setAddressSize(long l) {
            this.addressSize = l;
        }

        public void setSegmentSelectorSize(long l) {
            this.segmentSelectorSize = l;
        }

        public void setHeaderLength(long l) {
            this.headerLength = l;
        }

        public void setMinInstructionLength(long l) {
            this.minInstructionLength = l;
        }

        public void setMaxInstructionLength(long l) {
            this.maxInstructionLength = l;
        }

        public void setDefaultIsStmt(long l) {
            this.defaultIsStmt = l;
        }

        public void setLineBase(byte by) {
            this.lineBase = by;
        }

        public void setLineRange(long l) {
            this.lineRange = l;
        }

        public void setOpcodeBase(long l) {
            this.opcodeBase = l;
        }

        public void setStandardOpcodeLengths(byte[] byArray) {
            this.standardOpcodeLengths = byArray;
        }

        public void setDwarf5DirectoryEntryFormatCount(long l) {
            this.dwarf5DirectoryEntryFormatCount = l;
        }

        public void setDwarf5DirectoryEntryFormats(Dwarf5DirectoryEntryFormat[] dwarf5DirectoryEntryFormatArray) {
            this.dwarf5DirectoryEntryFormats = dwarf5DirectoryEntryFormatArray;
        }

        public void setDwarf5DirectoriesCount(long l) {
            this.dwarf5DirectoriesCount = l;
        }

        public void setDwarf5Directories(Dwarf5Directory[] dwarf5DirectoryArray) {
            this.dwarf5Directories = dwarf5DirectoryArray;
        }

        public void setDwarf5FileNameEntryFormatCount(long l) {
            this.dwarf5FileNameEntryFormatCount = l;
        }

        public void setDwarf5FileNameEntryFormats(Dwarf5FileNameEntryFormat[] dwarf5FileNameEntryFormatArray) {
            this.dwarf5FileNameEntryFormats = dwarf5FileNameEntryFormatArray;
        }

        public void setDwarf5FilesCount(long l) {
            this.dwarf5FilesCount = l;
        }

        public void setDwarf5Files(Dwarf5File[] dwarf5FileArray) {
            this.dwarf5Files = dwarf5FileArray;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof LineNumberProgramHeader)) {
                return false;
            }
            LineNumberProgramHeader lineNumberProgramHeader = (LineNumberProgramHeader)object;
            if (!lineNumberProgramHeader.canEqual(this)) {
                return false;
            }
            if (this.getDwarfFormat() != lineNumberProgramHeader.getDwarfFormat()) {
                return false;
            }
            if (this.getUnitLength() != lineNumberProgramHeader.getUnitLength()) {
                return false;
            }
            if (this.getVersion() != lineNumberProgramHeader.getVersion()) {
                return false;
            }
            if (this.getAddressSize() != lineNumberProgramHeader.getAddressSize()) {
                return false;
            }
            if (this.getSegmentSelectorSize() != lineNumberProgramHeader.getSegmentSelectorSize()) {
                return false;
            }
            if (this.getHeaderLength() != lineNumberProgramHeader.getHeaderLength()) {
                return false;
            }
            if (this.getMinInstructionLength() != lineNumberProgramHeader.getMinInstructionLength()) {
                return false;
            }
            if (this.getMaxInstructionLength() != lineNumberProgramHeader.getMaxInstructionLength()) {
                return false;
            }
            if (this.getDefaultIsStmt() != lineNumberProgramHeader.getDefaultIsStmt()) {
                return false;
            }
            if (this.getLineBase() != lineNumberProgramHeader.getLineBase()) {
                return false;
            }
            if (this.getLineRange() != lineNumberProgramHeader.getLineRange()) {
                return false;
            }
            if (this.getOpcodeBase() != lineNumberProgramHeader.getOpcodeBase()) {
                return false;
            }
            if (this.getDwarf5DirectoryEntryFormatCount() != lineNumberProgramHeader.getDwarf5DirectoryEntryFormatCount()) {
                return false;
            }
            if (this.getDwarf5DirectoriesCount() != lineNumberProgramHeader.getDwarf5DirectoriesCount()) {
                return false;
            }
            if (this.getDwarf5FileNameEntryFormatCount() != lineNumberProgramHeader.getDwarf5FileNameEntryFormatCount()) {
                return false;
            }
            if (this.getDwarf5FilesCount() != lineNumberProgramHeader.getDwarf5FilesCount()) {
                return false;
            }
            SectionReader sectionReader = this.getBinaryFileReader();
            SectionReader sectionReader2 = lineNumberProgramHeader.getBinaryFileReader();
            if (sectionReader == null ? sectionReader2 != null : !((Object)sectionReader).equals(sectionReader2)) {
                return false;
            }
            DebugStrParser debugStrParser = this.getDebugStrParser();
            DebugStrParser debugStrParser2 = lineNumberProgramHeader.getDebugStrParser();
            if (debugStrParser == null ? debugStrParser2 != null : !debugStrParser.equals(debugStrParser2)) {
                return false;
            }
            DebugLineStrParser debugLineStrParser = this.getDebugLineStrParser();
            DebugLineStrParser debugLineStrParser2 = lineNumberProgramHeader.getDebugLineStrParser();
            if (debugLineStrParser == null ? debugLineStrParser2 != null : !debugLineStrParser.equals(debugLineStrParser2)) {
                return false;
            }
            if (!Arrays.equals(this.getStandardOpcodeLengths(), lineNumberProgramHeader.getStandardOpcodeLengths())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getDwarf5DirectoryEntryFormats(), lineNumberProgramHeader.getDwarf5DirectoryEntryFormats())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getDwarf5Directories(), lineNumberProgramHeader.getDwarf5Directories())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getDwarf5FileNameEntryFormats(), lineNumberProgramHeader.getDwarf5FileNameEntryFormats())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getDwarf5Files(), lineNumberProgramHeader.getDwarf5Files())) {
                return false;
            }
            Vector<StringBuffer> vector = this.getDirTable();
            Vector<StringBuffer> vector2 = lineNumberProgramHeader.getDirTable();
            if (vector == null ? vector2 != null : !((Object)vector).equals(vector2)) {
                return false;
            }
            Vector<FileNameEntry> vector3 = this.getFileNameTable();
            Vector<FileNameEntry> vector4 = lineNumberProgramHeader.getFileNameTable();
            return !(vector3 == null ? vector4 != null : !((Object)vector3).equals(vector4));
        }

        protected boolean canEqual(Object object) {
            return object instanceof LineNumberProgramHeader;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            long l = this.getDwarfFormat();
            n2 = n2 * 59 + (int)(l >>> 32 ^ l);
            long l2 = this.getUnitLength();
            n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
            long l3 = this.getVersion();
            n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
            long l4 = this.getAddressSize();
            n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
            long l5 = this.getSegmentSelectorSize();
            n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
            long l6 = this.getHeaderLength();
            n2 = n2 * 59 + (int)(l6 >>> 32 ^ l6);
            long l7 = this.getMinInstructionLength();
            n2 = n2 * 59 + (int)(l7 >>> 32 ^ l7);
            long l8 = this.getMaxInstructionLength();
            n2 = n2 * 59 + (int)(l8 >>> 32 ^ l8);
            long l9 = this.getDefaultIsStmt();
            n2 = n2 * 59 + (int)(l9 >>> 32 ^ l9);
            n2 = n2 * 59 + this.getLineBase();
            long l10 = this.getLineRange();
            n2 = n2 * 59 + (int)(l10 >>> 32 ^ l10);
            long l11 = this.getOpcodeBase();
            n2 = n2 * 59 + (int)(l11 >>> 32 ^ l11);
            long l12 = this.getDwarf5DirectoryEntryFormatCount();
            n2 = n2 * 59 + (int)(l12 >>> 32 ^ l12);
            long l13 = this.getDwarf5DirectoriesCount();
            n2 = n2 * 59 + (int)(l13 >>> 32 ^ l13);
            long l14 = this.getDwarf5FileNameEntryFormatCount();
            n2 = n2 * 59 + (int)(l14 >>> 32 ^ l14);
            long l15 = this.getDwarf5FilesCount();
            n2 = n2 * 59 + (int)(l15 >>> 32 ^ l15);
            SectionReader sectionReader = this.getBinaryFileReader();
            n2 = n2 * 59 + (sectionReader == null ? 43 : ((Object)sectionReader).hashCode());
            DebugStrParser debugStrParser = this.getDebugStrParser();
            n2 = n2 * 59 + (debugStrParser == null ? 43 : debugStrParser.hashCode());
            DebugLineStrParser debugLineStrParser = this.getDebugLineStrParser();
            n2 = n2 * 59 + (debugLineStrParser == null ? 43 : debugLineStrParser.hashCode());
            n2 = n2 * 59 + Arrays.hashCode(this.getStandardOpcodeLengths());
            n2 = n2 * 59 + Arrays.deepHashCode(this.getDwarf5DirectoryEntryFormats());
            n2 = n2 * 59 + Arrays.deepHashCode(this.getDwarf5Directories());
            n2 = n2 * 59 + Arrays.deepHashCode(this.getDwarf5FileNameEntryFormats());
            n2 = n2 * 59 + Arrays.deepHashCode(this.getDwarf5Files());
            Vector<StringBuffer> vector = this.getDirTable();
            n2 = n2 * 59 + (vector == null ? 43 : ((Object)vector).hashCode());
            Vector<FileNameEntry> vector2 = this.getFileNameTable();
            n2 = n2 * 59 + (vector2 == null ? 43 : ((Object)vector2).hashCode());
            return n2;
        }

        public String toString() {
            return "DebugLineParser.LineNumberProgramHeader(binaryFileReader=" + this.getBinaryFileReader() + ", debugStrParser=" + this.getDebugStrParser() + ", debugLineStrParser=" + this.getDebugLineStrParser() + ", dwarfFormat=" + this.getDwarfFormat() + ", unitLength=" + this.getUnitLength() + ", version=" + this.getVersion() + ", addressSize=" + this.getAddressSize() + ", segmentSelectorSize=" + this.getSegmentSelectorSize() + ", headerLength=" + this.getHeaderLength() + ", minInstructionLength=" + this.getMinInstructionLength() + ", maxInstructionLength=" + this.getMaxInstructionLength() + ", defaultIsStmt=" + this.getDefaultIsStmt() + ", lineBase=" + this.getLineBase() + ", lineRange=" + this.getLineRange() + ", opcodeBase=" + this.getOpcodeBase() + ", standardOpcodeLengths=" + Arrays.toString(this.getStandardOpcodeLengths()) + ", dwarf5DirectoryEntryFormatCount=" + this.getDwarf5DirectoryEntryFormatCount() + ", dwarf5DirectoryEntryFormats=" + Arrays.deepToString(this.getDwarf5DirectoryEntryFormats()) + ", dwarf5DirectoriesCount=" + this.getDwarf5DirectoriesCount() + ", dwarf5Directories=" + Arrays.deepToString(this.getDwarf5Directories()) + ", dwarf5FileNameEntryFormatCount=" + this.getDwarf5FileNameEntryFormatCount() + ", dwarf5FileNameEntryFormats=" + Arrays.deepToString(this.getDwarf5FileNameEntryFormats()) + ", dwarf5FilesCount=" + this.getDwarf5FilesCount() + ", dwarf5Files=" + Arrays.deepToString(this.getDwarf5Files()) + ", dirTable=" + this.getDirTable() + ", fileNameTable=" + this.getFileNameTable() + ")";
        }
    }

    public static class Dwarf5File {
        String name;
        int directoryIndex;
        long timestamp;
        long size;
        String md5;
    }

    public static class Dwarf5FileNameEntryFormat {
        long typeCode;
        long formCode;
    }

    public static class Dwarf5Directory {
        String directoryName;
    }

    public static class Dwarf5DirectoryEntryFormat {
        long typeCode;
        long formCode;
    }

    public static class DebugLineEntry {
        private long address = -1L;
        private long lineNumber = -1L;
        private long endLineNumber = -1L;
        private long columnNumber = -1L;
        private String pathName = null;
        private long endAddress = -1L;

        public void copy(DebugLineEntry debugLineEntry) {
            this.setAddress(debugLineEntry.address);
            this.setLineNumber(debugLineEntry.lineNumber);
            this.setLineNumber(debugLineEntry.endLineNumber);
            this.setPathName(debugLineEntry.pathName);
            this.setColumnNumber(debugLineEntry.columnNumber);
        }

        public void setEndLineNumber(long l) {
            if (0L == l) {
                return;
            }
            if (l < this.lineNumber) {
                this.endLineNumber = this.lineNumber;
                this.lineNumber = l;
            } else {
                this.endLineNumber = l;
            }
        }

        public void setEndAddress(long l) {
            if (this.endAddress != -1L) {
                return;
            }
            this.endAddress = l;
        }

        public String toString() {
            return "DebugLineEntry{address=" + Long.toHexString(this.address) + ", endLineNumber=" + this.endLineNumber + ", pathName='" + this.pathName + '\'' + ", lineNumber=" + this.lineNumber + ", columnNumber=" + this.columnNumber + '}';
        }

        public long getAddress() {
            return this.address;
        }

        public long getLineNumber() {
            return this.lineNumber;
        }

        public long getEndLineNumber() {
            return this.endLineNumber;
        }

        public long getColumnNumber() {
            return this.columnNumber;
        }

        public String getPathName() {
            return this.pathName;
        }

        public long getEndAddress() {
            return this.endAddress;
        }

        public void setAddress(long l) {
            this.address = l;
        }

        public void setLineNumber(long l) {
            this.lineNumber = l;
        }

        public void setColumnNumber(long l) {
            this.columnNumber = l;
        }

        public void setPathName(String string) {
            this.pathName = string;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DebugLineEntry)) {
                return false;
            }
            DebugLineEntry debugLineEntry = (DebugLineEntry)object;
            if (!debugLineEntry.canEqual(this)) {
                return false;
            }
            if (this.getAddress() != debugLineEntry.getAddress()) {
                return false;
            }
            if (this.getLineNumber() != debugLineEntry.getLineNumber()) {
                return false;
            }
            if (this.getEndLineNumber() != debugLineEntry.getEndLineNumber()) {
                return false;
            }
            if (this.getColumnNumber() != debugLineEntry.getColumnNumber()) {
                return false;
            }
            if (this.getEndAddress() != debugLineEntry.getEndAddress()) {
                return false;
            }
            String string = this.getPathName();
            String string2 = debugLineEntry.getPathName();
            return !(string == null ? string2 != null : !string.equals(string2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof DebugLineEntry;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            long l = this.getAddress();
            n2 = n2 * 59 + (int)(l >>> 32 ^ l);
            long l2 = this.getLineNumber();
            n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
            long l3 = this.getEndLineNumber();
            n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
            long l4 = this.getColumnNumber();
            n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
            long l5 = this.getEndAddress();
            n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
            String string = this.getPathName();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            return n2;
        }
    }
}

