/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.common.file;

import com.uqm.crashsight.symtabtool.dwarf.ParseBuffer;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BinaryFileReader {
    private static final Log log = LogFactory.getLog(BinaryFileReader.class);
    public static long INVALID_ENDIAN = -1L;
    public static long BIG_ENDIAN = 0L;
    public static long LITTLE_ENDIAN = 1L;
    private final byte[] shortByteArray = new byte[2];
    private final byte[] intByteArray = new byte[4];
    private final byte[] longByteArray = new byte[8];
    private static final int LONG_BYTES_NUMBER = 8;
    private static final int INT_BYTES_NUMBER = 4;
    private static final int SHORT_BYTES_NUMBER = 2;
    private static final long FIX_UBYTE = 255L;
    private static final long FIX_USHORT = 65535L;
    private static final long FIX_UINT = 0xFFFFFFFFL;
    private long endian = LITTLE_ENDIAN;
    private String fileName = null;
    private BufferedInputStream bis = null;
    private long offset = 0L;
    private long readBytes = 0L;
    private boolean useParseBuffer = false;
    ParseBuffer parseBuffer = null;

    private void setFileName(String string) {
        this.fileName = string;
    }

    public long getReadBytesNum() {
        return this.readBytes;
    }

    public void resetReadBytes() {
        this.readBytes = 0L;
    }

    public BinaryFileReader(String string) throws Exception {
        this.open(string);
    }

    public BinaryFileReader(String string, long l) throws Exception {
        this.open(string, l);
    }

    public BinaryFileReader(String string, boolean bl) throws Exception {
        this.open(string, bl ? LITTLE_ENDIAN : BIG_ENDIAN);
    }

    private void open() throws Exception {
        if (null == this.fileName) {
            throw new Exception("File name is null!");
        }
        this.bis = new BufferedInputStream(new FileInputStream(this.fileName));
        this.offset = 0L;
        this.readBytes = 0L;
    }

    private void open(String string, long l) throws Exception {
        this.setFileName(string);
        this.setEndian(l);
        this.open();
    }

    private void open(String string) throws Exception {
        this.open(string, LITTLE_ENDIAN);
    }

    public long getOffset() {
        if (this.useParseBuffer) {
            return this.parseBuffer.getOffset();
        }
        return this.offset;
    }

    public boolean close() {
        try {
            if (null != this.bis) {
                this.bis.close();
            }
            this.bis = null;
            this.fileName = null;
            this.offset = 0L;
            this.readBytes = 0L;
            this.parseBuffer = null;
            return true;
        }
        catch (IOException iOException) {
            com.uqm.crashsight.symtabtool.common.utils.Log.error(iOException);
            return false;
        }
    }

    public boolean skip(long l) {
        if (this.useParseBuffer) {
            this.parseBuffer.pos(this.parseBuffer.getOffset() + l);
            return true;
        }
        if (null == this.bis) {
            com.uqm.crashsight.symtabtool.common.utils.Log.error("Please open file first\uff01", new Object[0]);
            return false;
        }
        if (0L == l) {
            return true;
        }
        for (long i = l; i > 0L; i -= this.bis.skip(i)) {
            try {
                continue;
            }
            catch (IOException iOException) {
                com.uqm.crashsight.symtabtool.common.utils.Log.error("Failed to skip file pointer\uff01", new Object[0]);
                return false;
            }
        }
        this.offset += l;
        return true;
    }

    public boolean readByteArray(byte[] byArray) {
        try {
            this.bis.read(byArray);
        }
        catch (IOException iOException) {
            com.uqm.crashsight.symtabtool.common.utils.Log.error(iOException);
            return false;
        }
        this.offset += (long)byArray.length;
        this.readBytes += (long)byArray.length;
        return true;
    }

    public byte readByte() throws IOException {
        byte by = 0;
        if (null == this.bis) {
            com.uqm.crashsight.symtabtool.common.utils.Log.error("Failed to skip file pointer\uff01", new Object[0]);
            return by;
        }
        by = (byte)this.bis.read();
        ++this.offset;
        ++this.readBytes;
        return by;
    }

    public short readShort() throws IOException {
        short s2 = 0;
        if (null == this.bis) {
            com.uqm.crashsight.symtabtool.common.utils.Log.error("Failed to skip file pointer\uff01", new Object[0]);
            return s2;
        }
        this.bis.read(this.shortByteArray);
        s2 = BinaryFileReader.byteArrayToShort(this.shortByteArray, this.endian);
        this.offset += 2L;
        this.readBytes += 2L;
        return s2;
    }

    public int readInt() throws IOException {
        int n = 0;
        if (null == this.bis) {
            com.uqm.crashsight.symtabtool.common.utils.Log.error("Failed to skip file pointer\uff01", new Object[0]);
            return n;
        }
        this.bis.read(this.intByteArray);
        n = BinaryFileReader.byteArrayToInt(this.intByteArray, this.endian);
        this.offset += 4L;
        this.readBytes += 4L;
        return n;
    }

    public long readLong() throws IOException {
        long l = 0L;
        if (null == this.bis) {
            com.uqm.crashsight.symtabtool.common.utils.Log.error("Failed to skip file pointer\uff01", new Object[0]);
            return l;
        }
        this.bis.read(this.longByteArray);
        l = BinaryFileReader.byteArrayToLong(this.longByteArray, this.endian);
        this.offset += 8L;
        this.readBytes += 8L;
        return l;
    }

    public long readUByte() throws IOException {
        if (this.useParseBuffer) {
            return this.parseBuffer.readU8();
        }
        return (long)this.readByte() & 0xFFL;
    }

    public long readUShort() throws IOException {
        if (this.useParseBuffer) {
            return this.parseBuffer.readU16();
        }
        return (long)this.readShort() & 0xFFFFL;
    }

    public long readUInt() throws IOException {
        if (this.useParseBuffer) {
            return this.parseBuffer.readU32();
        }
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readULong() throws IOException {
        if (this.useParseBuffer) {
            return this.parseBuffer.readI64();
        }
        return this.readLong();
    }

    private static short byteArrayToShortLE(byte[] byArray) {
        if (null == byArray || byArray.length > 2) {
            return -1;
        }
        return (short)BinaryFileReader.byteArrayToIntLE(byArray);
    }

    private static int byteArrayToIntLE(byte[] byArray) {
        if (null == byArray || byArray.length > 4) {
            return -1;
        }
        return (int)BinaryFileReader.byteArrayToLongLE(byArray);
    }

    private static long byteArrayToLongLE(byte[] byArray) {
        if (null == byArray || byArray.length > 8) {
            return -1L;
        }
        long l = 0L;
        for (int i = byArray.length - 1; i >= 0; --i) {
            l <<= 8;
            l |= (long)byArray[i] & 0xFFL;
        }
        return l;
    }

    private static short byteArrayToShortBE(byte[] byArray) {
        if (null == byArray || byArray.length > 2) {
            return -1;
        }
        return (short)BinaryFileReader.byteArrayToIntBE(byArray);
    }

    private static int byteArrayToIntBE(byte[] byArray) {
        if (null == byArray || byArray.length > 4) {
            return -1;
        }
        return (int)BinaryFileReader.byteArrayToLongBE(byArray);
    }

    private static long byteArrayToLongBE(byte[] byArray) {
        if (null == byArray || byArray.length > 8) {
            return -1L;
        }
        long l = 0L;
        for (byte by : byArray) {
            l <<= 8;
            l |= (long)by & 0xFFL;
        }
        return l;
    }

    public static short byteArrayToShort(byte[] byArray, long l) {
        if (LITTLE_ENDIAN == l) {
            return BinaryFileReader.byteArrayToShortLE(byArray);
        }
        return BinaryFileReader.byteArrayToShortBE(byArray);
    }

    public static int byteArrayToInt(byte[] byArray, long l) {
        if (LITTLE_ENDIAN == l) {
            return BinaryFileReader.byteArrayToIntLE(byArray);
        }
        return BinaryFileReader.byteArrayToIntBE(byArray);
    }

    public static long byteArrayToLong(byte[] byArray, long l) {
        if (LITTLE_ENDIAN == l) {
            return BinaryFileReader.byteArrayToLongLE(byArray);
        }
        return BinaryFileReader.byteArrayToLongBE(byArray);
    }

    public void setEndian(long l) {
        this.endian = l;
    }

    public long getEndian() {
        return this.endian;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isUseParseBuffer() {
        return this.useParseBuffer;
    }

    public void setUseParseBuffer(boolean bl) {
        this.useParseBuffer = bl;
    }

    public ParseBuffer getParseBuffer() {
        return this.parseBuffer;
    }

    public void setParseBuffer(ParseBuffer parseBuffer) {
        this.parseBuffer = parseBuffer;
    }
}

