/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabparser.stif;

import com.uqm.crashsight.symtabparser.stif.Symbol;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.symtab.SymbolEntry;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class SymtabIndexEntry {
    private long address = 0L;
    private long endAddress = 0L;
    private String symtabString = null;
    private long strEntryOffset = 0L;
    private List<SymbolEntry> symbolEntries;

    public long getAddress() {
        return this.address;
    }

    public long getEndAddress() {
        return this.endAddress;
    }

    public String getSymtabString() {
        return this.symtabString;
    }

    private String getSymtabString(Symbol symbol) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null == symbol.getFunction()) {
            return null;
        }
        stringBuilder.append(symbol.getFunction());
        String string = symbol.getSrcLineString();
        String[] stringArray = null;
        if (null != symbol.getSourceFile()) {
            if (null != symbol.getInlineFunction()) {
                stringArray = symbol.getInlineFunction().split(";");
            }
            stringBuilder.append(" (");
            stringBuilder.append(string);
            if (null != stringArray && stringArray.length > 0) {
                stringBuilder.append(" [Inline: ");
                stringBuilder.append(stringArray[0]);
                stringBuilder.append("]");
            }
            stringBuilder.append(")");
            if (null != stringArray && stringArray.length > 0) {
                stringBuilder.append(" (Other infos:");
                for (int i = 1; i < stringArray.length; ++i) {
                    stringBuilder.append(stringArray[i]);
                }
                stringBuilder.append(")");
            }
        }
        return stringBuilder.toString();
    }

    private List<SymbolEntry> getSymbolEntryList(Symbol symbol) {
        ArrayList<SymbolEntry> arrayList = new ArrayList<SymbolEntry>();
        if (null == symbol.getFunction()) {
            return null;
        }
        String string = symbol.getFunction();
        String string2 = symbol.getSourceFile();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (null != string2) {
            string4 = Paths.get(string2, new String[0]).toFile().getParent();
            string5 = Paths.get(string2, new String[0]).getFileName().toString();
        }
        if (null != symbol.getLineString()) {
            string3 = symbol.getLineString();
        }
        arrayList.add(SymbolEntry.create(string4, string5, string, string3));
        if (null != symbol.getInlineFunction()) {
            String[] stringArray = symbol.getInlineFunction().split(";");
            for (int i = 1; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("\t");
                if (stringArray2.length != 2) continue;
                String string6 = stringArray2[0];
                String[] stringArray3 = stringArray2[1].split(":");
                if (stringArray3.length != 2) continue;
                String string7 = stringArray3[0];
                String string8 = Paths.get(string7, new String[0]).getParent().getFileName().toString();
                String string9 = Paths.get(string7, new String[0]).getFileName().toString();
                String string10 = stringArray2[1];
                if (string6 == null || string10 == null) continue;
                arrayList.add(SymbolEntry.create(string8, string9, string6, string10));
            }
        }
        return arrayList;
    }

    private List<SymbolEntry> getSymbolEntryList(String string, String string2, String string3, String string4) {
        ArrayList<SymbolEntry> arrayList = new ArrayList<SymbolEntry>();
        String string5 = "";
        String string6 = "";
        if (null != string) {
            string5 = Paths.get(string, new String[0]).toFile().getParent();
            string6 = Paths.get(string, new String[0]).getFileName().toString();
        }
        arrayList.add(SymbolEntry.create(string5, string6, string2, string3));
        if (null != string4) {
            String[] stringArray = string4.split(";");
            for (int i = 1; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("\t");
                if (stringArray2.length != 2) continue;
                String string7 = stringArray2[0];
                String[] stringArray3 = stringArray2[1].split(":");
                if (stringArray3.length != 2) continue;
                String string8 = stringArray3[0];
                String string9 = Paths.get(string8, new String[0]).getParent().getFileName().toString();
                String string10 = Paths.get(string8, new String[0]).getFileName().toString();
                String string11 = stringArray2[1];
                if (string7 == null || string11 == null) continue;
                arrayList.add(SymbolEntry.create(string9, string10, string7, string11));
            }
        }
        return arrayList;
    }

    public long getStrEntryOffset() {
        return this.strEntryOffset;
    }

    public void setAddress(long l) {
        this.address = l;
    }

    public void setEndAddress(long l) {
        this.endAddress = l;
    }

    public void setSymtabString(String string) {
        this.symtabString = string;
    }

    public void setStrEntryOffset(long l) {
        this.strEntryOffset = l;
    }

    public List<SymbolEntry> getSymbolEntries() {
        return this.symbolEntries;
    }

    public void setSymbolEntries(List<SymbolEntry> list) {
        this.symbolEntries = list;
    }

    private boolean getInfoFromSymbol(Symbol symbol) {
        if (null == symbol) {
            return false;
        }
        this.address = symbol.getAddress();
        this.endAddress = symbol.getEndAddress();
        this.symbolEntries = this.getSymbolEntryList(symbol);
        return this.validate();
    }

    public static SymtabIndexEntry create(String string) {
        SymtabIndexEntry symtabIndexEntry = new SymtabIndexEntry();
        symtabIndexEntry.parseString(string);
        if (!symtabIndexEntry.validate()) {
            return null;
        }
        return symtabIndexEntry;
    }

    public void parseString(String string) {
        String[] stringArray;
        if (string.contains("\n")) {
            string = string.substring(0, string.indexOf("\n"));
        }
        if ((stringArray = string.split("-->")).length < 2) {
            Log.error("Failed to parse the string\uff1a%s", string);
            return;
        }
        String[] stringArray2 = stringArray[0].split("\t");
        this.address = Long.parseLong(stringArray2[0], 16);
        this.endAddress = Long.parseLong(stringArray2[1], 16);
        this.symbolEntries = new ArrayList<SymbolEntry>();
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i].split("->");
            if (stringArray3.length == 3) {
                String string2 = stringArray3[1];
                String string3 = Paths.get(string2, new String[0]).toFile().getParent();
                String string4 = Paths.get(string2, new String[0]).getFileName().toString();
                this.symbolEntries.add(SymbolEntry.create(string3, string4, stringArray3[0], stringArray3[2]));
                continue;
            }
            if (stringArray3.length != 1) continue;
            this.symbolEntries.add(SymbolEntry.create("", "", stringArray3[0], ""));
        }
    }

    private boolean validate() {
        if (this.address < 0L) {
            return false;
        }
        if (this.endAddress < 0L) {
            return false;
        }
        return null != this.symbolEntries && !this.symbolEntries.isEmpty();
    }
}

