/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.JsonResponseErrModel;
import com.tencentcloudapi.common.JsonResponseModel;
import com.tencentcloudapi.common.Sign;
import com.tencentcloudapi.common.TCLog;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.http.HttpConnection;
import com.tencentcloudapi.common.profile.ClientProfile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import javax.crypto.Mac;
import javax.net.ssl.SSLContext;
import javax.xml.bind.DatatypeConverter;

public abstract class AbstractClient {
    public static final int HTTP_RSP_OK = 200;
    public static final String SDK_VERSION = "SDK_JAVA_3.1.213";
    private Credential credential;
    private ClientProfile profile;
    private String endpoint;
    private String service;
    private String region;
    private String path;
    private String sdkVersion;
    private String apiVersion;
    public Gson gson;
    private TCLog log;

    public AbstractClient(String string, String string2, Credential credential, String string3) {
        this(string, string2, credential, string3, new ClientProfile());
    }

    public AbstractClient(String string, String string2, Credential credential, String string3, ClientProfile clientProfile) {
        this.credential = credential;
        this.profile = clientProfile;
        this.endpoint = string;
        this.service = string.split("\\.")[0];
        this.region = string3;
        this.path = "/";
        this.sdkVersion = SDK_VERSION;
        this.apiVersion = string2;
        this.gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        this.log = new TCLog(this.getClass().getName(), clientProfile.isDebug());
        this.warmup();
    }

    public void setRegion(String string) {
        this.region = string;
    }

    public String getRegion() {
        return this.region;
    }

    public void setClientProfile(ClientProfile clientProfile) {
        this.profile = clientProfile;
    }

    public ClientProfile getClientProfile() {
        return this.profile;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public String call(String string, String string2) throws TencentCloudSDKException {
        Headers headers;
        Response response;
        String string3 = this.getEndpoint();
        String string4 = "application/json; charset=utf-8";
        byte[] byArray = string2.getBytes(StandardCharsets.UTF_8);
        String string5 = "/";
        String string6 = "";
        String string7 = "content-type:" + string4 + "\nhost:" + string3 + "\n";
        String string8 = "content-type;host";
        String string9 = "";
        string9 = this.profile.isUnsignedPayload() ? Sign.sha256Hex("UNSIGNED-PAYLOAD".getBytes(StandardCharsets.UTF_8)) : Sign.sha256Hex(byArray);
        String string10 = "POST\n" + string5 + "\n" + string6 + "\n" + string7 + "\n" + string8 + "\n" + string9;
        String string11 = String.valueOf(System.currentTimeMillis() / 1000L);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String string12 = simpleDateFormat.format(new Date(Long.valueOf(string11 + "000")));
        String string13 = string3.split("\\.")[0];
        String string14 = string12 + "/" + string13 + "/tc3_request";
        String string15 = Sign.sha256Hex(string10.getBytes(StandardCharsets.UTF_8));
        String string16 = "TC3-HMAC-SHA256\n" + string11 + "\n" + string14 + "\n" + string15;
        String string17 = this.credential.getSecretId();
        String string18 = this.credential.getSecretKey();
        byte[] byArray2 = Sign.hmac256(("TC3" + string18).getBytes(StandardCharsets.UTF_8), string12);
        byte[] byArray3 = Sign.hmac256(byArray2, string13);
        byte[] byArray4 = Sign.hmac256(byArray3, "tc3_request");
        String string19 = DatatypeConverter.printHexBinary(Sign.hmac256(byArray4, string16)).toLowerCase();
        String string20 = "TC3-HMAC-SHA256 Credential=" + string17 + "/" + string14 + ", SignedHeaders=" + string8 + ", Signature=" + string19;
        HttpConnection httpConnection = new HttpConnection(this.profile.getHttpProfile().getConnTimeout(), this.profile.getHttpProfile().getReadTimeout(), this.profile.getHttpProfile().getWriteTimeout());
        httpConnection.addInterceptors(this.log);
        this.trySetProxy(httpConnection);
        String string21 = this.profile.getHttpProfile().getProtocol() + string3 + this.path;
        Headers.Builder builder = new Headers.Builder();
        builder.add("Content-Type", string4).add("Host", string3).add("Authorization", string20).add("X-TC-Action", string).add("X-TC-Timestamp", string11).add("X-TC-Version", this.apiVersion).add("X-TC-Region", this.getRegion()).add("X-TC-RequestClient", SDK_VERSION);
        String string22 = this.credential.getToken();
        if (string22 != null && !string22.isEmpty()) {
            builder.add("X-TC-Token", string22);
        }
        if (this.profile.isUnsignedPayload()) {
            builder.add("X-TC-Content-SHA256", "UNSIGNED-PAYLOAD");
        }
        if (null != this.profile.getLanguage()) {
            builder.add("X-TC-Language", this.profile.getLanguage().getValue());
        }
        if ((response = httpConnection.postRequest(string21, byArray, headers = builder.build())).code() != 200) {
            String string23 = "response code is " + response.code() + ", not 200";
            this.log.info(string23);
            throw new TencentCloudSDKException(string23, "", "ServerSideError");
        }
        String string24 = null;
        try {
            string24 = response.body().string();
        }
        catch (IOException iOException) {
            String string25 = "Cannot transfer response body to string, because Content-Length is too large, or Content-Length and stream length disagree.";
            this.log.info(string25);
            throw new TencentCloudSDKException(string25, "", iOException.getClass().getName());
        }
        JsonResponseModel jsonResponseModel = null;
        try {
            Type type = new TypeToken<JsonResponseModel<JsonResponseErrModel>>(){}.getType();
            jsonResponseModel = (JsonResponseModel)this.gson.fromJson(string24, type);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            String string26 = "json is not a valid representation for an object of type";
            this.log.info(string26);
            throw new TencentCloudSDKException(string26, "", jsonSyntaxException.getClass().getName());
        }
        if (((JsonResponseErrModel)jsonResponseModel.response).error != null) {
            throw new TencentCloudSDKException(((JsonResponseErrModel)jsonResponseModel.response).error.message, ((JsonResponseErrModel)jsonResponseModel.response).requestId, ((JsonResponseErrModel)jsonResponseModel.response).error.code);
        }
        return string24;
    }

    private void trySetProxy(HttpConnection httpConnection) {
        String string = this.profile.getHttpProfile().getProxyHost();
        int n = this.profile.getHttpProfile().getProxyPort();
        if (string == null || string.isEmpty()) {
            return;
        }
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n));
        httpConnection.setProxy(proxy);
        final String string2 = this.profile.getHttpProfile().getProxyUsername();
        final String string3 = this.profile.getHttpProfile().getProxyPassword();
        if (string2 == null || string2.isEmpty()) {
            return;
        }
        httpConnection.setAuthenticator(new Authenticator(){

            @Override
            public Request authenticate(Proxy proxy, Response response) throws IOException {
                String string = Credentials.basic(string2, string3);
                return response.request().newBuilder().header("Proxy-Authorization", string).build();
            }

            @Override
            public Request authenticateProxy(Proxy proxy, Response response) throws IOException {
                return this.authenticate(proxy, response);
            }
        });
    }

    protected String internalRequest(AbstractModel abstractModel, String string) throws TencentCloudSDKException {
        Response response = null;
        String string2 = this.getEndpoint();
        String[] stringArray = abstractModel.getBinaryParams();
        String string3 = this.profile.getSignMethod();
        String string4 = this.profile.getHttpProfile().getReqMethod();
        HashMap<String, Object> hashMap = abstractModel.any();
        if (hashMap.size() > 0) {
            if (stringArray.length > 0) {
                throw new TencentCloudSDKException("WrongUsage: Cannot post multipart with customized parameters.");
            }
            if (string3.equals("HmacSHA1") || string3.equals("HmacSHA256")) {
                throw new TencentCloudSDKException("WrongUsage: Cannot use HmacSHA1 or HmacSHA256 with customized parameters.");
            }
            if (string4.equals("GET")) {
                throw new TencentCloudSDKException("WrongUsage: Cannot use get method with customized parameters.");
            }
        }
        if (stringArray.length > 0 || string3.equals("TC3-HMAC-SHA256")) {
            response = this.doRequestWithTC3(string2, abstractModel, string);
        } else if (string3.equals("HmacSHA1") || string3.equals("HmacSHA256")) {
            response = this.doRequest(string2, abstractModel, string);
        } else {
            throw new TencentCloudSDKException("Signature method " + string3 + " is invalid or not supported yet.");
        }
        if (response.code() != 200) {
            String string5 = "response code is " + response.code() + ", not 200";
            this.log.info(string5);
            throw new TencentCloudSDKException(string5, "", "ServerSideError");
        }
        String string6 = null;
        try {
            string6 = response.body().string();
        }
        catch (IOException iOException) {
            String string7 = "Cannot transfer response body to string, because Content-Length is too large, or Content-Length and stream length disagree.";
            this.log.info(string7);
            throw new TencentCloudSDKException(string7, "", string2.getClass().getName());
        }
        JsonResponseModel jsonResponseModel = null;
        try {
            Type type = new TypeToken<JsonResponseModel<JsonResponseErrModel>>(){}.getType();
            jsonResponseModel = (JsonResponseModel)this.gson.fromJson(string6, type);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            String string8 = "json is not a valid representation for an object of type";
            this.log.info(string8);
            throw new TencentCloudSDKException(string8, "", jsonSyntaxException.getClass().getName());
        }
        if (((JsonResponseErrModel)jsonResponseModel.response).error != null) {
            throw new TencentCloudSDKException(((JsonResponseErrModel)jsonResponseModel.response).error.message, ((JsonResponseErrModel)jsonResponseModel.response).requestId, ((JsonResponseErrModel)jsonResponseModel.response).error.code);
        }
        return string6;
    }

    private Response doRequest(String string, AbstractModel abstractModel, String string2) throws TencentCloudSDKException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        abstractModel.toMap(hashMap, "");
        String string3 = this.formatRequestData(string2, hashMap);
        HttpConnection httpConnection = new HttpConnection(this.profile.getHttpProfile().getConnTimeout(), this.profile.getHttpProfile().getReadTimeout(), this.profile.getHttpProfile().getWriteTimeout());
        httpConnection.addInterceptors(this.log);
        this.trySetProxy(httpConnection);
        String string4 = this.profile.getHttpProfile().getReqMethod();
        String string5 = this.profile.getHttpProfile().getProtocol() + string + this.path;
        if (string4.equals("GET")) {
            return httpConnection.getRequest(string5 + "?" + string3);
        }
        if (string4.equals("POST")) {
            return httpConnection.postRequest(string5, string3);
        }
        throw new TencentCloudSDKException("Method only support (GET, POST)");
    }

    private Response doRequestWithTC3(String string, AbstractModel abstractModel, String string2) throws TencentCloudSDKException {
        String string3;
        String string4;
        String string5 = this.profile.getHttpProfile().getReqMethod();
        if (string5 == null) {
            throw new TencentCloudSDKException("Request method should not be null, can only be GET or POST");
        }
        String string6 = "application/x-www-form-urlencoded";
        byte[] byArray = "".getBytes(StandardCharsets.UTF_8);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        abstractModel.toMap(hashMap, "");
        String[] stringArray = abstractModel.getBinaryParams();
        if (stringArray.length > 0) {
            string5 = "POST";
            string4 = UUID.randomUUID().toString();
            string6 = "multipart/form-data; charset=utf-8; boundary=" + string4;
            try {
                byArray = this.getMultipartPayload(abstractModel, string4);
            }
            catch (Exception exception) {
                throw new TencentCloudSDKException("Failed to generate multipart. because: " + exception);
            }
        } else if (string5.equals("POST")) {
            byArray = AbstractModel.toJsonString(abstractModel).getBytes(StandardCharsets.UTF_8);
            string6 = "application/json; charset=utf-8";
        }
        string4 = "/";
        String string7 = this.getCanonicalQueryString(hashMap, string5);
        String string8 = "content-type:" + string6 + "\nhost:" + string + "\n";
        String string9 = "content-type;host";
        String string10 = "";
        string10 = this.profile.isUnsignedPayload() ? Sign.sha256Hex("UNSIGNED-PAYLOAD".getBytes(StandardCharsets.UTF_8)) : Sign.sha256Hex(byArray);
        String string11 = string5 + "\n" + string4 + "\n" + string7 + "\n" + string8 + "\n" + string9 + "\n" + string10;
        String string12 = String.valueOf(System.currentTimeMillis() / 1000L);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String string13 = simpleDateFormat.format(new Date(Long.valueOf(string12 + "000")));
        String string14 = string.split("\\.")[0];
        String string15 = string13 + "/" + string14 + "/tc3_request";
        String string16 = Sign.sha256Hex(string11.getBytes(StandardCharsets.UTF_8));
        String string17 = "TC3-HMAC-SHA256\n" + string12 + "\n" + string15 + "\n" + string16;
        String string18 = this.credential.getSecretId();
        String string19 = this.credential.getSecretKey();
        byte[] byArray2 = Sign.hmac256(("TC3" + string19).getBytes(StandardCharsets.UTF_8), string13);
        byte[] byArray3 = Sign.hmac256(byArray2, string14);
        byte[] byArray4 = Sign.hmac256(byArray3, "tc3_request");
        String string20 = DatatypeConverter.printHexBinary(Sign.hmac256(byArray4, string17)).toLowerCase();
        String string21 = "TC3-HMAC-SHA256 Credential=" + string18 + "/" + string15 + ", SignedHeaders=" + string9 + ", Signature=" + string20;
        HttpConnection httpConnection = new HttpConnection(this.profile.getHttpProfile().getConnTimeout(), this.profile.getHttpProfile().getReadTimeout(), this.profile.getHttpProfile().getWriteTimeout());
        httpConnection.addInterceptors(this.log);
        this.trySetProxy(httpConnection);
        String string22 = this.profile.getHttpProfile().getProtocol() + string + this.path;
        Headers.Builder builder = new Headers.Builder();
        builder.add("Content-Type", string6).add("Host", string).add("Authorization", string21).add("X-TC-Action", string2).add("X-TC-Timestamp", string12).add("X-TC-Version", this.apiVersion).add("X-TC-RequestClient", SDK_VERSION);
        if (null != this.getRegion()) {
            builder.add("X-TC-Region", this.getRegion());
        }
        if ((string3 = this.credential.getToken()) != null && !string3.isEmpty()) {
            builder.add("X-TC-Token", string3);
        }
        if (this.profile.isUnsignedPayload()) {
            builder.add("X-TC-Content-SHA256", "UNSIGNED-PAYLOAD");
        }
        if (null != this.profile.getLanguage()) {
            builder.add("X-TC-Language", this.profile.getLanguage().getValue());
        }
        Headers headers = builder.build();
        if (string5.equals("GET")) {
            return httpConnection.getRequest(string22 + "?" + string7, headers);
        }
        if (string5.equals("POST")) {
            return httpConnection.postRequest(string22, byArray, headers);
        }
        throw new TencentCloudSDKException("Method only support GET, POST");
    }

    private byte[] getMultipartPayload(AbstractModel abstractModel, String string) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String[] stringArray = abstractModel.getBinaryParams();
        for (Map.Entry<String, byte[]> entry : abstractModel.getMultipartRequestParams().entrySet()) {
            byteArrayOutputStream.write("--".getBytes(StandardCharsets.UTF_8));
            byteArrayOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            byteArrayOutputStream.write("\r\n".getBytes(StandardCharsets.UTF_8));
            byteArrayOutputStream.write("Content-Disposition: form-data; name=\"".getBytes(StandardCharsets.UTF_8));
            byteArrayOutputStream.write(entry.getKey().getBytes(StandardCharsets.UTF_8));
            if (Arrays.asList(stringArray).contains(entry.getKey())) {
                byteArrayOutputStream.write("\"; filename=\"".getBytes(StandardCharsets.UTF_8));
                byteArrayOutputStream.write(entry.getKey().getBytes(StandardCharsets.UTF_8));
                byteArrayOutputStream.write("\"\r\n".getBytes(StandardCharsets.UTF_8));
            } else {
                byteArrayOutputStream.write("\"\r\n".getBytes(StandardCharsets.UTF_8));
            }
            byteArrayOutputStream.write("\r\n".getBytes(StandardCharsets.UTF_8));
            byteArrayOutputStream.write(entry.getValue());
            byteArrayOutputStream.write("\r\n".getBytes(StandardCharsets.UTF_8));
        }
        if (byteArrayOutputStream.size() != 0) {
            byteArrayOutputStream.write("--".getBytes(StandardCharsets.UTF_8));
            byteArrayOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            byteArrayOutputStream.write("--\r\n".getBytes(StandardCharsets.UTF_8));
        }
        Object object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return object;
    }

    private String getCanonicalQueryString(HashMap<String, String> hashMap, String string) throws TencentCloudSDKException {
        if (string != null && string.equals("POST")) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("");
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            String string2;
            try {
                string2 = URLEncoder.encode(entry.getValue(), "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new TencentCloudSDKException("UTF8 is not supported." + unsupportedEncodingException.getMessage());
            }
            stringBuilder.append("&").append(entry.getKey()).append("=").append(string2);
        }
        return stringBuilder.toString().substring(1);
    }

    private String formatRequestData(String string, Map<String, String> map) throws TencentCloudSDKException {
        map.put("Action", string);
        map.put("RequestClient", this.sdkVersion);
        map.put("Nonce", String.valueOf(Math.abs(new SecureRandom().nextInt())));
        map.put("Timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        map.put("Version", this.apiVersion);
        if (this.credential.getSecretId() != null && !this.credential.getSecretId().isEmpty()) {
            map.put("SecretId", this.credential.getSecretId());
        }
        if (this.region != null && !this.region.isEmpty()) {
            map.put("Region", this.region);
        }
        if (this.profile.getSignMethod() != null && !this.profile.getSignMethod().isEmpty()) {
            map.put("SignatureMethod", this.profile.getSignMethod());
        }
        if (this.credential.getToken() != null && !this.credential.getToken().isEmpty()) {
            map.put("Token", this.credential.getToken());
        }
        if (null != this.profile.getLanguage()) {
            map.put("Language", this.profile.getLanguage().getValue());
        }
        String string2 = this.getEndpoint();
        String string3 = Sign.makeSignPlainText(new TreeMap<String, String>(map), this.profile.getHttpProfile().getReqMethod(), string2, this.path);
        String string4 = Sign.sign(this.credential.getSecretKey(), string3, this.profile.getSignMethod());
        String string5 = "";
        try {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                string5 = string5 + URLEncoder.encode(entry.getKey(), "utf-8") + "=" + URLEncoder.encode(entry.getValue(), "utf-8") + "&";
            }
            string5 = string5 + "Signature=" + URLEncoder.encode(string4, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TencentCloudSDKException(unsupportedEncodingException.getClass().getName() + "-" + unsupportedEncodingException.getMessage());
        }
        return string5;
    }

    private void warmup() {
        try {
            Mac.getInstance("HmacSHA1");
            Mac.getInstance("HmacSHA256");
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getEndpoint() {
        this.endpoint = this.profile.getHttpProfile().getEndpoint();
        if (null == this.endpoint) {
            this.endpoint = this.service + "." + this.profile.getHttpProfile().getRootDomain();
        }
        return this.endpoint;
    }
}

