/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.framed;

import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.framed.ErrorCode;
import com.squareup.okhttp.internal.framed.FrameReader;
import com.squareup.okhttp.internal.framed.FrameWriter;
import com.squareup.okhttp.internal.framed.Header;
import com.squareup.okhttp.internal.framed.HeadersMode;
import com.squareup.okhttp.internal.framed.Hpack;
import com.squareup.okhttp.internal.framed.Settings;
import com.squareup.okhttp.internal.framed.Variant;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Source;
import okio.Timeout;

public final class Http2
implements Variant {
    private static final Logger logger = Logger.getLogger(FrameLogger.class.getName());
    private static final ByteString CONNECTION_PREFACE = ByteString.encodeUtf8("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n");
    static final int INITIAL_MAX_FRAME_SIZE = 16384;
    static final byte TYPE_DATA = 0;
    static final byte TYPE_HEADERS = 1;
    static final byte TYPE_PRIORITY = 2;
    static final byte TYPE_RST_STREAM = 3;
    static final byte TYPE_SETTINGS = 4;
    static final byte TYPE_PUSH_PROMISE = 5;
    static final byte TYPE_PING = 6;
    static final byte TYPE_GOAWAY = 7;
    static final byte TYPE_WINDOW_UPDATE = 8;
    static final byte TYPE_CONTINUATION = 9;
    static final byte FLAG_NONE = 0;
    static final byte FLAG_ACK = 1;
    static final byte FLAG_END_STREAM = 1;
    static final byte FLAG_END_HEADERS = 4;
    static final byte FLAG_END_PUSH_PROMISE = 4;
    static final byte FLAG_PADDED = 8;
    static final byte FLAG_PRIORITY = 32;
    static final byte FLAG_COMPRESSED = 32;

    @Override
    public Protocol getProtocol() {
        return Protocol.HTTP_2;
    }

    @Override
    public FrameReader newReader(BufferedSource bufferedSource, boolean bl) {
        return new Reader(bufferedSource, 4096, bl);
    }

    @Override
    public FrameWriter newWriter(BufferedSink bufferedSink, boolean bl) {
        return new Writer(bufferedSink, bl);
    }

    private static IllegalArgumentException illegalArgument(String string, Object ... objectArray) {
        throw new IllegalArgumentException(String.format(string, objectArray));
    }

    private static IOException ioException(String string, Object ... objectArray) throws IOException {
        throw new IOException(String.format(string, objectArray));
    }

    private static int lengthWithoutPadding(int n, byte by, short s2) throws IOException {
        if ((by & 8) != 0) {
            --n;
        }
        if (s2 > n) {
            throw Http2.ioException("PROTOCOL_ERROR padding %s > remaining length %s", s2, n);
        }
        return (short)(n - s2);
    }

    private static int readMedium(BufferedSource bufferedSource) throws IOException {
        return (bufferedSource.readByte() & 0xFF) << 16 | (bufferedSource.readByte() & 0xFF) << 8 | bufferedSource.readByte() & 0xFF;
    }

    private static void writeMedium(BufferedSink bufferedSink, int n) throws IOException {
        bufferedSink.writeByte(n >>> 16 & 0xFF);
        bufferedSink.writeByte(n >>> 8 & 0xFF);
        bufferedSink.writeByte(n & 0xFF);
    }

    static final class FrameLogger {
        private static final String[] TYPES = new String[]{"DATA", "HEADERS", "PRIORITY", "RST_STREAM", "SETTINGS", "PUSH_PROMISE", "PING", "GOAWAY", "WINDOW_UPDATE", "CONTINUATION"};
        private static final String[] FLAGS = new String[64];
        private static final String[] BINARY = new String[256];

        FrameLogger() {
        }

        static String formatHeader(boolean bl, int n, int n2, byte by, byte by2) {
            String string = by < TYPES.length ? TYPES[by] : String.format("0x%02x", by);
            String string2 = FrameLogger.formatFlags(by, by2);
            return String.format("%s 0x%08x %5d %-13s %s", bl ? "<<" : ">>", n, n2, string, string2);
        }

        static String formatFlags(byte by, byte by2) {
            String string;
            if (by2 == 0) {
                return "";
            }
            switch (by) {
                case 4: 
                case 6: {
                    return by2 == 1 ? "ACK" : BINARY[by2];
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    return BINARY[by2];
                }
            }
            String string2 = string = by2 < FLAGS.length ? FLAGS[by2] : BINARY[by2];
            if (by == 5 && (by2 & 4) != 0) {
                return string.replace("HEADERS", "PUSH_PROMISE");
            }
            if (by == 0 && (by2 & 0x20) != 0) {
                return string.replace("PRIORITY", "COMPRESSED");
            }
            return string;
        }

        static {
            for (int i = 0; i < BINARY.length; ++i) {
                FrameLogger.BINARY[i] = String.format("%8s", Integer.toBinaryString(i)).replace(' ', '0');
            }
            FrameLogger.FLAGS[0] = "";
            FrameLogger.FLAGS[1] = "END_STREAM";
            int[] nArray = new int[]{1};
            FrameLogger.FLAGS[8] = "PADDED";
            int[] nArray2 = nArray;
            int n = nArray2.length;
            for (int i = 0; i < n; ++i) {
                int n2 = nArray2[i];
                FrameLogger.FLAGS[n2 | 8] = FLAGS[n2] + "|PADDED";
            }
            FrameLogger.FLAGS[4] = "END_HEADERS";
            FrameLogger.FLAGS[32] = "PRIORITY";
            FrameLogger.FLAGS[36] = "END_HEADERS|PRIORITY";
            for (int n3 : nArray2 = new int[]{4, 32, 36}) {
                for (int n4 : nArray) {
                    FrameLogger.FLAGS[n4 | n3] = FLAGS[n4] + '|' + FLAGS[n3];
                    FrameLogger.FLAGS[n4 | n3 | 8] = FLAGS[n4] + '|' + FLAGS[n3] + "|PADDED";
                }
            }
            for (int i = 0; i < FLAGS.length; ++i) {
                if (FLAGS[i] != null) continue;
                FrameLogger.FLAGS[i] = BINARY[i];
            }
        }
    }

    static final class ContinuationSource
    implements Source {
        private final BufferedSource source;
        int length;
        byte flags;
        int streamId;
        int left;
        short padding;

        public ContinuationSource(BufferedSource bufferedSource) {
            this.source = bufferedSource;
        }

        @Override
        public long read(Buffer buffer, long l) throws IOException {
            while (this.left == 0) {
                this.source.skip(this.padding);
                this.padding = 0;
                if ((this.flags & 4) != 0) {
                    return -1L;
                }
                this.readContinuationHeader();
            }
            long l2 = this.source.read(buffer, Math.min(l, (long)this.left));
            if (l2 == -1L) {
                return -1L;
            }
            this.left = (int)((long)this.left - l2);
            return l2;
        }

        @Override
        public Timeout timeout() {
            return this.source.timeout();
        }

        @Override
        public void close() throws IOException {
        }

        private void readContinuationHeader() throws IOException {
            int n = this.streamId;
            this.length = this.left = Http2.readMedium(this.source);
            byte by = (byte)(this.source.readByte() & 0xFF);
            this.flags = (byte)(this.source.readByte() & 0xFF);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(FrameLogger.formatHeader(true, this.streamId, this.length, by, this.flags));
            }
            this.streamId = this.source.readInt() & Integer.MAX_VALUE;
            if (by != 9) {
                throw Http2.ioException("%s != TYPE_CONTINUATION", new Object[]{by});
            }
            if (this.streamId != n) {
                throw Http2.ioException("TYPE_CONTINUATION streamId changed", new Object[0]);
            }
        }
    }

    static final class Writer
    implements FrameWriter {
        private final BufferedSink sink;
        private final boolean client;
        private final Buffer hpackBuffer;
        private final Hpack.Writer hpackWriter;
        private int maxFrameSize;
        private boolean closed;

        Writer(BufferedSink bufferedSink, boolean bl) {
            this.sink = bufferedSink;
            this.client = bl;
            this.hpackBuffer = new Buffer();
            this.hpackWriter = new Hpack.Writer(this.hpackBuffer);
            this.maxFrameSize = 16384;
        }

        @Override
        public synchronized void flush() throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            this.sink.flush();
        }

        @Override
        public synchronized void ackSettings(Settings settings) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            this.maxFrameSize = settings.getMaxFrameSize(this.maxFrameSize);
            int n = 0;
            byte by = 4;
            byte by2 = 1;
            int n2 = 0;
            this.frameHeader(n2, n, by, by2);
            this.sink.flush();
        }

        @Override
        public synchronized void connectionPreface() throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (!this.client) {
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format(">> CONNECTION %s", CONNECTION_PREFACE.hex()));
            }
            this.sink.write(CONNECTION_PREFACE.toByteArray());
            this.sink.flush();
        }

        @Override
        public synchronized void synStream(boolean bl, boolean bl2, int n, int n2, List<Header> list) throws IOException {
            if (bl2) {
                throw new UnsupportedOperationException();
            }
            if (this.closed) {
                throw new IOException("closed");
            }
            this.headers(bl, n, list);
        }

        @Override
        public synchronized void synReply(boolean bl, int n, List<Header> list) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            this.headers(bl, n, list);
        }

        @Override
        public synchronized void headers(int n, List<Header> list) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            this.headers(false, n, list);
        }

        @Override
        public synchronized void pushPromise(int n, int n2, List<Header> list) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            this.hpackWriter.writeHeaders(list);
            long l = this.hpackBuffer.size();
            int n3 = (int)Math.min((long)(this.maxFrameSize - 4), l);
            byte by = 5;
            byte by2 = l == (long)n3 ? (byte)4 : 0;
            this.frameHeader(n, n3 + 4, by, by2);
            this.sink.writeInt(n2 & Integer.MAX_VALUE);
            this.sink.write(this.hpackBuffer, (long)n3);
            if (l > (long)n3) {
                this.writeContinuationFrames(n, l - (long)n3);
            }
        }

        void headers(boolean bl, int n, List<Header> list) throws IOException {
            byte by;
            if (this.closed) {
                throw new IOException("closed");
            }
            this.hpackWriter.writeHeaders(list);
            long l = this.hpackBuffer.size();
            int n2 = (int)Math.min((long)this.maxFrameSize, l);
            byte by2 = 1;
            byte by3 = by = l == (long)n2 ? (byte)4 : 0;
            if (bl) {
                by = (byte)(by | 1);
            }
            this.frameHeader(n, n2, by2, by);
            this.sink.write(this.hpackBuffer, (long)n2);
            if (l > (long)n2) {
                this.writeContinuationFrames(n, l - (long)n2);
            }
        }

        private void writeContinuationFrames(int n, long l) throws IOException {
            while (l > 0L) {
                int n2;
                this.frameHeader(n, n2, (byte)9, (l -= (long)(n2 = (int)Math.min((long)this.maxFrameSize, l))) == 0L ? (byte)4 : 0);
                this.sink.write(this.hpackBuffer, (long)n2);
            }
        }

        @Override
        public synchronized void rstStream(int n, ErrorCode errorCode) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (errorCode.httpCode == -1) {
                throw new IllegalArgumentException();
            }
            int n2 = 4;
            byte by = 3;
            byte by2 = 0;
            this.frameHeader(n, n2, by, by2);
            this.sink.writeInt(errorCode.httpCode);
            this.sink.flush();
        }

        @Override
        public int maxDataLength() {
            return this.maxFrameSize;
        }

        @Override
        public synchronized void data(boolean bl, int n, Buffer buffer, int n2) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            byte by = 0;
            if (bl) {
                by = (byte)(by | 1);
            }
            this.dataFrame(n, by, buffer, n2);
        }

        void dataFrame(int n, byte by, Buffer buffer, int n2) throws IOException {
            byte by2 = 0;
            this.frameHeader(n, n2, by2, by);
            if (n2 > 0) {
                this.sink.write(buffer, (long)n2);
            }
        }

        @Override
        public synchronized void settings(Settings settings) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            int n = settings.size() * 6;
            byte by = 4;
            byte by2 = 0;
            int n2 = 0;
            this.frameHeader(n2, n, by, by2);
            for (int i = 0; i < 10; ++i) {
                if (!settings.isSet(i)) continue;
                int n3 = i;
                if (n3 == 4) {
                    n3 = 3;
                } else if (n3 == 7) {
                    n3 = 4;
                }
                this.sink.writeShort(n3);
                this.sink.writeInt(settings.get(i));
            }
            this.sink.flush();
        }

        @Override
        public synchronized void ping(boolean bl, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            int n3 = 8;
            byte by = 6;
            byte by2 = bl ? (byte)1 : 0;
            int n4 = 0;
            this.frameHeader(n4, n3, by, by2);
            this.sink.writeInt(n);
            this.sink.writeInt(n2);
            this.sink.flush();
        }

        @Override
        public synchronized void goAway(int n, ErrorCode errorCode, byte[] byArray) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (errorCode.httpCode == -1) {
                throw Http2.illegalArgument("errorCode.httpCode == -1", new Object[0]);
            }
            int n2 = 8 + byArray.length;
            byte by = 7;
            byte by2 = 0;
            int n3 = 0;
            this.frameHeader(n3, n2, by, by2);
            this.sink.writeInt(n);
            this.sink.writeInt(errorCode.httpCode);
            if (byArray.length > 0) {
                this.sink.write(byArray);
            }
            this.sink.flush();
        }

        @Override
        public synchronized void windowUpdate(int n, long l) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (l == 0L || l > Integer.MAX_VALUE) {
                throw Http2.illegalArgument("windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: %s", new Object[]{l});
            }
            int n2 = 4;
            byte by = 8;
            byte by2 = 0;
            this.frameHeader(n, n2, by, by2);
            this.sink.writeInt((int)l);
            this.sink.flush();
        }

        @Override
        public synchronized void close() throws IOException {
            this.closed = true;
            this.sink.close();
        }

        void frameHeader(int n, int n2, byte by, byte by2) throws IOException {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(FrameLogger.formatHeader(false, n, n2, by, by2));
            }
            if (n2 > this.maxFrameSize) {
                throw Http2.illegalArgument("FRAME_SIZE_ERROR length > %d: %d", new Object[]{this.maxFrameSize, n2});
            }
            if ((n & Integer.MIN_VALUE) != 0) {
                throw Http2.illegalArgument("reserved bit set: %s", new Object[]{n});
            }
            Http2.writeMedium(this.sink, n2);
            this.sink.writeByte(by & 0xFF);
            this.sink.writeByte(by2 & 0xFF);
            this.sink.writeInt(n & Integer.MAX_VALUE);
        }
    }

    static final class Reader
    implements FrameReader {
        private final BufferedSource source;
        private final ContinuationSource continuation;
        private final boolean client;
        final Hpack.Reader hpackReader;

        Reader(BufferedSource bufferedSource, int n, boolean bl) {
            this.source = bufferedSource;
            this.client = bl;
            this.continuation = new ContinuationSource(this.source);
            this.hpackReader = new Hpack.Reader(n, this.continuation);
        }

        @Override
        public void readConnectionPreface() throws IOException {
            if (this.client) {
                return;
            }
            ByteString byteString = this.source.readByteString(CONNECTION_PREFACE.size());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("<< CONNECTION %s", byteString.hex()));
            }
            if (!CONNECTION_PREFACE.equals(byteString)) {
                throw Http2.ioException("Expected a connection header but was %s", new Object[]{byteString.utf8()});
            }
        }

        @Override
        public boolean nextFrame(FrameReader.Handler handler) throws IOException {
            try {
                this.source.require(9L);
            }
            catch (IOException iOException) {
                return false;
            }
            int n = Http2.readMedium(this.source);
            if (n < 0 || n > 16384) {
                throw Http2.ioException("FRAME_SIZE_ERROR: %s", new Object[]{n});
            }
            byte by = (byte)(this.source.readByte() & 0xFF);
            byte by2 = (byte)(this.source.readByte() & 0xFF);
            int n2 = this.source.readInt() & Integer.MAX_VALUE;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(FrameLogger.formatHeader(true, n2, n, by, by2));
            }
            switch (by) {
                case 0: {
                    this.readData(handler, n, by2, n2);
                    break;
                }
                case 1: {
                    this.readHeaders(handler, n, by2, n2);
                    break;
                }
                case 2: {
                    this.readPriority(handler, n, by2, n2);
                    break;
                }
                case 3: {
                    this.readRstStream(handler, n, by2, n2);
                    break;
                }
                case 4: {
                    this.readSettings(handler, n, by2, n2);
                    break;
                }
                case 5: {
                    this.readPushPromise(handler, n, by2, n2);
                    break;
                }
                case 6: {
                    this.readPing(handler, n, by2, n2);
                    break;
                }
                case 7: {
                    this.readGoAway(handler, n, by2, n2);
                    break;
                }
                case 8: {
                    this.readWindowUpdate(handler, n, by2, n2);
                    break;
                }
                default: {
                    this.source.skip(n);
                }
            }
            return true;
        }

        private void readHeaders(FrameReader.Handler handler, int n, byte by, int n2) throws IOException {
            short s2;
            if (n2 == 0) {
                throw Http2.ioException("PROTOCOL_ERROR: TYPE_HEADERS streamId == 0", new Object[0]);
            }
            boolean bl = (by & 1) != 0;
            short s3 = s2 = (by & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
            if ((by & 0x20) != 0) {
                this.readPriority(handler, n2);
                n -= 5;
            }
            n = Http2.lengthWithoutPadding(n, by, s2);
            List<Header> list = this.readHeaderBlock(n, s2, by, n2);
            handler.headers(false, bl, n2, -1, list, HeadersMode.HTTP_20_HEADERS);
        }

        private List<Header> readHeaderBlock(int n, short s2, byte by, int n2) throws IOException {
            this.continuation.length = this.continuation.left = n;
            this.continuation.padding = s2;
            this.continuation.flags = by;
            this.continuation.streamId = n2;
            this.hpackReader.readHeaders();
            return this.hpackReader.getAndResetHeaderList();
        }

        private void readData(FrameReader.Handler handler, int n, byte by, int n2) throws IOException {
            boolean bl;
            boolean bl2 = (by & 1) != 0;
            boolean bl3 = bl = (by & 0x20) != 0;
            if (bl) {
                throw Http2.ioException("PROTOCOL_ERROR: FLAG_COMPRESSED without SETTINGS_COMPRESS_DATA", new Object[0]);
            }
            short s2 = (by & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
            n = Http2.lengthWithoutPadding(n, by, s2);
            handler.data(bl2, n2, this.source, n);
            this.source.skip(s2);
        }

        private void readPriority(FrameReader.Handler handler, int n, byte by, int n2) throws IOException {
            if (n != 5) {
                throw Http2.ioException("TYPE_PRIORITY length: %d != 5", new Object[]{n});
            }
            if (n2 == 0) {
                throw Http2.ioException("TYPE_PRIORITY streamId == 0", new Object[0]);
            }
            this.readPriority(handler, n2);
        }

        private void readPriority(FrameReader.Handler handler, int n) throws IOException {
            int n2 = this.source.readInt();
            boolean bl = (n2 & Integer.MIN_VALUE) != 0;
            int n3 = n2 & Integer.MAX_VALUE;
            int n4 = (this.source.readByte() & 0xFF) + 1;
            handler.priority(n, n3, n4, bl);
        }

        private void readRstStream(FrameReader.Handler handler, int n, byte by, int n2) throws IOException {
            if (n != 4) {
                throw Http2.ioException("TYPE_RST_STREAM length: %d != 4", new Object[]{n});
            }
            if (n2 == 0) {
                throw Http2.ioException("TYPE_RST_STREAM streamId == 0", new Object[0]);
            }
            int n3 = this.source.readInt();
            ErrorCode errorCode = ErrorCode.fromHttp2(n3);
            if (errorCode == null) {
                throw Http2.ioException("TYPE_RST_STREAM unexpected error code: %d", new Object[]{n3});
            }
            handler.rstStream(n2, errorCode);
        }

        private void readSettings(FrameReader.Handler handler, int n, byte by, int n2) throws IOException {
            if (n2 != 0) {
                throw Http2.ioException("TYPE_SETTINGS streamId != 0", new Object[0]);
            }
            if ((by & 1) != 0) {
                if (n != 0) {
                    throw Http2.ioException("FRAME_SIZE_ERROR ack frame should be empty!", new Object[0]);
                }
                handler.ackSettings();
                return;
            }
            if (n % 6 != 0) {
                throw Http2.ioException("TYPE_SETTINGS length %% 6 != 0: %s", new Object[]{n});
            }
            Settings settings = new Settings();
            for (int i = 0; i < n; i += 6) {
                short s2 = this.source.readShort();
                int n3 = this.source.readInt();
                switch (s2) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (n3 == 0 || n3 == 1) break;
                        throw Http2.ioException("PROTOCOL_ERROR SETTINGS_ENABLE_PUSH != 0 or 1", new Object[0]);
                    }
                    case 3: {
                        s2 = 4;
                        break;
                    }
                    case 4: {
                        s2 = 7;
                        if (n3 >= 0) break;
                        throw Http2.ioException("PROTOCOL_ERROR SETTINGS_INITIAL_WINDOW_SIZE > 2^31 - 1", new Object[0]);
                    }
                    case 5: {
                        if (n3 >= 16384 && n3 <= 0xFFFFFF) break;
                        throw Http2.ioException("PROTOCOL_ERROR SETTINGS_MAX_FRAME_SIZE: %s", new Object[]{n3});
                    }
                    case 6: {
                        break;
                    }
                    default: {
                        throw Http2.ioException("PROTOCOL_ERROR invalid settings id: %s", new Object[]{s2});
                    }
                }
                settings.set(s2, 0, n3);
            }
            handler.settings(false, settings);
            if (settings.getHeaderTableSize() >= 0) {
                this.hpackReader.headerTableSizeSetting(settings.getHeaderTableSize());
            }
        }

        private void readPushPromise(FrameReader.Handler handler, int n, byte by, int n2) throws IOException {
            if (n2 == 0) {
                throw Http2.ioException("PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0", new Object[0]);
            }
            short s2 = (by & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
            int n3 = this.source.readInt() & Integer.MAX_VALUE;
            n -= 4;
            n = Http2.lengthWithoutPadding(n, by, s2);
            List<Header> list = this.readHeaderBlock(n, s2, by, n2);
            handler.pushPromise(n2, n3, list);
        }

        private void readPing(FrameReader.Handler handler, int n, byte by, int n2) throws IOException {
            if (n != 8) {
                throw Http2.ioException("TYPE_PING length != 8: %s", new Object[]{n});
            }
            if (n2 != 0) {
                throw Http2.ioException("TYPE_PING streamId != 0", new Object[0]);
            }
            int n3 = this.source.readInt();
            int n4 = this.source.readInt();
            boolean bl = (by & 1) != 0;
            handler.ping(bl, n3, n4);
        }

        private void readGoAway(FrameReader.Handler handler, int n, byte by, int n2) throws IOException {
            if (n < 8) {
                throw Http2.ioException("TYPE_GOAWAY length < 8: %s", new Object[]{n});
            }
            if (n2 != 0) {
                throw Http2.ioException("TYPE_GOAWAY streamId != 0", new Object[0]);
            }
            int n3 = this.source.readInt();
            int n4 = this.source.readInt();
            int n5 = n - 8;
            ErrorCode errorCode = ErrorCode.fromHttp2(n4);
            if (errorCode == null) {
                throw Http2.ioException("TYPE_GOAWAY unexpected error code: %d", new Object[]{n4});
            }
            ByteString byteString = ByteString.EMPTY;
            if (n5 > 0) {
                byteString = this.source.readByteString(n5);
            }
            handler.goAway(n3, errorCode, byteString);
        }

        private void readWindowUpdate(FrameReader.Handler handler, int n, byte by, int n2) throws IOException {
            if (n != 4) {
                throw Http2.ioException("TYPE_WINDOW_UPDATE length !=4: %s", new Object[]{n});
            }
            long l = (long)this.source.readInt() & Integer.MAX_VALUE;
            if (l == 0L) {
                throw Http2.ioException("windowSizeIncrement was 0", new Object[]{l});
            }
            handler.windowUpdate(n2, l);
        }

        @Override
        public void close() throws IOException {
            this.source.close();
        }
    }
}

