/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.framed;

import com.squareup.okhttp.internal.framed.Header;
import com.squareup.okhttp.internal.framed.Huffman;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Source;

final class Hpack {
    private static final int PREFIX_4_BITS = 15;
    private static final int PREFIX_5_BITS = 31;
    private static final int PREFIX_6_BITS = 63;
    private static final int PREFIX_7_BITS = 127;
    private static final Header[] STATIC_HEADER_TABLE = new Header[]{new Header(Header.TARGET_AUTHORITY, ""), new Header(Header.TARGET_METHOD, "GET"), new Header(Header.TARGET_METHOD, "POST"), new Header(Header.TARGET_PATH, "/"), new Header(Header.TARGET_PATH, "/index.html"), new Header(Header.TARGET_SCHEME, "http"), new Header(Header.TARGET_SCHEME, "https"), new Header(Header.RESPONSE_STATUS, "200"), new Header(Header.RESPONSE_STATUS, "204"), new Header(Header.RESPONSE_STATUS, "206"), new Header(Header.RESPONSE_STATUS, "304"), new Header(Header.RESPONSE_STATUS, "400"), new Header(Header.RESPONSE_STATUS, "404"), new Header(Header.RESPONSE_STATUS, "500"), new Header("accept-charset", ""), new Header("accept-encoding", "gzip, deflate"), new Header("accept-language", ""), new Header("accept-ranges", ""), new Header("accept", ""), new Header("access-control-allow-origin", ""), new Header("age", ""), new Header("allow", ""), new Header("authorization", ""), new Header("cache-control", ""), new Header("content-disposition", ""), new Header("content-encoding", ""), new Header("content-language", ""), new Header("content-length", ""), new Header("content-location", ""), new Header("content-range", ""), new Header("content-type", ""), new Header("cookie", ""), new Header("date", ""), new Header("etag", ""), new Header("expect", ""), new Header("expires", ""), new Header("from", ""), new Header("host", ""), new Header("if-match", ""), new Header("if-modified-since", ""), new Header("if-none-match", ""), new Header("if-range", ""), new Header("if-unmodified-since", ""), new Header("last-modified", ""), new Header("link", ""), new Header("location", ""), new Header("max-forwards", ""), new Header("proxy-authenticate", ""), new Header("proxy-authorization", ""), new Header("range", ""), new Header("referer", ""), new Header("refresh", ""), new Header("retry-after", ""), new Header("server", ""), new Header("set-cookie", ""), new Header("strict-transport-security", ""), new Header("transfer-encoding", ""), new Header("user-agent", ""), new Header("vary", ""), new Header("via", ""), new Header("www-authenticate", "")};
    private static final Map<ByteString, Integer> NAME_TO_FIRST_INDEX = Hpack.nameToFirstIndex();

    private Hpack() {
    }

    private static Map<ByteString, Integer> nameToFirstIndex() {
        LinkedHashMap<ByteString, Integer> linkedHashMap = new LinkedHashMap<ByteString, Integer>(STATIC_HEADER_TABLE.length);
        for (int i = 0; i < STATIC_HEADER_TABLE.length; ++i) {
            if (linkedHashMap.containsKey(Hpack.STATIC_HEADER_TABLE[i].name)) continue;
            linkedHashMap.put(Hpack.STATIC_HEADER_TABLE[i].name, i);
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    private static ByteString checkLowercase(ByteString byteString) throws IOException {
        int n = byteString.size();
        for (int i = 0; i < n; ++i) {
            byte by = byteString.getByte(i);
            if (by < 65 || by > 90) continue;
            throw new IOException("PROTOCOL_ERROR response malformed: mixed case name: " + byteString.utf8());
        }
        return byteString;
    }

    static final class Writer {
        private final Buffer out;

        Writer(Buffer buffer) {
            this.out = buffer;
        }

        void writeHeaders(List<Header> list) throws IOException {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                ByteString byteString = list.get((int)i).name.toAsciiLowercase();
                Integer n2 = (Integer)NAME_TO_FIRST_INDEX.get(byteString);
                if (n2 != null) {
                    this.writeInt(n2 + 1, 15, 0);
                    this.writeByteString(list.get((int)i).value);
                    continue;
                }
                this.out.writeByte(0);
                this.writeByteString(byteString);
                this.writeByteString(list.get((int)i).value);
            }
        }

        void writeInt(int n, int n2, int n3) throws IOException {
            if (n < n2) {
                this.out.writeByte(n3 | n);
                return;
            }
            this.out.writeByte(n3 | n2);
            n -= n2;
            while (n >= 128) {
                int n4 = n & 0x7F;
                this.out.writeByte(n4 | 0x80);
                n >>>= 7;
            }
            this.out.writeByte(n);
        }

        void writeByteString(ByteString byteString) throws IOException {
            this.writeInt(byteString.size(), 127, 0);
            this.out.write(byteString);
        }
    }

    static final class Reader {
        private final List<Header> headerList = new ArrayList<Header>();
        private final BufferedSource source;
        private int headerTableSizeSetting;
        private int maxDynamicTableByteCount;
        Header[] dynamicTable = new Header[8];
        int nextHeaderIndex = this.dynamicTable.length - 1;
        int headerCount = 0;
        int dynamicTableByteCount = 0;

        Reader(int n, Source source2) {
            this.headerTableSizeSetting = n;
            this.maxDynamicTableByteCount = n;
            this.source = Okio.buffer(source2);
        }

        int maxDynamicTableByteCount() {
            return this.maxDynamicTableByteCount;
        }

        void headerTableSizeSetting(int n) {
            this.headerTableSizeSetting = n;
            this.maxDynamicTableByteCount = n;
            this.adjustDynamicTableByteCount();
        }

        private void adjustDynamicTableByteCount() {
            if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
                if (this.maxDynamicTableByteCount == 0) {
                    this.clearDynamicTable();
                } else {
                    this.evictToRecoverBytes(this.dynamicTableByteCount - this.maxDynamicTableByteCount);
                }
            }
        }

        private void clearDynamicTable() {
            this.headerList.clear();
            Arrays.fill(this.dynamicTable, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        private int evictToRecoverBytes(int n) {
            int n2 = 0;
            if (n > 0) {
                for (int i = this.dynamicTable.length - 1; i >= this.nextHeaderIndex && n > 0; --i) {
                    n -= this.dynamicTable[i].hpackSize;
                    this.dynamicTableByteCount -= this.dynamicTable[i].hpackSize;
                    --this.headerCount;
                    ++n2;
                }
                System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + n2, this.headerCount);
                this.nextHeaderIndex += n2;
            }
            return n2;
        }

        void readHeaders() throws IOException {
            while (!this.source.exhausted()) {
                int n;
                int n2 = this.source.readByte() & 0xFF;
                if (n2 == 128) {
                    throw new IOException("index == 0");
                }
                if ((n2 & 0x80) == 128) {
                    n = this.readInt(n2, 127);
                    this.readIndexedHeader(n - 1);
                    continue;
                }
                if (n2 == 64) {
                    this.readLiteralHeaderWithIncrementalIndexingNewName();
                    continue;
                }
                if ((n2 & 0x40) == 64) {
                    n = this.readInt(n2, 63);
                    this.readLiteralHeaderWithIncrementalIndexingIndexedName(n - 1);
                    continue;
                }
                if ((n2 & 0x20) == 32) {
                    this.maxDynamicTableByteCount = this.readInt(n2, 31);
                    if (this.maxDynamicTableByteCount < 0 || this.maxDynamicTableByteCount > this.headerTableSizeSetting) {
                        throw new IOException("Invalid dynamic table size update " + this.maxDynamicTableByteCount);
                    }
                    this.adjustDynamicTableByteCount();
                    continue;
                }
                if (n2 == 16 || n2 == 0) {
                    this.readLiteralHeaderWithoutIndexingNewName();
                    continue;
                }
                n = this.readInt(n2, 15);
                this.readLiteralHeaderWithoutIndexingIndexedName(n - 1);
            }
        }

        public List<Header> getAndResetHeaderList() {
            ArrayList<Header> arrayList = new ArrayList<Header>(this.headerList);
            this.headerList.clear();
            return arrayList;
        }

        private void readIndexedHeader(int n) throws IOException {
            if (this.isStaticHeader(n)) {
                Header header = STATIC_HEADER_TABLE[n];
                this.headerList.add(header);
            } else {
                int n2 = this.dynamicTableIndex(n - STATIC_HEADER_TABLE.length);
                if (n2 < 0 || n2 > this.dynamicTable.length - 1) {
                    throw new IOException("Header index too large " + (n + 1));
                }
                this.headerList.add(this.dynamicTable[n2]);
            }
        }

        private int dynamicTableIndex(int n) {
            return this.nextHeaderIndex + 1 + n;
        }

        private void readLiteralHeaderWithoutIndexingIndexedName(int n) throws IOException {
            ByteString byteString = this.getName(n);
            ByteString byteString2 = this.readByteString();
            this.headerList.add(new Header(byteString, byteString2));
        }

        private void readLiteralHeaderWithoutIndexingNewName() throws IOException {
            ByteString byteString = Hpack.checkLowercase(this.readByteString());
            ByteString byteString2 = this.readByteString();
            this.headerList.add(new Header(byteString, byteString2));
        }

        private void readLiteralHeaderWithIncrementalIndexingIndexedName(int n) throws IOException {
            ByteString byteString = this.getName(n);
            ByteString byteString2 = this.readByteString();
            this.insertIntoDynamicTable(-1, new Header(byteString, byteString2));
        }

        private void readLiteralHeaderWithIncrementalIndexingNewName() throws IOException {
            ByteString byteString = Hpack.checkLowercase(this.readByteString());
            ByteString byteString2 = this.readByteString();
            this.insertIntoDynamicTable(-1, new Header(byteString, byteString2));
        }

        private ByteString getName(int n) {
            if (this.isStaticHeader(n)) {
                return STATIC_HEADER_TABLE[n].name;
            }
            return this.dynamicTable[this.dynamicTableIndex((int)(n - STATIC_HEADER_TABLE.length))].name;
        }

        private boolean isStaticHeader(int n) {
            return n >= 0 && n <= STATIC_HEADER_TABLE.length - 1;
        }

        private void insertIntoDynamicTable(int n, Header header) {
            this.headerList.add(header);
            int n2 = header.hpackSize;
            if (n != -1) {
                n2 -= this.dynamicTable[this.dynamicTableIndex((int)n)].hpackSize;
            }
            if (n2 > this.maxDynamicTableByteCount) {
                this.clearDynamicTable();
                return;
            }
            int n3 = this.dynamicTableByteCount + n2 - this.maxDynamicTableByteCount;
            int n4 = this.evictToRecoverBytes(n3);
            if (n == -1) {
                if (this.headerCount + 1 > this.dynamicTable.length) {
                    Header[] headerArray = new Header[this.dynamicTable.length * 2];
                    System.arraycopy(this.dynamicTable, 0, headerArray, this.dynamicTable.length, this.dynamicTable.length);
                    this.nextHeaderIndex = this.dynamicTable.length - 1;
                    this.dynamicTable = headerArray;
                }
                n = this.nextHeaderIndex--;
                this.dynamicTable[n] = header;
                ++this.headerCount;
            } else {
                n += this.dynamicTableIndex(n) + n4;
                this.dynamicTable[n] = header;
            }
            this.dynamicTableByteCount += n2;
        }

        private int readByte() throws IOException {
            return this.source.readByte() & 0xFF;
        }

        int readInt(int n, int n2) throws IOException {
            int n3;
            int n4 = n & n2;
            if (n4 < n2) {
                return n4;
            }
            int n5 = n2;
            int n6 = 0;
            while (((n3 = this.readByte()) & 0x80) != 0) {
                n5 += (n3 & 0x7F) << n6;
                n6 += 7;
            }
            return n5 += n3 << n6;
        }

        ByteString readByteString() throws IOException {
            int n = this.readByte();
            boolean bl = (n & 0x80) == 128;
            int n2 = this.readInt(n, 127);
            if (bl) {
                return ByteString.of(Huffman.get().decode(this.source.readByteArray(n2)));
            }
            return this.source.readByteString(n2);
        }
    }
}

