/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal;

import android.util.Log;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.OptionalMethod;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.tls.AndroidTrustRootIndex;
import com.squareup.okhttp.internal.tls.RealTrustRootIndex;
import com.squareup.okhttp.internal.tls.TrustRootIndex;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okio.Buffer;

public class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();

    public static Platform get() {
        return PLATFORM;
    }

    public String getPrefix() {
        return "OkHttp";
    }

    public void logW(String string) {
        System.out.println(string);
    }

    public void tagSocket(Socket socket) throws SocketException {
    }

    public void untagSocket(Socket socket) throws SocketException {
    }

    public X509TrustManager trustManager(SSLSocketFactory sSLSocketFactory) {
        return null;
    }

    public TrustRootIndex trustRootIndex(X509TrustManager x509TrustManager) {
        return new RealTrustRootIndex(x509TrustManager.getAcceptedIssuers());
    }

    public void configureTlsExtensions(SSLSocket sSLSocket, String string, List<Protocol> list) {
    }

    public void afterHandshake(SSLSocket sSLSocket) {
    }

    public String getSelectedProtocol(SSLSocket sSLSocket) {
        return null;
    }

    public void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n) throws IOException {
        socket.connect(inetSocketAddress, n);
    }

    public void log(String string) {
        System.out.println(string);
    }

    private static Platform findPlatform() {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName("org.apache.harmony.xnet.provider.jsse.SSLParametersImpl");
            }
            OptionalMethod<Socket> optionalMethod = new OptionalMethod<Socket>(null, "setUseSessionTickets", Boolean.TYPE);
            OptionalMethod<Socket> optionalMethod2 = new OptionalMethod<Socket>(null, "setHostname", String.class);
            Method method = null;
            Method method2 = null;
            OptionalMethod optionalMethod3 = null;
            OptionalMethod optionalMethod4 = null;
            try {
                Class<?> clazz2 = Class.forName("android.net.TrafficStats");
                method = clazz2.getMethod("tagSocket", Socket.class);
                method2 = clazz2.getMethod("untagSocket", Socket.class);
                try {
                    Class.forName("android.net.Network");
                    optionalMethod3 = new OptionalMethod(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
                    optionalMethod4 = new OptionalMethod(null, "setAlpnProtocols", byte[].class);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
            return new Android(clazz, optionalMethod, optionalMethod2, method, method2, optionalMethod3, optionalMethod4);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class<?> clazz = Class.forName("sun.security.ssl.SSLContextImpl");
                try {
                    String string = "org.eclipse.jetty.alpn.ALPN";
                    Class<?> clazz3 = Class.forName(string);
                    Class<?> clazz4 = Class.forName(string + "$Provider");
                    Class<?> clazz5 = Class.forName(string + "$ClientProvider");
                    Class<?> clazz6 = Class.forName(string + "$ServerProvider");
                    Method method = clazz3.getMethod("put", SSLSocket.class, clazz4);
                    Method method3 = clazz3.getMethod("get", SSLSocket.class);
                    Method method4 = clazz3.getMethod("remove", SSLSocket.class);
                    return new JdkWithJettyBootPlatform(clazz, method, method3, method4, clazz5, clazz6);
                }
                catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                    return new JdkPlatform(clazz);
                }
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return new Platform();
            }
        }
    }

    static byte[] concatLengthPrefixed(List<Protocol> list) {
        Buffer buffer = new Buffer();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Protocol protocol = list.get(i);
            if (protocol == Protocol.HTTP_1_0) continue;
            buffer.writeByte(protocol.toString().length());
            buffer.writeUtf8(protocol.toString());
        }
        return buffer.readByteArray();
    }

    static <T> T readFieldOrNull(Object object, Class<T> clazz, String string) {
        Object object2;
        for (object2 = object.getClass(); object2 != Object.class; object2 = ((Class)object2).getSuperclass()) {
            try {
                Field field = ((Class)object2).getDeclaredField(string);
                field.setAccessible(true);
                Object object3 = field.get(object);
                if (object3 == null || !clazz.isInstance(object3)) {
                    return null;
                }
                return clazz.cast(object3);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
        }
        if (!string.equals("delegate") && (object2 = Platform.readFieldOrNull(object, Object.class, "delegate")) != null) {
            return Platform.readFieldOrNull(object2, clazz, string);
        }
        return null;
    }

    private static class JettyNegoProvider
    implements InvocationHandler {
        private final List<String> protocols;
        private boolean unsupported;
        private String selected;

        public JettyNegoProvider(List<String> list) {
            this.protocols = list;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            Class<?> clazz = method.getReturnType();
            if (objectArray == null) {
                objectArray = Util.EMPTY_STRING_ARRAY;
            }
            if (string.equals("supports") && Boolean.TYPE == clazz) {
                return true;
            }
            if (string.equals("unsupported") && Void.TYPE == clazz) {
                this.unsupported = true;
                return null;
            }
            if (string.equals("protocols") && objectArray.length == 0) {
                return this.protocols;
            }
            if ((string.equals("selectProtocol") || string.equals("select")) && String.class == clazz && objectArray.length == 1 && objectArray[0] instanceof List) {
                List list = (List)objectArray[0];
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    if (!this.protocols.contains(list.get(i))) continue;
                    this.selected = (String)list.get(i);
                    return this.selected;
                }
                this.selected = this.protocols.get(0);
                return this.selected;
            }
            if ((string.equals("protocolSelected") || string.equals("selected")) && objectArray.length == 1) {
                this.selected = (String)objectArray[0];
                return null;
            }
            return method.invoke((Object)this, objectArray);
        }
    }

    private static class JdkWithJettyBootPlatform
    extends JdkPlatform {
        private final Method putMethod;
        private final Method getMethod;
        private final Method removeMethod;
        private final Class<?> clientProviderClass;
        private final Class<?> serverProviderClass;

        public JdkWithJettyBootPlatform(Class<?> clazz, Method method, Method method2, Method method3, Class<?> clazz2, Class<?> clazz3) {
            super(clazz);
            this.putMethod = method;
            this.getMethod = method2;
            this.removeMethod = method3;
            this.clientProviderClass = clazz2;
            this.serverProviderClass = clazz3;
        }

        @Override
        public void configureTlsExtensions(SSLSocket sSLSocket, String string, List<Protocol> list) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Protocol protocol = list.get(i);
                if (protocol == Protocol.HTTP_1_0) continue;
                arrayList.add(protocol.toString());
            }
            try {
                Object object = Proxy.newProxyInstance(Platform.class.getClassLoader(), new Class[]{this.clientProviderClass, this.serverProviderClass}, (InvocationHandler)new JettyNegoProvider(arrayList));
                this.putMethod.invoke(null, sSLSocket, object);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                throw new AssertionError((Object)reflectiveOperationException);
            }
        }

        @Override
        public void afterHandshake(SSLSocket sSLSocket) {
            try {
                this.removeMethod.invoke(null, sSLSocket);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                throw new AssertionError();
            }
        }

        @Override
        public String getSelectedProtocol(SSLSocket sSLSocket) {
            try {
                JettyNegoProvider jettyNegoProvider = (JettyNegoProvider)Proxy.getInvocationHandler(this.getMethod.invoke(null, sSLSocket));
                if (!jettyNegoProvider.unsupported && jettyNegoProvider.selected == null) {
                    Internal.logger.log(Level.INFO, "ALPN callback dropped: SPDY and HTTP/2 are disabled. Is alpn-boot on the boot class path?");
                    return null;
                }
                return jettyNegoProvider.unsupported ? null : jettyNegoProvider.selected;
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                throw new AssertionError();
            }
        }
    }

    private static class JdkPlatform
    extends Platform {
        private final Class<?> sslContextClass;

        public JdkPlatform(Class<?> clazz) {
            this.sslContextClass = clazz;
        }

        @Override
        public X509TrustManager trustManager(SSLSocketFactory sSLSocketFactory) {
            Object obj = JdkPlatform.readFieldOrNull(sSLSocketFactory, this.sslContextClass, "context");
            if (obj == null) {
                return null;
            }
            return JdkPlatform.readFieldOrNull(obj, X509TrustManager.class, "trustManager");
        }
    }

    private static class Android
    extends Platform {
        private static final int MAX_LOG_LENGTH = 4000;
        private final Class<?> sslParametersClass;
        private final OptionalMethod<Socket> setUseSessionTickets;
        private final OptionalMethod<Socket> setHostname;
        private final Method trafficStatsTagSocket;
        private final Method trafficStatsUntagSocket;
        private final OptionalMethod<Socket> getAlpnSelectedProtocol;
        private final OptionalMethod<Socket> setAlpnProtocols;

        public Android(Class<?> clazz, OptionalMethod<Socket> optionalMethod, OptionalMethod<Socket> optionalMethod2, Method method, Method method2, OptionalMethod<Socket> optionalMethod3, OptionalMethod<Socket> optionalMethod4) {
            this.sslParametersClass = clazz;
            this.setUseSessionTickets = optionalMethod;
            this.setHostname = optionalMethod2;
            this.trafficStatsTagSocket = method;
            this.trafficStatsUntagSocket = method2;
            this.getAlpnSelectedProtocol = optionalMethod3;
            this.setAlpnProtocols = optionalMethod4;
        }

        @Override
        public void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n) throws IOException {
            try {
                socket.connect(inetSocketAddress, n);
            }
            catch (AssertionError assertionError) {
                if (Util.isAndroidGetsocknameError(assertionError)) {
                    throw new IOException((Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            catch (SecurityException securityException) {
                IOException iOException = new IOException("Exception in connect");
                iOException.initCause(securityException);
                throw iOException;
            }
        }

        @Override
        public X509TrustManager trustManager(SSLSocketFactory sSLSocketFactory) {
            Object object;
            Object object2 = Android.readFieldOrNull(sSLSocketFactory, this.sslParametersClass, "sslParameters");
            if (object2 == null) {
                try {
                    object = Class.forName("com.google.android.gms.org.conscrypt.SSLParametersImpl", false, sSLSocketFactory.getClass().getClassLoader());
                    object2 = Android.readFieldOrNull(sSLSocketFactory, object, "sslParameters");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
            if ((object = Android.readFieldOrNull(object2, X509TrustManager.class, "x509TrustManager")) != null) {
                return object;
            }
            return Android.readFieldOrNull(object2, X509TrustManager.class, "trustManager");
        }

        @Override
        public TrustRootIndex trustRootIndex(X509TrustManager x509TrustManager) {
            TrustRootIndex trustRootIndex = AndroidTrustRootIndex.get(x509TrustManager);
            if (trustRootIndex != null) {
                return trustRootIndex;
            }
            return super.trustRootIndex(x509TrustManager);
        }

        @Override
        public void configureTlsExtensions(SSLSocket sSLSocket, String string, List<Protocol> list) {
            if (string != null) {
                this.setUseSessionTickets.invokeOptionalWithoutCheckedException(sSLSocket, true);
                this.setHostname.invokeOptionalWithoutCheckedException(sSLSocket, string);
            }
            if (this.setAlpnProtocols != null && this.setAlpnProtocols.isSupported(sSLSocket)) {
                Object[] objectArray = new Object[]{Android.concatLengthPrefixed(list)};
                this.setAlpnProtocols.invokeWithoutCheckedException(sSLSocket, objectArray);
            }
        }

        @Override
        public String getSelectedProtocol(SSLSocket sSLSocket) {
            if (this.getAlpnSelectedProtocol == null) {
                return null;
            }
            if (!this.getAlpnSelectedProtocol.isSupported(sSLSocket)) {
                return null;
            }
            byte[] byArray = (byte[])this.getAlpnSelectedProtocol.invokeWithoutCheckedException(sSLSocket, new Object[0]);
            return byArray != null ? new String(byArray, Util.UTF_8) : null;
        }

        @Override
        public void tagSocket(Socket socket) throws SocketException {
            if (this.trafficStatsTagSocket == null) {
                return;
            }
            try {
                this.trafficStatsTagSocket.invoke(null, socket);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getCause());
            }
        }

        @Override
        public void untagSocket(Socket socket) throws SocketException {
            if (this.trafficStatsUntagSocket == null) {
                return;
            }
            try {
                this.trafficStatsUntagSocket.invoke(null, socket);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getCause());
            }
        }

        @Override
        public void log(String string) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3 = string.indexOf(10, i);
                n3 = n3 != -1 ? n3 : n;
                do {
                    n2 = Math.min(n3, i + 4000);
                    Log.d((String)"OkHttp", (String)string.substring(i, n2));
                } while ((i = n2) < n3);
            }
        }
    }
}

