/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.internal.Util;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import okio.BufferedSink;
import okio.ByteString;
import okio.Okio;
import okio.Source;

public abstract class RequestBody {
    public abstract MediaType contentType();

    public long contentLength() throws IOException {
        return -1L;
    }

    public abstract void writeTo(BufferedSink var1) throws IOException;

    public static RequestBody create(MediaType mediaType, String string) {
        Charset charset = Util.UTF_8;
        if (mediaType != null && (charset = mediaType.charset()) == null) {
            charset = Util.UTF_8;
            mediaType = MediaType.parse(mediaType + "; charset=utf-8");
        }
        byte[] byArray = string.getBytes(charset);
        return RequestBody.create(mediaType, byArray);
    }

    public static RequestBody create(final MediaType mediaType, final ByteString byteString) {
        return new RequestBody(){

            @Override
            public MediaType contentType() {
                return mediaType;
            }

            @Override
            public long contentLength() throws IOException {
                return byteString.size();
            }

            @Override
            public void writeTo(BufferedSink bufferedSink) throws IOException {
                bufferedSink.write(byteString);
            }
        };
    }

    public static RequestBody create(MediaType mediaType, byte[] byArray) {
        return RequestBody.create(mediaType, byArray, 0, byArray.length);
    }

    public static RequestBody create(final MediaType mediaType, final byte[] byArray, final int n, final int n2) {
        if (byArray == null) {
            throw new NullPointerException("content == null");
        }
        Util.checkOffsetAndCount(byArray.length, n, n2);
        return new RequestBody(){

            @Override
            public MediaType contentType() {
                return mediaType;
            }

            @Override
            public long contentLength() {
                return n2;
            }

            @Override
            public void writeTo(BufferedSink bufferedSink) throws IOException {
                bufferedSink.write(byArray, n, n2);
            }
        };
    }

    public static RequestBody create(final MediaType mediaType, final File file) {
        if (file == null) {
            throw new NullPointerException("content == null");
        }
        return new RequestBody(){

            @Override
            public MediaType contentType() {
                return mediaType;
            }

            @Override
            public long contentLength() {
                return file.length();
            }

            @Override
            public void writeTo(BufferedSink bufferedSink) throws IOException {
                Source source2 = null;
                try {
                    source2 = Okio.source(file);
                    bufferedSink.writeAll(source2);
                }
                finally {
                    Util.closeQuietly(source2);
                }
            }
        };
    }
}

