/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.CacheControl;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.internal.http.HttpMethod;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;

public final class Request {
    private final HttpUrl url;
    private final String method;
    private final Headers headers;
    private final RequestBody body;
    private final Object tag;
    private volatile URL javaNetUrl;
    private volatile URI javaNetUri;
    private volatile CacheControl cacheControl;

    private Request(Builder builder) {
        this.url = builder.url;
        this.method = builder.method;
        this.headers = builder.headers.build();
        this.body = builder.body;
        this.tag = builder.tag != null ? builder.tag : this;
    }

    public HttpUrl httpUrl() {
        return this.url;
    }

    public URL url() {
        URL uRL = this.javaNetUrl;
        return uRL != null ? uRL : (this.javaNetUrl = this.url.url());
    }

    public URI uri() throws IOException {
        try {
            URI uRI = this.javaNetUri;
            return uRI != null ? uRI : (this.javaNetUri = this.url.uri());
        }
        catch (IllegalStateException illegalStateException) {
            throw new IOException(illegalStateException.getMessage());
        }
    }

    public String urlString() {
        return this.url.toString();
    }

    public String method() {
        return this.method;
    }

    public Headers headers() {
        return this.headers;
    }

    public String header(String string) {
        return this.headers.get(string);
    }

    public List<String> headers(String string) {
        return this.headers.values(string);
    }

    public RequestBody body() {
        return this.body;
    }

    public Object tag() {
        return this.tag;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public CacheControl cacheControl() {
        CacheControl cacheControl = this.cacheControl;
        return cacheControl != null ? cacheControl : (this.cacheControl = CacheControl.parse(this.headers));
    }

    public boolean isHttps() {
        return this.url.isHttps();
    }

    public String toString() {
        return "Request{method=" + this.method + ", url=" + this.url + ", tag=" + (this.tag != this ? this.tag : null) + '}';
    }

    public static class Builder {
        private HttpUrl url;
        private String method;
        private Headers.Builder headers;
        private RequestBody body;
        private Object tag;

        public Builder() {
            this.method = "GET";
            this.headers = new Headers.Builder();
        }

        private Builder(Request request) {
            this.url = request.url;
            this.method = request.method;
            this.body = request.body;
            this.tag = request.tag;
            this.headers = request.headers.newBuilder();
        }

        public Builder url(HttpUrl httpUrl) {
            if (httpUrl == null) {
                throw new IllegalArgumentException("url == null");
            }
            this.url = httpUrl;
            return this;
        }

        public Builder url(String string) {
            if (string == null) {
                throw new IllegalArgumentException("url == null");
            }
            if (string.regionMatches(true, 0, "ws:", 0, 3)) {
                string = "http:" + string.substring(3);
            } else if (string.regionMatches(true, 0, "wss:", 0, 4)) {
                string = "https:" + string.substring(4);
            }
            HttpUrl httpUrl = HttpUrl.parse(string);
            if (httpUrl == null) {
                throw new IllegalArgumentException("unexpected url: " + string);
            }
            return this.url(httpUrl);
        }

        public Builder url(URL uRL) {
            if (uRL == null) {
                throw new IllegalArgumentException("url == null");
            }
            HttpUrl httpUrl = HttpUrl.get(uRL);
            if (httpUrl == null) {
                throw new IllegalArgumentException("unexpected url: " + uRL);
            }
            return this.url(httpUrl);
        }

        public Builder header(String string, String string2) {
            this.headers.set(string, string2);
            return this;
        }

        public Builder addHeader(String string, String string2) {
            this.headers.add(string, string2);
            return this;
        }

        public Builder removeHeader(String string) {
            this.headers.removeAll(string);
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers.newBuilder();
            return this;
        }

        public Builder cacheControl(CacheControl cacheControl) {
            String string = cacheControl.toString();
            if (string.isEmpty()) {
                return this.removeHeader("Cache-Control");
            }
            return this.header("Cache-Control", string);
        }

        public Builder get() {
            return this.method("GET", null);
        }

        public Builder head() {
            return this.method("HEAD", null);
        }

        public Builder post(RequestBody requestBody) {
            return this.method("POST", requestBody);
        }

        public Builder delete(RequestBody requestBody) {
            return this.method("DELETE", requestBody);
        }

        public Builder delete() {
            return this.delete(RequestBody.create(null, new byte[0]));
        }

        public Builder put(RequestBody requestBody) {
            return this.method("PUT", requestBody);
        }

        public Builder patch(RequestBody requestBody) {
            return this.method("PATCH", requestBody);
        }

        public Builder method(String string, RequestBody requestBody) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("method == null || method.length() == 0");
            }
            if (requestBody != null && !HttpMethod.permitsRequestBody(string)) {
                throw new IllegalArgumentException("method " + string + " must not have a request body.");
            }
            if (requestBody == null && HttpMethod.requiresRequestBody(string)) {
                throw new IllegalArgumentException("method " + string + " must have a request body.");
            }
            this.method = string;
            this.body = requestBody;
            return this;
        }

        public Builder tag(Object object) {
            this.tag = object;
            return this;
        }

        public Request build() {
            if (this.url == null) {
                throw new IllegalStateException("url == null");
            }
            return new Request(this);
        }
    }
}

