/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.internal.http.HttpDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class Headers {
    private final String[] namesAndValues;

    private Headers(Builder builder) {
        this.namesAndValues = builder.namesAndValues.toArray(new String[builder.namesAndValues.size()]);
    }

    private Headers(String[] stringArray) {
        this.namesAndValues = stringArray;
    }

    public String get(String string) {
        return Headers.get(this.namesAndValues, string);
    }

    public Date getDate(String string) {
        String string2 = this.get(string);
        return string2 != null ? HttpDate.parse(string2) : null;
    }

    public int size() {
        return this.namesAndValues.length / 2;
    }

    public String name(int n) {
        int n2 = n * 2;
        if (n2 < 0 || n2 >= this.namesAndValues.length) {
            return null;
        }
        return this.namesAndValues[n2];
    }

    public String value(int n) {
        int n2 = n * 2 + 1;
        if (n2 < 0 || n2 >= this.namesAndValues.length) {
            return null;
        }
        return this.namesAndValues[n2];
    }

    public Set<String> names() {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            treeSet.add(this.name(i));
        }
        return Collections.unmodifiableSet(treeSet);
    }

    public List<String> values(String string) {
        ArrayList<String> arrayList = null;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equalsIgnoreCase(this.name(i))) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>(2);
            }
            arrayList.add(this.value(i));
        }
        return arrayList != null ? Collections.unmodifiableList(arrayList) : Collections.emptyList();
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        Collections.addAll(builder.namesAndValues, this.namesAndValues);
        return builder;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.name(i)).append(": ").append(this.value(i)).append("\n");
        }
        return stringBuilder.toString();
    }

    public Map<String, List<String>> toMultimap() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            String string = this.name(i);
            ArrayList<String> arrayList = (ArrayList<String>)linkedHashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>(2);
                linkedHashMap.put(string, arrayList);
            }
            arrayList.add(this.value(i));
        }
        return linkedHashMap;
    }

    private static String get(String[] stringArray, String string) {
        for (int i = stringArray.length - 2; i >= 0; i -= 2) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return stringArray[i + 1];
        }
        return null;
    }

    public static Headers of(String ... stringArray) {
        int n;
        if (stringArray == null || stringArray.length % 2 != 0) {
            throw new IllegalArgumentException("Expected alternating header names and values");
        }
        stringArray = (String[])stringArray.clone();
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            stringArray[n] = stringArray[n].trim();
        }
        for (n = 0; n < stringArray.length; n += 2) {
            String string = stringArray[n];
            String string2 = stringArray[n + 1];
            if (string.length() != 0 && string.indexOf(0) == -1 && string2.indexOf(0) == -1) continue;
            throw new IllegalArgumentException("Unexpected header: " + string + ": " + string2);
        }
        return new Headers(stringArray);
    }

    public static Headers of(Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException("Expected map with header names and values");
        }
        String[] stringArray = new String[map.size() * 2];
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            String string = entry.getKey().trim();
            String string2 = entry.getValue().trim();
            if (string.length() == 0 || string.indexOf(0) != -1 || string2.indexOf(0) != -1) {
                throw new IllegalArgumentException("Unexpected header: " + string + ": " + string2);
            }
            stringArray[n] = string;
            stringArray[n + 1] = string2;
            n += 2;
        }
        return new Headers(stringArray);
    }

    public static final class Builder {
        private final List<String> namesAndValues = new ArrayList<String>(20);

        Builder addLenient(String string) {
            int n = string.indexOf(":", 1);
            if (n != -1) {
                return this.addLenient(string.substring(0, n), string.substring(n + 1));
            }
            if (string.startsWith(":")) {
                return this.addLenient("", string.substring(1));
            }
            return this.addLenient("", string);
        }

        public Builder add(String string) {
            int n = string.indexOf(":");
            if (n == -1) {
                throw new IllegalArgumentException("Unexpected header: " + string);
            }
            return this.add(string.substring(0, n).trim(), string.substring(n + 1));
        }

        public Builder add(String string, String string2) {
            this.checkNameAndValue(string, string2);
            return this.addLenient(string, string2);
        }

        Builder addLenient(String string, String string2) {
            this.namesAndValues.add(string);
            this.namesAndValues.add(string2.trim());
            return this;
        }

        public Builder removeAll(String string) {
            for (int i = 0; i < this.namesAndValues.size(); i += 2) {
                if (!string.equalsIgnoreCase(this.namesAndValues.get(i))) continue;
                this.namesAndValues.remove(i);
                this.namesAndValues.remove(i);
                i -= 2;
            }
            return this;
        }

        public Builder set(String string, String string2) {
            this.checkNameAndValue(string, string2);
            this.removeAll(string);
            this.addLenient(string, string2);
            return this;
        }

        private void checkNameAndValue(String string, String string2) {
            char c;
            int n;
            if (string == null) {
                throw new IllegalArgumentException("name == null");
            }
            if (string.isEmpty()) {
                throw new IllegalArgumentException("name is empty");
            }
            int n2 = string.length();
            for (n = 0; n < n2; ++n) {
                c = string.charAt(n);
                if (c > '\u001f' && c < '\u007f') continue;
                throw new IllegalArgumentException(String.format("Unexpected char %#04x at %d in header name: %s", c, n, string));
            }
            if (string2 == null) {
                throw new IllegalArgumentException("value == null");
            }
            n2 = string2.length();
            for (n = 0; n < n2; ++n) {
                c = string2.charAt(n);
                if (c > '\u001f' && c < '\u007f') continue;
                throw new IllegalArgumentException(String.format("Unexpected char %#04x at %d in header value: %s", c, n, string2));
            }
        }

        public String get(String string) {
            for (int i = this.namesAndValues.size() - 2; i >= 0; i -= 2) {
                if (!string.equalsIgnoreCase(this.namesAndValues.get(i))) continue;
                return this.namesAndValues.get(i + 1);
            }
            return null;
        }

        public Headers build() {
            return new Headers(this);
        }
    }
}

