/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.Address;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.RouteDatabase;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.StreamAllocation;
import com.squareup.okhttp.internal.io.RealConnection;
import java.lang.ref.Reference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ConnectionPool {
    private static final long DEFAULT_KEEP_ALIVE_DURATION_MS = 300000L;
    private static final ConnectionPool systemDefault;
    private final Executor executor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory("OkHttp ConnectionPool", true));
    private final int maxIdleConnections;
    private final long keepAliveDurationNs;
    private Runnable cleanupRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l;
            while ((l = ConnectionPool.this.cleanup(System.nanoTime())) != -1L) {
                if (l <= 0L) continue;
                long l2 = l / 1000000L;
                l -= l2 * 1000000L;
                ConnectionPool connectionPool = ConnectionPool.this;
                synchronized (connectionPool) {
                    try {
                        ConnectionPool.this.wait(l2, (int)l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return;
        }
    };
    private final Deque<RealConnection> connections = new ArrayDeque<RealConnection>();
    final RouteDatabase routeDatabase = new RouteDatabase();

    public ConnectionPool(int n, long l) {
        this(n, l, TimeUnit.MILLISECONDS);
    }

    public ConnectionPool(int n, long l, TimeUnit timeUnit) {
        this.maxIdleConnections = n;
        this.keepAliveDurationNs = timeUnit.toNanos(l);
        if (l <= 0L) {
            throw new IllegalArgumentException("keepAliveDuration <= 0: " + l);
        }
    }

    public static ConnectionPool getDefault() {
        return systemDefault;
    }

    public synchronized int getIdleConnectionCount() {
        int n = 0;
        for (RealConnection realConnection : this.connections) {
            if (!realConnection.allocations.isEmpty()) continue;
            ++n;
        }
        return n;
    }

    public synchronized int getConnectionCount() {
        return this.connections.size();
    }

    @Deprecated
    public synchronized int getSpdyConnectionCount() {
        return this.getMultiplexedConnectionCount();
    }

    public synchronized int getMultiplexedConnectionCount() {
        int n = 0;
        for (RealConnection realConnection : this.connections) {
            if (!realConnection.isMultiplexed()) continue;
            ++n;
        }
        return n;
    }

    public synchronized int getHttpConnectionCount() {
        return this.connections.size() - this.getMultiplexedConnectionCount();
    }

    RealConnection get(Address address, StreamAllocation streamAllocation) {
        assert (Thread.holdsLock(this));
        for (RealConnection realConnection : this.connections) {
            if (realConnection.allocations.size() >= realConnection.allocationLimit() || !address.equals(realConnection.getRoute().address) || realConnection.noNewStreams) continue;
            streamAllocation.acquire(realConnection);
            return realConnection;
        }
        return null;
    }

    void put(RealConnection realConnection) {
        assert (Thread.holdsLock(this));
        if (this.connections.isEmpty()) {
            this.executor.execute(this.cleanupRunnable);
        }
        this.connections.add(realConnection);
    }

    boolean connectionBecameIdle(RealConnection realConnection) {
        assert (Thread.holdsLock(this));
        if (realConnection.noNewStreams || this.maxIdleConnections == 0) {
            this.connections.remove(realConnection);
            return true;
        }
        this.notifyAll();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() {
        ArrayList<RealConnection> arrayList = new ArrayList<RealConnection>();
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            Iterator<RealConnection> object = this.connections.iterator();
            while (object.hasNext()) {
                RealConnection realConnection = object.next();
                if (!realConnection.allocations.isEmpty()) continue;
                realConnection.noNewStreams = true;
                arrayList.add(realConnection);
                object.remove();
            }
        }
        for (RealConnection realConnection : arrayList) {
            Util.closeQuietly(realConnection.getSocket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long cleanup(long l) {
        int n = 0;
        int n2 = 0;
        RealConnection realConnection = null;
        long l2 = Long.MIN_VALUE;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            for (RealConnection realConnection2 : this.connections) {
                if (this.pruneAndGetAllocationCount(realConnection2, l) > 0) {
                    ++n;
                    continue;
                }
                ++n2;
                long l3 = l - realConnection2.idleAtNanos;
                if (l3 <= l2) continue;
                l2 = l3;
                realConnection = realConnection2;
            }
            if (l2 < this.keepAliveDurationNs && n2 <= this.maxIdleConnections) {
                if (n2 > 0) {
                    return this.keepAliveDurationNs - l2;
                }
                if (n > 0) {
                    return this.keepAliveDurationNs;
                }
                return -1L;
            }
            this.connections.remove(realConnection);
        }
        Util.closeQuietly(realConnection.getSocket());
        return 0L;
    }

    private int pruneAndGetAllocationCount(RealConnection realConnection, long l) {
        List<Reference<StreamAllocation>> list = realConnection.allocations;
        int n = 0;
        while (n < list.size()) {
            Reference<StreamAllocation> reference = list.get(n);
            if (reference.get() != null) {
                ++n;
                continue;
            }
            Internal.logger.warning("A connection to " + realConnection.getRoute().getAddress().url() + " was leaked. Did you forget to close a response body?");
            list.remove(n);
            realConnection.noNewStreams = true;
            if (!list.isEmpty()) continue;
            realConnection.idleAtNanos = l - this.keepAliveDurationNs;
            return 0;
        }
        return list.size();
    }

    void setCleanupRunnableForTest(Runnable runnable2) {
        this.cleanupRunnable = runnable2;
    }

    static {
        long l;
        String string = System.getProperty("http.keepAlive");
        String string2 = System.getProperty("http.keepAliveDuration");
        String string3 = System.getProperty("http.maxConnections");
        long l2 = l = string2 != null ? Long.parseLong(string2) : 300000L;
        systemDefault = string != null && !Boolean.parseBoolean(string) ? new ConnectionPool(0, l) : (string3 != null ? new ConnectionPool(Integer.parseInt(string3), l) : new ConnectionPool(5, l));
    }
}

