/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlEncoderUtils {
    private static final String PATH_DELIMITER = "/";
    private static final String ENCODE_DELIMITER = "%2F";
    private static final Logger log = LoggerFactory.getLogger(UrlEncoderUtils.class);

    public static String encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error("URLEncoder error, exception: {}", unsupportedEncodingException);
            return null;
        }
    }

    public static String encodeEscapeDelimiter(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split(PATH_DELIMITER);
        boolean bl = true;
        for (String string2 : stringArray) {
            if (bl) {
                stringBuilder.append(UrlEncoderUtils.encode(string2));
                bl = false;
                continue;
            }
            stringBuilder.append(PATH_DELIMITER).append(UrlEncoderUtils.encode(string2));
        }
        if (string.endsWith(PATH_DELIMITER)) {
            stringBuilder.append(PATH_DELIMITER);
        }
        return stringBuilder.toString();
    }

    public static String encodeUrlPath(String string) {
        int n;
        if (string.length() <= 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PATH_DELIMITER);
        int n2 = 1;
        for (n = 1; n < string.length(); ++n) {
            if ('/' != string.charAt(n)) continue;
            if ('/' == string.charAt(n - 1)) {
                stringBuilder.append(ENCODE_DELIMITER);
            } else {
                stringBuilder.append(UrlEncoderUtils.encode(string.substring(n2, n))).append(PATH_DELIMITER);
            }
            n2 = n + 1;
        }
        if (n2 < n) {
            stringBuilder.append(UrlEncoderUtils.encode(string.substring(n2, n)));
        }
        return stringBuilder.toString();
    }

    public static String urlDecode(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }
}

