/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.utils;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.FileLockException;
import com.qcloud.cos.internal.FileLocks;
import com.qcloud.cos.internal.SkipMd5CheckStrategy;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.utils.BinaryUtils;
import com.qcloud.cos.utils.IOUtils;
import com.qcloud.cos.utils.Md5Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Arrays;
import javax.net.ssl.SSLProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceUtils {
    private static final Logger log = LoggerFactory.getLogger(ServiceUtils.class);
    private static final SkipMd5CheckStrategy skipMd5CheckStrategy = SkipMd5CheckStrategy.INSTANCE;
    public static final boolean APPEND_MODE = true;
    public static final boolean OVERWRITE_MODE = false;

    public static void downloadToFile(COSObject cOSObject, File file, boolean bl, boolean bl2, long l) {
        Object object;
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists() && !file2.mkdirs()) {
            throw new CosClientException("Unable to create directory in the path" + file2.getAbsolutePath());
        }
        if (!FileLocks.lock(file)) {
            throw new FileLockException("Fail to lock " + file + " for appendData=" + bl2);
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            long l2 = file.length();
            if (bl2 && l2 != l) {
                throw new IllegalStateException("Expected file length to append is " + l + " but actual length is " + l2 + " for file " + file);
            }
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file, bl2));
            object = new byte[10240];
            while ((n = cOSObject.getObjectContent().read((byte[])object)) > -1) {
                ((OutputStream)bufferedOutputStream).write((byte[])object, 0, n);
            }
        }
        catch (IOException iOException) {
            try {
                cOSObject.getObjectContent().abort();
                throw new CosClientException("Unable to store object contents to disk: " + iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedOutputStream, log);
                FileLocks.unlock(file);
                IOUtils.closeQuietly(cOSObject.getObjectContent(), log);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(bufferedOutputStream, log);
        FileLocks.unlock(file);
        IOUtils.closeQuietly(cOSObject.getObjectContent(), log);
        if (bl) {
            byte[] byArray = null;
            byte[] byArray2 = null;
            try {
                object = cOSObject.getObjectMetadata();
                if (!skipMd5CheckStrategy.skipClientSideValidationPerGetResponse((ObjectMetadata)object)) {
                    byArray = Md5Utils.computeMD5Hash(file);
                    byArray2 = BinaryUtils.fromHex(((ObjectMetadata)object).getETag());
                }
            }
            catch (Exception exception) {
                log.warn("Unable to calculate MD5 hash to validate download: " + exception.getMessage(), exception);
            }
            if (byArray != null && byArray2 != null && !Arrays.equals(byArray, byArray2)) {
                throw new CosClientException("Unable to verify integrity of data download.  Client calculated content hash didn't match hash calculated by Qcloud COS.  The data stored in '" + file.getAbsolutePath() + "' may be corrupt.");
            }
        }
    }

    public static void downloadObjectToFile(COSObject cOSObject, File file, boolean bl, boolean bl2) {
        ServiceUtils.downloadToFile(cOSObject, file, bl, bl2, -1L);
    }

    public static COSObject retryableDownloadCOSObjectToFile(File file, RetryableCOSDownloadTask retryableCOSDownloadTask, boolean bl) {
        COSObject cOSObject;
        boolean bl2;
        boolean bl3 = false;
        do {
            bl2 = false;
            cOSObject = retryableCOSDownloadTask.getCOSObjectStream();
            if (cOSObject == null) {
                return null;
            }
            try {
                ServiceUtils.downloadObjectToFile(cOSObject, file, retryableCOSDownloadTask.needIntegrityCheck(), bl);
            }
            catch (CosClientException cosClientException) {
                if (!cosClientException.isRetryable()) {
                    cOSObject.getObjectContent().abort();
                    throw cosClientException;
                }
                if (cosClientException.getCause() instanceof SocketException || cosClientException.getCause() instanceof SSLProtocolException) {
                    throw cosClientException;
                }
                bl2 = true;
                if (bl3) {
                    cOSObject.getObjectContent().abort();
                    throw cosClientException;
                }
                log.info("Retry the download of object " + cOSObject.getKey() + " (bucket " + cOSObject.getBucketName() + ")", cosClientException);
                bl3 = true;
            }
        } while (bl2);
        return cOSObject;
    }

    public static interface RetryableCOSDownloadTask {
        public COSObject getCOSObjectStream();

        public boolean needIntegrityCheck();
    }
}

