/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.utils;

import com.qcloud.cos.utils.Base64;
import com.qcloud.cos.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class Md5Utils {
    public static byte[] computeMD5Hash(InputStream inputStream2) throws IOException {
        return DigestUtils.md5(inputStream2);
    }

    public static String md5AsBase64(InputStream inputStream2) throws IOException {
        return Base64.encodeAsString(Md5Utils.computeMD5Hash(inputStream2));
    }

    public static byte[] computeMD5Hash(byte[] byArray) {
        return DigestUtils.md5(byArray);
    }

    public static String md5AsBase64(byte[] byArray) {
        return Base64.encodeAsString(Md5Utils.computeMD5Hash(byArray));
    }

    public static String md5Hex(File file) throws FileNotFoundException, IOException {
        return Hex.encodeHexString(Md5Utils.computeMD5Hash(file));
    }

    public static String md5Hex(String string) {
        return Hex.encodeHexString(Md5Utils.computeMD5Hash(string.getBytes(StringUtils.UTF8)));
    }

    public static String md5Hex(byte[] byArray) {
        return Hex.encodeHexString(Md5Utils.computeMD5Hash(byArray));
    }

    public static byte[] computeMD5Hash(File file) throws FileNotFoundException, IOException {
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(file);
            byte[] byArray = Md5Utils.computeMD5Hash(fileInputStream);
            return byArray;
        }
    }

    public static String md5AsBase64(File file) throws FileNotFoundException, IOException {
        return Base64.encodeAsString(Md5Utils.computeMD5Hash(file));
    }
}

