/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.event.COSProgressPublisher;
import com.qcloud.cos.event.ProgressEventType;
import com.qcloud.cos.event.ProgressListenerChain;
import com.qcloud.cos.event.TransferStateChangeListener;
import com.qcloud.cos.exception.PauseException;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.transfer.AbstractTransfer;
import com.qcloud.cos.transfer.Download;
import com.qcloud.cos.transfer.PersistableDownload;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.transfer.TransferManagerUtils;
import com.qcloud.cos.transfer.TransferProgress;
import java.io.File;
import java.io.IOException;

public class DownloadImpl
extends AbstractTransfer
implements Download {
    private COSObject cosObject;
    private final PersistableDownload persistableDownload;

    public DownloadImpl(String string, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, COSObject cOSObject, TransferStateChangeListener transferStateChangeListener, GetObjectRequest getObjectRequest, File file) {
        super(string, transferProgress, progressListenerChain, transferStateChangeListener);
        this.cosObject = cOSObject;
        this.persistableDownload = this.captureDownloadState(getObjectRequest, file);
        COSProgressPublisher.publishTransferPersistable(progressListenerChain, this.persistableDownload);
    }

    @Override
    public ObjectMetadata getObjectMetadata() {
        return this.cosObject.getObjectMetadata();
    }

    @Override
    public String getBucketName() {
        return this.cosObject.getBucketName();
    }

    @Override
    public String getKey() {
        return this.cosObject.getKey();
    }

    @Override
    public synchronized void abort() throws IOException {
        this.monitor.getFuture().cancel(true);
        if (this.cosObject != null) {
            this.cosObject.getObjectContent().abort();
        }
        this.setState(Transfer.TransferState.Canceled);
    }

    public synchronized void abortWithoutNotifyingStateChangeListener() throws IOException {
        this.monitor.getFuture().cancel(true);
        this.state = Transfer.TransferState.Canceled;
    }

    public COSObject getCosObject() {
        return this.cosObject;
    }

    public void setCosObject(COSObject cOSObject) {
        this.cosObject = cOSObject;
    }

    @Override
    public void setState(Transfer.TransferState transferState) {
        super.setState(transferState);
        if (transferState == Transfer.TransferState.Completed) {
            this.fireProgressEvent(ProgressEventType.TRANSFER_COMPLETED_EVENT);
        }
    }

    private PersistableDownload captureDownloadState(GetObjectRequest getObjectRequest, File file) {
        if (getObjectRequest.getSSECustomerKey() == null) {
            return new PersistableDownload(getObjectRequest.getBucketName(), getObjectRequest.getKey(), getObjectRequest.getVersionId(), getObjectRequest.getRange(), getObjectRequest.getResponseHeaders(), file.getAbsolutePath());
        }
        return null;
    }

    @Override
    public PersistableDownload pause() throws PauseException {
        boolean bl = true;
        Transfer.TransferState transferState = this.getState();
        this.monitor.getFuture().cancel(true);
        if (this.persistableDownload == null) {
            throw new PauseException(TransferManagerUtils.determinePauseStatus(transferState, bl));
        }
        return this.persistableDownload;
    }
}

