/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.COS;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.FileLockException;
import com.qcloud.cos.internal.FileLocks;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.transfer.DownloadImpl;
import com.qcloud.cos.transfer.DownloadMonitor;
import com.qcloud.cos.transfer.DownloadTaskImpl;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.utils.ServiceUtils;
import java.io.File;
import java.net.SocketException;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import javax.net.ssl.SSLProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DownloadCallable
implements Callable<File> {
    private static final Logger log = LoggerFactory.getLogger(DownloadCallable.class);
    private final COS cos;
    private final CountDownLatch latch;
    private final GetObjectRequest req;
    private final boolean resumeExistingDownload;
    private final DownloadImpl download;
    private final File dstfile;
    private final long origStartingByte;
    private long expectedFileLength;
    private static boolean testing;

    DownloadCallable(COS cOS, CountDownLatch countDownLatch, GetObjectRequest getObjectRequest, boolean bl, DownloadImpl downloadImpl, File file, long l, long l2) {
        if (cOS == null || countDownLatch == null || getObjectRequest == null || file == null || downloadImpl == null) {
            throw new IllegalArgumentException();
        }
        this.cos = cOS;
        this.latch = countDownLatch;
        this.req = getObjectRequest;
        this.resumeExistingDownload = bl;
        this.download = downloadImpl;
        this.dstfile = file;
        this.origStartingByte = l;
        this.expectedFileLength = l2;
    }

    @Override
    public File call() throws Exception {
        try {
            this.latch.await();
            this.download.setState(Transfer.TransferState.InProgress);
            COSObject cOSObject = this.retryableDownloadCOSObjectToFile(this.dstfile, new DownloadTaskImpl(this.cos, this.download, this.req), this.resumeExistingDownload);
            if (cOSObject == null) {
                this.download.setState(Transfer.TransferState.Canceled);
                this.download.setMonitor(new DownloadMonitor(this.download, null));
            } else {
                this.download.setState(Transfer.TransferState.Completed);
            }
            return this.dstfile;
        }
        catch (Throwable throwable) {
            if (this.download.getState() != Transfer.TransferState.Canceled) {
                this.download.setState(Transfer.TransferState.Failed);
            }
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw (Error)throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustRequest(GetObjectRequest getObjectRequest) {
        long[] lArray = getObjectRequest.getRange();
        long l = lArray[1];
        long l2 = l - this.origStartingByte + 1L;
        if (this.dstfile.exists()) {
            if (!FileLocks.lock(this.dstfile)) {
                throw new FileLockException("Fail to lock " + this.dstfile + " for range adjustment");
            }
            try {
                this.expectedFileLength = this.dstfile.length();
                long l3 = this.origStartingByte + this.expectedFileLength;
                log.info("Adjusting request range from " + Arrays.toString(lArray) + " to " + Arrays.toString(new long[]{l3, l}) + " for file " + this.dstfile);
                getObjectRequest.setRange(l3, l);
                l2 = l - l3 + 1L;
            }
            finally {
                FileLocks.unlock(this.dstfile);
            }
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("Unable to determine the range for download operation. lastByte=" + l + ", origStartingByte=" + this.origStartingByte + ", expectedFileLength=" + this.expectedFileLength + ", totalBytesToDownload=" + l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private COSObject retryableDownloadCOSObjectToFile(File file, ServiceUtils.RetryableCOSDownloadTask retryableCOSDownloadTask, boolean bl) {
        boolean bl2 = false;
        while (true) {
            COSObject cOSObject;
            if (this.resumeExistingDownload && bl2) {
                this.adjustRequest(this.req);
            }
            if ((cOSObject = retryableCOSDownloadTask.getCOSObjectStream()) == null) {
                return null;
            }
            try {
                if (testing && this.resumeExistingDownload && !bl2) {
                    throw new CosClientException("testing");
                }
                ServiceUtils.downloadToFile(cOSObject, file, retryableCOSDownloadTask.needIntegrityCheck(), bl, this.expectedFileLength);
                COSObject cOSObject2 = cOSObject;
                return cOSObject2;
            }
            catch (CosClientException cosClientException) {
                if (!cosClientException.isRetryable()) {
                    throw cosClientException;
                }
                if (cosClientException.getCause() instanceof SocketException || cosClientException.getCause() instanceof SSLProtocolException) {
                    throw cosClientException;
                }
                if (bl2) {
                    throw cosClientException;
                }
                log.info("Retry the download of object " + cOSObject.getKey() + " (bucket " + cOSObject.getBucketName() + ")", cosClientException);
                bl2 = true;
                continue;
            }
            finally {
                cOSObject.getObjectContent().abort();
                continue;
            }
            break;
        }
    }

    static void setTesting(boolean bl) {
        testing = bl;
    }
}

