/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.COS;
import com.qcloud.cos.event.ProgressEventType;
import com.qcloud.cos.event.ProgressListenerChain;
import com.qcloud.cos.event.SDKProgressPublisher;
import com.qcloud.cos.internal.CopyImpl;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.CopyObjectResult;
import com.qcloud.cos.model.CopyPartRequest;
import com.qcloud.cos.model.CopyResult;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.CopyPartCallable;
import com.qcloud.cos.transfer.CopyPartRequestFactory;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.TransferManagerConfiguration;
import com.qcloud.cos.transfer.TransferManagerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CopyCallable
implements Callable<CopyResult> {
    private final COS cos;
    private final ExecutorService threadPool;
    private final CopyObjectRequest copyObjectRequest;
    private String multipartUploadId;
    private final ObjectMetadata metadata;
    private final CopyImpl copy;
    private static final Log log = LogFactory.getLog(CopyCallable.class);
    private final TransferManagerConfiguration configuration;
    private final List<Future<PartETag>> futures = new ArrayList<Future<PartETag>>();
    private final ProgressListenerChain listenerChain;

    public CopyCallable(TransferManager transferManager, ExecutorService executorService, CopyImpl copyImpl, CopyObjectRequest copyObjectRequest, ObjectMetadata objectMetadata, ProgressListenerChain progressListenerChain) {
        this.cos = transferManager.getCOSClient();
        this.configuration = transferManager.getConfiguration();
        this.threadPool = executorService;
        this.copyObjectRequest = copyObjectRequest;
        this.metadata = objectMetadata;
        this.listenerChain = progressListenerChain;
        this.copy = copyImpl;
    }

    List<Future<PartETag>> getFutures() {
        return this.futures;
    }

    String getMultipartUploadId() {
        return this.multipartUploadId;
    }

    public boolean isMultipartCopy() {
        Region region = this.copyObjectRequest.getSourceBucketRegion();
        Region region2 = this.cos.getClientConfig().getRegion();
        String string = (String)this.metadata.getRawMetadataValue("x-cos-storage-class");
        String string2 = this.copyObjectRequest.getStorageClass();
        if (string == null) {
            string = "Standard";
        }
        if (string.equalsIgnoreCase(string2) && (region == null || region.equals(region2))) {
            return false;
        }
        return this.metadata.getContentLength() > this.configuration.getMultipartCopyThreshold();
    }

    @Override
    public CopyResult call() throws Exception {
        this.copy.setState(Transfer.TransferState.InProgress);
        if (this.isMultipartCopy()) {
            SDKProgressPublisher.publishProgress(this.listenerChain, ProgressEventType.TRANSFER_STARTED_EVENT);
            this.copyInParts();
            return null;
        }
        return this.copyInOneChunk();
    }

    private CopyResult copyInOneChunk() {
        CopyObjectResult copyObjectResult = this.cos.copyObject(this.copyObjectRequest);
        if (copyObjectResult == null) {
            return null;
        }
        CopyResult copyResult = new CopyResult();
        copyResult.setSourceBucketName(this.copyObjectRequest.getSourceBucketName());
        copyResult.setSourceKey(this.copyObjectRequest.getSourceKey());
        copyResult.setDestinationBucketName(this.copyObjectRequest.getDestinationBucketName());
        copyResult.setDestinationKey(this.copyObjectRequest.getDestinationKey());
        copyResult.setETag(copyObjectResult.getETag());
        copyResult.setVersionId(copyObjectResult.getVersionId());
        copyResult.setRequestId(copyObjectResult.getRequestId());
        copyResult.setDateStr(copyObjectResult.getDateStr());
        copyResult.setCrc64Ecma(copyObjectResult.getCrc64Ecma());
        return copyResult;
    }

    private void copyInParts() throws Exception {
        this.multipartUploadId = this.initiateMultipartUpload(this.copyObjectRequest);
        long l = this.getOptimalPartSize(this.metadata.getContentLength());
        try {
            CopyPartRequestFactory copyPartRequestFactory = new CopyPartRequestFactory(this.copyObjectRequest, this.multipartUploadId, l, this.metadata.getContentLength());
            this.copyPartsInParallel(copyPartRequestFactory);
        }
        catch (Exception exception) {
            SDKProgressPublisher.publishProgress(this.listenerChain, ProgressEventType.TRANSFER_FAILED_EVENT);
            this.abortMultipartCopy();
            throw new RuntimeException("Unable to perform multipart copy", exception);
        }
    }

    private long getOptimalPartSize(long l) {
        long l2 = TransferManagerUtils.calculateOptimalPartSizeForCopy(this.copyObjectRequest, this.configuration, l);
        log.debug("Calculated optimal part size: " + l2);
        return l2;
    }

    private void copyPartsInParallel(CopyPartRequestFactory copyPartRequestFactory) {
        while (copyPartRequestFactory.hasMoreRequests()) {
            if (this.threadPool.isShutdown()) {
                throw new CancellationException("TransferManager has been shutdown");
            }
            CopyPartRequest copyPartRequest = copyPartRequestFactory.getNextCopyPartRequest();
            this.futures.add(this.threadPool.submit(new CopyPartCallable(this.cos, copyPartRequest)));
        }
    }

    private String initiateMultipartUpload(CopyObjectRequest copyObjectRequest) {
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = (InitiateMultipartUploadRequest)new InitiateMultipartUploadRequest(copyObjectRequest.getDestinationBucketName(), copyObjectRequest.getDestinationKey()).withCannedACL(copyObjectRequest.getCannedAccessControlList()).withAccessControlList(copyObjectRequest.getAccessControlList()).withStorageClass(copyObjectRequest.getStorageClass()).withGeneralProgressListener(copyObjectRequest.getGeneralProgressListener());
        ObjectMetadata objectMetadata = copyObjectRequest.getNewObjectMetadata();
        if (objectMetadata == null) {
            objectMetadata = new ObjectMetadata();
        }
        if (objectMetadata.getContentType() == null) {
            objectMetadata.setContentType(this.metadata.getContentType());
        }
        initiateMultipartUploadRequest.setObjectMetadata(objectMetadata);
        TransferManagerUtils.populateEndpointAddr(copyObjectRequest, initiateMultipartUploadRequest);
        String string = this.cos.initiateMultipartUpload(initiateMultipartUploadRequest).getUploadId();
        log.debug("Initiated new multipart upload: " + string);
        return string;
    }

    private void abortMultipartCopy() {
        try {
            AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(this.copyObjectRequest.getDestinationBucketName(), this.copyObjectRequest.getDestinationKey(), this.multipartUploadId);
            TransferManagerUtils.populateEndpointAddr(this.copyObjectRequest, abortMultipartUploadRequest);
            this.cos.abortMultipartUpload(abortMultipartUploadRequest);
        }
        catch (Exception exception) {
            log.info("Unable to abort multipart upload, you may need to manually remove uploaded parts: " + exception.getMessage(), exception);
        }
    }
}

