/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.COS;
import com.qcloud.cos.event.ProgressEventType;
import com.qcloud.cos.event.ProgressListenerChain;
import com.qcloud.cos.event.SDKProgressPublisher;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.CopyResult;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.transfer.CopyMonitor;
import com.qcloud.cos.transfer.TransferManagerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class CompleteMultipartCopy
implements Callable<CopyResult> {
    private final String uploadId;
    private final COS cos;
    private final CopyObjectRequest origReq;
    private final List<Future<PartETag>> futures;
    private final CopyMonitor monitor;
    private final ProgressListenerChain listener;

    public CompleteMultipartCopy(String string, COS cOS, CopyObjectRequest copyObjectRequest, List<Future<PartETag>> list, ProgressListenerChain progressListenerChain, CopyMonitor copyMonitor) {
        this.uploadId = string;
        this.cos = cOS;
        this.origReq = copyObjectRequest;
        this.futures = list;
        this.listener = progressListenerChain;
        this.monitor = copyMonitor;
    }

    @Override
    public CopyResult call() throws Exception {
        CompleteMultipartUploadResult completeMultipartUploadResult;
        Object object;
        try {
            object = (CompleteMultipartUploadRequest)new CompleteMultipartUploadRequest(this.origReq.getDestinationBucketName(), this.origReq.getDestinationKey(), this.uploadId, this.collectPartETags()).withGeneralProgressListener(this.origReq.getGeneralProgressListener());
            ObjectMetadata objectMetadata = this.origReq.getNewObjectMetadata();
            if (objectMetadata != null) {
                ObjectMetadata objectMetadata2 = ((CompleteMultipartUploadRequest)object).getObjectMetadata();
                if (objectMetadata2 == null) {
                    objectMetadata2 = new ObjectMetadata();
                }
                objectMetadata2.setUserMetadata(objectMetadata.getUserMetadata());
                ((CompleteMultipartUploadRequest)object).setObjectMetadata(objectMetadata2);
            }
            TransferManagerUtils.populateEndpointAddr(this.origReq, (CosServiceRequest)object);
            completeMultipartUploadResult = this.cos.completeMultipartUpload((CompleteMultipartUploadRequest)object);
        }
        catch (Exception exception) {
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_FAILED_EVENT);
            throw exception;
        }
        object = new CopyResult();
        ((CopyResult)object).setSourceBucketName(this.origReq.getSourceBucketName());
        ((CopyResult)object).setSourceKey(this.origReq.getSourceKey());
        ((CopyResult)object).setDestinationBucketName(completeMultipartUploadResult.getBucketName());
        ((CopyResult)object).setDestinationKey(completeMultipartUploadResult.getKey());
        ((CopyResult)object).setETag(completeMultipartUploadResult.getETag());
        ((CopyResult)object).setVersionId(completeMultipartUploadResult.getVersionId());
        ((CopyResult)object).setRequestId(completeMultipartUploadResult.getRequestId());
        ((CopyResult)object).setDateStr(completeMultipartUploadResult.getDateStr());
        ((CopyResult)object).setCrc64Ecma(completeMultipartUploadResult.getCrc64Ecma());
        this.monitor.copyComplete();
        return object;
    }

    private List<PartETag> collectPartETags() {
        ArrayList<PartETag> arrayList = new ArrayList<PartETag>();
        for (Future<PartETag> future : this.futures) {
            try {
                arrayList.add(future.get());
            }
            catch (Exception exception) {
                throw new CosClientException("Unable to copy part: " + exception.getCause().getMessage(), exception.getCause());
            }
        }
        return arrayList;
    }
}

