/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.retry;

import com.qcloud.cos.retry.BackoffStrategy;
import com.qcloud.cos.utils.ValidationUtils;

public class PredefinedBackoffStrategies {
    private static final int SDK_DEFAULT_BASE_DELAY = 100;
    static final int SDK_DEFAULT_MAX_BACKOFF_IN_MILLISECONDS = 20000;
    private static final int MAX_RETRIES = 30;
    public static final BackoffStrategy DEFAULT = new ExponentialBackoffStrategy(100, 20000);

    private static int calculateExponentialDelay(int n, int n2, int n3) {
        int n4 = Math.min(n, 30);
        return (int)Math.min((1L << n4) * (long)n2, (long)n3);
    }

    public static class ExponentialBackoffStrategy
    implements BackoffStrategy {
        private final int baseDelay;
        private final int maxBackoffTime;

        public ExponentialBackoffStrategy(int n, int n2) {
            this.baseDelay = ValidationUtils.assertIsPositive(n, "Base delay");
            this.maxBackoffTime = ValidationUtils.assertIsPositive(n2, "Max backoff");
        }

        @Override
        public long computeDelayBeforeNextRetry(int n) {
            return PredefinedBackoffStrategies.calculateExponentialDelay(n, this.baseDelay, this.maxBackoffTime);
        }
    }
}

