/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.region;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.UrlComponentUtils;
import java.io.Serializable;

public class Region
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String regionName;
    private String displayName;

    public Region(String string) {
        this(string, string);
    }

    public Region(String string, String string2) {
        this.regionName = string;
        this.displayName = string2;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Region) {
            String string = ((Region)object).getRegionName();
            return string.equals(this.regionName);
        }
        return false;
    }

    public static String formatRegion(Region region) throws CosClientException {
        return Region.formatRegion(region.getRegionName());
    }

    public static String formatRegion(String string) throws CosClientException {
        UrlComponentUtils.validateRegionName(string);
        if (string.startsWith("cos.")) {
            return string;
        }
        if (string.equals("cn-east") || string.equals("cn-south") || string.equals("cn-north") || string.equals("cn-south-2") || string.equals("cn-southwest") || string.equals("sg")) {
            return string;
        }
        return "cos." + string;
    }

    public static String formatCIRegion(Region region) throws CosClientException {
        return Region.formatCIRegion(region.getRegionName());
    }

    public static String formatCIRegion(String string) throws CosClientException {
        UrlComponentUtils.validateRegionName(string);
        if (string.startsWith("ap-") || string.startsWith("eu-") || string.startsWith("na-")) {
            return string;
        }
        return "ap-" + string;
    }
}

