/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model.ciModel.xml;

import com.qcloud.cos.internal.RequestXmlFactory;
import com.qcloud.cos.internal.XmlWriter;
import com.qcloud.cos.model.ciModel.common.BatchInputObject;
import com.qcloud.cos.model.ciModel.common.MediaInputObject;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.job.AudioConfig;
import com.qcloud.cos.model.ciModel.job.BatchJobOperation;
import com.qcloud.cos.model.ciModel.job.BatchJobRequest;
import com.qcloud.cos.model.ciModel.job.CallBackMqConfig;
import com.qcloud.cos.model.ciModel.job.ColorEnhance;
import com.qcloud.cos.model.ciModel.job.EffectConfig;
import com.qcloud.cos.model.ciModel.job.ExtractDigitalWatermark;
import com.qcloud.cos.model.ciModel.job.FrameEnhance;
import com.qcloud.cos.model.ciModel.job.JobParam;
import com.qcloud.cos.model.ciModel.job.MediaAudioMixObject;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatFragmentObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatTemplateObject;
import com.qcloud.cos.model.ciModel.job.MediaContainerObject;
import com.qcloud.cos.model.ciModel.job.MediaDigitalWatermark;
import com.qcloud.cos.model.ciModel.job.MediaJobOperation;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaPicProcessTemplateObject;
import com.qcloud.cos.model.ciModel.job.MediaRemoveWaterMark;
import com.qcloud.cos.model.ciModel.job.MediaTimeIntervalObject;
import com.qcloud.cos.model.ciModel.job.MediaTransConfigObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeVideoObject;
import com.qcloud.cos.model.ciModel.job.MediaTtsConfig;
import com.qcloud.cos.model.ciModel.job.MediaVideoObject;
import com.qcloud.cos.model.ciModel.job.MsSharpen;
import com.qcloud.cos.model.ciModel.job.SDRtoHDR;
import com.qcloud.cos.model.ciModel.job.Subtitle;
import com.qcloud.cos.model.ciModel.job.Subtitles;
import com.qcloud.cos.model.ciModel.job.SuperResolution;
import com.qcloud.cos.model.ciModel.job.TtsTpl;
import com.qcloud.cos.model.ciModel.job.VideoEnhance;
import com.qcloud.cos.model.ciModel.job.VideoTargetRec;
import com.qcloud.cos.model.ciModel.job.VoiceSeparate;
import com.qcloud.cos.model.ciModel.template.MediaHlsEncryptObject;
import com.qcloud.cos.model.ciModel.template.MediaSegmentObject;
import com.qcloud.cos.model.ciModel.template.MediaSmartCoverObject;
import com.qcloud.cos.model.ciModel.template.MediaSnapshotObject;
import com.qcloud.cos.model.ciModel.template.MediaTemplateRequest;
import com.qcloud.cos.model.ciModel.template.MediaVideoMontageObject;
import com.qcloud.cos.model.ciModel.template.MediaWaterMarkImage;
import com.qcloud.cos.model.ciModel.template.MediaWaterMarkText;
import com.qcloud.cos.model.ciModel.template.MediaWatermark;
import com.qcloud.cos.model.ciModel.template.SpriteSnapshotConfig;
import com.qcloud.cos.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CIMediaXmlFactory {
    static void addIfNotNull(XmlWriter xmlWriter, String string, String string2) {
        if (string2 != null) {
            xmlWriter.start(string).value(string2).end();
        }
    }

    static void addIfNotNull(XmlWriter xmlWriter, String string, Object object) {
        if (object != null && object.toString() != null) {
            xmlWriter.start(string).value(object.toString()).end();
        }
    }

    public static byte[] convertToXmlByteArray(MediaJobsRequest mediaJobsRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        CIMediaXmlFactory.addCommonParams(xmlWriter, mediaJobsRequest);
        CIMediaXmlFactory.addInput(xmlWriter, mediaJobsRequest.getInput());
        CIMediaXmlFactory.addOperation(xmlWriter, mediaJobsRequest);
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(BatchJobRequest batchJobRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        CIMediaXmlFactory.addBatchCommonParams(xmlWriter, batchJobRequest);
        CIMediaXmlFactory.addInput(xmlWriter, batchJobRequest.getInput());
        CIMediaXmlFactory.addBatchOperation(xmlWriter, batchJobRequest.getOperation());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private static void addBatchCommonParams(XmlWriter xmlWriter, BatchJobRequest batchJobRequest) {
        if (CIMediaXmlFactory.objIsNotValid(batchJobRequest).booleanValue()) {
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Name", batchJobRequest.getName());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Type", batchJobRequest.getType());
        }
    }

    public static byte[] convertToXmlByteArray(MediaTemplateRequest mediaTemplateRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        String string = mediaTemplateRequest.getTag();
        xmlWriter.start("Request");
        xmlWriter.start("Tag").value(string).end();
        xmlWriter.start("Name").value(mediaTemplateRequest.getName()).end();
        if ("Animation".equalsIgnoreCase(string)) {
            xmlWriter.start("Container");
            xmlWriter.start("Format").value(mediaTemplateRequest.getContainer().getFormat()).end();
            xmlWriter.end();
            CIMediaXmlFactory.addVideo(xmlWriter, mediaTemplateRequest.getVideo());
            if (CIMediaXmlFactory.objIsNotValid(mediaTemplateRequest.getTimeInterval()).booleanValue()) {
                xmlWriter.start("TimeInterval");
                xmlWriter.start("Duration").value(mediaTemplateRequest.getTimeInterval().getDuration()).end();
                xmlWriter.start("Start").value(mediaTemplateRequest.getTimeInterval().getStart()).end();
                xmlWriter.end();
            }
        } else if ("Snapshot".equalsIgnoreCase(string)) {
            MediaSnapshotObject mediaSnapshotObject = mediaTemplateRequest.getSnapshot();
            CIMediaXmlFactory.addSnapshot(xmlWriter, mediaSnapshotObject);
        } else if ("Watermark".equalsIgnoreCase(string)) {
            xmlWriter.start("Watermark");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Type", mediaTemplateRequest.getWatermark().getType());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Dx", mediaTemplateRequest.getWatermark().getDx());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Dy", mediaTemplateRequest.getWatermark().getDy());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "EndTime", mediaTemplateRequest.getWatermark().getEndTime());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "LocMode", mediaTemplateRequest.getWatermark().getLocMode());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Pos", mediaTemplateRequest.getWatermark().getPos());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "StartTime", mediaTemplateRequest.getWatermark().getStartTime());
            if ("Text".equalsIgnoreCase(mediaTemplateRequest.getWatermark().getType())) {
                xmlWriter.start("Text");
                MediaWaterMarkText mediaWaterMarkText = mediaTemplateRequest.getWatermark().getText();
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "FontColor", mediaWaterMarkText.getFontColor());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "FontSize", mediaWaterMarkText.getFontSize());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "FontType", mediaWaterMarkText.getFontType());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Text", mediaWaterMarkText.getText());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Transparency", mediaWaterMarkText.getTransparency());
                xmlWriter.end();
            } else if ("Image".equalsIgnoreCase(mediaTemplateRequest.getWatermark().getType())) {
                xmlWriter.start("Image");
                MediaWaterMarkImage mediaWaterMarkImage = mediaTemplateRequest.getWatermark().getImage();
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Height", mediaWaterMarkImage.getHeight());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Mode", mediaWaterMarkImage.getMode());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Url", mediaWaterMarkImage.getUrl());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Transparency", mediaWaterMarkImage.getTransparency());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Width", mediaWaterMarkImage.getWidth());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Background", mediaWaterMarkImage.getBackground());
                xmlWriter.end();
            }
            xmlWriter.end();
        } else if ("Transcode".equalsIgnoreCase(string)) {
            CIMediaXmlFactory.addFormat(xmlWriter, mediaTemplateRequest.getContainer());
            CIMediaXmlFactory.addTimeInterval(xmlWriter, mediaTemplateRequest.getTimeInterval());
            CIMediaXmlFactory.addAudio(xmlWriter, mediaTemplateRequest.getAudio());
            CIMediaXmlFactory.addVideo(xmlWriter, mediaTemplateRequest.getVideo());
            CIMediaXmlFactory.addTransConfig(xmlWriter, mediaTemplateRequest.getTransConfig());
        } else if ("Concat".equalsIgnoreCase(string)) {
            CIMediaXmlFactory.addConcat(xmlWriter, mediaTemplateRequest.getConcat());
            CIMediaXmlFactory.addAudio(xmlWriter, mediaTemplateRequest.getAudio());
            CIMediaXmlFactory.addAudioMix(xmlWriter, mediaTemplateRequest.getAudioMix(), "AudioMix");
            CIMediaXmlFactory.addContainer(xmlWriter, mediaTemplateRequest.getContainer());
        } else if ("VideoTargetRec".equalsIgnoreCase(string)) {
            VideoTargetRec videoTargetRec = mediaTemplateRequest.getVideoTargetRec();
            CIMediaXmlFactory.addVideoTargetRec(xmlWriter, videoTargetRec);
        } else if ("Tts".equalsIgnoreCase(string)) {
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Codec", mediaTemplateRequest.getCodec());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Mode", mediaTemplateRequest.getMode());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Speed", mediaTemplateRequest.getSpeed());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Volume", mediaTemplateRequest.getVolume());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "VoiceType", mediaTemplateRequest.getVoiceType());
        } else if ("VideoEnhance".equalsIgnoreCase(string)) {
            CIMediaXmlFactory.addVideoEnhance(xmlWriter, mediaTemplateRequest.getVideoEnhance());
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private static void addOperation(XmlWriter xmlWriter, MediaJobsRequest mediaJobsRequest) {
        MediaJobOperation mediaJobOperation = mediaJobsRequest.getOperation();
        xmlWriter.start("Operation");
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "TemplateId", mediaJobOperation.getTemplateId());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "JobLevel", mediaJobOperation.getJobLevel());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "DecryptKey", mediaJobOperation.getDecryptKey());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "UserData", mediaJobOperation.getUserData());
        CIMediaXmlFactory.addWatermarkTemplateId(xmlWriter, mediaJobOperation.getWatermarkTemplateId());
        CIMediaXmlFactory.addWatermar(xmlWriter, mediaJobOperation.getWatermark());
        CIMediaXmlFactory.addWatermarList(xmlWriter, mediaJobOperation.getWatermarkList());
        CIMediaXmlFactory.addRemoveWatermark(xmlWriter, mediaJobOperation.getRemoveWatermark());
        CIMediaXmlFactory.addConcat(xmlWriter, mediaJobOperation.getMediaConcatTemplate());
        CIMediaXmlFactory.addTranscode(xmlWriter, mediaJobOperation.getTranscode());
        CIMediaXmlFactory.addExtractDigitalWatermark(xmlWriter, mediaJobOperation.getExtractDigitalWatermark());
        CIMediaXmlFactory.addMediaDigitalWatermark(xmlWriter, mediaJobOperation.getDigitalWatermark());
        CIMediaXmlFactory.addOutput(xmlWriter, mediaJobOperation.getOutput());
        CIMediaXmlFactory.addSnapshot(xmlWriter, mediaJobOperation.getSnapshot());
        CIMediaXmlFactory.addSegment(xmlWriter, mediaJobOperation.getSegment());
        CIMediaXmlFactory.addSmartCover(xmlWriter, mediaJobOperation.getSmartCover());
        CIMediaXmlFactory.addVideoMontage(xmlWriter, mediaJobOperation.getVideoMontage());
        CIMediaXmlFactory.addPicProcess(xmlWriter, mediaJobOperation.getPicProcess());
        CIMediaXmlFactory.addVideoTargetRec(xmlWriter, mediaJobOperation.getVideoTargetRec());
        CIMediaXmlFactory.addVoiceSeparate(xmlWriter, mediaJobOperation.getVoiceSeparate());
        CIMediaXmlFactory.addTtsConfig(xmlWriter, mediaJobOperation.getTtsConfig());
        CIMediaXmlFactory.addTtsTpl(xmlWriter, mediaJobOperation.getTtsTpl());
        CIMediaXmlFactory.addVideoEnhance(xmlWriter, mediaJobOperation.getVideoEnhance());
        CIMediaXmlFactory.addSubtitles(xmlWriter, mediaJobOperation.getSubtitles());
        xmlWriter.end();
    }

    private static void addSubtitles(XmlWriter xmlWriter, Subtitles subtitles) {
        if (CIMediaXmlFactory.objIsNotValid(subtitles).booleanValue()) {
            xmlWriter.start("Subtitles");
            List<Subtitle> list = subtitles.getSubtitle();
            for (Subtitle subtitle : list) {
                if (!CIMediaXmlFactory.objIsNotValid(list).booleanValue()) continue;
                xmlWriter.start("Subtitle");
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Url", subtitle.getUrl());
                xmlWriter.end();
            }
            xmlWriter.end();
        }
    }

    private static void addVideoEnhance(XmlWriter xmlWriter, VideoEnhance videoEnhance) {
        if (CIMediaXmlFactory.objIsNotValid(videoEnhance).booleanValue()) {
            xmlWriter.start("VideoEnhance");
            CIMediaXmlFactory.addTranscode(xmlWriter, videoEnhance.getTrascode());
            CIMediaXmlFactory.addSuperResolution(xmlWriter, videoEnhance.getSuperResolution());
            CIMediaXmlFactory.addColorEnhance(xmlWriter, videoEnhance.getColorEnhance());
            CIMediaXmlFactory.addMsSharpen(xmlWriter, videoEnhance.getMsSharpen());
            CIMediaXmlFactory.addSdrToHDR(xmlWriter, videoEnhance.getSdrToHDR());
            CIMediaXmlFactory.addFrameEnhance(xmlWriter, videoEnhance.getFrameEnhance());
            xmlWriter.end();
        }
    }

    private static void addFrameEnhance(XmlWriter xmlWriter, FrameEnhance frameEnhance) {
        if (CIMediaXmlFactory.objIsNotValid(frameEnhance).booleanValue()) {
            xmlWriter.start("FrameEnhance");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "FrameDoubling", frameEnhance.getFrameDoubling());
            xmlWriter.end();
        }
    }

    private static void addSdrToHDR(XmlWriter xmlWriter, SDRtoHDR sDRtoHDR) {
        if (CIMediaXmlFactory.objIsNotValid(sDRtoHDR).booleanValue()) {
            xmlWriter.start("SDRtoHDR");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "HdrMode", sDRtoHDR.getHdrMode());
            xmlWriter.end();
        }
    }

    private static void addMsSharpen(XmlWriter xmlWriter, MsSharpen msSharpen) {
        if (CIMediaXmlFactory.objIsNotValid(msSharpen).booleanValue()) {
            xmlWriter.start("MsSharpen");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "SharpenLevel", msSharpen.getSharpenLevel());
            xmlWriter.end();
        }
    }

    private static void addColorEnhance(XmlWriter xmlWriter, ColorEnhance colorEnhance) {
        if (CIMediaXmlFactory.objIsNotValid(colorEnhance).booleanValue()) {
            xmlWriter.start("ColorEnhance");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Contrast", colorEnhance.getContrast());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Correction", colorEnhance.getCorrection());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Saturation", colorEnhance.getSaturation());
            xmlWriter.end();
        }
    }

    private static void addSuperResolution(XmlWriter xmlWriter, SuperResolution superResolution) {
        if (CIMediaXmlFactory.objIsNotValid(superResolution).booleanValue()) {
            xmlWriter.start("SuperResolution");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Resolution", superResolution.getResolution());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "EnableScaleUp", superResolution.getEnableScaleUp());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Version", superResolution.getVersion());
            xmlWriter.end();
        }
    }

    private static void addTtsTpl(XmlWriter xmlWriter, TtsTpl ttsTpl) {
        if (CIMediaXmlFactory.objIsNotValid(ttsTpl).booleanValue()) {
            xmlWriter.start("TtsTpl");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Codec", ttsTpl.getCodec());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Mode", ttsTpl.getMode());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Speed", ttsTpl.getSpeed());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Volume", ttsTpl.getVolume());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "VoiceType", ttsTpl.getVoiceType());
            xmlWriter.end();
        }
    }

    private static void addTtsConfig(XmlWriter xmlWriter, MediaTtsConfig mediaTtsConfig) {
        if (CIMediaXmlFactory.objIsNotValid(mediaTtsConfig).booleanValue()) {
            xmlWriter.start("TtsConfig");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Input", mediaTtsConfig.getInput());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "InputType", mediaTtsConfig.getInputType());
            xmlWriter.end();
        }
    }

    private static void addBatchOperation(XmlWriter xmlWriter, BatchJobOperation batchJobOperation) {
        xmlWriter.start("Operation");
        CIMediaXmlFactory.addTimeInterval(xmlWriter, batchJobOperation.getTimeInterval());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "QueueId", batchJobOperation.getQueueId());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "UserData", batchJobOperation.getUserData());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "CallBack", batchJobOperation.getCallBack());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Tag", batchJobOperation.getTag());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "JobLevel", batchJobOperation.getJobLevel());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "WorkflowIds", batchJobOperation.getWorkflowIds());
        CIMediaXmlFactory.addJobParam(xmlWriter, batchJobOperation.getJobParam());
        CIMediaXmlFactory.addOutput(xmlWriter, batchJobOperation.getOutput());
        CIMediaXmlFactory.addCallBackMqConfig(xmlWriter, batchJobOperation.getCallBackMqConfig());
        xmlWriter.end();
    }

    private static void addJobParam(XmlWriter xmlWriter, JobParam jobParam) {
        if (CIMediaXmlFactory.objIsNotValid(jobParam).booleanValue()) {
            xmlWriter.start("JobParam");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "TemplateId", jobParam.getTemplateId());
            CIMediaXmlFactory.addPicProcess(xmlWriter, jobParam.getPicProcess());
            xmlWriter.end();
        }
    }

    private static void addCallBackMqConfig(XmlWriter xmlWriter, CallBackMqConfig callBackMqConfig) {
        if (CIMediaXmlFactory.objIsNotValid(callBackMqConfig).booleanValue()) {
            xmlWriter.start("CallBackMqConfig");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "MqMode", callBackMqConfig.getMqMode());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "MqName", callBackMqConfig.getMqName());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "MqRegion", callBackMqConfig.getMqRegion());
            xmlWriter.end();
        }
    }

    private static void addPicProcess(XmlWriter xmlWriter, MediaPicProcessTemplateObject mediaPicProcessTemplateObject) {
        if (CIMediaXmlFactory.objIsNotValid(mediaPicProcessTemplateObject).booleanValue()) {
            xmlWriter.start("PicProcess");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "IsPicInfo", mediaPicProcessTemplateObject.getIsPicInfo());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "ProcessRule", mediaPicProcessTemplateObject.getProcessRule());
            xmlWriter.end();
        }
    }

    private static void addVoiceSeparate(XmlWriter xmlWriter, VoiceSeparate voiceSeparate) {
        if (CIMediaXmlFactory.objIsNotValid(voiceSeparate).booleanValue()) {
            xmlWriter.start("VoiceSeparate");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "AudioMode", voiceSeparate.getAudioMode());
            AudioConfig audioConfig = voiceSeparate.getAudioConfig();
            if (CIMediaXmlFactory.objIsNotValid(audioConfig).booleanValue()) {
                xmlWriter.start("AudioConfig");
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Bitrate", audioConfig.getBitrate());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Channels", audioConfig.getChannels());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Codec", audioConfig.getCodec());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Samplerate", audioConfig.getSamplerate());
                xmlWriter.end();
            }
            xmlWriter.end();
        }
    }

    private static void addVideoTargetRec(XmlWriter xmlWriter, VideoTargetRec videoTargetRec) {
        if (CIMediaXmlFactory.objIsNotValid(videoTargetRec).booleanValue()) {
            xmlWriter.start("VideoTargetRec");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Body", videoTargetRec.getBody());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Car", videoTargetRec.getCar());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Pet", videoTargetRec.getPet());
            xmlWriter.end();
        }
    }

    private static void addWatermarList(XmlWriter xmlWriter, List<MediaWatermark> list) {
        if (list != null && !list.isEmpty()) {
            for (MediaWatermark mediaWatermark : list) {
                CIMediaXmlFactory.addWatermar(xmlWriter, mediaWatermark);
            }
        }
    }

    private static void addWatermarkTemplateId(XmlWriter xmlWriter, List<String> list) {
        if (list != null && !list.isEmpty()) {
            for (String string : list) {
                xmlWriter.start("WatermarkTemplateId").value(string).end();
            }
        }
    }

    private static void addVideoMontage(XmlWriter xmlWriter, MediaVideoMontageObject mediaVideoMontageObject) {
        if (CIMediaXmlFactory.objIsNotValid(mediaVideoMontageObject).booleanValue()) {
            xmlWriter.start("VideoMontage");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Duration", mediaVideoMontageObject.getDuration());
            CIMediaXmlFactory.addVideo(xmlWriter, mediaVideoMontageObject.getVideo());
            CIMediaXmlFactory.addAudio(xmlWriter, mediaVideoMontageObject.getAudio());
            CIMediaXmlFactory.addAudioMix(xmlWriter, mediaVideoMontageObject.getAudioMix(), "AudioMix");
            CIMediaXmlFactory.addContainer(xmlWriter, mediaVideoMontageObject.getContainer());
            xmlWriter.end();
        }
    }

    private static void addAudioMix(XmlWriter xmlWriter, MediaAudioMixObject mediaAudioMixObject, String string) {
        if (CIMediaXmlFactory.objIsNotValid(mediaAudioMixObject).booleanValue()) {
            xmlWriter.start(string);
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "MixMode", mediaAudioMixObject.getMixMode());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "AudioSource", mediaAudioMixObject.getAudioSource());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Replace", mediaAudioMixObject.getReplace());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "DirectMix", mediaAudioMixObject.getDirectMix());
            EffectConfig effectConfig = mediaAudioMixObject.getEffectConfig();
            if (CIMediaXmlFactory.objIsNotValid(effectConfig).booleanValue()) {
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "BgmFadeTime", effectConfig.getBgmFadeTime());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "EnableBgmFade", effectConfig.getEnableBgmFade());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "EnableEndFadeout", effectConfig.getEnableEndFadeout());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "EnableStartFadein", effectConfig.getEnableStartFadein());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "EndFadeoutTime", effectConfig.getEndFadeoutTime());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "StartFadeinTime", effectConfig.getStartFadeinTime());
            }
            xmlWriter.end();
        }
    }

    private static void addConcat(XmlWriter xmlWriter, MediaConcatTemplateObject mediaConcatTemplateObject) {
        if (CIMediaXmlFactory.objIsNotValid(mediaConcatTemplateObject).booleanValue()) {
            xmlWriter.start("ConcatTemplate");
            List<MediaConcatFragmentObject> list = mediaConcatTemplateObject.getConcatFragmentList();
            for (MediaConcatFragmentObject mediaConcatFragmentObject : list) {
                xmlWriter.start("ConcatFragment");
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Mode", mediaConcatFragmentObject.getMode());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Url", mediaConcatFragmentObject.getUrl());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "FragmentIndex", mediaConcatFragmentObject.getFragmentIndex());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "StartTime", mediaConcatFragmentObject.getStartTime());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "EndTime", mediaConcatFragmentObject.getEndTime());
                xmlWriter.end();
            }
            CIMediaXmlFactory.addVideo(xmlWriter, mediaConcatTemplateObject.getVideo());
            CIMediaXmlFactory.addAudio(xmlWriter, mediaConcatTemplateObject.getAudio());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Index", mediaConcatTemplateObject.getIndex());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "DirectConcat", mediaConcatTemplateObject.getDirectConcat());
            CIMediaXmlFactory.addContainer(xmlWriter, mediaConcatTemplateObject.getContainer());
            CIMediaXmlFactory.addAudioMix(xmlWriter, mediaConcatTemplateObject.getAudioMix(), "AudioMix");
            xmlWriter.end();
        }
    }

    private static void addContainer(XmlWriter xmlWriter, MediaContainerObject mediaContainerObject) {
        if (!StringUtils.isNullOrEmpty(mediaContainerObject.getFormat())) {
            xmlWriter.start("Container");
            xmlWriter.start("Format").value(mediaContainerObject.getFormat()).end();
            xmlWriter.end();
        }
    }

    private static void addMediaDigitalWatermark(XmlWriter xmlWriter, MediaDigitalWatermark mediaDigitalWatermark) {
        if (CIMediaXmlFactory.objIsNotValid(mediaDigitalWatermark).booleanValue()) {
            xmlWriter.start("DigitalWatermark");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Message", mediaDigitalWatermark.getMessage());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Type", mediaDigitalWatermark.getType());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Version", mediaDigitalWatermark.getVersion());
            xmlWriter.end();
        }
    }

    private static void addExtractDigitalWatermark(XmlWriter xmlWriter, ExtractDigitalWatermark extractDigitalWatermark) {
        if (extractDigitalWatermark.getType() != null || extractDigitalWatermark.getMessage() != null) {
            xmlWriter.start("ExtractDigitalWatermark");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Message", extractDigitalWatermark.getMessage());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Type", extractDigitalWatermark.getType());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Version", extractDigitalWatermark.getVersion());
            xmlWriter.end();
        }
    }

    protected static void addOutput(XmlWriter xmlWriter, MediaOutputObject mediaOutputObject) {
        if (CIMediaXmlFactory.objIsNotValid(mediaOutputObject).booleanValue()) {
            xmlWriter.start("Output");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Region", mediaOutputObject.getRegion());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Object", mediaOutputObject.getObject());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Bucket", mediaOutputObject.getBucket());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "SpriteObject", mediaOutputObject.getSpriteObject());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "AuObject", mediaOutputObject.getAuObject());
            xmlWriter.end();
        }
    }

    private static void addSegment(XmlWriter xmlWriter, MediaSegmentObject mediaSegmentObject) {
        if (CIMediaXmlFactory.objIsNotValid(mediaSegmentObject).booleanValue()) {
            xmlWriter.start("Segment");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Duration", mediaSegmentObject.getDuration());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Format", mediaSegmentObject.getFormat());
            MediaHlsEncryptObject mediaHlsEncryptObject = mediaSegmentObject.getHlsEncrypt();
            if (CIMediaXmlFactory.objIsNotValid(mediaHlsEncryptObject).booleanValue()) {
                xmlWriter.start("HlsEncrypt");
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "IsHlsEncrypt", mediaHlsEncryptObject.getIsHlsEncrypt());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "UriKey", mediaHlsEncryptObject.getUriKey());
                xmlWriter.end();
            }
            xmlWriter.end();
        }
    }

    private static void addSmartCover(XmlWriter xmlWriter, MediaSmartCoverObject mediaSmartCoverObject) {
        if (CIMediaXmlFactory.objIsNotValid(mediaSmartCoverObject).booleanValue()) {
            xmlWriter.start("SmartCover");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Format", mediaSmartCoverObject.getFormat());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Width", mediaSmartCoverObject.getWidth());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Height", mediaSmartCoverObject.getHeight());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Count", mediaSmartCoverObject.getCount());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "DeleteDuplicates", mediaSmartCoverObject.getDeleteDuplicates());
            xmlWriter.end();
        }
    }

    private static void addCommonParams(XmlWriter xmlWriter, MediaJobsRequest mediaJobsRequest) {
        if (CIMediaXmlFactory.objIsNotValid(mediaJobsRequest).booleanValue()) {
            xmlWriter.start("Tag").value(mediaJobsRequest.getTag()).end();
            xmlWriter.start("BucketName").value(mediaJobsRequest.getBucketName()).end();
            xmlWriter.start("QueueId").value(mediaJobsRequest.getQueueId()).end();
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "CallBack", mediaJobsRequest.getCallBack());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "CallBackFormat", mediaJobsRequest.getCallBackFormat());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "CallBackType", mediaJobsRequest.getCallBackType());
        }
    }

    private static void addTranscode(XmlWriter xmlWriter, MediaTranscodeObject mediaTranscodeObject) {
        if (CIMediaXmlFactory.objIsNotValid(mediaTranscodeObject).booleanValue()) {
            xmlWriter.start("Transcode");
            MediaTranscodeVideoObject mediaTranscodeVideoObject = mediaTranscodeObject.getVideo();
            MediaAudioObject mediaAudioObject = mediaTranscodeObject.getAudio();
            MediaTransConfigObject mediaTransConfigObject = mediaTranscodeObject.getTransConfig();
            MediaTimeIntervalObject mediaTimeIntervalObject = mediaTranscodeObject.getTimeInterval();
            CIMediaXmlFactory.addFormat(xmlWriter, mediaTranscodeObject.getContainer());
            CIMediaXmlFactory.addTimeInterval(xmlWriter, mediaTimeIntervalObject);
            CIMediaXmlFactory.addVideo(xmlWriter, mediaTranscodeVideoObject);
            CIMediaXmlFactory.addAudio(xmlWriter, mediaAudioObject);
            CIMediaXmlFactory.addTransConfig(xmlWriter, mediaTransConfigObject);
            CIMediaXmlFactory.addAudioMix(xmlWriter, mediaTranscodeObject.getAudioMix(), "AudioMix");
            CIMediaXmlFactory.addAudioMixArray(xmlWriter, mediaTranscodeObject.getAudioMixArray());
            xmlWriter.end();
        }
    }

    private static void addAudioMixArray(XmlWriter xmlWriter, List<MediaAudioMixObject> list) {
        if (CIMediaXmlFactory.objIsNotValid(list).booleanValue()) {
            for (MediaAudioMixObject mediaAudioMixObject : list) {
                CIMediaXmlFactory.addAudioMix(xmlWriter, mediaAudioMixObject, "AudioMixArray");
            }
        }
    }

    private static void addFormat(XmlWriter xmlWriter, MediaContainerObject mediaContainerObject) {
        String string = mediaContainerObject.getFormat();
        if (string != null) {
            xmlWriter.start("Container");
            xmlWriter.start("Format").value(string).end();
            if (mediaContainerObject.getClipConfig().getDuration() != null) {
                xmlWriter.start("ClipConfig");
                xmlWriter.start("Duration").value(mediaContainerObject.getClipConfig().getDuration()).end();
                xmlWriter.end();
            }
            xmlWriter.end();
        }
    }

    private static void addSnapshot(XmlWriter xmlWriter, MediaSnapshotObject mediaSnapshotObject) {
        if (CIMediaXmlFactory.objIsNotValid(mediaSnapshotObject).booleanValue()) {
            xmlWriter.start("Snapshot");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Mode", mediaSnapshotObject.getMode());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Count", mediaSnapshotObject.getCount());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Fps", mediaSnapshotObject.getFps());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Height", mediaSnapshotObject.getHeight());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Start", mediaSnapshotObject.getStart());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "TimeInterval", mediaSnapshotObject.getTimeInterval());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Width", mediaSnapshotObject.getWidth());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "CIParam", mediaSnapshotObject.getCiParam());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "IsCheckCount", mediaSnapshotObject.getIsCheckCount());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "IsCheckBlack", mediaSnapshotObject.getIsCheckBlack());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "BlackLevel", mediaSnapshotObject.getBlackLevel());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "PixelBlackThreshold", mediaSnapshotObject.getPixelBlackThreshold());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "SnapshotOutMode", mediaSnapshotObject.getSnapshotOutMode());
            if (CIMediaXmlFactory.objIsNotValid(mediaSnapshotObject.getSnapshotConfig()).booleanValue()) {
                SpriteSnapshotConfig spriteSnapshotConfig = mediaSnapshotObject.getSnapshotConfig();
                xmlWriter.start("SpriteSnapshotConfig");
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "CellWidth", spriteSnapshotConfig.getCellWidth());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "CellHeight", spriteSnapshotConfig.getCellHeight());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Padding", spriteSnapshotConfig.getPadding());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Margin", spriteSnapshotConfig.getMargin());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Color", spriteSnapshotConfig.getColor());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Columns", spriteSnapshotConfig.getColumns());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Lines", spriteSnapshotConfig.getLines());
                xmlWriter.end();
            }
            xmlWriter.end();
        }
    }

    private static void addVideo(XmlWriter xmlWriter, MediaVideoObject mediaVideoObject) {
        if (RequestXmlFactory.CheckObjectUtils.objIsValid(mediaVideoObject).booleanValue()) {
            return;
        }
        xmlWriter.start("Video");
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Codec", mediaVideoObject.getCodec());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Width", mediaVideoObject.getWidth());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Height", mediaVideoObject.getHeight());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Fps", mediaVideoObject.getFps());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Bitrate", mediaVideoObject.getBitrate());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "BufSize", mediaVideoObject.getBufSize());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Crf", mediaVideoObject.getCrf());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Crop", mediaVideoObject.getCrop());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Gop", mediaVideoObject.getGop());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "LongShortMode", mediaVideoObject.getLongShortMode());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Maxrate", mediaVideoObject.getMaxrate());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Pad", mediaVideoObject.getPad());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "PixFmt", mediaVideoObject.getPixFmt());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Preset", mediaVideoObject.getPreset());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Profile", mediaVideoObject.getProfile());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Qality", mediaVideoObject.getQality());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Quality", mediaVideoObject.getQuality());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Remove", mediaVideoObject.getRemove());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "ScanMode", mediaVideoObject.getScanMode());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "HlsTsTime", mediaVideoObject.getHlsTsTime());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "AnimateFramesPerSecond", mediaVideoObject.getAnimateFramesPerSecond());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "AnimateTimeIntervalOfFrame", mediaVideoObject.getAnimateTimeIntervalOfFrame());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "AnimateOnlyKeepKeyFrame", mediaVideoObject.getAnimateOnlyKeepKeyFrame());
        xmlWriter.end();
    }

    private static void addVideo(XmlWriter xmlWriter, MediaTranscodeVideoObject mediaTranscodeVideoObject) {
        if (RequestXmlFactory.CheckObjectUtils.objIsValid(mediaTranscodeVideoObject).booleanValue()) {
            return;
        }
        xmlWriter.start("Video");
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Codec", mediaTranscodeVideoObject.getCodec());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Width", mediaTranscodeVideoObject.getWidth());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Height", mediaTranscodeVideoObject.getHeight());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Fps", mediaTranscodeVideoObject.getFps());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Bitrate", mediaTranscodeVideoObject.getBitrate());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "BufSize", mediaTranscodeVideoObject.getBufSize());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Crf", mediaTranscodeVideoObject.getCrf());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Gop", mediaTranscodeVideoObject.getGop());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Maxrate", mediaTranscodeVideoObject.getMaxrate());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Preset", mediaTranscodeVideoObject.getPreset());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Profile", mediaTranscodeVideoObject.getProfile());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Remove", mediaTranscodeVideoObject.getRemove());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "ScanMode", mediaTranscodeVideoObject.getScanMode());
        xmlWriter.end();
    }

    private static void addAudio(XmlWriter xmlWriter, MediaAudioObject mediaAudioObject) {
        if (CIMediaXmlFactory.objIsNotValid(mediaAudioObject).booleanValue()) {
            xmlWriter.start("Audio");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Bitrate", mediaAudioObject.getBitrate());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Channels", mediaAudioObject.getChannels());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Codec", mediaAudioObject.getCodec());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Profile", mediaAudioObject.getProfile());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Remove", mediaAudioObject.getRemove());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Samplerate", mediaAudioObject.getSamplerate());
            xmlWriter.end();
        }
    }

    private static void addTimeInterval(XmlWriter xmlWriter, MediaTimeIntervalObject mediaTimeIntervalObject) {
        if (CIMediaXmlFactory.objIsNotValid(mediaTimeIntervalObject).booleanValue()) {
            xmlWriter.start("TimeInterval");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Duration", mediaTimeIntervalObject.getDuration());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Start", mediaTimeIntervalObject.getStart());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "End", mediaTimeIntervalObject.getEnd());
            xmlWriter.end();
        }
    }

    private static void addTransConfig(XmlWriter xmlWriter, MediaTransConfigObject mediaTransConfigObject) {
        if (CIMediaXmlFactory.objIsNotValid(mediaTransConfigObject).booleanValue()) {
            xmlWriter.start("TransConfig");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "AdjDarMethod", mediaTransConfigObject.getAdjDarMethod());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "AudioBitrateAdjMethod", mediaTransConfigObject.getAudioBitrateAdjMethod());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "IsCheckAudioBitrate", mediaTransConfigObject.getIsCheckAudioBitrate());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "IsCheckReso", mediaTransConfigObject.getIsCheckReso());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "IsCheckVideoBitrate", mediaTransConfigObject.getIsCheckVideoBitrate());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "ResoAdjMethod", mediaTransConfigObject.getResoAdjMethod());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "TransMode", mediaTransConfigObject.getTransMode());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "DeleteMetadata", mediaTransConfigObject.getDeleteMetadata());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "IsHdr2Sdr", mediaTransConfigObject.getIsHdr2Sdr());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "HlsEncrypt", mediaTransConfigObject.getHlsEncrypt());
            xmlWriter.end();
        }
    }

    private static void addInput(XmlWriter xmlWriter, MediaInputObject mediaInputObject) {
        if (CIMediaXmlFactory.objIsNotValid(mediaInputObject).booleanValue()) {
            xmlWriter.start("Input");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Object", mediaInputObject.getObject());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Url", mediaInputObject.getUrl());
            xmlWriter.end();
        }
    }

    private static void addInput(XmlWriter xmlWriter, BatchInputObject batchInputObject) {
        xmlWriter.start("Input");
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Object", batchInputObject.getObject());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Url", batchInputObject.getUrl());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Manifest", batchInputObject.getManifest());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Prefix", batchInputObject.getPrefix());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "UrlFile", batchInputObject.getUrlFile());
        xmlWriter.end();
    }

    private static void addWatermar(XmlWriter xmlWriter, MediaWatermark mediaWatermark) {
        if (CIMediaXmlFactory.objIsNotValid(mediaWatermark).booleanValue()) {
            xmlWriter.start("Watermark");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Type", mediaWatermark.getType());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Dx", mediaWatermark.getDx());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Dy", mediaWatermark.getDy());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "EndTime", mediaWatermark.getEndTime());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "LocMode", mediaWatermark.getLocMode());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Pos", mediaWatermark.getPos());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "StartTime", mediaWatermark.getStartTime());
            if ("Text".equalsIgnoreCase(mediaWatermark.getType())) {
                MediaWaterMarkText mediaWaterMarkText = mediaWatermark.getText();
                xmlWriter.start("Text");
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "FontColor", mediaWaterMarkText.getFontColor());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "FontSize", mediaWaterMarkText.getFontSize());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "FontType", mediaWaterMarkText.getFontType());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Text", mediaWaterMarkText.getText());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Transparency", mediaWaterMarkText.getTransparency());
                xmlWriter.end();
            } else if ("Image".equalsIgnoreCase(mediaWatermark.getType())) {
                MediaWaterMarkImage mediaWaterMarkImage = mediaWatermark.getImage();
                xmlWriter.start("Image");
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Height", mediaWaterMarkImage.getHeight());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Mode", mediaWaterMarkImage.getMode());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Transparency", mediaWaterMarkImage.getTransparency());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Url", mediaWaterMarkImage.getUrl());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Width", mediaWaterMarkImage.getWidth());
                xmlWriter.end();
            }
            xmlWriter.end();
        }
    }

    private static void addRemoveWatermark(XmlWriter xmlWriter, MediaRemoveWaterMark mediaRemoveWaterMark) {
        if (CIMediaXmlFactory.objIsNotValid(mediaRemoveWaterMark).booleanValue()) {
            xmlWriter.start("RemoveWatermark");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Height", mediaRemoveWaterMark.getHeight());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Dx", mediaRemoveWaterMark.getDx());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Dy", mediaRemoveWaterMark.getDy());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Switch", mediaRemoveWaterMark.get_switch());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Width", mediaRemoveWaterMark.getWidth());
            xmlWriter.end();
        }
    }

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String && ((String)object).isEmpty()) {
            return true;
        }
        if (object instanceof Collection && ((Collection)object).isEmpty()) {
            return true;
        }
        if (object instanceof Map && ((Map)object).isEmpty()) {
            return true;
        }
        return object instanceof Object[] && ((Object[])object).length == 0;
    }

    public static Boolean objIsNotValid(Object object) {
        Field[] fieldArray;
        for (Field field : fieldArray = object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object object2 = field.get(object);
                if (field.isSynthetic() || CIMediaXmlFactory.isEmpty(object2)) continue;
                return true;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        return false;
    }
}

