/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model.ciModel.xml;

import com.qcloud.cos.internal.XmlWriter;
import com.qcloud.cos.model.ciModel.auditing.AudioAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.AuditingInputObject;
import com.qcloud.cos.model.ciModel.auditing.AuditingSnapshotObject;
import com.qcloud.cos.model.ciModel.auditing.BatchImageAuditingInputObject;
import com.qcloud.cos.model.ciModel.auditing.BatchImageAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.Conf;
import com.qcloud.cos.model.ciModel.auditing.DocumentAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.Encryption;
import com.qcloud.cos.model.ciModel.auditing.Freeze;
import com.qcloud.cos.model.ciModel.auditing.ReportBadCaseRequest;
import com.qcloud.cos.model.ciModel.auditing.TextAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.UserInfo;
import com.qcloud.cos.model.ciModel.auditing.VideoAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.WebpageAuditingRequest;
import com.qcloud.cos.model.ciModel.xml.CIMediaXmlFactory;
import java.util.List;

public class CIAuditingXmlFactory {
    public static byte[] convertToXmlByteArray(BatchImageAuditingRequest batchImageAuditingRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        List<BatchImageAuditingInputObject> list = batchImageAuditingRequest.getInputList();
        for (BatchImageAuditingInputObject batchImageAuditingInputObject : list) {
            xmlWriter.start("Input");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Url", batchImageAuditingInputObject.getUrl());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Object", batchImageAuditingInputObject.getObject());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "DataId", batchImageAuditingInputObject.getDataId());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "MaxFrames", batchImageAuditingInputObject.getMaxFrames());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Interval", batchImageAuditingInputObject.getInterval());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "LargeImageDetect", batchImageAuditingInputObject.getLargeImageDetect());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Content", batchImageAuditingInputObject.getContent());
            CIAuditingXmlFactory.addUserInfo(xmlWriter, batchImageAuditingInputObject.getUserInfo());
            CIAuditingXmlFactory.addEncryption(xmlWriter, batchImageAuditingInputObject.getEncryption());
            xmlWriter.end();
        }
        CIAuditingXmlFactory.addAuditingConf(xmlWriter, batchImageAuditingRequest.getConf());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(TextAuditingRequest textAuditingRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        CIAuditingXmlFactory.addAuditingInput(xmlWriter, textAuditingRequest.getInput());
        CIAuditingXmlFactory.addAuditingConf(xmlWriter, textAuditingRequest.getConf());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(DocumentAuditingRequest documentAuditingRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        xmlWriter.start("Input");
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Url", documentAuditingRequest.getInput().getUrl());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Object", documentAuditingRequest.getInput().getObject());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Type", documentAuditingRequest.getInput().getType());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "DataId", documentAuditingRequest.getInput().getDataId());
        CIAuditingXmlFactory.addUserInfo(xmlWriter, documentAuditingRequest.getInput().getUserInfo());
        xmlWriter.end();
        CIAuditingXmlFactory.addAuditingConf(xmlWriter, documentAuditingRequest.getConf());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(AudioAuditingRequest audioAuditingRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        CIAuditingXmlFactory.addAuditingInput(xmlWriter, audioAuditingRequest.getInput());
        CIAuditingXmlFactory.addAuditingConf(xmlWriter, audioAuditingRequest.getConf());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(ReportBadCaseRequest reportBadCaseRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "ContentType", reportBadCaseRequest.getContentType());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Text", reportBadCaseRequest.getText());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "Label", reportBadCaseRequest.getLabel());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "SuggestedLabel", (Object)reportBadCaseRequest.getSuggestedLabel());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "JobId", reportBadCaseRequest.getJobId());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "ModerationTime", reportBadCaseRequest.getModerationTime());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(VideoAuditingRequest videoAuditingRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        CIAuditingXmlFactory.addAuditingInput(xmlWriter, videoAuditingRequest.getInput());
        CIAuditingXmlFactory.addAuditingConf(xmlWriter, videoAuditingRequest.getConf());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(WebpageAuditingRequest webpageAuditingRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        CIAuditingXmlFactory.addAuditingInput(xmlWriter, webpageAuditingRequest.getInput());
        CIAuditingXmlFactory.addAuditingConf(xmlWriter, webpageAuditingRequest.getConf());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private static void addUserInfo(XmlWriter xmlWriter, UserInfo userInfo) {
        if (CIMediaXmlFactory.objIsNotValid(userInfo).booleanValue()) {
            xmlWriter.start("UserInfo");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "TokenId", userInfo.getTokenId());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Nickname", userInfo.getNickname());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "DeviceId", userInfo.getDeviceId());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "AppId", userInfo.getAppId());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Room", userInfo.getRoom());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "IP", userInfo.getIp());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Type", userInfo.getType());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "ReceiveTokenId", userInfo.getReceiveTokenId());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Gender", userInfo.getGender());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Level", userInfo.getLevel());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Role", userInfo.getRole());
            xmlWriter.end();
        }
    }

    private static void addAuditingDetectType(XmlWriter xmlWriter, String string) {
        if (!"all".equalsIgnoreCase(string)) {
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "DetectType", string);
        }
    }

    private static void addAuditingInput(XmlWriter xmlWriter, AuditingInputObject auditingInputObject) {
        if (CIMediaXmlFactory.objIsNotValid(auditingInputObject).booleanValue()) {
            xmlWriter.start("Input");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Object", auditingInputObject.getObject());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Url", auditingInputObject.getUrl());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "DataId", auditingInputObject.getDataId());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Content", auditingInputObject.getContent());
            CIAuditingXmlFactory.addUserInfo(xmlWriter, auditingInputObject.getUserInfo());
            CIAuditingXmlFactory.addEncryption(xmlWriter, auditingInputObject.getEncryption());
            xmlWriter.end();
        }
    }

    private static void addEncryption(XmlWriter xmlWriter, Encryption encryption) {
        if (CIMediaXmlFactory.objIsNotValid(encryption).booleanValue()) {
            xmlWriter.start("Encryption");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Algorithm", encryption.getAlgorithm());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "IV", encryption.getIV());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Key", encryption.getKey());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "KeyId", encryption.getKeyId());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "KeyType", encryption.getKeyType());
            xmlWriter.end();
        }
    }

    private static void addAuditingConf(XmlWriter xmlWriter, Conf conf) {
        if (CIMediaXmlFactory.objIsNotValid(conf).booleanValue()) {
            xmlWriter.start("Conf");
            String string = conf.getDetectType();
            CIAuditingXmlFactory.addAuditingDetectType(xmlWriter, string);
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "BizType", conf.getBizType());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "DetectContent", conf.getDetectContent());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "CallbackVersion", (Object)conf.getCallbackVersion());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Callback", conf.getCallback());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "ReturnHighlightHtml", conf.getReturnHighlightHtml());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Async", conf.getAsync());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "CallbackType", conf.getCallbackType());
            CIAuditingXmlFactory.addAuditingSnapshot(xmlWriter, conf.getSnapshot());
            CIAuditingXmlFactory.addFreeze(xmlWriter, conf.getFreeze());
            xmlWriter.end();
        }
    }

    private static void addFreeze(XmlWriter xmlWriter, Freeze freeze) {
        if (CIMediaXmlFactory.objIsNotValid(freeze).booleanValue()) {
            xmlWriter.start("Freeze");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "PornScore", freeze.getPornScore());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "AdsScore", freeze.getAdsScore());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "TerrorismScore", freeze.getTerrorismScore());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "PoliticsScore", freeze.getPoliticsScore());
            xmlWriter.end();
        }
    }

    private static void addAuditingSnapshot(XmlWriter xmlWriter, AuditingSnapshotObject auditingSnapshotObject) {
        if (CIMediaXmlFactory.objIsNotValid(auditingSnapshotObject).booleanValue()) {
            xmlWriter.start("Snapshot");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Mode", auditingSnapshotObject.getMode());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "TimeInterval", auditingSnapshotObject.getTimeInterval());
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "Count", auditingSnapshotObject.getCount());
            xmlWriter.end();
        }
    }
}

