/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.annotation.NotThreadSafe;
import com.qcloud.cos.exception.SelectObjectContentEventException;
import com.qcloud.cos.internal.ReleasableInputStream;
import com.qcloud.cos.internal.SdkFilterInputStream;
import com.qcloud.cos.internal.eventstreaming.Message;
import com.qcloud.cos.internal.eventstreaming.MessageDecoder;
import com.qcloud.cos.model.SelectObjectContentEvent;
import com.qcloud.cos.model.SelectObjectContentEventVisitor;
import com.qcloud.cos.model.SelectRecordsInputStream;
import com.qcloud.cos.model.transform.SelectObjectContentEventUnmarshaller;
import com.qcloud.cos.utils.BinaryUtils;
import com.qcloud.cos.utils.ValidationUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;

@NotThreadSafe
public class SelectObjectContentEventStream
implements Closeable {
    private static final InputStream EMPTY_INPUT_STREAM = new ByteArrayInputStream(new byte[0]);
    private final SdkFilterInputStream inputStream;
    private boolean readOptionChosen = false;

    public SelectObjectContentEventStream(SdkFilterInputStream sdkFilterInputStream) {
        this.inputStream = ValidationUtils.assertNotNull(sdkFilterInputStream, "inputStream");
    }

    public List<SelectObjectContentEvent> getAllEvents() throws SelectObjectContentEventException {
        ArrayList<SelectObjectContentEvent> arrayList = new ArrayList<SelectObjectContentEvent>();
        Iterator<SelectObjectContentEvent> iterator2 = this.getEventsIterator();
        while (iterator2.hasNext()) {
            arrayList.add(iterator2.next());
        }
        return arrayList;
    }

    public void visitAllEvents(SelectObjectContentEventVisitor selectObjectContentEventVisitor) throws SelectObjectContentEventException {
        Iterator<SelectObjectContentEvent> iterator2 = this.getEventsIterator();
        while (iterator2.hasNext()) {
            iterator2.next().visit(selectObjectContentEventVisitor);
        }
    }

    public Iterator<SelectObjectContentEvent> getEventsIterator() throws SelectObjectContentEventException {
        this.readOptionChosen();
        return new SelectEventIterator();
    }

    public SelectRecordsInputStream getRecordsInputStream() throws SelectObjectContentEventException {
        return this.getRecordsInputStream(new SelectObjectContentEventVisitor(){});
    }

    public SelectRecordsInputStream getRecordsInputStream(SelectObjectContentEventVisitor selectObjectContentEventVisitor) throws SelectObjectContentEventException {
        SequenceInputStream sequenceInputStream = new SequenceInputStream(new EventStreamEnumeration(this.getEventsIterator(), selectObjectContentEventVisitor));
        sequenceInputStream = ReleasableInputStream.wrap(sequenceInputStream).disableClose();
        return new SelectRecordsInputStream(sequenceInputStream, this.inputStream);
    }

    public void abort() {
        this.inputStream.abort();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    private void readOptionChosen() {
        if (this.readOptionChosen) {
            throw new IllegalStateException("Reading of the select event stream was already started by another method.");
        }
        this.readOptionChosen = true;
    }

    private abstract class LazyLoadedIterator<T>
    implements Iterator<T> {
        private final Queue<T> next = new ArrayDeque<T>();
        private boolean isDone = false;

        private LazyLoadedIterator() {
        }

        @Override
        public boolean hasNext() {
            this.advanceIfNeeded();
            return !this.isDone;
        }

        @Override
        public T next() {
            this.advanceIfNeeded();
            if (this.isDone) {
                throw new NoSuchElementException();
            }
            return this.next.poll();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advanceIfNeeded() {
            if (!this.isDone && this.next.isEmpty()) {
                try {
                    this.next.addAll(this.getNext());
                    this.isDone = this.next.isEmpty();
                }
                catch (IOException iOException) {
                    throw new SelectObjectContentEventException("Failed to read COS select event.", iOException);
                }
            }
        }

        protected abstract Collection<? extends T> getNext() throws IOException;
    }

    private class EventStreamEnumeration
    extends LazyLoadedIterator<InputStream>
    implements Enumeration<InputStream> {
        private final Iterator<SelectObjectContentEvent> selectEventIterator;
        private final SelectObjectContentEventVisitor additionalVisitor;
        private boolean initialized = false;

        private EventStreamEnumeration(Iterator<SelectObjectContentEvent> iterator2, SelectObjectContentEventVisitor selectObjectContentEventVisitor) {
            this.selectEventIterator = iterator2;
            this.additionalVisitor = selectObjectContentEventVisitor;
        }

        @Override
        protected Collection<? extends InputStream> getNext() {
            if (!this.initialized) {
                this.initialized = true;
                return Collections.singleton(EMPTY_INPUT_STREAM);
            }
            final ArrayList arrayList = new ArrayList();
            while (this.selectEventIterator.hasNext()) {
                SelectObjectContentEvent selectObjectContentEvent = this.selectEventIterator.next();
                selectObjectContentEvent.visit(this.additionalVisitor);
                selectObjectContentEvent.visit(new SelectObjectContentEventVisitor(){

                    @Override
                    public void visit(SelectObjectContentEvent.RecordsEvent recordsEvent) {
                        ByteBuffer byteBuffer = recordsEvent.getPayload();
                        if (byteBuffer != null) {
                            arrayList.add(new ByteArrayInputStream(BinaryUtils.copyBytesFrom(byteBuffer)));
                        }
                    }
                });
                if (arrayList.isEmpty()) continue;
                return arrayList;
            }
            return arrayList;
        }

        @Override
        public boolean hasMoreElements() {
            return super.hasNext();
        }

        @Override
        public InputStream nextElement() {
            return (InputStream)super.next();
        }
    }

    private class SelectEventIterator
    extends LazyLoadedIterator<SelectObjectContentEvent> {
        private final MessageDecoder decoder = new MessageDecoder();

        private SelectEventIterator() {
        }

        @Override
        protected Collection<SelectObjectContentEvent> getNext() throws IOException {
            ArrayList<SelectObjectContentEvent> arrayList = new ArrayList<SelectObjectContentEvent>();
            byte[] byArray = new byte[256];
            while (arrayList.isEmpty()) {
                int n = SelectObjectContentEventStream.this.inputStream.read(byArray);
                if (n == -1) {
                    if (!this.decoder.hasPendingContent()) break;
                    throw new SelectObjectContentEventException("Service stream ended before an event could be entirely decoded.");
                }
                List<Message> list = this.decoder.feed(byArray, 0, n);
                for (Message message : list) {
                    arrayList.add(SelectObjectContentEventUnmarshaller.unmarshalMessage(message));
                }
            }
            return arrayList;
        }
    }
}

