/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.internal.SdkFilterInputStream;
import com.qcloud.cos.utils.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.methods.HttpRequestBase;

public class COSObjectInputStream
extends SdkFilterInputStream {
    private final HttpRequestBase httpRequest;
    private boolean eof;

    public COSObjectInputStream(InputStream inputStream2, HttpRequestBase httpRequestBase) {
        super(inputStream2);
        this.httpRequest = httpRequestBase;
    }

    @Override
    public void abort() {
        this.doAbort();
    }

    private void doAbort() {
        if (this.httpRequest != null) {
            this.httpRequest.abort();
        }
        IOUtils.closeQuietly(this.in, null);
    }

    public HttpRequestBase getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public int available() throws IOException {
        int n = super.available();
        return n == 0 ? 1 : n;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n == -1) {
            this.eof = true;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 == -1) {
            this.eof = true;
        }
        return n3;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.eof = false;
    }

    @Override
    public void close() throws IOException {
        if (this.eof) {
            super.close();
            this.httpRequest.releaseConnection();
        } else {
            this.doAbort();
        }
    }
}

