/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.ObjectMetadata;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class COSObject
implements Closeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String key = null;
    private String bucketName = null;
    private ObjectMetadata metadata = new ObjectMetadata();
    private transient COSObjectInputStream objectContent;

    public ObjectMetadata getObjectMetadata() {
        return this.metadata;
    }

    public void setObjectMetadata(ObjectMetadata objectMetadata) {
        this.metadata = objectMetadata;
    }

    public COSObjectInputStream getObjectContent() {
        return this.objectContent;
    }

    public void setObjectContent(COSObjectInputStream cOSObjectInputStream) {
        this.objectContent = cOSObjectInputStream;
    }

    public void setObjectContent(InputStream inputStream2) {
        this.setObjectContent(new COSObjectInputStream(inputStream2, this.objectContent != null ? this.objectContent.getHttpRequest() : null));
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String string) {
        this.bucketName = string;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String toString() {
        return "COSObject [key=" + this.getKey() + ",bucket=" + (this.bucketName == null ? "<Unknown>" : this.bucketName) + "]";
    }

    @Override
    public void close() throws IOException {
        COSObjectInputStream cOSObjectInputStream = this.getObjectContent();
        if (cOSObjectInputStream != null) {
            ((InputStream)cOSObjectInputStream).close();
        }
    }
}

