/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.model.AbortIncompleteMultipartUpload;
import com.qcloud.cos.model.StorageClass;
import com.qcloud.cos.model.lifecycle.LifecycleFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class BucketLifecycleConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ENABLED = "Enabled";
    public static final String DISABLED = "Disabled";
    private List<Rule> rules;

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> list) {
        this.rules = list;
    }

    public BucketLifecycleConfiguration withRules(List<Rule> list) {
        this.setRules(list);
        return this;
    }

    public BucketLifecycleConfiguration withRules(Rule ... ruleArray) {
        this.setRules(Arrays.asList(ruleArray));
        return this;
    }

    public BucketLifecycleConfiguration(List<Rule> list) {
        this.rules = list;
    }

    public BucketLifecycleConfiguration() {
    }

    public static class NoncurrentVersionTransition
    implements Serializable {
        private int days = -1;
        private String storageClass;

        public void setDays(int n) {
            this.days = n;
        }

        public int getDays() {
            return this.days;
        }

        public NoncurrentVersionTransition withDays(int n) {
            this.days = n;
            return this;
        }

        public void setStorageClass(StorageClass storageClass) {
            if (storageClass == null) {
                this.setStorageClass((String)null);
            } else {
                this.setStorageClass(storageClass.toString());
            }
        }

        public void setStorageClass(String string) {
            this.storageClass = string;
        }

        public String getStorageClassAsString() {
            return this.storageClass;
        }

        public NoncurrentVersionTransition withStorageClass(StorageClass storageClass) {
            this.setStorageClass(storageClass);
            return this;
        }

        public NoncurrentVersionTransition withStorageClass(String string) {
            this.setStorageClass(string);
            return this;
        }
    }

    public static class Transition
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int days = -1;
        private Date date;
        private String storageClass;

        public void setDays(int n) {
            this.days = n;
        }

        public int getDays() {
            return this.days;
        }

        public Transition withDays(int n) {
            this.days = n;
            return this;
        }

        public void setStorageClass(String string) {
            this.storageClass = string;
        }

        public String getStorageClass() {
            return this.storageClass;
        }

        public Transition withStorageClass(String string) {
            this.storageClass = string;
            return this;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public Date getDate() {
            return this.date;
        }

        public Transition withDate(Date date) {
            this.date = date;
            return this;
        }
    }

    public static class Rule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String id;
        private String status;
        private LifecycleFilter filter;
        private int expirationInDays = -1;
        private boolean expiredObjectDeleteMarker = false;
        private int noncurrentVersionExpirationInDays = -1;
        private Date expirationDate;
        private List<Transition> transitions;
        private List<NoncurrentVersionTransition> noncurrentVersionTransitions;
        private AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;

        public void setId(String string) {
            this.id = string;
        }

        public void setExpirationInDays(int n) {
            this.expirationInDays = n;
        }

        public String getId() {
            return this.id;
        }

        public Rule withId(String string) {
            this.id = string;
            return this;
        }

        public int getExpirationInDays() {
            return this.expirationInDays;
        }

        public Rule withExpirationInDays(int n) {
            this.expirationInDays = n;
            return this;
        }

        public boolean isExpiredObjectDeleteMarker() {
            return this.expiredObjectDeleteMarker;
        }

        public void setExpiredObjectDeleteMarker(boolean bl) {
            this.expiredObjectDeleteMarker = bl;
        }

        public Rule withExpiredObjectDeleteMarker(boolean bl) {
            this.expiredObjectDeleteMarker = bl;
            return this;
        }

        public int getNoncurrentVersionExpirationInDays() {
            return this.noncurrentVersionExpirationInDays;
        }

        public void setNoncurrentVersionExpirationInDays(int n) {
            this.noncurrentVersionExpirationInDays = n;
        }

        public Rule withNoncurrentVersionExpirationInDays(int n) {
            this.noncurrentVersionExpirationInDays = n;
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String string) {
            this.status = string;
        }

        public Rule withStatus(String string) {
            this.setStatus(string);
            return this;
        }

        public void setExpirationDate(Date date) {
            this.expirationDate = date;
        }

        public Date getExpirationDate() {
            return this.expirationDate;
        }

        public Rule withExpirationDate(Date date) {
            this.expirationDate = date;
            return this;
        }

        public void setTransitions(List<Transition> list) {
            this.transitions = new ArrayList<Transition>(list);
        }

        public List<Transition> getTransitions() {
            return this.transitions;
        }

        public Rule withTransitions(List<Transition> list) {
            this.transitions = list;
            return this;
        }

        public Rule addTransition(Transition transition) {
            if (transition == null) {
                throw new IllegalArgumentException("Transition cannot be null.");
            }
            if (this.transitions == null) {
                this.transitions = new ArrayList<Transition>();
            }
            this.transitions.add(transition);
            return this;
        }

        public List<NoncurrentVersionTransition> getNoncurrentVersionTransitions() {
            return this.noncurrentVersionTransitions;
        }

        public void setNoncurrentVersionTransitions(List<NoncurrentVersionTransition> list) {
            this.noncurrentVersionTransitions = new ArrayList<NoncurrentVersionTransition>(list);
        }

        public Rule withNoncurrentVersionTransitions(List<NoncurrentVersionTransition> list) {
            this.setNoncurrentVersionTransitions(list);
            return this;
        }

        public Rule addNoncurrentVersionTransition(NoncurrentVersionTransition noncurrentVersionTransition) {
            if (noncurrentVersionTransition == null) {
                throw new IllegalArgumentException("NoncurrentVersionTransition cannot be null.");
            }
            if (this.noncurrentVersionTransitions == null) {
                this.noncurrentVersionTransitions = new ArrayList<NoncurrentVersionTransition>();
            }
            this.noncurrentVersionTransitions.add(noncurrentVersionTransition);
            return this;
        }

        public AbortIncompleteMultipartUpload getAbortIncompleteMultipartUpload() {
            return this.abortIncompleteMultipartUpload;
        }

        public void setAbortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
        }

        public Rule withAbortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload) {
            this.setAbortIncompleteMultipartUpload(abortIncompleteMultipartUpload);
            return this;
        }

        public LifecycleFilter getFilter() {
            return this.filter;
        }

        public void setFilter(LifecycleFilter lifecycleFilter) {
            this.filter = lifecycleFilter;
        }

        public Rule withFilter(LifecycleFilter lifecycleFilter) {
            this.setFilter(lifecycleFilter);
            return this;
        }
    }
}

