/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.XmlWriter;
import com.qcloud.cos.model.BucketCrossOriginConfiguration;
import com.qcloud.cos.model.BucketDomainConfiguration;
import com.qcloud.cos.model.BucketIntelligentTierConfiguration;
import com.qcloud.cos.model.BucketLifecycleConfiguration;
import com.qcloud.cos.model.BucketLoggingConfiguration;
import com.qcloud.cos.model.BucketRefererConfiguration;
import com.qcloud.cos.model.BucketReplicationConfiguration;
import com.qcloud.cos.model.BucketTaggingConfiguration;
import com.qcloud.cos.model.BucketVersioningConfiguration;
import com.qcloud.cos.model.BucketWebsiteConfiguration;
import com.qcloud.cos.model.CORSRule;
import com.qcloud.cos.model.DomainRule;
import com.qcloud.cos.model.RedirectRule;
import com.qcloud.cos.model.ReplicationDestinationConfig;
import com.qcloud.cos.model.ReplicationRule;
import com.qcloud.cos.model.RoutingRule;
import com.qcloud.cos.model.RoutingRuleCondition;
import com.qcloud.cos.model.Tag.LifecycleTagPredicate;
import com.qcloud.cos.model.Tag.Tag;
import com.qcloud.cos.model.TagSet;
import com.qcloud.cos.model.bucketcertificate.BucketDomainCertificateInfo;
import com.qcloud.cos.model.bucketcertificate.BucketPutDomainCertificate;
import com.qcloud.cos.model.inventory.InventoryConfiguration;
import com.qcloud.cos.model.inventory.InventoryCosBucketDestination;
import com.qcloud.cos.model.inventory.InventoryDestination;
import com.qcloud.cos.model.inventory.InventoryEncryption;
import com.qcloud.cos.model.inventory.InventoryFilter;
import com.qcloud.cos.model.inventory.InventoryFilterPredicate;
import com.qcloud.cos.model.inventory.InventoryPrefixPredicate;
import com.qcloud.cos.model.inventory.InventorySchedule;
import com.qcloud.cos.model.inventory.ServerSideEncryptionCOS;
import com.qcloud.cos.model.lifecycle.LifecycleAndOperator;
import com.qcloud.cos.model.lifecycle.LifecycleFilter;
import com.qcloud.cos.model.lifecycle.LifecycleFilterPredicate;
import com.qcloud.cos.model.lifecycle.LifecyclePredicateVisitor;
import com.qcloud.cos.model.lifecycle.LifecyclePrefixPredicate;
import com.qcloud.cos.utils.CollectionUtils;
import com.qcloud.cos.utils.DateUtils;
import java.util.List;

public class BucketConfigurationXmlFactory {
    public byte[] convertToXmlByteArray(BucketCrossOriginConfiguration bucketCrossOriginConfiguration) throws CosClientException {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("CORSConfiguration");
        for (CORSRule cORSRule : bucketCrossOriginConfiguration.getRules()) {
            this.writeRule(xmlWriter, cORSRule);
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketLoggingConfiguration bucketLoggingConfiguration) {
        String string = bucketLoggingConfiguration.getLogFilePrefix();
        if (string == null) {
            string = "";
        }
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("BucketLoggingStatus");
        if (bucketLoggingConfiguration.isLoggingEnabled()) {
            xmlWriter.start("LoggingEnabled");
            xmlWriter.start("TargetBucket").value(bucketLoggingConfiguration.getDestinationBucketName()).end();
            xmlWriter.start("TargetPrefix").value(bucketLoggingConfiguration.getLogFilePrefix()).end();
            xmlWriter.end();
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketVersioningConfiguration bucketVersioningConfiguration) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("VersioningConfiguration");
        xmlWriter.start("Status").value(bucketVersioningConfiguration.getStatus()).end();
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public byte[] convertToXmlByteArray(InventoryConfiguration inventoryConfiguration) throws CosClientException {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("InventoryConfiguration");
        xmlWriter.start("Id").value(inventoryConfiguration.getId()).end();
        xmlWriter.start("IsEnabled").value(String.valueOf(inventoryConfiguration.isEnabled())).end();
        xmlWriter.start("IncludedObjectVersions").value(inventoryConfiguration.getIncludedObjectVersions()).end();
        this.writeInventoryDestination(xmlWriter, inventoryConfiguration.getDestination());
        this.writeInventoryFilter(xmlWriter, inventoryConfiguration.getInventoryFilter());
        this.addInventorySchedule(xmlWriter, inventoryConfiguration.getSchedule());
        this.addInventoryOptionalFields(xmlWriter, inventoryConfiguration.getOptionalFields());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketTaggingConfiguration bucketTaggingConfiguration) throws CosClientException {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Tagging");
        for (TagSet tagSet : bucketTaggingConfiguration.getAllTagSets()) {
            this.writeRule(xmlWriter, tagSet);
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private void writeInventoryDestination(XmlWriter xmlWriter, InventoryDestination inventoryDestination) {
        if (inventoryDestination == null) {
            return;
        }
        xmlWriter.start("Destination");
        InventoryCosBucketDestination inventoryCosBucketDestination = inventoryDestination.getCosBucketDestination();
        if (inventoryCosBucketDestination != null) {
            xmlWriter.start("COSBucketDestination");
            this.addParameterIfNotNull(xmlWriter, "AccountId", inventoryCosBucketDestination.getAccountId());
            this.addParameterIfNotNull(xmlWriter, "Bucket", inventoryCosBucketDestination.getBucketArn());
            this.addParameterIfNotNull(xmlWriter, "Prefix", inventoryCosBucketDestination.getPrefix());
            this.addParameterIfNotNull(xmlWriter, "Format", inventoryCosBucketDestination.getFormat());
            this.writeInventoryEncryption(xmlWriter, inventoryCosBucketDestination.getEncryption());
            xmlWriter.end();
        }
        xmlWriter.end();
    }

    private void writeInventoryEncryption(XmlWriter xmlWriter, InventoryEncryption inventoryEncryption) {
        if (inventoryEncryption == null) {
            return;
        }
        xmlWriter.start("Encryption");
        if (inventoryEncryption instanceof ServerSideEncryptionCOS) {
            xmlWriter.start("SSE-COS").end();
        }
        xmlWriter.end();
    }

    private void writeInventoryFilter(XmlWriter xmlWriter, InventoryFilter inventoryFilter) {
        if (inventoryFilter == null) {
            return;
        }
        xmlWriter.start("Filter");
        this.writeInventoryFilterPredicate(xmlWriter, inventoryFilter.getPredicate());
        xmlWriter.end();
    }

    private void writeInventoryFilterPredicate(XmlWriter xmlWriter, InventoryFilterPredicate inventoryFilterPredicate) {
        if (inventoryFilterPredicate == null) {
            return;
        }
        if (inventoryFilterPredicate instanceof InventoryPrefixPredicate) {
            this.writePrefix(xmlWriter, ((InventoryPrefixPredicate)inventoryFilterPredicate).getPrefix());
        }
    }

    private void addInventorySchedule(XmlWriter xmlWriter, InventorySchedule inventorySchedule) {
        if (inventorySchedule == null) {
            return;
        }
        xmlWriter.start("Schedule");
        this.addParameterIfNotNull(xmlWriter, "Frequency", inventorySchedule.getFrequency());
        xmlWriter.end();
    }

    private void addInventoryOptionalFields(XmlWriter xmlWriter, List<String> list) {
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        xmlWriter.start("OptionalFields");
        for (String string : list) {
            xmlWriter.start("Field").value(string).end();
        }
        xmlWriter.end();
    }

    public byte[] convertToXmlByteArray(BucketLifecycleConfiguration bucketLifecycleConfiguration) throws CosClientException {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("LifecycleConfiguration");
        for (BucketLifecycleConfiguration.Rule rule : bucketLifecycleConfiguration.getRules()) {
            this.writeRule(xmlWriter, rule);
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketWebsiteConfiguration bucketWebsiteConfiguration) {
        XmlWriter xmlWriter;
        Object object;
        XmlWriter xmlWriter2 = new XmlWriter();
        xmlWriter2.start("WebsiteConfiguration");
        if (bucketWebsiteConfiguration.getIndexDocumentSuffix() != null) {
            object = xmlWriter2.start("IndexDocument");
            ((XmlWriter)object).start("Suffix").value(bucketWebsiteConfiguration.getIndexDocumentSuffix()).end();
            ((XmlWriter)object).end();
        }
        if (bucketWebsiteConfiguration.getErrorDocument() != null) {
            object = xmlWriter2.start("ErrorDocument");
            ((XmlWriter)object).start("Key").value(bucketWebsiteConfiguration.getErrorDocument()).end();
            ((XmlWriter)object).end();
        }
        if ((object = bucketWebsiteConfiguration.getRedirectAllRequestsTo()) != null) {
            xmlWriter = xmlWriter2.start("RedirectAllRequestsTo");
            if (((RedirectRule)object).getprotocol() != null) {
                xmlWriter2.start("Protocol").value(((RedirectRule)object).getprotocol()).end();
            }
            if (((RedirectRule)object).getHostName() != null) {
                xmlWriter2.start("HostName").value(((RedirectRule)object).getHostName()).end();
            }
            if (((RedirectRule)object).getReplaceKeyPrefixWith() != null) {
                xmlWriter2.start("ReplaceKeyPrefixWith").value(((RedirectRule)object).getReplaceKeyPrefixWith()).end();
            }
            if (((RedirectRule)object).getReplaceKeyWith() != null) {
                xmlWriter2.start("ReplaceKeyWith").value(((RedirectRule)object).getReplaceKeyWith()).end();
            }
            xmlWriter.end();
        }
        if (bucketWebsiteConfiguration.getRoutingRules() != null && bucketWebsiteConfiguration.getRoutingRules().size() > 0) {
            xmlWriter = xmlWriter2.start("RoutingRules");
            for (RoutingRule routingRule : bucketWebsiteConfiguration.getRoutingRules()) {
                this.writeRule(xmlWriter, routingRule);
            }
            xmlWriter.end();
        }
        xmlWriter2.end();
        return xmlWriter2.getBytes();
    }

    private void writeRule(XmlWriter xmlWriter, CORSRule cORSRule) {
        xmlWriter.start("CORSRule");
        if (cORSRule.getId() != null) {
            xmlWriter.start("ID").value(cORSRule.getId()).end();
        }
        if (cORSRule.getAllowedOrigins() != null) {
            for (String object : cORSRule.getAllowedOrigins()) {
                xmlWriter.start("AllowedOrigin").value(object).end();
            }
        }
        if (cORSRule.getAllowedMethods() != null) {
            for (CORSRule.AllowedMethods allowedMethods : cORSRule.getAllowedMethods()) {
                xmlWriter.start("AllowedMethod").value(allowedMethods.toString()).end();
            }
        }
        if (cORSRule.getMaxAgeSeconds() != 0) {
            xmlWriter.start("MaxAgeSeconds").value(Integer.toString(cORSRule.getMaxAgeSeconds())).end();
        }
        if (cORSRule.getExposedHeaders() != null) {
            for (String string : cORSRule.getExposedHeaders()) {
                xmlWriter.start("ExposeHeader").value(string).end();
            }
        }
        if (cORSRule.getAllowedHeaders() != null) {
            for (String string : cORSRule.getAllowedHeaders()) {
                xmlWriter.start("AllowedHeader").value(string).end();
            }
        }
        xmlWriter.end();
    }

    private void writeRule(XmlWriter xmlWriter, BucketLifecycleConfiguration.Rule rule) {
        xmlWriter.start("Rule");
        if (rule.getId() != null) {
            xmlWriter.start("ID").value(rule.getId()).end();
        }
        xmlWriter.start("Status").value(rule.getStatus()).end();
        this.writeLifecycleFilter(xmlWriter, rule.getFilter());
        this.addTransitions(xmlWriter, rule.getTransitions());
        this.addNoncurrentTransitions(xmlWriter, rule.getNoncurrentVersionTransitions());
        if (this.hasCurrentExpirationPolicy(rule)) {
            xmlWriter.start("Expiration");
            if (rule.getExpirationInDays() != -1) {
                xmlWriter.start("Days").value("" + rule.getExpirationInDays()).end();
            }
            if (rule.getExpirationDate() != null) {
                xmlWriter.start("Date").value(DateUtils.formatISO8601Date(rule.getExpirationDate())).end();
            }
            if (rule.isExpiredObjectDeleteMarker()) {
                xmlWriter.start("ExpiredObjectDeleteMarker").value("true").end();
            }
            xmlWriter.end();
        }
        if (rule.getNoncurrentVersionExpirationInDays() != -1) {
            xmlWriter.start("NoncurrentVersionExpiration");
            xmlWriter.start("NoncurrentDays").value(Integer.toString(rule.getNoncurrentVersionExpirationInDays())).end();
            xmlWriter.end();
        }
        if (rule.getAbortIncompleteMultipartUpload() != null) {
            xmlWriter.start("AbortIncompleteMultipartUpload");
            xmlWriter.start("DaysAfterInitiation").value(Integer.toString(rule.getAbortIncompleteMultipartUpload().getDaysAfterInitiation())).end();
            xmlWriter.end();
        }
        xmlWriter.end();
    }

    private void writeRule(XmlWriter xmlWriter, RoutingRule routingRule) {
        xmlWriter.start("RoutingRule");
        RoutingRuleCondition routingRuleCondition = routingRule.getCondition();
        if (routingRuleCondition != null) {
            xmlWriter.start("Condition");
            xmlWriter.start("KeyPrefixEquals");
            if (routingRuleCondition.getKeyPrefixEquals() != null) {
                xmlWriter.value(routingRuleCondition.getKeyPrefixEquals());
            }
            xmlWriter.end();
            if (routingRuleCondition.getHttpErrorCodeReturnedEquals() != null) {
                xmlWriter.start("HttpErrorCodeReturnedEquals ").value(routingRuleCondition.getHttpErrorCodeReturnedEquals()).end();
            }
            xmlWriter.end();
        }
        xmlWriter.start("Redirect");
        RedirectRule redirectRule = routingRule.getRedirect();
        if (redirectRule != null) {
            if (redirectRule.getprotocol() != null) {
                xmlWriter.start("Protocol").value(redirectRule.getprotocol()).end();
            }
            if (redirectRule.getHostName() != null) {
                xmlWriter.start("HostName").value(redirectRule.getHostName()).end();
            }
            if (redirectRule.getReplaceKeyPrefixWith() != null) {
                xmlWriter.start("ReplaceKeyPrefixWith").value(redirectRule.getReplaceKeyPrefixWith()).end();
            }
            if (redirectRule.getReplaceKeyWith() != null) {
                xmlWriter.start("ReplaceKeyWith").value(redirectRule.getReplaceKeyWith()).end();
            }
            if (redirectRule.getHttpRedirectCode() != null) {
                xmlWriter.start("HttpRedirectCode").value(redirectRule.getHttpRedirectCode()).end();
            }
        }
        xmlWriter.end();
        xmlWriter.end();
    }

    private void writeRule(XmlWriter xmlWriter, DomainRule domainRule) {
        xmlWriter.start("DomainRule");
        xmlWriter.start("Status").value(domainRule.getStatus()).end();
        xmlWriter.start("Name").value(domainRule.getName()).end();
        xmlWriter.start("Type").value(domainRule.getType()).end();
        if (domainRule.getForcedReplacement() != null) {
            xmlWriter.start("ForcedReplacement").value(domainRule.getForcedReplacement()).end();
        }
        xmlWriter.end();
    }

    private void writeRule(XmlWriter xmlWriter, TagSet tagSet) {
        xmlWriter.start("TagSet");
        for (String string : tagSet.getAllTags().keySet()) {
            xmlWriter.start("Tag");
            xmlWriter.start("Key").value(string).end();
            xmlWriter.start("Value").value(tagSet.getTag(string)).end();
            xmlWriter.end();
        }
        xmlWriter.end();
    }

    private void addTransitions(XmlWriter xmlWriter, List<BucketLifecycleConfiguration.Transition> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (BucketLifecycleConfiguration.Transition transition : list) {
            if (transition == null) continue;
            xmlWriter.start("Transition");
            if (transition.getDate() != null) {
                xmlWriter.start("Date");
                xmlWriter.value(DateUtils.formatISO8601Date(transition.getDate()));
                xmlWriter.end();
            }
            if (transition.getDays() != -1) {
                xmlWriter.start("Days");
                xmlWriter.value(Integer.toString(transition.getDays()));
                xmlWriter.end();
            }
            xmlWriter.start("StorageClass");
            xmlWriter.value(transition.getStorageClass().toString());
            xmlWriter.end();
            xmlWriter.end();
        }
    }

    private void addNoncurrentTransitions(XmlWriter xmlWriter, List<BucketLifecycleConfiguration.NoncurrentVersionTransition> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (BucketLifecycleConfiguration.NoncurrentVersionTransition noncurrentVersionTransition : list) {
            if (noncurrentVersionTransition == null) continue;
            xmlWriter.start("NoncurrentVersionTransition");
            if (noncurrentVersionTransition.getDays() != -1) {
                xmlWriter.start("NoncurrentDays");
                xmlWriter.value(Integer.toString(noncurrentVersionTransition.getDays()));
                xmlWriter.end();
            }
            xmlWriter.start("StorageClass");
            xmlWriter.value(noncurrentVersionTransition.getStorageClassAsString());
            xmlWriter.end();
            xmlWriter.end();
        }
    }

    private void writeLifecycleFilter(XmlWriter xmlWriter, LifecycleFilter lifecycleFilter) {
        if (lifecycleFilter == null) {
            return;
        }
        xmlWriter.start("Filter");
        this.writeLifecycleFilterPredicate(xmlWriter, lifecycleFilter.getPredicate());
        xmlWriter.end();
    }

    private void writeLifecycleFilterPredicate(XmlWriter xmlWriter, LifecycleFilterPredicate lifecycleFilterPredicate) {
        if (lifecycleFilterPredicate == null) {
            return;
        }
        lifecycleFilterPredicate.accept(new LifecyclePredicateVisitorImpl(xmlWriter));
    }

    public byte[] convertToXmlByteArray(BucketReplicationConfiguration bucketReplicationConfiguration) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("ReplicationConfiguration");
        List<ReplicationRule> list = bucketReplicationConfiguration.getRules();
        String string = bucketReplicationConfiguration.getRoleName();
        xmlWriter.start("Role").value(string).end();
        for (ReplicationRule replicationRule : list) {
            String string2 = replicationRule.getID();
            xmlWriter.start("Rule");
            xmlWriter.start("ID").value(string2).end();
            xmlWriter.start("Prefix").value(replicationRule.getPrefix()).end();
            xmlWriter.start("Status").value(replicationRule.getStatus()).end();
            ReplicationDestinationConfig replicationDestinationConfig = replicationRule.getDestinationConfig();
            xmlWriter.start("Destination");
            xmlWriter.start("Bucket").value(replicationDestinationConfig.getBucketQCS()).end();
            if (replicationDestinationConfig.getStorageClass() != null) {
                xmlWriter.start("StorageClass").value(replicationDestinationConfig.getStorageClass()).end();
            }
            xmlWriter.end();
            xmlWriter.end();
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketDomainConfiguration bucketDomainConfiguration) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("DomainConfiguration");
        for (DomainRule domainRule : bucketDomainConfiguration.getDomainRules()) {
            this.writeRule(xmlWriter, domainRule);
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketRefererConfiguration bucketRefererConfiguration) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("RefererConfiguration");
        xmlWriter.start("Status").value(bucketRefererConfiguration.getStatus()).end();
        xmlWriter.start("RefererType").value(bucketRefererConfiguration.getRefererType()).end();
        xmlWriter.start("DomainList");
        for (String string : bucketRefererConfiguration.getDomainList()) {
            xmlWriter.start("Domain").value(string).end();
        }
        xmlWriter.end();
        String string = bucketRefererConfiguration.getEmptyReferConfiguration();
        if (string != null && (string == BucketRefererConfiguration.DENY || string == BucketRefererConfiguration.ALLOW)) {
            xmlWriter.start("EmptyReferConfiguration").value(string).end();
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private boolean hasCurrentExpirationPolicy(BucketLifecycleConfiguration.Rule rule) {
        return rule.getExpirationInDays() != -1 || rule.getExpirationDate() != null || rule.isExpiredObjectDeleteMarker();
    }

    private void addParameterIfNotNull(XmlWriter xmlWriter, String string, String string2) {
        if (string2 != null) {
            xmlWriter.start(string).value(string2).end();
        }
    }

    private void writePrefix(XmlWriter xmlWriter, String string) {
        this.addParameterIfNotNull(xmlWriter, "Prefix", string);
    }

    private void writeTag(XmlWriter xmlWriter, Tag tag) {
        if (tag == null) {
            return;
        }
        xmlWriter.start("Tag");
        xmlWriter.start("Key").value(tag.getKey()).end();
        xmlWriter.start("Value").value(tag.getValue()).end();
        xmlWriter.end();
    }

    public byte[] convertToXmlByteArray(BucketIntelligentTierConfiguration bucketIntelligentTierConfiguration) throws CosClientException {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("IntelligentTieringConfiguration");
        String string = bucketIntelligentTierConfiguration.getStatus();
        xmlWriter.start("Status").value(string).end();
        BucketIntelligentTierConfiguration.Transition transition = bucketIntelligentTierConfiguration.getTransition();
        if (string.equals("Enabled") && transition != null) {
            xmlWriter.start("Transition");
            xmlWriter.start("Days").value(Integer.toString(transition.getDays())).end();
            xmlWriter.start("RequestFrequent").value(Integer.toString(transition.getRequestFrequent())).end();
            xmlWriter.end();
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketPutDomainCertificate bucketPutDomainCertificate) throws CosClientException {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("DomainCertificate");
        BucketDomainCertificateInfo bucketDomainCertificateInfo = bucketPutDomainCertificate.getBucketDomainCertificateInfo();
        xmlWriter.start("CertificateInfo");
        xmlWriter.start("CertType").value(bucketDomainCertificateInfo.getCertType()).end();
        xmlWriter.start("CustomCert");
        xmlWriter.start("Cert").value(bucketDomainCertificateInfo.getCert()).end();
        xmlWriter.start("PrivateKey").value(bucketDomainCertificateInfo.getPrivateKey()).end();
        xmlWriter.end();
        xmlWriter.end();
        xmlWriter.start("DomainList");
        for (String string : bucketPutDomainCertificate.getDomainList()) {
            xmlWriter.start("DomainName").value(string).end();
        }
        xmlWriter.end();
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private class LifecyclePredicateVisitorImpl
    implements LifecyclePredicateVisitor {
        private final XmlWriter xml;

        public LifecyclePredicateVisitorImpl(XmlWriter xmlWriter) {
            this.xml = xmlWriter;
        }

        @Override
        public void visit(LifecyclePrefixPredicate lifecyclePrefixPredicate) {
            BucketConfigurationXmlFactory.this.writePrefix(this.xml, lifecyclePrefixPredicate.getPrefix());
        }

        @Override
        public void visit(LifecycleTagPredicate lifecycleTagPredicate) {
            BucketConfigurationXmlFactory.this.writeTag(this.xml, lifecycleTagPredicate.getTag());
        }

        @Override
        public void visit(LifecycleAndOperator lifecycleAndOperator) {
            this.xml.start("And");
            for (LifecycleFilterPredicate lifecycleFilterPredicate : lifecycleAndOperator.getOperands()) {
                lifecycleFilterPredicate.accept(this);
            }
            this.xml.end();
        }
    }
}

