/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.model.AccessControlList;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.CosDataSource;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.SSECOSKeyManagementParams;
import com.qcloud.cos.model.SSECOSKeyManagementParamsProvider;
import com.qcloud.cos.model.SSECustomerKey;
import com.qcloud.cos.model.SSECustomerKeyProvider;
import com.qcloud.cos.model.StorageClass;
import com.qcloud.cos.model.ciModel.persistence.PicOperations;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;

public abstract class AbstractPutObjectRequest
extends CosServiceRequest
implements CosDataSource,
SSECOSKeyManagementParamsProvider,
SSECustomerKeyProvider,
Serializable,
Cloneable {
    private String bucketName;
    private String key;
    private File file;
    private transient InputStream inputStream;
    private ObjectMetadata metadata;
    private CannedAccessControlList cannedAcl;
    private AccessControlList accessControlList;
    private String storageClass;
    private String redirectLocation;
    private SSECustomerKey sseCustomerKey;
    private SSECOSKeyManagementParams sseCOSKeyManagementParams;
    private int trafficLimit = 0;
    private PicOperations picOperations;

    public AbstractPutObjectRequest(String string, String string2, File file) {
        this.bucketName = string;
        this.key = string2;
        this.file = file;
    }

    public AbstractPutObjectRequest(String string, String string2, String string3) {
        this.bucketName = string;
        this.key = string2;
        this.redirectLocation = string3;
    }

    protected AbstractPutObjectRequest(String string, String string2, InputStream inputStream2, ObjectMetadata objectMetadata) {
        this.bucketName = string;
        this.key = string2;
        this.inputStream = inputStream2;
        this.metadata = objectMetadata;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String string) {
        this.bucketName = string;
    }

    public <T extends AbstractPutObjectRequest> T withBucketName(String string) {
        this.setBucketName(string);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public <T extends AbstractPutObjectRequest> T withKey(String string) {
        this.setKey(string);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String string) {
        this.storageClass = string;
    }

    public <T extends AbstractPutObjectRequest> T withStorageClass(String string) {
        this.setStorageClass(string);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    public void setStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass.toString();
    }

    public <T extends AbstractPutObjectRequest> T withStorageClass(StorageClass storageClass) {
        this.setStorageClass(storageClass);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    public <T extends AbstractPutObjectRequest> T withFile(File file) {
        this.setFile(file);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ObjectMetadata objectMetadata) {
        this.metadata = objectMetadata;
    }

    public <T extends AbstractPutObjectRequest> T withMetadata(ObjectMetadata objectMetadata) {
        this.setMetadata(objectMetadata);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAccessControlList cannedAccessControlList) {
        this.cannedAcl = cannedAccessControlList;
    }

    public <T extends AbstractPutObjectRequest> T withCannedAcl(CannedAccessControlList cannedAccessControlList) {
        this.setCannedAcl(cannedAccessControlList);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    public AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(AccessControlList accessControlList) {
        this.accessControlList = accessControlList;
    }

    public <T extends AbstractPutObjectRequest> T withAccessControlList(AccessControlList accessControlList) {
        this.setAccessControlList(accessControlList);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void setInputStream(InputStream inputStream2) {
        this.inputStream = inputStream2;
    }

    public <T extends AbstractPutObjectRequest> T withInputStream(InputStream inputStream2) {
        this.setInputStream(inputStream2);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    public void setRedirectLocation(String string) {
        this.redirectLocation = string;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public <T extends AbstractPutObjectRequest> T withRedirectLocation(String string) {
        this.redirectLocation = string;
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    @Override
    public SSECustomerKey getSSECustomerKey() {
        return this.sseCustomerKey;
    }

    public void setSSECustomerKey(SSECustomerKey sSECustomerKey) {
        if (sSECustomerKey != null && this.sseCOSKeyManagementParams != null) {
            throw new IllegalArgumentException("Either SSECustomerKey or SSECOSKeyManagementParams must not be set at the same time.");
        }
        this.sseCustomerKey = sSECustomerKey;
    }

    public <T extends AbstractPutObjectRequest> T withSSECustomerKey(SSECustomerKey sSECustomerKey) {
        this.setSSECustomerKey(sSECustomerKey);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    @Override
    public SSECOSKeyManagementParams getSSECOSKeyManagementParams() {
        return this.sseCOSKeyManagementParams;
    }

    public void setSSECOSKeyManagementParams(SSECOSKeyManagementParams sSECOSKeyManagementParams) {
        if (sSECOSKeyManagementParams != null && this.sseCustomerKey != null) {
            throw new IllegalArgumentException("Either SSECustomerKey or SSECOSKeyManagementParams must not be set at the same time.");
        }
        this.sseCOSKeyManagementParams = sSECOSKeyManagementParams;
    }

    public <T extends AbstractPutObjectRequest> T withSSECOSKeyManagementParams(SSECOSKeyManagementParams sSECOSKeyManagementParams) {
        this.setSSECOSKeyManagementParams(sSECOSKeyManagementParams);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    @Override
    public AbstractPutObjectRequest clone() {
        return (AbstractPutObjectRequest)super.clone();
    }

    protected final <T extends AbstractPutObjectRequest> T copyPutObjectBaseTo(T t2) {
        this.copyBaseTo(t2);
        ObjectMetadata objectMetadata = this.getMetadata();
        return ((AbstractPutObjectRequest)((AbstractPutObjectRequest)((AbstractPutObjectRequest)((AbstractPutObjectRequest)((AbstractPutObjectRequest)((AbstractPutObjectRequest)((AbstractPutObjectRequest)t2.withAccessControlList(this.getAccessControlList())).withCannedAcl(this.getCannedAcl())).withInputStream(this.getInputStream())).withMetadata(objectMetadata == null ? null : objectMetadata.clone())).withRedirectLocation(this.getRedirectLocation())).withStorageClass(this.getStorageClass())).withSSECOSKeyManagementParams(this.getSSECOSKeyManagementParams())).withSSECustomerKey(this.getSSECustomerKey());
    }

    public int getTrafficLimit() {
        return this.trafficLimit;
    }

    public void setTrafficLimit(int n) {
        this.trafficLimit = n;
    }

    public PicOperations getPicOperations() {
        return this.picOperations;
    }

    public void setPicOperations(PicOperations picOperations) {
        this.picOperations = picOperations;
    }
}

