/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.crypto.QCLOUDKMS;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.kms.v20190118.KmsClient;
import com.tencentcloudapi.kms.v20190118.models.DecryptRequest;
import com.tencentcloudapi.kms.v20190118.models.DecryptResponse;
import com.tencentcloudapi.kms.v20190118.models.EncryptRequest;
import com.tencentcloudapi.kms.v20190118.models.EncryptResponse;
import com.tencentcloudapi.kms.v20190118.models.GenerateDataKeyRequest;
import com.tencentcloudapi.kms.v20190118.models.GenerateDataKeyResponse;

public class TencentCloudKMSClient
implements QCLOUDKMS {
    private final KmsClient kmsClient;

    public TencentCloudKMSClient(COSCredentialsProvider cOSCredentialsProvider, String string) {
        COSCredentials cOSCredentials = cOSCredentialsProvider.getCredentials();
        String string2 = cOSCredentials.getCOSAccessKeyId();
        String string3 = cOSCredentials.getCOSSecretKey();
        Credential credential = new Credential(string2, string3);
        this.kmsClient = new KmsClient(credential, string);
    }

    @Override
    public GenerateDataKeyResponse generateDataKey(GenerateDataKeyRequest generateDataKeyRequest) {
        try {
            GenerateDataKeyResponse generateDataKeyResponse = this.kmsClient.GenerateDataKey(generateDataKeyRequest);
            return generateDataKeyResponse;
        }
        catch (TencentCloudSDKException tencentCloudSDKException) {
            throw new CosClientException("TencentCloudKMS Service got exception while GenerateDataKey", tencentCloudSDKException);
        }
    }

    @Override
    public EncryptResponse encrypt(EncryptRequest encryptRequest) {
        try {
            EncryptResponse encryptResponse = this.kmsClient.Encrypt(encryptRequest);
            return encryptResponse;
        }
        catch (TencentCloudSDKException tencentCloudSDKException) {
            throw new CosClientException("TencentCloudKMS Service got exception while Encrypt", tencentCloudSDKException);
        }
    }

    @Override
    public DecryptResponse decrypt(DecryptRequest decryptRequest) {
        try {
            DecryptResponse decryptResponse = this.kmsClient.Decrypt(decryptRequest);
            return decryptResponse;
        }
        catch (TencentCloudSDKException tencentCloudSDKException) {
            throw new CosClientException("TencentCloudKMS Service got exception while Decrypt", tencentCloudSDKException);
        }
    }

    @Override
    public void shutdown() {
    }
}

