/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.qcloud.cos.internal.crypto.CipherLite;
import com.qcloud.cos.internal.crypto.ContentCryptoScheme;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;

final class GCMCipherLite
extends CipherLite {
    private static final int TAG_LENGTH = ContentCryptoScheme.AES_GCM.getTagLengthInBits() / 8;
    private final int tagLen;
    private long outputByteCount;
    private boolean invisiblyProcessed;
    private long currentCount;
    private long markedCount;
    private CipherLite aux;
    private byte[] finalBytes;
    private boolean doneFinal;
    private boolean securityViolated;

    GCMCipherLite(Cipher cipher, SecretKey secretKey, int n) {
        super(cipher, ContentCryptoScheme.AES_GCM, secretKey, n);
        int n2 = this.tagLen = n == 1 ? TAG_LENGTH : 0;
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    byte[] doFinal() throws IllegalBlockSizeException, BadPaddingException {
        if (this.doneFinal) {
            if (this.securityViolated) {
                throw new SecurityException();
            }
            return this.finalBytes == null ? null : (byte[])this.finalBytes.clone();
        }
        this.doneFinal = true;
        this.finalBytes = super.doFinal();
        if (this.finalBytes == null) {
            return null;
        }
        this.outputByteCount += (long)this.checkMax(this.finalBytes.length - this.tagLen);
        return (byte[])this.finalBytes.clone();
    }

    @Override
    final byte[] doFinal(byte[] byArray) throws IllegalBlockSizeException, BadPaddingException {
        return this.doFinal0(byArray, 0, byArray.length);
    }

    @Override
    final byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.doFinal0(byArray, n, n2);
    }

    private final byte[] doFinal0(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        if (this.doneFinal) {
            if (this.securityViolated) {
                throw new SecurityException();
            }
            if (2 == this.getCipherMode()) {
                return this.finalBytes == null ? null : (byte[])this.finalBytes.clone();
            }
            int n3 = this.finalBytes.length - this.tagLen;
            if (n2 == n3) {
                return (byte[])this.finalBytes.clone();
            }
            if (n2 < n3 && (long)n2 + this.currentCount == this.outputByteCount) {
                int n4 = this.finalBytes.length - this.tagLen - n2;
                return Arrays.copyOfRange(this.finalBytes, n4, this.finalBytes.length);
            }
            throw new IllegalStateException("Inconsistent re-rencryption");
        }
        this.doneFinal = true;
        this.finalBytes = super.doFinal(byArray, n, n2);
        if (this.finalBytes == null) {
            return null;
        }
        this.outputByteCount += (long)this.checkMax(this.finalBytes.length - this.tagLen);
        return (byte[])this.finalBytes.clone();
    }

    @Override
    byte[] update(byte[] byArray, int n, int n2) {
        byte[] byArray2;
        if (this.aux == null) {
            byArray2 = super.update(byArray, n, n2);
            if (byArray2 == null) {
                this.invisiblyProcessed = byArray.length > 0;
                return null;
            }
            this.outputByteCount += (long)this.checkMax(byArray2.length);
            this.invisiblyProcessed = byArray2.length == 0 && n2 > 0;
        } else {
            byArray2 = this.aux.update(byArray, n, n2);
            if (byArray2 == null) {
                return null;
            }
            this.currentCount += (long)byArray2.length;
            if (this.currentCount == this.outputByteCount) {
                this.aux = null;
            } else if (this.currentCount > this.outputByteCount) {
                if (1 == this.getCipherMode()) {
                    throw new IllegalStateException("currentCount=" + this.currentCount + " > outputByteCount=" + this.outputByteCount);
                }
                int n3 = this.finalBytes == null ? 0 : this.finalBytes.length;
                long l = this.outputByteCount - (this.currentCount - (long)byArray2.length) - (long)n3;
                this.currentCount = this.outputByteCount - (long)n3;
                this.aux = null;
                return Arrays.copyOf(byArray2, (int)l);
            }
        }
        return byArray2;
    }

    private int checkMax(int n) {
        if (this.outputByteCount + (long)n > 0xFFFFFFFE0L) {
            this.securityViolated = true;
            throw new SecurityException("Number of bytes processed has exceeded the maximum allowed by AES/GCM; [outputByteCount=" + this.outputByteCount + ", delta=" + n + "]");
        }
        return n;
    }

    @Override
    long mark() {
        this.markedCount = this.aux == null ? this.outputByteCount : this.currentCount;
        return this.markedCount;
    }

    @Override
    boolean markSupported() {
        return true;
    }

    @Override
    void reset() {
        if (this.markedCount < this.outputByteCount || this.invisiblyProcessed) {
            try {
                this.aux = this.createAuxiliary(this.markedCount);
                this.currentCount = this.markedCount;
            }
            catch (Exception exception) {
                throw exception instanceof RuntimeException ? (RuntimeException)exception : new IllegalStateException(exception);
            }
        }
    }

    byte[] getFinalBytes() {
        return this.finalBytes == null ? null : (byte[])this.finalBytes.clone();
    }

    byte[] getTag() {
        return this.getCipherMode() != 1 || this.finalBytes == null ? null : Arrays.copyOfRange(this.finalBytes, this.finalBytes.length - this.tagLen, this.finalBytes.length);
    }

    long getOutputByteCount() {
        return this.outputByteCount;
    }

    long getCurrentCount() {
        return this.currentCount;
    }

    long getMarkedCount() {
        return this.markedCount;
    }
}

