/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.qcloud.cos.internal.crypto.CryptoMode;
import com.qcloud.cos.internal.crypto.CryptoRuntime;
import com.qcloud.cos.internal.crypto.CryptoStorageMode;
import java.io.Serializable;
import java.security.Provider;

public class CryptoConfiguration
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8646831898339939580L;
    private CryptoMode cryptoMode;
    private CryptoStorageMode storageMode;
    private Provider cryptoProvider;
    private boolean ignoreMissingInstructionFile = true;
    private transient String kmsRegion;
    private byte[] iv = null;

    public CryptoConfiguration() {
        this(CryptoMode.AuthenticatedEncryption);
    }

    public CryptoConfiguration(CryptoMode cryptoMode) {
        this.check(cryptoMode);
        this.storageMode = CryptoStorageMode.ObjectMetadata;
        this.cryptoProvider = null;
        this.cryptoMode = cryptoMode;
    }

    public void setStorageMode(CryptoStorageMode cryptoStorageMode) {
        this.storageMode = cryptoStorageMode;
    }

    public CryptoConfiguration withStorageMode(CryptoStorageMode cryptoStorageMode) {
        this.storageMode = cryptoStorageMode;
        return this;
    }

    public CryptoStorageMode getStorageMode() {
        return this.storageMode;
    }

    public void setCryptoProvider(Provider provider) {
        this.cryptoProvider = provider;
    }

    public CryptoConfiguration withCryptoProvider(Provider provider) {
        this.cryptoProvider = provider;
        return this;
    }

    public Provider getCryptoProvider() {
        return this.cryptoProvider;
    }

    public CryptoMode getCryptoMode() {
        return this.cryptoMode;
    }

    public void setCryptoMode(CryptoMode cryptoMode) throws UnsupportedOperationException {
        this.cryptoMode = cryptoMode;
        this.check(cryptoMode);
    }

    public CryptoConfiguration withCryptoMode(CryptoMode cryptoMode) throws UnsupportedOperationException {
        this.cryptoMode = cryptoMode;
        this.check(cryptoMode);
        return this;
    }

    public boolean isIgnoreMissingInstructionFile() {
        return this.ignoreMissingInstructionFile;
    }

    public void setIgnoreMissingInstructionFile(boolean bl) {
        this.ignoreMissingInstructionFile = bl;
    }

    public CryptoConfiguration withIgnoreMissingInstructionFile(boolean bl) {
        this.ignoreMissingInstructionFile = bl;
        return this;
    }

    private void check(CryptoMode cryptoMode) {
        if (cryptoMode == CryptoMode.AuthenticatedEncryption || cryptoMode == CryptoMode.StrictAuthenticatedEncryption) {
            if (!CryptoRuntime.isBouncyCastleAvailable()) {
                CryptoRuntime.enableBouncyCastle();
                if (!CryptoRuntime.isBouncyCastleAvailable()) {
                    throw new UnsupportedOperationException("The Bouncy castle library jar is required on the classpath to enable authenticated encryption");
                }
            }
            if (!CryptoRuntime.isAesGcmAvailable()) {
                throw new UnsupportedOperationException("More recent version of the Bouncy castle library is required to enable authenticated encryption");
            }
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    public CryptoConfiguration readOnly() {
        if (this.isReadOnly()) {
            return this;
        }
        return this.copyTo(new ReadOnly());
    }

    public CryptoConfiguration clone() {
        return this.copyTo(new CryptoConfiguration());
    }

    private CryptoConfiguration copyTo(CryptoConfiguration cryptoConfiguration) {
        cryptoConfiguration.cryptoMode = this.cryptoMode;
        cryptoConfiguration.storageMode = this.storageMode;
        cryptoConfiguration.cryptoProvider = this.cryptoProvider;
        cryptoConfiguration.ignoreMissingInstructionFile = this.ignoreMissingInstructionFile;
        cryptoConfiguration.iv = this.iv;
        return cryptoConfiguration;
    }

    public String getKmsRegion() {
        return this.kmsRegion;
    }

    public void setKmsRegion(String string) {
        this.kmsRegion = string;
    }

    public CryptoConfiguration withKmsRegion(String string) {
        this.kmsRegion = string;
        return this;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public void setIV(byte[] byArray) {
        this.iv = byArray;
    }

    public CryptoConfiguration withIV(byte[] byArray) {
        this.iv = byArray;
        return this;
    }

    private static final class ReadOnly
    extends CryptoConfiguration {
        private static final long serialVersionUID = -7579268925296074735L;

        private ReadOnly() {
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public void setStorageMode(CryptoStorageMode cryptoStorageMode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfiguration withStorageMode(CryptoStorageMode cryptoStorageMode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCryptoProvider(Provider provider) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfiguration withCryptoProvider(Provider provider) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCryptoMode(CryptoMode cryptoMode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfiguration withCryptoMode(CryptoMode cryptoMode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setIgnoreMissingInstructionFile(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfiguration withIgnoreMissingInstructionFile(boolean bl) {
            throw new UnsupportedOperationException();
        }
    }
}

