/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.internal.crypto.COSCryptoScheme;
import com.qcloud.cos.internal.crypto.COSKeyWrapScheme;
import com.qcloud.cos.internal.crypto.CipherLite;
import com.qcloud.cos.internal.crypto.ContentCryptoScheme;
import com.qcloud.cos.internal.crypto.CryptoMode;
import com.qcloud.cos.internal.crypto.EncryptionMaterials;
import com.qcloud.cos.internal.crypto.EncryptionMaterialsAccessor;
import com.qcloud.cos.internal.crypto.KMSEncryptionMaterials;
import com.qcloud.cos.internal.crypto.KMSEncryptionMaterialsProvider;
import com.qcloud.cos.internal.crypto.KMSSecuredCEK;
import com.qcloud.cos.internal.crypto.QCLOUDKMS;
import com.qcloud.cos.internal.crypto.SecuredCEK;
import com.qcloud.cos.internal.crypto.StaticEncryptionMaterialsProvider;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.MaterialsDescriptionProvider;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.utils.Base64;
import com.qcloud.cos.utils.Jackson;
import com.qcloud.cos.utils.StringUtils;
import com.tencentcloudapi.kms.v20190118.models.DecryptRequest;
import com.tencentcloudapi.kms.v20190118.models.DecryptResponse;
import com.tencentcloudapi.kms.v20190118.models.EncryptRequest;
import com.tencentcloudapi.kms.v20190118.models.EncryptResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ContentCryptoMaterial {
    private final String keyWrappingAlgorithm;
    private final CipherLite cipherLite;
    private final Map<String, String> kekMaterialsDescription;
    private final byte[] encryptedCEK;
    private final byte[] securedIV;
    private static final Logger log = LoggerFactory.getLogger(ContentCryptoMaterial.class);

    ContentCryptoMaterial(Map<String, String> map, byte[] byArray, String string, CipherLite cipherLite, byte[] byArray2) {
        this.cipherLite = cipherLite;
        this.keyWrappingAlgorithm = string;
        this.encryptedCEK = (byte[])byArray.clone();
        this.kekMaterialsDescription = map;
        this.securedIV = byArray2;
    }

    String getKeyWrappingAlgorithm() {
        return this.keyWrappingAlgorithm;
    }

    private boolean usesKMSKey() {
        return KMSSecuredCEK.isKMSKeyWrapped(this.keyWrappingAlgorithm);
    }

    ContentCryptoScheme getContentCryptoScheme() {
        return this.cipherLite.getContentCryptoScheme();
    }

    ObjectMetadata toObjectMetadata(ObjectMetadata objectMetadata, CryptoMode cryptoMode) {
        return this.toObjectMetadata(objectMetadata);
    }

    private ObjectMetadata toObjectMetadata(ObjectMetadata objectMetadata) {
        String string;
        byte[] byArray = this.getEncryptedCEK();
        objectMetadata.addUserMetadata("client-side-encryption-key", Base64.encodeAsString(byArray));
        objectMetadata.addUserMetadata("client-side-encryption-start", Base64.encodeAsString(this.securedIV));
        String string2 = this.kekMaterialDescAsJson();
        if (string2 != null) {
            objectMetadata.addUserMetadata("client-side-encryption-matdesc", this.kekMaterialDescAsJson());
        }
        ContentCryptoScheme contentCryptoScheme = this.getContentCryptoScheme();
        objectMetadata.addUserMetadata("client-side-encryption-cek-alg", contentCryptoScheme.getCipherAlgorithm());
        int n = contentCryptoScheme.getTagLengthInBits();
        if (n > 0) {
            objectMetadata.addUserMetadata("x-cos-tag-len", String.valueOf(n));
        }
        if ((string = this.getKeyWrappingAlgorithm()) != null) {
            objectMetadata.addUserMetadata("client-side-encryption-wrap-alg", string);
        }
        return objectMetadata;
    }

    String toJsonString() {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        byte[] byArray = this.getEncryptedCEK();
        hashMap.put("x-cos-key-v2", Base64.encodeAsString(byArray));
        byte[] byArray2 = this.cipherLite.getIV();
        hashMap.put("x-cos-iv", Base64.encodeAsString(byArray2));
        hashMap.put("x-cos-matdesc", this.kekMaterialDescAsJson());
        ContentCryptoScheme contentCryptoScheme = this.getContentCryptoScheme();
        hashMap.put("x-cos-cek-alg", contentCryptoScheme.getCipherAlgorithm());
        int n = contentCryptoScheme.getTagLengthInBits();
        if (n > 0) {
            hashMap.put("x-cos-tag-len", String.valueOf(n));
        }
        if ((string = this.getKeyWrappingAlgorithm()) != null) {
            hashMap.put("x-cos-wrap-alg", string);
        }
        return Jackson.toJsonString(hashMap);
    }

    private String kekMaterialDescAsJson() {
        Map<String, String> map = this.getKEKMaterialsDescription();
        if (map == null || map.isEmpty()) {
            return null;
        }
        return Jackson.toJsonString(map);
    }

    private static Map<String, String> matdescFromJson(String string) {
        Map map = Jackson.fromJsonString(string, Map.class);
        return map == null ? null : Collections.unmodifiableMap(map);
    }

    private static SecretKey cek(byte[] byArray, String string, EncryptionMaterials encryptionMaterials, Provider provider, ContentCryptoScheme contentCryptoScheme, QCLOUDKMS qCLOUDKMS) {
        Key key;
        if (KMSSecuredCEK.isKMSKeyWrapped(string)) {
            return ContentCryptoMaterial.cekByKMS(byArray, string, encryptionMaterials, contentCryptoScheme, qCLOUDKMS);
        }
        if (encryptionMaterials.getKeyPair() != null ? (key = encryptionMaterials.getKeyPair().getPrivate()) == null : (key = encryptionMaterials.getSymmetricKey()) == null) {
            throw new CosClientException("Key encrypting key not available");
        }
        try {
            if (string != null) {
                Cipher cipher = provider == null ? Cipher.getInstance(string) : Cipher.getInstance(string, provider);
                cipher.init(4, key);
                return (SecretKey)cipher.unwrap(byArray, string, 3);
            }
            Cipher cipher = provider != null ? Cipher.getInstance(key.getAlgorithm(), provider) : Cipher.getInstance(key.getAlgorithm());
            cipher.init(2, key);
            byte[] byArray2 = cipher.doFinal(byArray);
            return new SecretKeySpec(byArray2, "AES");
        }
        catch (Exception exception) {
            throw new CosClientException("Unable to decrypt symmetric key from object metadata", exception);
        }
    }

    private static SecretKey cekByKMS(byte[] byArray, String string, EncryptionMaterials encryptionMaterials, ContentCryptoScheme contentCryptoScheme, QCLOUDKMS qCLOUDKMS) {
        Object object;
        DecryptRequest decryptRequest = new DecryptRequest();
        Map<String, String> map = encryptionMaterials.getMaterialsDescription();
        try {
            object = new ObjectMapper();
            decryptRequest.setEncryptionContext(((ObjectMapper)object).writeValueAsString(map));
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new CosClientException("decrypt request set encryption context got json processing exception", jsonProcessingException);
        }
        decryptRequest.setCiphertextBlob(new String(byArray));
        object = qCLOUDKMS.decrypt(decryptRequest);
        byte[] byArray2 = Base64.decode(((DecryptResponse)object).getPlaintext());
        return new SecretKeySpec(byArray2, contentCryptoScheme.getKeyGeneratorAlgorithm());
    }

    static ContentCryptoMaterial fromObjectMetadata(ObjectMetadata objectMetadata, EncryptionMaterialsAccessor encryptionMaterialsAccessor, Provider provider, boolean bl, QCLOUDKMS qCLOUDKMS) {
        return ContentCryptoMaterial.fromObjectMetadata0(objectMetadata, encryptionMaterialsAccessor, provider, null, bl, qCLOUDKMS);
    }

    static ContentCryptoMaterial fromObjectMetadata(ObjectMetadata objectMetadata, EncryptionMaterialsAccessor encryptionMaterialsAccessor, Provider provider, long[] lArray, boolean bl, QCLOUDKMS qCLOUDKMS) {
        return ContentCryptoMaterial.fromObjectMetadata0(objectMetadata, encryptionMaterialsAccessor, provider, lArray, bl, qCLOUDKMS);
    }

    private static ContentCryptoMaterial fromObjectMetadata0(ObjectMetadata objectMetadata, EncryptionMaterialsAccessor encryptionMaterialsAccessor, Provider provider, long[] lArray, boolean bl, QCLOUDKMS qCLOUDKMS) {
        EncryptionMaterials encryptionMaterials;
        Map<String, String> map = objectMetadata.getUserMetadata();
        if (map.get("client-side-encryption-key") != null) {
            return ContentCryptoMaterial.fromObjectMetadata1(map, encryptionMaterialsAccessor, provider, lArray, bl, qCLOUDKMS);
        }
        String string = map.get("x-cos-key-v2");
        if (string == null && (string = map.get("x-cos-key")) == null) {
            throw new CosClientException("Content encrypting key not found.");
        }
        byte[] byArray = Base64.decode(string);
        byte[] byArray2 = Base64.decode(map.get("x-cos-iv"));
        if (byArray == null || byArray2 == null) {
            throw new CosClientException("Content encrypting key or IV not found.");
        }
        String string2 = map.get("x-cos-matdesc");
        String string3 = map.get("x-cos-wrap-alg");
        boolean bl2 = KMSSecuredCEK.isKMSKeyWrapped(string3);
        Map<String, String> map2 = ContentCryptoMaterial.matdescFromJson(string2);
        if (bl2) {
            encryptionMaterials = new KMSEncryptionMaterials(map2.get("kms_cmk_id"));
            encryptionMaterials.addDescriptions(map2);
        } else {
            EncryptionMaterials encryptionMaterials2 = encryptionMaterials = encryptionMaterialsAccessor == null ? null : encryptionMaterialsAccessor.getEncryptionMaterials(map2);
            if (encryptionMaterials == null) {
                throw new CosClientException("Unable to retrieve the client encryption materials");
            }
        }
        String string4 = map.get("x-cos-cek-alg");
        boolean bl3 = lArray != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(string4, bl3);
        if (bl3) {
            byArray2 = contentCryptoScheme.adjustIV(byArray2, lArray[0]);
        } else {
            String string5;
            int n;
            int n2 = contentCryptoScheme.getTagLengthInBits();
            if (n2 > 0 && n2 != (n = Integer.parseInt(string5 = map.get("x-cos-tag-len")))) {
                throw new CosClientException("Unsupported tag length: " + n + ", expected: " + n2);
            }
        }
        if (bl && string3 == null) {
            throw ContentCryptoMaterial.newKeyWrapException();
        }
        SecretKey secretKey = ContentCryptoMaterial.cek(byArray, string3, encryptionMaterials, provider, contentCryptoScheme, qCLOUDKMS);
        return new ContentCryptoMaterial(map2, byArray, string3, contentCryptoScheme.createCipherLite(secretKey, byArray2, 2, provider), null);
    }

    private static ContentCryptoMaterial fromObjectMetadata1(Map<String, String> map, EncryptionMaterialsAccessor encryptionMaterialsAccessor, Provider provider, long[] lArray, boolean bl, QCLOUDKMS qCLOUDKMS) {
        EncryptionMaterials encryptionMaterials;
        Object object;
        String string = map.get("client-side-encryption-key");
        if (string == null) {
            throw new CosClientException("Content encrypting key not found.");
        }
        byte[] byArray = Base64.decode(string);
        String string2 = map.get("client-side-encryption-start");
        if (string2 == null) {
            throw new CosClientException("Content encrypting key or IV not found.");
        }
        byte[] byArray2 = Base64.decode(string2);
        String string3 = map.get("client-side-encryption-wrap-alg");
        String string4 = map.get("client-side-encryption-matdesc");
        boolean bl2 = KMSSecuredCEK.isKMSKeyWrapped(string3);
        Map<String, String> map2 = ContentCryptoMaterial.matdescFromJson(string4);
        if (bl2) {
            if (!(encryptionMaterialsAccessor instanceof KMSEncryptionMaterialsProvider)) {
                throw new CosClientException("Must use KMSEncryptionMaterials");
            }
            object = (KMSEncryptionMaterialsProvider)encryptionMaterialsAccessor;
            encryptionMaterials = ((StaticEncryptionMaterialsProvider)object).getEncryptionMaterials();
            if (map2 != null) {
                encryptionMaterials.addDescriptions(map2);
            }
        } else {
            EncryptionMaterials encryptionMaterials2 = encryptionMaterials = encryptionMaterialsAccessor == null ? null : encryptionMaterialsAccessor.getEncryptionMaterials(map2);
            if (encryptionMaterials == null) {
                throw new CosClientException("Unable to retrieve the client encryption materials");
            }
        }
        object = map.get("client-side-encryption-cek-alg");
        boolean bl3 = lArray != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo((String)object, bl3);
        byte[] byArray3 = ContentCryptoMaterial.decryptIV(byArray2, string3, encryptionMaterials, provider, contentCryptoScheme, qCLOUDKMS);
        if (bl3) {
            byArray3 = contentCryptoScheme.adjustIV(byArray3, lArray[0]);
        }
        if (bl && string3 == null) {
            throw ContentCryptoMaterial.newKeyWrapException();
        }
        SecretKey secretKey = ContentCryptoMaterial.cek(byArray, string3, encryptionMaterials, provider, contentCryptoScheme, qCLOUDKMS);
        return new ContentCryptoMaterial(map2, byArray, string3, contentCryptoScheme.createCipherLite(secretKey, byArray3, 2, provider), null);
    }

    private static CosClientException newKeyWrapException() {
        return new CosClientException("Missing key-wrap for the content-encrypting-key");
    }

    static ContentCryptoMaterial fromInstructionFile(Map<String, String> map, EncryptionMaterialsAccessor encryptionMaterialsAccessor, Provider provider, boolean bl, QCLOUDKMS qCLOUDKMS) {
        return ContentCryptoMaterial.fromInstructionFile0(map, encryptionMaterialsAccessor, provider, null, bl, qCLOUDKMS);
    }

    static ContentCryptoMaterial fromInstructionFile(Map<String, String> map, EncryptionMaterialsAccessor encryptionMaterialsAccessor, Provider provider, long[] lArray, boolean bl, QCLOUDKMS qCLOUDKMS) {
        return ContentCryptoMaterial.fromInstructionFile0(map, encryptionMaterialsAccessor, provider, lArray, bl, qCLOUDKMS);
    }

    private static ContentCryptoMaterial fromInstructionFile0(Map<String, String> map, EncryptionMaterialsAccessor encryptionMaterialsAccessor, Provider provider, long[] lArray, boolean bl, QCLOUDKMS qCLOUDKMS) {
        EncryptionMaterials encryptionMaterials;
        String string = map.get("x-cos-key-v2");
        if (string == null && (string = map.get("x-cos-key")) == null) {
            throw new CosClientException("Content encrypting key not found.");
        }
        byte[] byArray = Base64.decode(string);
        byte[] byArray2 = Base64.decode(map.get("x-cos-iv"));
        if (byArray == null || byArray2 == null) {
            throw new CosClientException("Necessary encryption info not found in the instruction file " + map);
        }
        String string2 = map.get("x-cos-wrap-alg");
        boolean bl2 = KMSSecuredCEK.isKMSKeyWrapped(string2);
        String string3 = map.get("x-cos-matdesc");
        Map<String, String> map2 = ContentCryptoMaterial.matdescFromJson(string3);
        if (bl2) {
            encryptionMaterials = new KMSEncryptionMaterials(map2.get("kms_cmk_id"));
            encryptionMaterials.addDescriptions(map2);
        } else {
            EncryptionMaterials encryptionMaterials2 = encryptionMaterials = encryptionMaterialsAccessor == null ? null : encryptionMaterialsAccessor.getEncryptionMaterials(map2);
            if (encryptionMaterials == null) {
                throw new CosClientException("Unable to retrieve the encryption materials that originally encrypted object corresponding to instruction file " + map);
            }
        }
        String string4 = map.get("x-cos-cek-alg");
        boolean bl3 = lArray != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(string4, bl3);
        if (bl3) {
            byArray2 = contentCryptoScheme.adjustIV(byArray2, lArray[0]);
        } else {
            String string5;
            int n;
            int n2 = contentCryptoScheme.getTagLengthInBits();
            if (n2 > 0 && n2 != (n = Integer.parseInt(string5 = map.get("x-cos-tag-len")))) {
                throw new CosClientException("Unsupported tag length: " + n + ", expected: " + n2);
            }
        }
        if (bl && string2 == null) {
            throw ContentCryptoMaterial.newKeyWrapException();
        }
        SecretKey secretKey = ContentCryptoMaterial.cek(byArray, string2, encryptionMaterials, provider, contentCryptoScheme, qCLOUDKMS);
        return new ContentCryptoMaterial(map2, byArray, string2, contentCryptoScheme.createCipherLite(secretKey, byArray2, 2, provider), null);
    }

    static String parseInstructionFile(COSObject cOSObject) {
        try {
            return ContentCryptoMaterial.convertStreamToString(cOSObject.getObjectContent());
        }
        catch (Exception exception) {
            throw new CosClientException("Error parsing JSON instruction file", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream inputStream2) throws IOException {
        if (inputStream2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream2, StringUtils.UTF8));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
        }
        finally {
            inputStream2.close();
        }
        return stringBuilder.toString();
    }

    CipherLite getCipherLite() {
        return this.cipherLite;
    }

    Map<String, String> getKEKMaterialsDescription() {
        return this.kekMaterialsDescription;
    }

    byte[] getEncryptedCEK() {
        return (byte[])this.encryptedCEK.clone();
    }

    ContentCryptoMaterial recreate(Map<String, String> map, EncryptionMaterialsAccessor encryptionMaterialsAccessor, COSCryptoScheme cOSCryptoScheme, Provider provider, QCLOUDKMS qCLOUDKMS, CosServiceRequest cosServiceRequest) {
        EncryptionMaterials encryptionMaterials;
        if (!this.usesKMSKey() && map.equals(this.kekMaterialsDescription)) {
            throw new SecurityException("Material description of the new KEK must differ from the current one");
        }
        if (this.usesKMSKey()) {
            encryptionMaterials = new KMSEncryptionMaterials(this.kekMaterialsDescription.get("kms_cmk_id"));
        } else {
            encryptionMaterials = encryptionMaterialsAccessor.getEncryptionMaterials(this.kekMaterialsDescription);
            if (encryptionMaterials == null) {
                throw new CosClientException("Unable to retrieve the origin encryption materials");
            }
        }
        EncryptionMaterials encryptionMaterials2 = encryptionMaterialsAccessor.getEncryptionMaterials(map);
        if (encryptionMaterials2 == null) {
            throw new CosClientException("No material available with the description " + map + " from the encryption material provider");
        }
        SecretKey secretKey = ContentCryptoMaterial.cek(this.encryptedCEK, this.keyWrappingAlgorithm, encryptionMaterials, provider, this.getContentCryptoScheme(), qCLOUDKMS);
        ContentCryptoMaterial contentCryptoMaterial = ContentCryptoMaterial.create(secretKey, this.cipherLite.getIV(), encryptionMaterials2, this.getContentCryptoScheme(), cOSCryptoScheme, provider, qCLOUDKMS, cosServiceRequest);
        if (Arrays.equals(contentCryptoMaterial.encryptedCEK, this.encryptedCEK)) {
            throw new SecurityException("The new KEK must differ from the original");
        }
        return contentCryptoMaterial;
    }

    ContentCryptoMaterial recreate(EncryptionMaterials encryptionMaterials, EncryptionMaterialsAccessor encryptionMaterialsAccessor, COSCryptoScheme cOSCryptoScheme, Provider provider, QCLOUDKMS qCLOUDKMS, CosServiceRequest cosServiceRequest) {
        EncryptionMaterials encryptionMaterials2;
        if (!this.usesKMSKey() && encryptionMaterials.getMaterialsDescription().equals(this.kekMaterialsDescription)) {
            throw new SecurityException("Material description of the new KEK must differ from the current one");
        }
        if (this.usesKMSKey()) {
            encryptionMaterials2 = new KMSEncryptionMaterials(this.kekMaterialsDescription.get("kms_cmk_id"));
        } else {
            encryptionMaterials2 = encryptionMaterialsAccessor.getEncryptionMaterials(this.kekMaterialsDescription);
            if (encryptionMaterials2 == null) {
                throw new CosClientException("Unable to retrieve the origin encryption materials");
            }
        }
        SecretKey secretKey = ContentCryptoMaterial.cek(this.encryptedCEK, this.keyWrappingAlgorithm, encryptionMaterials2, provider, this.getContentCryptoScheme(), qCLOUDKMS);
        ContentCryptoMaterial contentCryptoMaterial = ContentCryptoMaterial.create(secretKey, this.cipherLite.getIV(), encryptionMaterials, this.getContentCryptoScheme(), cOSCryptoScheme, provider, qCLOUDKMS, cosServiceRequest);
        if (Arrays.equals(contentCryptoMaterial.encryptedCEK, this.encryptedCEK)) {
            throw new SecurityException("The new KEK must differ from the original");
        }
        return contentCryptoMaterial;
    }

    static ContentCryptoMaterial create(SecretKey secretKey, byte[] byArray, EncryptionMaterials encryptionMaterials, ContentCryptoScheme contentCryptoScheme, COSCryptoScheme cOSCryptoScheme, Provider provider, QCLOUDKMS qCLOUDKMS, CosServiceRequest cosServiceRequest) {
        return ContentCryptoMaterial.doCreate(secretKey, byArray, encryptionMaterials, contentCryptoScheme, cOSCryptoScheme, provider, qCLOUDKMS, cosServiceRequest);
    }

    static ContentCryptoMaterial create(SecretKey secretKey, byte[] byArray, EncryptionMaterials encryptionMaterials, COSCryptoScheme cOSCryptoScheme, Provider provider, QCLOUDKMS qCLOUDKMS, CosServiceRequest cosServiceRequest) {
        return ContentCryptoMaterial.doCreate(secretKey, byArray, encryptionMaterials, cOSCryptoScheme.getContentCryptoScheme(), cOSCryptoScheme, provider, qCLOUDKMS, cosServiceRequest);
    }

    private static ContentCryptoMaterial doCreate(SecretKey secretKey, byte[] byArray, EncryptionMaterials encryptionMaterials, ContentCryptoScheme contentCryptoScheme, COSCryptoScheme cOSCryptoScheme, Provider provider, QCLOUDKMS qCLOUDKMS, CosServiceRequest cosServiceRequest) {
        SecuredCEK securedCEK = ContentCryptoMaterial.secureCEK(secretKey, encryptionMaterials, cOSCryptoScheme.getKeyWrapScheme(), cOSCryptoScheme.getSecureRandom(), provider, qCLOUDKMS, cosServiceRequest);
        byte[] byArray2 = ContentCryptoMaterial.encryptIV(byArray, encryptionMaterials, cOSCryptoScheme.getKeyWrapScheme(), cOSCryptoScheme.getSecureRandom(), provider, qCLOUDKMS, cosServiceRequest);
        return ContentCryptoMaterial.wrap(secretKey, byArray, contentCryptoScheme, provider, securedCEK, byArray2);
    }

    public static ContentCryptoMaterial wrap(SecretKey secretKey, byte[] byArray, ContentCryptoScheme contentCryptoScheme, Provider provider, SecuredCEK securedCEK, byte[] byArray2) {
        return new ContentCryptoMaterial(securedCEK.getMaterialDescription(), securedCEK.getEncrypted(), securedCEK.getKeyWrapAlgorithm(), contentCryptoScheme.createCipherLite(secretKey, byArray, 1, provider), byArray2);
    }

    private static SecuredCEK secureCEK(SecretKey secretKey, EncryptionMaterials encryptionMaterials, COSKeyWrapScheme cOSKeyWrapScheme, SecureRandom secureRandom, Provider provider, QCLOUDKMS qCLOUDKMS, CosServiceRequest cosServiceRequest) {
        if (encryptionMaterials.isKMSEnabled()) {
            Object object;
            Map<String, String> map = ContentCryptoMaterial.mergeMaterialDescriptions(encryptionMaterials, cosServiceRequest);
            EncryptRequest encryptRequest = new EncryptRequest();
            try {
                object = new ObjectMapper();
                encryptRequest.setEncryptionContext(((ObjectMapper)object).writeValueAsString(map));
            }
            catch (JsonProcessingException jsonProcessingException) {
                throw new CosClientException("encrypt request set encryption context got json processing exception", jsonProcessingException);
            }
            encryptRequest.setKeyId(encryptionMaterials.getCustomerMasterKeyId());
            encryptRequest.setPlaintext(secretKey.getEncoded().toString());
            object = qCLOUDKMS.encrypt(encryptRequest);
            byte[] byArray = ((EncryptResponse)object).getCiphertextBlob().getBytes();
            return new KMSSecuredCEK(byArray, map);
        }
        Map<String, String> map = encryptionMaterials.getMaterialsDescription();
        Key key = encryptionMaterials.getKeyPair() != null ? encryptionMaterials.getKeyPair().getPublic() : encryptionMaterials.getSymmetricKey();
        String string = cOSKeyWrapScheme.getKeyWrapAlgorithm(key);
        try {
            Cipher cipher = provider == null ? Cipher.getInstance(string) : Cipher.getInstance(string, provider);
            cipher.init(3, key, secureRandom);
            return new SecuredCEK(cipher.wrap(secretKey), string, map);
        }
        catch (Exception exception) {
            throw new CosClientException("Unable to encrypt symmetric key", exception);
        }
    }

    public static byte[] encryptIV(byte[] byArray, EncryptionMaterials encryptionMaterials, COSKeyWrapScheme cOSKeyWrapScheme, SecureRandom secureRandom, Provider provider, QCLOUDKMS qCLOUDKMS, CosServiceRequest cosServiceRequest) {
        if (encryptionMaterials.isKMSEnabled()) {
            Object object;
            Map<String, String> map = ContentCryptoMaterial.mergeMaterialDescriptions(encryptionMaterials, cosServiceRequest);
            EncryptRequest encryptRequest = new EncryptRequest();
            try {
                object = new ObjectMapper();
                encryptRequest.setEncryptionContext(((ObjectMapper)object).writeValueAsString(map));
            }
            catch (JsonProcessingException jsonProcessingException) {
                throw new CosClientException("encrypt request set encryption context got json processing exception", jsonProcessingException);
            }
            encryptRequest.setKeyId(encryptionMaterials.getCustomerMasterKeyId());
            encryptRequest.setPlaintext(Base64.encodeAsString(byArray));
            object = qCLOUDKMS.encrypt(encryptRequest);
            String string = ((EncryptResponse)object).getCiphertextBlob();
            return string.getBytes(Charset.forName("UTF-8"));
        }
        Key key = encryptionMaterials.getKeyPair() != null ? encryptionMaterials.getKeyPair().getPublic() : encryptionMaterials.getSymmetricKey();
        String string = cOSKeyWrapScheme.getKeyWrapAlgorithm(key);
        try {
            Cipher cipher = provider == null ? Cipher.getInstance(string) : Cipher.getInstance(string, provider);
            cipher.init(1, key, secureRandom);
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new CosClientException("Unable to encrypt IV", exception);
        }
    }

    public static byte[] decryptIV(byte[] byArray, String string, EncryptionMaterials encryptionMaterials, Provider provider, ContentCryptoScheme contentCryptoScheme, QCLOUDKMS qCLOUDKMS) {
        Key key;
        if (encryptionMaterials.isKMSEnabled()) {
            Object object;
            DecryptRequest decryptRequest = new DecryptRequest();
            Map<String, String> map = encryptionMaterials.getMaterialsDescription();
            try {
                object = new ObjectMapper();
                decryptRequest.setEncryptionContext(((ObjectMapper)object).writeValueAsString(map));
            }
            catch (JsonProcessingException jsonProcessingException) {
                throw new CosClientException("decrypt request set encryption context got json processing exception", jsonProcessingException);
            }
            decryptRequest.setCiphertextBlob(new String(byArray, Charset.forName("UTF-8")));
            object = qCLOUDKMS.decrypt(decryptRequest);
            return Base64.decode(((DecryptResponse)object).getPlaintext());
        }
        if (encryptionMaterials.getKeyPair() != null ? (key = encryptionMaterials.getKeyPair().getPrivate()) == null : (key = encryptionMaterials.getSymmetricKey()) == null) {
            throw new CosClientException("Key encrypting key not available");
        }
        try {
            if (string != null) {
                Cipher cipher = provider == null ? Cipher.getInstance(string) : Cipher.getInstance(string, provider);
                cipher.init(2, key);
                return cipher.doFinal(byArray);
            }
            Cipher cipher = provider != null ? Cipher.getInstance(key.getAlgorithm(), provider) : Cipher.getInstance(key.getAlgorithm());
            cipher.init(2, key);
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new CosClientException("Unable to decrypt symmetric key from object metadata", exception);
        }
    }

    static Map<String, String> mergeMaterialDescriptions(EncryptionMaterials encryptionMaterials, CosServiceRequest cosServiceRequest) {
        MaterialsDescriptionProvider materialsDescriptionProvider;
        Map<String, String> map;
        Map<String, String> map2 = encryptionMaterials.getMaterialsDescription();
        if (cosServiceRequest instanceof MaterialsDescriptionProvider && (map = (materialsDescriptionProvider = (MaterialsDescriptionProvider)((Object)cosServiceRequest)).getMaterialsDescription()) != null) {
            map2 = new TreeMap<String, String>(map2);
            map2.putAll(map);
        }
        return map2;
    }
}

