/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.internal.SdkFilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5DigestCalculatingInputStream
extends SdkFilterInputStream {
    private MessageDigest digest = this.newMD5();
    private MessageDigest digestLastMarked;

    public MD5DigestCalculatingInputStream(InputStream inputStream2) {
        super(inputStream2);
    }

    private MessageDigest newMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("unexpected", noSuchAlgorithmException);
        }
    }

    private MessageDigest cloneFrom(MessageDigest messageDigest) {
        try {
            return (MessageDigest)messageDigest.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("unexpected", cloneNotSupportedException);
        }
    }

    public byte[] getMd5Digest() {
        return this.digest.digest();
    }

    @Override
    public void mark(int n) {
        if (this.markSupported()) {
            super.mark(n);
            this.digestLastMarked = this.cloneFrom(this.digest);
        }
    }

    @Override
    public void reset() throws IOException {
        if (!this.markSupported()) {
            throw new IOException("mark/reset not supported");
        }
        super.reset();
        this.digest = this.digestLastMarked == null ? this.newMD5() : this.cloneFrom(this.digestLastMarked);
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            this.digest.update((byte)n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.digest.update(byArray, n, n3);
        }
        return n3;
    }
}

