/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.SdkFilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class InputSubstream
extends SdkFilterInputStream {
    private static final int MAX_SKIPS = 100;
    private long currentPosition = 0L;
    private final long requestedOffset;
    private final long requestedLength;
    private final boolean closeSourceStream;
    private long markedPosition = 0L;

    public InputSubstream(InputStream inputStream2, long l, long l2, boolean bl) {
        super(inputStream2);
        this.requestedLength = l2;
        this.requestedOffset = l;
        this.closeSourceStream = bl;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n == -1) {
            return n;
        }
        return byArray[0];
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        long l;
        int n3 = 0;
        while (this.currentPosition < this.requestedOffset) {
            l = super.skip(this.requestedOffset - this.currentPosition);
            if (l == 0L && ++n3 > 100) {
                throw new CosClientException("Unable to position the currentPosition from " + this.currentPosition + " to " + this.requestedOffset);
            }
            this.currentPosition += l;
        }
        l = this.requestedLength + this.requestedOffset - this.currentPosition;
        if (l <= 0L) {
            return -1;
        }
        n2 = (int)Math.min((long)n2, l);
        int n4 = super.read(byArray, n, n2);
        this.currentPosition += (long)n4;
        return n4;
    }

    @Override
    public synchronized void mark(int n) {
        this.markedPosition = this.currentPosition;
        super.mark(n);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.currentPosition = this.markedPosition;
        super.reset();
    }

    @Override
    public void close() throws IOException {
        if (this.closeSourceStream) {
            super.close();
        }
    }

    @Override
    public int available() throws IOException {
        long l = this.currentPosition < this.requestedOffset ? this.requestedLength : this.requestedLength + this.requestedOffset - this.currentPosition;
        return (int)Math.min(l, (long)super.available());
    }

    InputStream getWrappedInputStream() {
        return this.in;
    }
}

