/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.exception.CosServiceExceptionBuilder;
import com.qcloud.cos.http.CosHttpResponse;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.http.HttpResponseHandler;
import com.qcloud.cos.utils.IOUtils;
import com.qcloud.cos.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosErrorResponseHandler
implements HttpResponseHandler<CosServiceException> {
    private static final Logger log = LoggerFactory.getLogger(CosErrorResponseHandler.class);
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    private CosServiceException createExceptionFromHeaders(CosHttpResponse cosHttpResponse, String string) {
        Map<String, String> map = cosHttpResponse.getHeaders();
        int n = cosHttpResponse.getStatusCode();
        CosServiceExceptionBuilder cosServiceExceptionBuilder = new CosServiceExceptionBuilder();
        cosServiceExceptionBuilder.setErrorMessage(cosHttpResponse.getStatusText());
        cosServiceExceptionBuilder.setErrorResponseXml(string);
        cosServiceExceptionBuilder.setStatusCode(n);
        cosServiceExceptionBuilder.setTraceId(map.get("x-cos-trace-id"));
        cosServiceExceptionBuilder.setRequestId(map.get("x-cos-request-id"));
        cosServiceExceptionBuilder.setErrorCode(n + " " + cosHttpResponse.getStatusText());
        return cosServiceExceptionBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CosServiceException handle(CosHttpResponse cosHttpResponse) throws XMLStreamException {
        XMLStreamReader xMLStreamReader;
        InputStream inputStream2 = cosHttpResponse.getContent();
        String string = null;
        if (inputStream2 == null || cosHttpResponse.getRequest().getHttpMethod() == HttpMethodName.HEAD) {
            return this.createExceptionFromHeaders(cosHttpResponse, null);
        }
        String string2 = null;
        try {
            string2 = IOUtils.toString(inputStream2);
        }
        catch (IOException iOException) {
            log.debug("Failed in parsing the error response : ", iOException);
            return this.createExceptionFromHeaders(cosHttpResponse, null);
        }
        XMLInputFactory xMLInputFactory = xmlInputFactory;
        synchronized (xMLInputFactory) {
            xMLStreamReader = xmlInputFactory.createXMLStreamReader(new ByteArrayInputStream(string2.getBytes(StringUtils.UTF8)));
        }
        try {
            int n = 0;
            CosServiceExceptionBuilder cosServiceExceptionBuilder = new CosServiceExceptionBuilder();
            cosServiceExceptionBuilder.setErrorResponseXml(string2);
            cosServiceExceptionBuilder.setStatusCode(cosHttpResponse.getStatusCode());
            boolean bl = false;
            block13: while (xMLStreamReader.hasNext()) {
                int n2 = xMLStreamReader.next();
                switch (n2) {
                    case 1: {
                        String string3 = xMLStreamReader.getLocalName();
                        if (++n == 1 && !COSErrorTags.Error.toString().equals(string3)) {
                            return this.createExceptionFromHeaders(cosHttpResponse, "Unable to parse error response. Error XML Not in proper format." + string2);
                        }
                        if (!COSErrorTags.Error.toString().equals(string3)) continue block13;
                        bl = true;
                        continue block13;
                    }
                    case 4: {
                        string = xMLStreamReader.getText();
                        if (string == null) continue block13;
                        string = string.trim();
                        continue block13;
                    }
                    case 2: {
                        String string3 = xMLStreamReader.getLocalName();
                        if (!bl || --n > 1) {
                            return this.createExceptionFromHeaders(cosHttpResponse, "Unable to parse error response. Error XML Not in proper format." + string2);
                        }
                        if (COSErrorTags.Message.toString().equals(string3)) {
                            cosServiceExceptionBuilder.setErrorMessage(string);
                            continue block13;
                        }
                        if (COSErrorTags.Code.toString().equals(string3)) {
                            cosServiceExceptionBuilder.setErrorCode(string);
                            continue block13;
                        }
                        if (COSErrorTags.RequestId.toString().equals(string3)) {
                            cosServiceExceptionBuilder.setRequestId(string);
                            continue block13;
                        }
                        if (COSErrorTags.TraceId.toString().equals(string3)) {
                            cosServiceExceptionBuilder.setTraceId(string);
                            continue block13;
                        }
                        cosServiceExceptionBuilder.addAdditionalDetail(string3, string);
                        continue block13;
                    }
                    case 8: {
                        return cosServiceExceptionBuilder.build();
                    }
                }
            }
        }
        catch (Exception exception) {
            log.debug("Failed in parsing the error response : " + string2, exception);
        }
        return this.createExceptionFromHeaders(cosHttpResponse, string2);
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    private static enum COSErrorTags {
        Error,
        Code,
        Message,
        Resource,
        RequestId,
        TraceId;

    }
}

