/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

public enum BucketNameUtils {

    private static final int MIN_BUCKET_NAME_LENGTH = 1;

    public static void validateBucketName(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Bucket Name cannot be null");
        }
        String string2 = string;
        if (string.contains("-") && string.lastIndexOf("-") != 0) {
            string2 = string.substring(0, string.lastIndexOf("-"));
        }
        if (string2.length() < 1) {
            throw new IllegalArgumentException("bucketName length must at least 1 character long");
        }
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (i == 0 && c == '-') {
                throw new IllegalArgumentException("Bucket name can not start with -");
            }
            if (c == '-' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            if (c >= 'A' && c <= 'Z') {
                throw new IllegalArgumentException("Bucket name should not contain uppercase characters");
            }
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                throw new IllegalArgumentException("Bucket name should not contain whitespace");
            }
            throw new IllegalArgumentException("Bucket name only should contain lowercase characters, num and -");
        }
    }
}

