/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.endpoint;

import com.qcloud.cos.endpoint.EndpointBuilder;
import com.qcloud.cos.internal.BucketNameUtils;
import com.qcloud.cos.internal.UrlComponentUtils;

public class SuffixEndpointBuilder
implements EndpointBuilder {
    private String endpointSuffix;

    public SuffixEndpointBuilder(String string) {
        if (string == null) {
            throw new IllegalArgumentException("endpointSuffix must not be null");
        }
        while (string.startsWith(".")) {
            string = string.substring(1);
        }
        UrlComponentUtils.validateEndPointSuffix(string);
        this.endpointSuffix = string.trim();
    }

    @Override
    public String buildGeneralApiEndpoint(String string) {
        BucketNameUtils.validateBucketName(string);
        return String.format("%s.%s", string, this.endpointSuffix);
    }

    @Override
    public String buildGetServiceApiEndpoint() {
        return this.endpointSuffix;
    }
}

