/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.endpoint;

import com.qcloud.cos.endpoint.EndpointBuilder;
import com.qcloud.cos.internal.BucketNameUtils;
import com.qcloud.cos.region.Region;

public class RegionEndpointBuilder
implements EndpointBuilder {
    private Region region;

    public RegionEndpointBuilder(Region region) {
        this.region = region;
    }

    @Override
    public String buildGeneralApiEndpoint(String string) {
        if (this.region == null) {
            throw new IllegalArgumentException("region is null");
        }
        BucketNameUtils.validateBucketName(string);
        return String.format("%s.%s.myqcloud.com", string, Region.formatRegion(this.region));
    }

    @Override
    public String buildGetServiceApiEndpoint() {
        return "service.cos.myqcloud.com";
    }
}

