/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.fetch;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.endpoint.UserSpecifiedEndpointBuilder;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.fetch.GetAsyncFetchTaskRequest;
import com.qcloud.cos.model.fetch.GetAsyncFetchTaskResult;
import com.qcloud.cos.region.Region;
import java.util.Map;

public class GetAsyncFetchTaskDemo {
    static String ak = System.getProperty("COS_AK");
    static String sk = System.getProperty("COS_SK");
    static String region = "ap-shanghai";
    static String bucketName = "test-1250000000";
    static String taskId = "Nj00000000000000000000000000000000000000";

    public static COSClient createCosClient() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials(ak, sk);
        ClientConfig clientConfig = new ClientConfig(new Region(region));
        clientConfig.setHttpProtocol(HttpProtocol.http);
        return new COSClient(basicCOSCredentials, clientConfig);
    }

    public static void getAsyncFetchTask() {
        UserSpecifiedEndpointBuilder userSpecifiedEndpointBuilder = new UserSpecifiedEndpointBuilder(String.format("%s.migration.myqcloud.com", region), "service.cos.myqcloud.com");
        COSClient cOSClient = GetAsyncFetchTaskDemo.createCosClient();
        cOSClient.getClientConfig().setEndpointBuilder(userSpecifiedEndpointBuilder);
        GetAsyncFetchTaskRequest getAsyncFetchTaskRequest = new GetAsyncFetchTaskRequest();
        getAsyncFetchTaskRequest.setBucketName(bucketName);
        getAsyncFetchTaskRequest.setTaskId(taskId);
        GetAsyncFetchTaskResult getAsyncFetchTaskResult = cOSClient.getAsyncFetchTask(getAsyncFetchTaskRequest);
        System.out.println(getAsyncFetchTaskResult.getCosRequestId());
        System.out.println(getAsyncFetchTaskResult.getCode());
        System.out.println(getAsyncFetchTaskResult.getMessage());
        System.out.println(getAsyncFetchTaskResult.getRequestId());
        for (Map.Entry<String, String> entry : getAsyncFetchTaskResult.getData().entrySet()) {
            System.out.println(entry.getKey());
            System.out.println(entry.getValue());
        }
    }

    public static void main(String[] stringArray) {
        GetAsyncFetchTaskDemo.getAsyncFetchTask();
    }
}

