/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.job.AudioConfig;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.VoiceSeparate;

public class VoiceSeparateJobDemo {
    public static void main(String[] stringArray) throws Exception {
        COSClient cOSClient = ClientUtils.getTestClient();
        VoiceSeparateJobDemo.createMediaJobs(cOSClient);
    }

    public static void createMediaJobs(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("demo-1234567890");
        mediaJobsRequest.setTag("VoiceSeparate");
        mediaJobsRequest.getInput().setObject("1.mp4");
        VoiceSeparate voiceSeparate = mediaJobsRequest.getOperation().getVoiceSeparate();
        voiceSeparate.setAudioMode("AudioAndBackground");
        AudioConfig audioConfig = voiceSeparate.getAudioConfig();
        audioConfig.setBitrate("500");
        audioConfig.setSamplerate("44100");
        audioConfig.setCodec("mp3");
        audioConfig.setChannels("2");
        MediaOutputObject mediaOutputObject = mediaJobsRequest.getOperation().getOutput();
        mediaOutputObject.setBucket("demo-1234567890");
        mediaOutputObject.setRegion("ap-chongqing");
        mediaOutputObject.setObject("demo.mp3");
        mediaOutputObject.setAuObject("au.mp3");
        mediaJobsRequest.setQueueId("p9900025e4ec44b5e8225e70a52170834");
        mediaJobsRequest.setCallBack("https://cloud.tencent.com/xxx");
        MediaJobResponse mediaJobResponse = cOSClient.createMediaJobs(mediaJobsRequest);
        System.out.println(mediaJobResponse.getJobsDetail().getJobId());
    }

    public static void describeMediaJob(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("demo-1234567890");
        mediaJobsRequest.setJobId("jccc9be6e7b7c11edb66a4b87d14*****");
        MediaJobResponse mediaJobResponse = cOSClient.describeMediaJob(mediaJobsRequest);
        System.out.println(mediaJobResponse);
    }
}

